//Backup.c Part of Helio shopping list application
//Deals with saving the list to the memo database, either as a shopping list,
//or as backup of the shopping database. Also has code for restoring the backup to 
//the shopping db, although this does not work if there has been a hard reset. 
//Something happens to the fields somehow, so that the function here won't read it.

#include "main.h"

#define MEMODB (BYTE*)("Memo Database")

//Variables
DatabaseID     memo_dbid;
USHORT         item_num;

//functions
void           Backup_toMemo();
void           Reading_BackupMemo();
void           Restore_Database();
void           Reading_BackupMemo();
void           Save_List();
//see main.c:
extern void    Delete_Lists();
extern void    Draw_Lists();
extern void    Qty_Records();
extern void    Read_Database();
extern void    Redraw_Line();





void Save_List()  //saves shopping list to memo
{
    RTM     date;
    BYTE    sketch;
    BYTE    MemoText[10000];//100 items
    UBYTE   cat;
    SHORT   total_list, x;

    strcpy(MemoText, "Shopping List: ");
    strncat(&MemoText, "\r\n", 5);
    strncat(&MemoText, "Qty Item", 20);
    strncat(&MemoText, "\t\t", 5);
    strncat(&MemoText, "\t\t", 5);
    strncat(&MemoText, "Store", 20);
    strncat(&MemoText, "\t\t", 5);
    strncat(&MemoText, "\t\t", 5);
    strncat(&MemoText, "Aisle", 20);
    strncat(&MemoText, "\r\n", 5);

    ListGetNumOfItems(LIST_ITEMS, &total_list);
    if(total_list>100) total_list=100;
    
    for (x=0;x<total_list; x++)
    {
        ListGetListItem(LIST_QTY, x, (BYTE **)&item_text);
        strncat(&MemoText, item_text, 5);

        strncat(&MemoText, "  ", 5);
        ListGetListItem(LIST_ITEMS, x, (BYTE **) &item_text);
        strncat(&MemoText, item_text, 31);

        if(strlen(item_text)<12)
        {
            strncat(&MemoText, "\t\t", 5);
            strncat(&MemoText, "\t\t", 5);
        }
        strncat(&MemoText, "\t", 5);
        ListGetListItem(LIST_STORE, x, (BYTE **) &item_text);
        strncat(&MemoText, item_text, 31);        

        if(strlen(item_text)<8) strncat(&MemoText, "\t\t", 5);
        strncat(&MemoText, "\t", 5);
        ListGetListItem(LIST_AISLE, x, (BYTE **) &item_text);
        strncat(&MemoText, item_text, 5);

        strncat(&MemoText, "\r\n", 5);
    }

    if(DataFindDB(MEMODB, &memo_dbid))
    {
        if(DataOpenDB(memo_dbid,0,OPEN_RW))
        {
             if(DataNewRecord(memo_dbid,0,4,&rec_id))
             {
                   sketch = 0;
                   DataWriteField(memo_dbid,rec_id, 0, 8,  (BYTE*)&sketch);
                   DataWriteField(memo_dbid,rec_id, 1, (strlen(MemoText) + 1),  MemoText);

                   RtcGetTime(&date);
                   RtcFormatDate(&date, "YY~/MM~/DD", MemoText);
                   DataWriteField(memo_dbid,rec_id,2,(strlen(MemoText) + 1),  MemoText);
                   DataWriteField(memo_dbid,rec_id, 3, 1, (BYTE*)(""));

                   DataCloseRecord(memo_dbid, rec_id);
             }
             DataCloseDB(memo_dbid);
        }
    }
}



void Backup_toMemo()
{ 
    RTM     date;
    BYTE    sketch;
    BYTE    MemoText[10000];  //10000/100=100items
    UBYTE   cat;
    SHORT   total_list, x;
    UBYTE   rec_cat;
    UWORD   count;

    if(DataOpenDB(ShopperdbID,0,OPEN_RW))
    {
        DataTotalRecord(ShopperdbID, &recCount);

        //-------------recCount <100
        if(recCount>100) count=100;
        else count=recCount;
        strcpy(MemoText, "Backup of Shopping Information");
        strncat(&MemoText, "\r\n", 5);

        for (x=0;x<count; x++)
        {
            if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
            {
                DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                if(rec_cat==0)
                {
                    DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                    strncat(&MemoText, buffer, byte_read);
                    strncat(&MemoText, "\t\t", 5);
                    DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                    strncat(&MemoText, buffer, byte_read);
                    strncat(&MemoText, "\t\t", 5);
                    DataGetField(ShopperdbID, rec_id, 2, &buffer, &byte_read);
                    strncat(&MemoText, buffer, byte_read);
                    strncat(&MemoText, "\t\t", 5);
                    DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                    strncat(&MemoText, buffer, byte_read);
                    strncat(&MemoText, "\t\t", 5);
                    DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                    strncat(&MemoText, buffer, byte_read);
                    strncat(&MemoText, "\t\t", 5);
                    DataGetField(ShopperdbID, rec_id, 5, &buffer, &byte_read);
                    strncat(&MemoText, buffer, byte_read);
                    strncat(&MemoText, "\t\t", 5);
                    strncat(&MemoText, "\r\n", 5);
                    qfree(buffer);
                }
                DataCloseRecord(ShopperdbID,rec_id);
            }
        }

        DataCloseDB(ShopperdbID);
    }

    if(DataFindDB(MEMODB, &memo_dbid))
    {
        if(DataOpenDB(memo_dbid,0,OPEN_RW))
        {
            if(DataNewRecord(memo_dbid,0,4,&rec_id))
            {
                sketch = 0;
                DataWriteField(memo_dbid,rec_id, 0, 8,  (BYTE*)&sketch);
                DataWriteField(memo_dbid,rec_id, 1, (strlen(MemoText) + 1),  MemoText);
                //DataWriteField(memo_dbid,rec_id, 1, (strlen(MemoText)),  MemoText);
                
                RtcGetTime(&date);
                RtcFormatDate(&date, "YY~/MM~/DD", MemoText);
                //DataWriteField(memo_dbid,rec_id,2,(strlen(MemoText)),  MemoText);
                DataWriteField(memo_dbid,rec_id,2,(strlen(MemoText) + 1),  MemoText);
                
                DataWriteField(memo_dbid,rec_id, 3, 1, (BYTE*)(""));
                DataCloseRecord(memo_dbid, rec_id);
            }
            DataCloseDB(memo_dbid);
        }
    }

    //---------100-200 records
    if(recCount>100)
    {
        if(recCount>200) count=200;
        else count=recCount;
        if(DataOpenDB(ShopperdbID,0,OPEN_RW))
        {
            strcpy(MemoText, "Backup of Shopping Information2");
            strncat(&MemoText, "\r\n", 5);

            for (x=100;x<count; x++)
            {
                if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                {
                    DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                    if(rec_cat==0)
                    {
                        DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 2, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        strncat(&MemoText, "\r\n", 5);
                        qfree(buffer);
                    }
                    DataCloseRecord(ShopperdbID,rec_id);
                }
            }
            DataCloseDB(ShopperdbID);
        }

        if(DataFindDB(MEMODB, &memo_dbid))
        {
            if(DataOpenDB(memo_dbid,0,OPEN_RW))
            {           
                if(DataNewRecord(memo_dbid,0,4,&rec_id))
                {
                    sketch = 0;
                    DataWriteField(memo_dbid,rec_id, 0, 8,  (BYTE*)&sketch);
                    DataWriteField(memo_dbid,rec_id, 1, (strlen(MemoText) + 1),  MemoText);
                    RtcGetTime(&date);
                    RtcFormatDate(&date, "YY~/MM~/DD", MemoText);
                    DataWriteField(memo_dbid,rec_id,2,(strlen(MemoText) + 1),  MemoText);
                    
                    DataWriteField(memo_dbid,rec_id, 3, 1, (BYTE*)(""));
                    DataCloseRecord(memo_dbid, rec_id);
                }
                DataCloseDB(memo_dbid);
            }
        }
    }

    //---------200-300 records
    if(recCount>200)
    {
        if(recCount>300) count=300;
        else count=recCount;
        if(DataOpenDB(ShopperdbID,0,OPEN_RW))
        {
            strcpy(MemoText, "Backup of Shopping Information3");
            strncat(&MemoText, "\r\n", 5);

            for (x=200;x<count; x++)
            {
                if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                {
                    DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                    if(rec_cat==0)
                    {
                        DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 2, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        strncat(&MemoText, "\r\n", 5);
                        qfree(buffer);
                    }
                    DataCloseRecord(ShopperdbID,rec_id);
                }
            }
            DataCloseDB(ShopperdbID);
        }
        if(DataFindDB(MEMODB, &memo_dbid))
        {
            if(DataOpenDB(memo_dbid,0,OPEN_RW))
            {
                 if(DataNewRecord(memo_dbid,0,4,&rec_id))
                 {
                      sketch = 0;
                      DataWriteField(memo_dbid,rec_id, 0, 8,  (BYTE*)&sketch);
                      DataWriteField(memo_dbid,rec_id, 1, (strlen(MemoText) + 1),  MemoText);
                      RtcGetTime(&date);
                      RtcFormatDate(&date, "YY~/MM~/DD", MemoText);
                      DataWriteField(memo_dbid,rec_id,2,(strlen(MemoText) + 1),  MemoText);
                      
                      DataWriteField(memo_dbid,rec_id, 3, 1, (BYTE*)(""));
                      DataCloseRecord(memo_dbid, rec_id);
                 }
                 DataCloseDB(memo_dbid);
            }
        }
    }

    //---------300-400 records
    if(recCount>300)
    {
        if(recCount>400) count=400;
        else count=recCount;
        if(DataOpenDB(ShopperdbID,0,OPEN_RW))
        {
            strcpy(MemoText, "Backup of Shopping Information4");
            strncat(&MemoText, "\r\n", 5);

            for (x=300;x<count; x++)
            {
                if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                {
                    DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                    if(rec_cat==0)
                    {
                        DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 2, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        strncat(&MemoText, "\r\n", 5);
                        qfree(buffer);
                    }
                    DataCloseRecord(ShopperdbID,rec_id);
                }
            }
            DataCloseDB(ShopperdbID);
        }
        if(DataFindDB(MEMODB, &memo_dbid))
        {
            if(DataOpenDB(memo_dbid,0,OPEN_RW))
            {
                if(DataNewRecord(memo_dbid,0,4,&rec_id))
                {
                    sketch = 0;
                    DataWriteField(memo_dbid,rec_id, 0, 8,  (BYTE*)&sketch);
                    DataWriteField(memo_dbid,rec_id, 1, (strlen(MemoText) + 1),  MemoText);
                    RtcGetTime(&date);
                    RtcFormatDate(&date, "YY~/MM~/DD", MemoText);
                    
                    DataWriteField(memo_dbid,rec_id, 3, 1, (BYTE*)(""));
                    DataCloseRecord(memo_dbid, rec_id);
                }
                DataCloseDB(memo_dbid);
            }
        }
    }
    //---------400-500 records
    if(recCount>400)
    {
        if(recCount>200) count=500;
        else count=recCount;
        if(DataOpenDB(ShopperdbID,0,OPEN_RW))
        {
            strcpy(MemoText, "Backup of Shopping Information5");
            strncat(&MemoText, "\r\n", 5);

            for (x=400;x<count; x++)
            {
                if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                {
                    DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                    if(rec_cat==0)
                    {
                        DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 2, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                        strncat(&MemoText, buffer, byte_read);
                        strncat(&MemoText, "\t\t", 5);
                        strncat(&MemoText, "\r\n", 5);
                        qfree(buffer);
                    }
                    DataCloseRecord(ShopperdbID,rec_id);
                }
            }
            DataCloseDB(ShopperdbID);
        }
        if(DataFindDB(MEMODB, &memo_dbid))
        {
            if(DataOpenDB(memo_dbid,0,OPEN_RW))
            {
                  if(DataNewRecord(memo_dbid,0,4,&rec_id))
                  {
                       sketch = 0;
                       DataWriteField(memo_dbid,rec_id, 0, 8,  (BYTE*)&sketch);
                       DataWriteField(memo_dbid,rec_id, 1, (strlen(MemoText) + 1),  MemoText);
                       RtcGetTime(&date);
                       RtcFormatDate(&date, "YY~/MM~/DD", MemoText);
                       DataWriteField(memo_dbid,rec_id,2,(strlen(MemoText) + 1),  MemoText);
                       
                       DataWriteField(memo_dbid,rec_id, 3, 1, (BYTE*)(""));
                       DataCloseRecord(memo_dbid, rec_id);
                  }
                  DataCloseDB(memo_dbid);
            }
        }
    }
}

void    Restore_Database()
{
    int x;    

    if(DataFindDB(MEMODB, &memo_dbid))
    {
        if(DataOpenDB(memo_dbid,0,OPEN_RW))
        {
            DataTotalRecord(memo_dbid, &recCount);

            for (x=0;x<recCount; x++)
            {
                if(DataOpenRecord(memo_dbid,x,&rec_id,NULL))
                {
                    DataGetField(memo_dbid, rec_id,1,&buffer, &byte_read);
                    if(strstr(buffer, "Backup of Shopping Information"))
                    {                
                       // back_text=buffer;    //both are pointers
                        Reading_BackupMemo();
                    }
                    DataCloseRecord(memo_dbid, rec_id);
                    qfree(buffer);
                }
            }
            DataCloseDB(memo_dbid);
        }
    }

   
    //qfree(back_text);
    Read_Database();
}


void Reading_BackupMemo()  
{    
    int         x,z;
    char        sz[10];
    char        back_item[32];
    char        back_qty[11];
    char        back_cat[32];
    char        back_store[32];
    char        back_aisle[11];
    char        back_done[11];
    int         f,g,from_pos,to_pos;
    BYTE        rec_length;
    char        back_rec[110];
    RecordID    Srec_id;
    
    f=0;
    g=0;
     
     //reading the memo one char at a time
    for (x=0;x<byte_read; x++)
    {
       // if(back_text[x]=='\n')  //=new record
         if(buffer[x]=='\n') 
        {
            if(x==byte_read-1) break;

            if(f==0) //first occurence
            {
                from_pos=x;
                f=1;
            }
            else
            {
                to_pos=x;
                strncpy(back_rec,&buffer[from_pos],(to_pos-from_pos));
                
                //strncpy(back_rec,&back_text[from_pos],(to_pos-from_pos));
                back_rec[x-3]='\0';

                sprintf(sz,"\nfrom_pos=%i\n",from_pos);
                sprintf(sz,"to_pos=%i\n",to_pos);
                sprintf(sz,"back rec=%s\n",back_rec);

                //rec_length=to_pos-from_pos-4;
                rec_length=to_pos-from_pos;
                
                if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
                {
                    if(DataNewRecord(ShopperdbID,0,6,&Srec_id))
                    {
                       for (z=1;z<rec_length; z++)
                       {
                           if(back_rec[z]=='\t')   //new field
                           {
                               if(g==0) //field 0 Text
                               {                           
                                   from_pos=1;
                                   to_pos=z;
                                   sprintf(sz,"from_pos=%i\n",from_pos);
                                   sprintf(sz,"to_pos=%i\n",to_pos);
                                   strncpy(back_item,&back_rec[from_pos],(to_pos-from_pos));
                                   back_item[(to_pos-from_pos)]='\0';
                                   //back_item[z-1]='\0';
                                   DataWriteField(ShopperdbID,Srec_id, 0, 31,  (char *)back_item);
                                   from_pos=z+2;
                                   z=z+1;
                               }

                               if(g==1)//field 1 Qty
                               {
                                   to_pos=z;   
                                   strncpy(back_qty,&back_rec[from_pos],(to_pos-from_pos));
                                   back_qty[(to_pos-from_pos)]='\0';
                                   DataWriteField(ShopperdbID,Srec_id, 1, 3,  (char *)back_qty);
                                   from_pos=z+2;
                                   z=z+1;

                               }
                               if(g==2)//field 2 Category
                               {
                                   to_pos=z;
                                   strncpy(back_cat,&back_rec[from_pos],(to_pos-from_pos));
                                   back_cat[(to_pos-from_pos)]='\0';
                                   
                                   DataWriteField(ShopperdbID,Srec_id, 2, 31,  (char *)back_cat);
                                   from_pos=z+2;
                                   z=z+1;
                               }
                               if(g==3)//field 3 Store
                               {
                                   to_pos=z;
                                   strncpy(back_store,&back_rec[from_pos],(to_pos-from_pos));
                                   back_store[(to_pos-from_pos)]='\0';
                                  
                                   DataWriteField(ShopperdbID,Srec_id, 3, 31,  (char *)back_store);
                                   from_pos=z+2;
                                   z=z+1;
                               }
                               if(g==4)//field 4 Aisle
                               {
                                   //to_pos=z+3;
                                   to_pos=z;
                                   strncpy(back_aisle,&back_rec[from_pos],(to_pos-from_pos));

                                   back_aisle[(to_pos-from_pos)]='\0';
                                   
                                   DataWriteField(ShopperdbID,Srec_id, 4, 3,  (char *)back_aisle);
                                   from_pos=z+2;
                                   z=z+1;
                               }
                               if(g==5)//field 5 if done
                               {
                                   to_pos=z;
                                   strncpy(back_done,&back_rec[from_pos],(to_pos-from_pos));

                                   back_done[(to_pos-from_pos)]='\0';
                                   DataWriteField(ShopperdbID,Srec_id, 5, 3,  (char *)back_done);
                               }
                               g=g+1;
                           }
                       } //for
                       from_pos=x;
                       g=0;
                    }          
                       DataCloseRecord(ShopperdbID,Srec_id);
                }
                //qfree(back_text);
                DataCloseDB(ShopperdbID);
            }
        }
    }
}