//Database.c Part of Helio shopping list application
//Deals with access to the shopping database, adding/editing records.

#include "main.h"

//local variables
BYTE        *TextField;
int         del_chk=0; 

//functions
void        Add_Record();
void        Create_Database();
void        Delete_Record();
void        Done_Quantity();
void        Done_Record();
void        Reset_Qty();
void        Save_Quantity();

extern void Filter();  //see main.c

void Create_Database()
{
    if(!DataFindDB("ShopperDB", &ShopperdbID))
    {
        if(DataNewDB((BYTE*)("ShopperDB"), 1, (BYTE *)("Heidi"), &ShopperdbID))
        {           
            if(DataOpenDB(ShopperdbID,0,OPEN_RW))
            {
                 //default values - cat.3, 4 fields
                 if(DataNewRecord(ShopperdbID,3,4,&rec_id))
                 {
                     //font
                     DataWriteField(ShopperdbID,rec_id, 0, 31, "Small Font");
                     font=SMALL_FONT;
                     //categroy
                     DataWriteField(ShopperdbID,rec_id, 1, 31,  "Shopping List");
                     item_cat="Shopping List";
                     //store
                     DataWriteField(ShopperdbID,rec_id, 2, 31,  "All Stores");
                     item_store="All Stores";
                     //sort-field
                     DataWriteField(ShopperdbID,rec_id, 3, 2,  "0");
                     sort_field=0;
                     DataCloseRecord(ShopperdbID,rec_id);
                 }
                 DataCloseDB(ShopperdbID);
            }
        }
    }
}

void Add_Record()
{
    char aisle_text[3];
    
    TextboxGetTextPointer(TB_ITEM, &TextField);
    if(strcmp(TextField,"")!=0)
    {
         if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
         {
             if (del_chk==1)
             {
                 DataDeleteRecord(ShopperdbID, edit_id, FALSE);
             }
             ControlGetLabel(POPUP_CAT, &item_cat);
             ControlGetLabel(EPOPUP_STORE, &item_store);
             if(strstr(item_cat,"Edit Categories"))    
                         item_cat="Unfiled";                
             if(strstr(item_store,"Edit Stores"))
                         item_store="Any";
             
             if(DataNewRecord(ShopperdbID,0,6,&rec_id))
             {
                  DataWriteField(ShopperdbID,rec_id, 0, 31,  TextField);    //category 0

                  TextboxGetTextPointer(TB_QTY, &TextField);
                  DataWriteField(ShopperdbID,rec_id, 1, 5,  TextField);

                  DataWriteField(ShopperdbID,rec_id, 2, 31,  item_cat);

                  DataWriteField(ShopperdbID,rec_id, 3, 31,  item_store);

                  TextboxGetTextPointer(TB_AISLE, &TextField);
                  if(strlen(TextField)==1)
                  {
                      strcpy(aisle_text," ");
                      strncat(aisle_text,TextField,3);
                      TextField=aisle_text;
                  }
                  DataWriteField(ShopperdbID,rec_id, 4, 5, TextField);    
   
                  switch(edit_chk)
                  {
                       case 0: DataWriteField(ShopperdbID,rec_id, 5, 5, "-");
                               break;
                       case 1: DataWriteField(ShopperdbID,rec_id, 5, 5, record_done);
                               break;
                       case 2: DataWriteField(ShopperdbID,rec_id, 5, 5, "-");
                               break;
                       case 3: DataWriteField(ShopperdbID,rec_id, 5, 5, "-");
                               break;
                       case 4: DataWriteField(ShopperdbID,rec_id, 5, 5, "-");
                               break;
                  }              
                  DataCloseRecord(ShopperdbID,rec_id);
             }
              DataCloseDB(ShopperdbID);
         }
    }
    qfree(TextField);
    edit_chk=0;
    //done_chk=0;
    del_chk=0;
    FormPopupForm(FORM_MAIN);
}

void Delete_Record()
{
    BYTE *recordStore;
    int   x=0;
    
    TextboxGetTextPointer(TB_ITEM, &TextField);
    if(strcmp(TextField,"")!=0)
    {
        if(DataFindDB("ShopperDB", &ShopperdbID))
        {
            if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
            {
                DataTotalRecord(ShopperdbID, &recCount);
                for(x=0;x<recCount;x++)
                {
                    if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                    {
                          DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                          DataGetField(ShopperdbID, rec_id, 3, &buffer1, &byte_read);
                          DataCloseRecord(ShopperdbID,rec_id);

                          if(strcmp(buffer,record_text)==0)
                          {
                              if(strcmp(buffer1,record_store)==0)
                              {
                                  DataDeleteRecord(ShopperdbID, rec_id, FALSE);
                                  break;
                              }
                          }
                          qfree(buffer);
                          qfree(buffer1);
                    }                
                }
                DataCloseDB(ShopperdbID);
            }
        qfree(recordStore);//new3
        } 
    }
    ListSetHighlightedItem (LIST_ITEMS, -1);  
    ListSetHighlightedItem (LIST_DONE, -1); 
    ListSetHighlightedItem (LIST_AISLE, -1); 
    ListSetHighlightedItem (LIST_QTY, -1);   
    qfree(TextField);
    FormPopupForm(FORM_MAIN);
    item_cat="All";
    item_store="All Stores";
    Filter();
}

void Done_Record()
{
    int  x=0;

    if(listno!=NO_SELECTION)
    {
        if(DataFindDB("ShopperDB", &ShopperdbID))
        {
            if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
            {
                DataTotalRecord(ShopperdbID, &recCount);
                ListGetListItem(LIST_ITEMS, listno, (BYTE **) &recordText);

                for(x=0;x<recCount;x++)
                {
                    if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                    {
                        DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);  //item

                        if(strcmp(buffer,recordText)==0)
                        {
                            DataWriteField(ShopperdbID,rec_id, 5, 5, "V");
                            ListDeleteItem(LIST_DONE, listno);
                            ListInsertItem(LIST_DONE, listno, "V");                    
                        }
                        DataCloseRecord(ShopperdbID,rec_id);
                    }
                }
                DataCloseDB(ShopperdbID);
            }
            qfree(buffer);
        }
    }
    ListDrawList(LIST_DONE);
    Redraw_Line();
}

void Done_Quantity()
{
    int  x=0;

    if(listno!=NO_SELECTION)
    {
        if(DataFindDB("ShopperDB", &ShopperdbID))
        {
            if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
            {
                DataTotalRecord(ShopperdbID, &recCount);
                ListGetListItem(LIST_ITEMS, listno, (BYTE **) &recordText);

                for(x=0;x<recCount;x++)
                {
                    if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                    {
                        DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                        if(strcmp(buffer,recordText)==0)
                        {
                            DataWriteField(ShopperdbID,rec_id, 1, 3, "0");
                            DataWriteField(ShopperdbID,rec_id, 5, 3, "-");
                            ListDeleteItem(LIST_QTY, listno);
                            DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                            ListInsertItem(LIST_QTY, listno, buffer);
                            
                            DataGetField(ShopperdbID, rec_id, 5, &buffer, &byte_read);                    
                            ListDeleteItem(LIST_DONE, listno);
                            ListInsertItem(LIST_DONE, listno, buffer);
                        }
                        DataCloseRecord(ShopperdbID,rec_id);
                    }
                }
                DataCloseDB(ShopperdbID);
            }
            qfree(buffer);
        }
    }
    ListDrawList(LIST_QTY);
    ListDrawList(LIST_DONE);
    Filter();
    Redraw_Line();
}

void Save_Quantity()
{
    char *recordQty;
    char qty_text[10];
    int  q_value;
    int  x=0;

    if(listno!=NO_SELECTION)
    {
        if(DataFindDB("ShopperDB", &ShopperdbID))
        {
            if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
            {
                DataTotalRecord(ShopperdbID, &recCount);
                ListGetListItem(LIST_ITEMS, listno, (BYTE **) &recordText);
                ListGetListItem(LIST_QTY, listno, (BYTE **) &recordQty);
                q_value=atol((char*)recordQty);

                for(x=0;x<recCount;x++)
                {
                    if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                    {
                        DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                        
                        if(strcmp(buffer,recordText)==0)
                        {
                            // if(strcmp(buffer1,recordStore)==0)
                            {                       
                                if(qty_no==1)
                                {
                                    strcpy(qty_text,"0");
                                    qty_no=0;
                                }
                                else
                                {
                                    DataGetField(ShopperdbID, rec_id,1, &buffer, &byte_read);
                                    q_value=atol((char*)buffer);
                                    q_value=q_value+1;
                                    ltoa(q_value, (char*)qty_text, 2);
                                }
                                DataWriteField(ShopperdbID,rec_id, 1, 3, qty_text);
                                DataWriteField(ShopperdbID,rec_id, 5, 3, "-");
                                ListDeleteItem(LIST_QTY, listno);
                                ListInsertItem(LIST_QTY, listno, qty_text);

                                strcpy(qty_text,"0");
                                ListDeleteItem(LIST_DONE, listno);
                                ListInsertItem(LIST_DONE, listno, qty_text);
                            }
                        }
                        DataCloseRecord(ShopperdbID,rec_id);
                    }
                }
                DataCloseDB(ShopperdbID);
            }
            qfree(buffer);
            qfree(recordQty);//new3
        }
    }
    Filter();
    Redraw_Line();
}

void Reset_Qty()      //reset all quantities to 0
{
    int  x=0;

    if(DataFindDB("ShopperDB", &ShopperdbID))
    {
        if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
        {
            DataTotalRecord(ShopperdbID, &recCount);

            for(x=0;x<recCount;x++)
            {
                if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                {
                     DataWriteField(ShopperdbID,rec_id, 1, 5,  "0");
                     DataWriteField(ShopperdbID,rec_id, 5, 3, "-");
                     DataCloseRecord(ShopperdbID,rec_id);
                }
            }
            DataCloseDB(ShopperdbID);
        }
    }
    Filter();
}