/*
 * @(#)gccfix.c
 *
 * Copyright 1999-2001, Aaron Ardiri (mailto:aaron@ardiri.com)
 * All rights reserved.
 *
 * The  source code outlines a number of basic Helio Computing Programming
 * principles and you  should be able to take the core structure and write 
 * a large complex program. It is distributed WITHOUT ANY WARRANTY; use it
 * "AS IS" and at your own risk.
 *
 * The code presented is Copyright 2000 by Aaron Ardiri. It should be used
 * for educational purposes only.  You  shall not modify the Cube3D source 
 * code in any way and re-distribute it as your own, however you  are free 
 * to  use the  code as a  guide  for  developing  programs on  the  Helio 
 * Computing Platform.
 */

#include "helio.h"

/**
 * The Helio Computing Platform entry routine (mainline).
 *
 * @param cmd    a word value specifying the launch code.
 * @param cmdPBP pointer to a structure associated with the launch code.
 * @return zero if launch successful, non zero otherwise.
 */
BOOLEAN
__main(WORD cmd, void *cmd_ptr)
{
  BOOLEAN result = FALSE;

  // what type of launch was this?
  switch (cmd) 
  {
    case LAUNCH_CMD_NORMAL_LAUNCH:
         {
           UIApplicationInit();
	   HelioMain(cmd, cmd_ptr);
           UIDeleteAllAppObjects();
         }
         result = TRUE;
         break;

    case LAUNCH_CMD_GOTO_REC:
         if (((GotoRec*)cmd_ptr)->find_string != NULL)
           pfree(((GotoRec*)cmd_ptr)->find_string);

    case LAUNCH_CMD_FIND:
    case LAUNCH_CMD_ALARM_HIT:
         pfree(cmd_ptr);
         result = TRUE;
         break;

    default:
         break;
  }

  return result;
}
