/*
*	Network library (byte-stream sockets)
*
*	Nicholas Christopoulos
*/

#if !defined(_inet_ndclib_h)
#define _inet_ndclib_h

#include "sys.h"
#if defined(_PalmOS)
    #include <NetMgr.h>

    typedef NetSocketRef     socket_t;
#else
	#include <string.h>
	#include <sys/types.h>
	#include <errno.h>

	#if defined(_UnixOS)
		#include <sys/socket.h>
		#include <netinet/in.h>
		#include <sys/param.h>
		#include <netdb.h>
		#include <arpa/inet.h>
	#elif defined(_DOS)
	//#define _DOSTCP_ENABLE

	#if defined(_DOSTCP_ENABLE)
		#include <netinet/in.h>
		#include <socket.h>
		#define INADDR_NONE    NULL
	#endif
	#elif defined(_Win32)
		#include <winsock2.h>	// @#@!$@#!$ it uses 'byte'
	#endif

    typedef int     socket_t;
#endif

int     net_init(void)                                              SEC(BIO);
int     net_close(void)                                             SEC(BIO);
void    net_print(socket_t s, const char *str)                      SEC(BIO);
void    net_printf(socket_t s, const char *fmt, ...)                SEC(BIO);
int		net_input(socket_t s, char *buf, int size, const char *delim)   SEC(BIO);
socket_t  net_connect(const char *server_name, int server_port)     SEC(BIO);
void	net_disconnect(socket_t s)                                  SEC(BIO);
int		net_peek(socket_t s)										SEC(BIO);

#endif


