
/*
*	Keyboard codes
*/

#if !defined(_sb_keycodes_h)
#define _sb_keycodes_h

#if defined(_PalmOS)
//
//	PalmOS
//

// PalmOS - SB H/W KEYS
#define	SB_KEY_PALM_PGUP	0xFF01
#define	SB_KEY_PALM_PGDN	0xFF02
#define	SB_KEY_PALM_BTN1	0xFF03
#define	SB_KEY_PALM_BTN2	0xFF04
#define	SB_KEY_PALM_BTN3	0xFF05
#define	SB_KEY_PALM_BTN4	0xFF06
#define	SB_KEY_PALM_FIND	0xFF07
#define	SB_KEY_PALM_CALC	0xFF08
#endif

// COMMON
#if defined(__linux__)
#define	SB_KEY_BACKSPACE	127			// Linux has problem with ^H
#define	SB_KEY_DELETE		8           // ??????????
#else
#define	SB_KEY_BACKSPACE	8
#define	SB_KEY_DELETE		127
#endif

#if defined(_PalmOS)
#define	SB_KEY_BREAK		SB_KEY_PALM_BTN4		// MemoPad
#else
#define	SB_KEY_BREAK		0x3				// Ctrl+C
#endif

#define	SB_KEY_TAB			9
#define	SB_KEY_ENTER		'\n'

// first 16 - common with handhelds any extra key will be there
#define	SB_KEY_PGUP			0xFF01
#define	SB_KEY_PGDN			0xFF02
#define	SB_KEY_LEFT			0xFF04
#define	SB_KEY_RIGHT		0xFF05
#define	SB_KEY_UP			0xFF09
#define	SB_KEY_DN			0xFF0A

// second 16 - common on PCs
#define	SB_KEY_INSERT		0xFF10
#define SB_KEY_HOME			0xFF11
#define SB_KEY_END			0xFF12

// function keys (16 codes)
#define	SB_KEY_F(x)			(0xFFF0+(x))

// Control & Alt keys (parameter = capital character)
#define	SB_KEY_CTRL(x)		((x)-'0')
#define	SB_KEY_ALT(x)		(0xFF20+(((x)>='a') ? (x)-57 : (x)-31))

#endif

