/*
*	mem.h
*
*	Memory manager unix/palm
*
*	Nicholas Christopoulos
*
*	This program is distributed under the terms of the GPL v2.0 or later
*	Download the GNU Public License (GPL) from www.gnu.org
*/

#if !defined(_sb_mem_h)
#define	_sb_mem_h

#if defined(MALLOC_LIMITED)
#include <string.h>
#endif

#if defined(__cplusplus)
extern "C" {
#endif

#if defined(_PalmOS)
	#define memset(a,b,c)	MemSet((a),(c),(b))
#endif

#if !defined(NULL)
	#define NULL	(void*)0L
#endif

#define ENABLE_TMPLIST

#if defined(_Win32)
#include <winsock2.h>	// there are conflicts for data types: byte, int32
#endif

/*
*	data-types
*/
#if defined(MALLOC_LIMITED)
typedef	unsigned long	MemHandle;
#define	MemPtrNew(x)	malloc(x)
#define	MemPtrFree(x)	free(x)
#endif
typedef	MemHandle		mem_t;

#if !defined(_Win32)
typedef	unsigned char	byte;
#endif
typedef	byte*			byte_p_t;
typedef	char*			char_p_t;

// 16-bit integer
typedef	int short		int16;
typedef	unsigned short	word;

// 32-bit integer
#if defined(_PalmOS)
typedef	long			int32;
typedef	unsigned long	dword;
#else	/* Unix, Win32 */
#if !defined(_Win32)
typedef	int				int32;
#endif
typedef	unsigned int	dword;
#endif

// old code
#if !defined(_Win32) && !defined(_VTOS)
typedef	dword	DWORD;
typedef	word	WORD;
typedef	byte	BYTE;
#endif

// code 
typedef byte        	code_t;		// basic code unit 				(unsigned)

#if	defined(OS_ADDR16)				// work with 16bits
#define	ADDR16						// just for short defs

typedef int16			fcode_t;	// buildin function code 		(signed)
typedef int16			pcode_t;	// buildin procedure code		(signed)
typedef word        	addr_t;		// memory address				(unsigned)
#define INVALID_ADDR    0xFFFF		// invalid address value		(unsigned)
typedef int16        	bid_t;		// IDs (labels, variables, etc)	(signed)
#define	OS_ADDRSZ		2			// size of address pointer (always 2 for 16b mode)
#define	OS_CODESZ		2			// size of buildin func/proc ptrs (always 2 for 16b mode)
#define	OS_STRLEN		2			// size of strings

#else
typedef int32			fcode_t;
typedef int32			pcode_t;
typedef dword	        addr_t;
typedef int32			bid_t;
#define INVALID_ADDR    0xFFFFFFFF
#define	OS_ADDRSZ		4			// size of address pointer (always 4 for 32b addresses)
#define	OS_CODESZ		4			// size of buildin func/proc ptrs (always 4 for 32b mode)
#define	OS_STRLEN		4			// size of strings

#endif

// ---------------------------------------------

#define	ADDRSZ			OS_ADDRSZ
#define	CODESZ			OS_CODESZ
#define	BC_CTRLSZ		(ADDRSZ+ADDRSZ)

#if defined(OS_PREC64)
#define	OS_INTSZ		8			// size of integer
#define	OS_REALSZ		16			// size of real
#else
#define	OS_INTSZ		4			// size of integer
#define	OS_REALSZ		8			// size of real
#endif

// ---------------------------------------------

// Dynamic RAM
#if defined(_PalmOS) || defined(MALLOC_LIMITED)
void	*tmp_alloc(dword size);
void	tmp_free(void *ptr);
#else
#define	tmp_alloc(s)	tmp_allocX((s), __FILE__, __LINE__)
#define	tmp_free(p)		tmp_freeX((p), __FILE__, __LINE__)
void	*tmp_allocX(dword size, const char *file, int line);
void	tmp_freeX(void *ptr, const char *file, int line);
#endif
void    *tmp_realloc(void *ptr, dword size);

char	*tmp_strdup(const char *source);

// Storage RAM
#if defined(_PalmOS) || defined(MALLOC_LIMITED)
mem_t	mem_alloc(dword size);
#else
#define	mem_alloc(s)	mem_allocX((s), __FILE__, __LINE__)
mem_t	mem_allocX(dword size, const char *file, int line);
#endif
mem_t	mem_realloc(mem_t handle, dword new_size);
void*	mem_lock(mem_t h);
void	mem_unlock(mem_t h);
void	mem_free(mem_t h);
mem_t	mem_new_text(const char *text);

#if defined(MALLOC_LIMITED)
dword	MemPtrSize(void *ptr);
dword	MemHandleSize(mem_t h);
#endif

/*
*	standard list (with handles) --- dynamic single-linked list, stored in STORAGE RAM
*/
//#define ENABLE_MEMLIST
#if defined(ENABLE_MEMLIST)

struct mem_list_node_s	{
	mem_t	data;
	struct mem_list_node_s
			*next;
	};
typedef struct mem_list_node_s	mnode_t;

struct mem_list_s	{
	mnode_t		*head, *tail;
	int			count;
	};
typedef struct mem_list_s mlist_t;

void	mlist_init(mlist_t *lst)			SEC(TRASH);
void	mlist_clear(mlist_t *lst)			SEC(TRASH);	
mnode_t	*mlist_add(mlist_t *lst, mem_t h)	SEC(TRASH);
#endif


/*
*	temporary list --- dynamic single-linked list, stored in DYNAMIC RAM
*/
//#define ENABLE_TMPLIST
#if defined(ENABLE_TMPLIST)

struct tmpmem_list_node_s	{
	void	*data;
	struct tmpmem_list_node_s
			*next;
	};
typedef struct tmpmem_list_node_s	tmpnode_t;

struct tmpmem_list_s	{
	tmpnode_t	*head, *tail;
	int			count;
	};
typedef struct tmpmem_list_s tmplist_t;

void	tmplist_init(tmplist_t *lst)		SEC(TRASH);
void	tmplist_clear(tmplist_t *lst)		SEC(TRASH);
tmpnode_t	*tmplist_add(tmplist_t *lst, void *ptr, int size)	SEC(TRASH);
#endif


// logfile
void	lwrite(const char *buf)				SEC(TRASH);
void	lprintf(const char *fmt, ...)		SEC(TRASH);
void	lg(const char *fmt, ...)			SEC(TRASH);

// Virtual memory
//#define ENABLE_VMM
#if defined(ENABLE_VMM)
void	vm_init(void)						SEC(TRASH);
void	vm_close(void)						SEC(TRASH);

int		vm_halloc(word size)				SEC(TRASH);
void	vm_hfree(int idx)					SEC(TRASH);

void*	vm_lock(int idx)					SEC(TRASH);
void	vm_unlock(int idx)					SEC(TRASH);

void*	vm_alloc(word size)					SEC(TRASH);
void	vm_free(void*)						SEC(TRASH);
#endif

// PalmOS database I/O
#if defined(_PalmOS)
typedef	DmOpenRef	dbt_t;
#else
typedef	int			dbt_t;
#endif

dbt_t	dbt_create(const char *fileName)						SEC(TRASH);
void	dbt_close(dbt_t f)										SEC(TRASH);
void	dbt_write(dbt_t f, int index, void *ptr, int size)		SEC(TRASH);
void	dbt_read(dbt_t f, int index, void *ptr, int size)		SEC(TRASH);
void	dbt_prealloc(dbt_t f, int num, int size)				SEC(TRASH);

#if defined(__cplusplus)
}
#endif

#endif

