/*
*	SmallBASIC, RTL API (Parameter's API)
*
*	Nicholas Christopoulos
*
*	This program is distributed under the terms of the GPL v2.0 or later
*	Download the GNU Public License (GPL) from www.gnu.org
*/

#if !defined(_sb_proc_h)
#define _sb_proc_h

#include "sys.h"
#include "str.h"
#include "kw.h"
#include "panic.h"
#include "var.h"
#include "device.h"
#include "blib.h"
#include "sberr.h"

#if !defined(PI)
#define	PI	3.14159265358979323846
#endif

#define	PV_CONSOLE				0
#define	PV_FILE					1
#define	PV_LOG					2
#define	PV_STRING				3

#if defined(__cplusplus)
extern "C" {
#endif

#define pfree(a)		{ if ((a))	  tmp_free((a));		}
#define pfree2(a,b)		{ pfree((a)); pfree((b)); 			}
#define pfree3(a,b,c)	{ pfree2((a),(b)); pfree((c)); 		}
#define pfree4(a,b,c,d)	{ pfree3((a),(b),(c)); pfree((d));	}

/* */
#if !defined(BRUN_MODULE)
extern int      prog_error;				// Non-zero = run-time error was happened
extern addr_t   prog_length;			// byte-code size
extern byte     *prog_source;			// the byte-code itself
extern addr_t   prog_ip;				// instruction pointer
extern int      prog_line;				// current source-line
extern var_t    **tvar; 				// table of variables
extern lab_t    *tlab;					// table of labels
extern addr_t	data_ip;				// READ/DATA position
#endif

/*
*	low-level
*/
void	bc_loop(int isf);
void	eval(var_t *result);
void	eval_alloc_stack(void);
void	eval_free_stack(void);
addr_t	getarrayidx(var_t *array);
void	set_dataip(word label_id)							SEC(BLIB);

void	pv_write(char *str, int method, int handle)			SEC(BIO2);
void	pv_writevar(var_t *var, int method, int handle)	   	SEC(BIO2);
void	print_var(var_t *var)								SEC(BIO2);
void	fprint_var(int handle, var_t *var)					SEC(BIO2);
void	logprint_var(var_t *var)							SEC(BIO2);


/*
*	Parameter's API
*
*	Use these functions
*/

/*
*	Parameter structure, used in 'partables'
*/
typedef struct	{
	var_t	*var;		// a var_t pointer; the data

	byte	prev_sep;	// previous separator (default '\0')
	byte	next_sep;	// next separator (default '\0')

	byte	flags;		// 
						// 0x1 = its a 'byval' and the 'var' must be released
	} par_t;

/* par_t flags */
#define	PAR_BYVAL	1	// parameter was an expression (var = the temporary copy of the result)

/*
*	low-level parameters parser
*/
void	par_getvar(var_t *var)			SEC(BLIB);	
var_t	*par_getvar_ptr(void)			SEC(BLIB);
void	par_getstr(var_t *var)			SEC(BLIB);
long	par_getint(void)				SEC(BLIB);
double	par_getnum(void)				SEC(BLIB);
#define	par_getreal()		par_getnum()
int		par_getsep(void)				SEC(BLIB);
void	par_getcomma(void)				SEC(BLIB);
void	par_getsharp(void)				SEC(BLIB);
void	par_getsemicolon(void)			SEC(BLIB);
var_t	*par_getvarray(void)			SEC(BLIB);
int     par_isonevar(void)				SEC(BLIB);
void	par_skip(void)					SEC(BLIB);

/*
*	high-level parameters parser
*/

// return parameters as a table --- read remarks on proc.c
int		par_getpartable(par_t **ptable_pp, const char *valid_sep)	SEC(BLIB);
void	par_freepartable(par_t **ptable_pp, int pcount)				SEC(BLIB);

// return parameters as scanf-style --- read remarks on proc.c
int		par_massget(const char *fmt, ...)							SEC(BLIB);

// execute 'USE' expressions --- read remarks on proc.c
void	exec_usefunc(var_t *var, addr_t ip)							SEC(BLIB);		// one parameter    (x)
void	exec_usefunc2(var_t *var1, var_t *var2, addr_t ip)			SEC(BLIB);		// two parameters   (x,y)
void	exec_usefunc3(var_t *var1, var_t *var2, var_t *var3, addr_t ip) SEC(BLIB);	// three parameters (x,y,z)

/*
*	Special parameters
*/
pt_t	par_getpt(void)				SEC(BIO2);		// get a point parameter
int		par_getpoly(pt_t **poly)	SEC(BIO2);		// get a polyline
ipt_t	par_getipt(void)			SEC(BIO2);		// get a point parameter (integers)
int		par_getipoly(ipt_t **poly)	SEC(BIO2);		// get a polyline (integers)

#if defined(__cplusplus)
}
#endif

#endif

