/*
*	SmallBASIC - COMPILER/EXECUTOR/IDE COMMON DEFS
* 
*	Nicholas Christopoulos
*/

#if !defined(_smbas_h)
#define _smbas_h

#include "sys.h"

#if defined(__cplusplus)
extern "C" {
#endif

#define	BRUN_RUNNING	0
#define	BRUN_STOPPED	1

/*
*	compiler options
*/
#if !defined(BRUN_MODULE)
extern byte	opt_graphics;			// command-line option: start in graphics mode
extern byte	opt_quite;				// command-line option: quite
extern int	opt_retval;				// return-value 
extern byte	opt_decomp;		 		// decompile
extern char	*opt_command;	   		// command-line parameters
extern byte os_charset;				// charset
extern byte	opt_safedraw;			// using safest drawing routines (PalmOS: Use API for draw)
#endif


/*
*	byte-code header
*/
typedef struct {
	char	sign;				// always 'V'
	byte	unused;
	word	ver;				// version of this structure
	dword	sbver;				// version of SB
	dword	flags;				// flags
								// b0 = Big-endian CPU
								// b1 = BC 16bit
								// b2 = BC 32bit

	dword	size;				// total size (include label-table and bc)
	dword	bc_count;			// BC length
	dword	var_count;			// number of variables
	dword	lab_count;			// number of labels
	dword	data_ip;			// default DATA position

	//
	char	reserved[32];
	} bc_head_t;

/*
*/
void	bc_init(void)				SEC(BCSCAN);
void	bc_load(const char *fileName) SEC(BCSCAN);
void	bc_scan(const char *section, const char *text) SEC(BCSCAN);
void	bc_pass2(void)				SEC(BCSCAN);
void	bc_check_labels(void)		SEC(BCSCAN);
int		bc_get_error(void)			SEC(BCSCAN);
void	bc_close(void)				SEC(BCSCAN);
mem_t	bc_createbin(void)			SEC(BCSCAN);

int		basFileExist(const char *basfile) SEC(TRASH);

void	brun(char *file, int nocomp);
void	brun_break(void)			;
void	brun_stop(void)				;
int		brun_status(void)			;

void	brun_init(byte *source)		;
int		brun_close(void) 			;
void	brun_load(char *fileName, int nocomp)	;

#if defined(__cplusplus)
}
#endif

#endif
