/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   dev_snd.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for sound low level driver
Revision    :   1.1
Note        :   18/08/98   Prepared by Andrew Hui (AH)                     
                07/01/99   2.0 change sib access method                    
                08/09/99   2.1 Fixed Physical address masking              
===========================================================================
*/              
                
#ifndef __SND_DD_FUNCTION__
#define __SND_DD_FUNCTION__


extern volatile WORD SndInitState;
extern volatile WORD SndEnableState;


void SndInit(WORD SamplingRate, WORD DataLength, WORD InputGain, WORD OutputAttn );
void SndInitSM();
void SndEnable(WORD Channel);
void SndEnableSM();


extern WORD SibReg;
extern void (*SibAccessReqAck)();  /* SIB access grant acknowledge; init to zero*/
extern void (*SibReadReqAck)();    /* Return from SibRead : Internal use only */
extern void (*SibWriteReqAck)();   /* Return from SibWrite: Internal use only */
extern WORD       SibIntState;
extern WORD       SibRdState;
extern WORD       SibWrtState;
extern WORD       SibDataInBuf;



void SibRead();
void SibWrite();

void SibInit();

#define SibEnable()  CPU->REG_SIB_CTRL |= ENSIB       /* Enable  SIB   */


/* switch for enable/disable DMA buffers swapping */
#define SND_PLAYING     0x1
#define SND_RECORDING   0x2

#define SND_BUF_SIZE    160     /* buffer size of in, out, working buffer */


/* switch for DMA Input/Output enable/disable */
#define MIC                     1
#define SPEAKER                 2

#define SIBCLK_F               SIB_CLK_RATE            /* SIB Clock Rate */

#define AUDIO_SAMPLE_RATE(a)    ((SIBCLK_F*2)/(64*a))

#define SR_8KHZ    AUDIO_SAMPLE_RATE(8000)
#define SR_16KHZ   AUDIO_SAMPLE_RATE(16000)




//#define SR_8KHZ 36      /* sibclock =   9MHz */
//#define SR_8KHZ 18      /* sibclock = 4.5MHz */

//#define SR_16KHZ   AUDIO_SAMPLE_RATE(16000)




#define REG_BASE 0xb0c00000

#define SndTxDmaAddr(a)         (CPU->REG_SIB_SND_TX_START= (a))
#define SndRxDmaAddr(a)         (CPU->REG_SIB_SND_RX_START= (a))
//#define SndDmaLen(snd)          (CPU->REG_SIB_SIZE = ((snd&0x3ffC)<<16))

extern SHORT  sndibuf1[SND_BUF_SIZE];
extern SHORT  sndibuf2[SND_BUF_SIZE];
extern SHORT  sndobuf1[SND_BUF_SIZE];
extern SHORT  sndobuf2[SND_BUF_SIZE];

extern WORD   SndAction ;                     /* init to zero */
extern WORD   frame_no ;                      /* init to zero */


extern WORD   SndInBuf;
extern WORD   SndOutBuf;
extern WORD   SndWrkInBuf;
extern WORD   SndWrkOutBuf;
extern WORD   SndInBufPA;
extern WORD   SndOutBufPA;
extern WORD   SndWrkInBufPA;
extern WORD   SndWrkOutBufPA;

extern WORD   SM_par1, SM_par2, SM_par3, SM_par4, SM_par5;


#define BTY_ADC_INT     BTY_ADC_INT_STAT
#define BTY_TTP_INT     BTY_TSPX_INT_STAT
#define BTY_IO_INT      BTY_IO_INT_STAT

#endif __SND_DD_FUNCTION__

