#ifndef _SYSDEF_H_
#define _SYSDEF_H_
/*
#include "include\uifunc.h"
#include "include\uidef.h"
#include "include\ui.h"
#include "include\mmu.h"
*/
#include "include\system.h"
#include "include\sysetup.h"

/******************************************************************
***************** SYSTEM SETUP OBJECT ID DEFINES ******************
******************************************************************/

/*===============================================================*/
/*============== FORM_SYSETUP_COUNTRY ===========================*/
#define		FORM_SYSETUP_COUNTRY					0
#define		STRING_SYSETUP_COUNTRY_COUNTRY			1
#define		STRING_SYSETUP_COUNTRY_REGIONAL			2
#define		STRING_SYSETUP_COUNTRY_TFORMAT			3
#define		STRING_SYSETUP_COUNTRY_TSAMPLE			4
#define		STRING_SYSETUP_COUNTRY_TSAMPLE_TIME		5
#define		STRING_SYSETUP_COUNTRY_DFORMAT			6
#define		STRING_SYSETUP_COUNTRY_START_WK			7
#define		STRING_SYSETUP_COUNTRY_NUM				8
#define		STRING_SYSETUP_COUNTRY_UNITS			9
#define		POPUP_SYSETUP_COUNTRY_REGIONAL			10
#define		POPUP_SYSETUP_COUNTRY_TFORMAT			11
#define		POPUP_SYSETUP_COUNTRY_DFORMAT			12
#define		POPUP_SYSETUP_COUNTRY_START_WK			13
#define		POPUP_SYSETUP_COUNTRY_NUM				14
#define		POPUP_SYSETUP_COUNTRY_UNITS				15
#define		LINE_SYSETUP_COUNTRY_COUNTRY			16

/*===============================================================*/
/*============== FORM_SYSETUP_MODEM =============================*/
#define		FORM_SYSETUP_MODEM						17
#define		STRING_SYSETUP_MODEM_MODEM				18
#define		STRING_SYSETUP_MODEM_DIAL				19
#define		TEXTBOX_SYSETUP_MODEM_DIAL				20
#define		BITMAP_SYSETUP_MODEM_DIALKPAD			21
#define		BITMAP_SYSETUP_MODEM_DIALKB				22
#define		BITMAP_SYSETUP_MODEM_DIALKC				23
#define		BITMAP_SYSETUP_MODEM_DIALKF				24
#define		BITMAP_SYSETUP_MODEM_DIALK1				25
#define		BITMAP_SYSETUP_MODEM_DIALK2				26
#define		BITMAP_SYSETUP_MODEM_DIALK3				27
#define		BITMAP_SYSETUP_MODEM_DIALK4				28
#define		BITMAP_SYSETUP_MODEM_DIALK5				29
#define		BITMAP_SYSETUP_MODEM_DIALK6				30
#define		BITMAP_SYSETUP_MODEM_DIALK7				31
#define		BITMAP_SYSETUP_MODEM_DIALK8				32
#define		BITMAP_SYSETUP_MODEM_DIALK9				33
#define		BITMAP_SYSETUP_MODEM_DIALKA				34
#define		BITMAP_SYSETUP_MODEM_DIALK0				35
#define		BITMAP_SYSETUP_MODEM_DIALKS				36
#define		BITMAP_SYSETUP_MODEM_DIALKEN			37
#define		PUSH_SYSETUP_MODEM_SLOW					38
#define		PUSH_SYSETUP_MODEM_NORMAL				39
#define		PUSH_SYSETUP_MODEM_FAST					40
#define		PUSH_SYSETUP_MODEM_TONE					41
#define		PUSH_SYSETUP_MODEM_PULSE				42
#define		BUTTON_SYSETUP_MODEM_CUSTOM				43
#define		GROUP_ID_SYSETUP_MODEM_SPEED			0
#define		GROUP_ID_SYSETUP_MODEM_DIAL				1

/*===============================================================*/
/*============== FORM_SYSETUP_MODEM_CUSTOM ======================*/
#define		FORM_SYSETUP_MODEM_CUSTOM				44
#define		STRING_SYSETUP_MODEM_CUSTOM_MODEM		45
#define		STRING_SYSETUP_MODEM_CUSTOM_SPEED		46		
#define		STRING_SYSETUP_MODEM_CUSTOM_PARITY		47
#define		STRING_SYSETUP_MODEM_CUSTOM_DATA		48
#define		STRING_SYSETUP_MODEM_CUSTOM_STOP		49
#define		STRING_SYSETUP_MODEM_CUSTOM_HAND		50
#define		STRING_SYSETUP_MODEM_CUSTOM_COM			51
//#define	STRING_SYSETUP_MODEM_CUSTOM_LINE		52
#define		POPUP_SYSETUP_MODEM_CUSTOM_SPEED		53		
#define		POPUP_SYSETUP_MODEM_CUSTOM_PARITY		54
#define		POPUP_SYSETUP_MODEM_CUSTOM_DATA			55
#define		POPUP_SYSETUP_MODEM_CUSTOM_STOP			56
#define		POPUP_SYSETUP_MODEM_CUSTOM_HAND			57
#define		POPUP_SYSETUP_MODEM_CUSTOM_COM			58
//#define	POPUP_SYSETUP_MODEM_CUSTOM_LINE			59

/*===============================================================*/
/*============== FORM_SYSETUP_CLOCK =============================*/
#define		FORM_SYSETUP_CLOCK						60
#define		STRING_SYSETUP_CLOCK_CLOCK				61
#define		STRING_SYSETUP_CLOCK_VIST_DATE			62
#define		STRING_SYSETUP_CLOCK_VIST_TIME			63
#define		STRING_SYSETUP_CLOCK_AUTOFFTIME			64
#define		BUTTON_SYSETUP_CLOCK_HOME_DATE			65
#define		BUTTON_SYSETUP_CLOCK_HOME_TIME			66
#define		PUSH_SYSETUP_CLOCK_VIST_DST				67
#define		PUSH_SYSETUP_CLOCK_HOME_DST				68
#define		POPUP_SYSETUP_CLOCK_VIST_COUNTRY		69
#define		POPUP_SYSETUP_CLOCK_HOME_COUNTRY		70
#define		POPUP_SYSETUP_CLOCK_AUTOFFTIME			71
#define		BITMAP_SYSETUP_CLOCK_DAYCLK				72			
#define		BITMAP_SYSETUP_CLOCK_NIGHTCLK			73
#define		BITMAP_SYSETUP_CLOCK_VIST_LOGO			74			
#define		BITMAP_SYSETUP_CLOCK_HOME_LOGO			75
#define		LINE_SYSETUP_CLOCK_VIST_HLINE			76
#define		LINE_SYSETUP_CLOCK_VIST_MLINE			77
#define		LINE_SYSETUP_CLOCK_HOME_HLINE			78
#define		LINE_SYSETUP_CLOCK_HOME_MLINE			79

/*===============================================================*/
/*============== FORM_SYSETUP_CLOCK_12HR ========================*/
#define		FORM_SYSETUP_CLOCK_12HR					80
#define		BUTTON_SYSETUP_CLOCK_12HR				81
#define		STRING_SYSETUP_CLOCK_12HR_SEMICO		82
#define		PUSH_SYSETUP_CLOCK_12HR_HR				83
#define		PUSH_SYSETUP_CLOCK_12HR_10MIN			84
#define		PUSH_SYSETUP_CLOCK_12HR_MIN				85
#define		PUSH_SYSETUP_CLOCK_12HR_AM				86
#define		PUSH_SYSETUP_CLOCK_12HR_PM				87
#define		REPEAT_SYSETUP_CLOCK_12HR_UPARW			88
#define		REPEAT_SYSETUP_CLOCK_12HR_DNARW			89

#define		GROUP_ID_SYSETUP_CLOCK_12HR_TIME		4
#define		GROUP_ID_SYSETUP_CLOCK_12HR_AMPM		5

/*===============================================================*/
/*============== FORM_SYSETUP_CLOCK_24HR ========================*/
#define		FORM_SYSETUP_CLOCK_24HR					90
#define		BUTTON_SYSETUP_CLOCK_24HR				91
#define		STRING_SYSETUP_CLOCK_24HR_SEMICO		92
#define		PUSH_SYSETUP_CLOCK_24HR_HR				93
#define		PUSH_SYSETUP_CLOCK_24HR_10MIN			94
#define		PUSH_SYSETUP_CLOCK_24HR_MIN				95
#define		REPEAT_SYSETUP_CLOCK_24HR_UPARW			96
#define		REPEAT_SYSETUP_CLOCK_24HR_DNARW			97

#define		GROUP_ID_SYSETUP_CLOCK_24HR_TIME		6

/*===============================================================*/
/*============== FORM_SYSETUP_DATE ==============================*/
#define		FORM_SYSETUP_DATE						98
#define		STRING_SYSETUP_DATE_DATE				99
#define		PUSH_SYSETUP_DATE_JAN					100
#define		PUSH_SYSETUP_DATE_FEB					101
#define		PUSH_SYSETUP_DATE_MAR					102
#define		PUSH_SYSETUP_DATE_APR					103
#define		PUSH_SYSETUP_DATE_MAY					104
#define		PUSH_SYSETUP_DATE_JUN					105
#define		PUSH_SYSETUP_DATE_JUL					106
#define		PUSH_SYSETUP_DATE_AUG					107
#define		PUSH_SYSETUP_DATE_SEP					108
#define		PUSH_SYSETUP_DATE_OCT					109
#define		PUSH_SYSETUP_DATE_NOV					110
#define		PUSH_SYSETUP_DATE_DEC					111
#define		STRING_SYSETUP_DATE_WDAY1				112
#define		STRING_SYSETUP_DATE_WDAY2				113
#define		STRING_SYSETUP_DATE_WDAY3				114
#define		STRING_SYSETUP_DATE_WDAY4				115
#define		STRING_SYSETUP_DATE_WDAY5				116
#define		STRING_SYSETUP_DATE_WDAY6				117
#define		STRING_SYSETUP_DATE_WDAY7				118
#define		TABLE_SYSETUP_DATE						119
#define		BITMAP_SYSETUP_DATE_LEFT				120
#define		BITMAP_SYSETUP_DATE_RIGHT				121
#define		BUTTON_SYSETUP_DATE_DISABLE_BKGRD		122
#define		PUSH_SYSETUP_DATE_Y1					123
#define		PUSH_SYSETUP_DATE_Y2					124
#define		PUSH_SYSETUP_DATE_Y3					125
#define		PUSH_SYSETUP_DATE_Y4					126
#define		PUSH_SYSETUP_DATE_Y5					127
#define		LINE_SYSETUP_DATE_YUP					128
#define		LINE_SYSETUP_DATE_YDWN					129

#define		GROUP_ID_SYSETUP_DATE_MONTH				7
#define		GROUP_ID_SYSETUP_DATE_YEAR				9

/*===============================================================*/
/*============== FORM_SYSETUP_MENU ==============================*/
#define		FORM_SYSETUP_MENU						130
#define		BITMAP_SYSETUP_MENU_UPARW				131
#define		BITMAP_SYSETUP_MENU_DWNARW				132
#define		BITMAP_SYSETUP_MENU_CLOCK				133
#define		STRING_SYSETUP_MENU_CLOCK1				134
#define		STRING_SYSETUP_MENU_CLOCK2				135
#define		BITMAP_SYSETUP_MENU_AUTOFFTIME			136
#define		STRING_SYSETUP_MENU_AUTOFFTIME1			137
#define		STRING_SYSETUP_MENU_AUTOFFTIME2			138
#define		BITMAP_SYSETUP_MENU_SCRCAL				139
#define		STRING_SYSETUP_MENU_SCRCAL1				140
#define		STRING_SYSETUP_MENU_SCRCAL2				141
#define		BITMAP_SYSETUP_MENU_SOUND				142
#define		STRING_SYSETUP_MENU_SOUND1				143
#define		STRING_SYSETUP_MENU_SOUND2				144
#define		BITMAP_SYSETUP_MENU_SYSINFO				145
#define		STRING_SYSETUP_MENU_SYSINFO1			146
#define		STRING_SYSETUP_MENU_SYSINFO2			147
#define		BITMAP_SYSETUP_MENU_PASSWORD			148
#define		STRING_SYSETUP_MENU_PASSWORD1			149
#define		STRING_SYSETUP_MENU_PASSWORD2			150
#define		BITMAP_SYSETUP_MENU_COUNTRY				151
#define		STRING_SYSETUP_MENU_COUNTRY1			152
#define		STRING_SYSETUP_MENU_COUNTRY2			153
#define		BITMAP_SYSETUP_MENU_OWNINFO				154
#define		STRING_SYSETUP_MENU_OWNINFO1			155
#define		STRING_SYSETUP_MENU_OWNINFO2			156
#define		BITMAP_SYSETUP_MENU_MODEM				157
#define		STRING_SYSETUP_MENU_MODEM1				158
#define		STRING_SYSETUP_MENU_MODEM2				159
#define		BITMAP_SYSETUP_MENU_EMAIL				160
#define		STRING_SYSETUP_MENU_EMAIL1				161
#define		STRING_SYSETUP_MENU_EMAIL2				162

/*===============================================================*/
/*============== FORM_SYSETUP_SOUND =============================*/
#define		FORM_SYSETUP_SOUND						163
#define		STRING_SYSETUP_SOUND_SOUND				164
#define		PUSH_SYSETUP_SOUND_VOLBOX				165
#define		PUSH_SYSETUP_SOUND_CLICKBOX				166
#define		STRING_SYSETUP_SOUND_VOL_SET			167
#define		STRING_SYSETUP_SOUND_VOL_MIN			168
#define		STRING_SYSETUP_SOUND_VOL_MAX			169
#define		STRING_SYSETUP_SOUND_CLICK_SET			170
#define		STRING_SYSETUP_SOUND_CLICK_MIN			171
#define		STRING_SYSETUP_SOUND_CLICK_MAX			172
#define		SCROLLBAR_SYSETUP_SOUND_VOL				173
#define		SCROLLBAR_SYSETUP_SOUND_CLICK			174

/*===============================================================*/
/*============== FORM_SYSETUP_SYSINFO ===========================*/
#define		FORM_SYSETUP_SYSINFO					175
#define		STRING_SYSETUP_SYSINFO_SYSINFO			176
#define		STRING_SYSETUP_SYSINFO_SYSRES			177
#define		LINE_SYSETUP_SYSINFO					178
#define		PUSH_SYSETUP_SYSINFO_BOX				179
#define		STRING_SYSETUP_SYSINFO_FREEMEM			180
#define		STRING_SYSETUP_SYSINFO_ROM				181
#define		STRING_SYSETUP_SYSINFO_RAM				182
#define		STRING_SYSETUP_SYSINFO_SYSUSED			183
#define		SCROLLBAR_SYSETUP_SOUND_SYSINFO			184
#define		BUTTON_SYSETUP_SYSINFO_DELAPP			185

/*===============================================================*/
/*============== FORM_SYSETUP_SCRCAL ============================*/
#define		FORM_SYSETUP_SCRCAL						186
#define		STRING_SYSETUP_SCRCAL_SCRCAL			187
#define		STRING_SYSETUP_SCRCAL_TEXT1				188
#define		STRING_SYSETUP_SCRCAL_TEXT2				189
#define		STRING_SYSETUP_SCRCAL_TEXT3				190
#define		STRING_SYSETUP_SCRCAL_TEXT4				191
#define		STRING_SYSETUP_SCRCAL_TEXT5				192
#define		STRING_SYSETUP_SCRCAL_TEXT6				193
#define		BITMAP_SYSETUP_SCRCAL					194

/*===============================================================*/
/*============== FORM_SYSETUP_OWNINFO ===========================*/
#define		FORM_SYSETUP_OWNINFO					195
#define		STRING_SYSETUP_OWNINFO_OWNINFO			196
#define		STRING_SYSETUP_OWNINFO_DISPLAY			197
#define		CHECKBOX_SYSETUP_OWNINFO_DISPLAY		198
#define		SCROLLBAR_SYSETUP_OWNINFO				199
#define		TABLE_SYSETUP_OWNINFO					200
#define		STRING_SYSETUP_OWNINFO_LNAME			201
#define		FIELD_SYSETUP_OWNINFO_LNAME				202
#define		FIELD_SYSETUP_OWNINFO_FNAME				203
#define		FIELD_SYSETUP_OWNINFO_COTEL				204
#define		FIELD_SYSETUP_OWNINFO_COFAX				205
#define		FIELD_SYSETUP_OWNINFO_MOBILE			206
#define		FIELD_SYSETUP_OWNINFO_PAGER				207
#define		FIELD_SYSETUP_OWNINFO_COEMAIL			208
#define		FIELD_SYSETUP_OWNINFO_COINTERNET		209
#define		FIELD_SYSETUP_OWNINFO_COINADDR			210
#define		FIELD_SYSETUP_OWNINFO_COADDR			211
#define		FIELD_SYSETUP_OWNINFO_COCITY			212
#define		FIELD_SYSETUP_OWNINFO_COSTATE			213
#define		FIELD_SYSETUP_OWNINFO_COZIPCODE			214
#define		FIELD_SYSETUP_OWNINFO_HOTEL				215
#define		FIELD_SYSETUP_OWNINFO_HOFAX				216
#define		FIELD_SYSETUP_OWNINFO_HOEMAIL			217
#define		FIELD_SYSETUP_OWNINFO_HOADDR			218
#define		FIELD_SYSETUP_OWNINFO_HOCITY			219
#define		FIELD_SYSETUP_OWNINFO_HOSTATE			220
#define		FIELD_SYSETUP_OWNINFO_HOZIPCODE			221
#define		STRING_SYSETUP_OWNINFO_FNAME			222
#define		STRING_SYSETUP_OWNINFO_COTEL			223
#define		STRING_SYSETUP_OWNINFO_COFAX			224
#define		STRING_SYSETUP_OWNINFO_MOBILE			225
#define		STRING_SYSETUP_OWNINFO_PAGER			226
#define		STRING_SYSETUP_OWNINFO_COEMAIL			227
#define		STRING_SYSETUP_OWNINFO_COINTERNET		228
#define		STRING_SYSETUP_OWNINFO_COINADDR			229
#define		STRING_SYSETUP_OWNINFO_COADDR			230
#define		STRING_SYSETUP_OWNINFO_COCITY			231
#define		STRING_SYSETUP_OWNINFO_COSTATE			232
#define		STRING_SYSETUP_OWNINFO_COZIPCODE		233
#define		STRING_SYSETUP_OWNINFO_HOTEL			234
#define		STRING_SYSETUP_OWNINFO_HOFAX			235
#define		STRING_SYSETUP_OWNINFO_HOEMAIL			236
#define		STRING_SYSETUP_OWNINFO_HOADDR			237
#define		STRING_SYSETUP_OWNINFO_HOCITY			238
#define		STRING_SYSETUP_OWNINFO_HOSTATE			239
#define		STRING_SYSETUP_OWNINFO_HOZIPCODE		240

/*===============================================================*/
/*============== FORM_SYSETUP_PASSWORD ==========================*/
#define		FORM_SYSETUP_PASSWORD					241
#define		STRING_SYSETUP_PASSWORD_PASSWORD		242
#define		STRING_SYSETUP_PASSWORD_OLD				243
#define		STRING_SYSETUP_PASSWORD_NEW				244
#define		STRING_SYSETUP_PASSWORD_CONFIRM			245
#define		TEXTBOX_SYSETUP_PASSWORD_OLD			246
#define		TEXTBOX_SYSETUP_PASSWORD_NEW			247
#define		TEXTBOX_SYSETUP_PASSWORD_CONFIRM		248
#define		STRING_SYSETUP_PASSWORD_CHECK			249
#define		CHECKBOX_SYSETUP_PASSWORD_CHECK			250
#define		BUTTON_SYSETUP_PASSWORD_HINTS			251

/*===============================================================*/
/*============== FORM_SYSETUP_PASSWORD_HINTS ====================*/
#define		FORM_SYSETUP_PASSWORD_HINTS				252
#define		STRING_SYSETUP_PASSWORD_HINTS_PASSWORD	253
#define		STRING_SYSETUP_PASSWORD_HINTS_HINTS		254
#define		FIELD_SYSETUP_PASSWORD_HINTS			255
#define		SCROLLBAR_SYSETUP_PASSWORD_HINTS		256

/*===============================================================*/
/*============== FORM_SYSETUP_PASSWORD_FAILURE ==================*/
#define		FORM_SYSETUP_PASSWORD_FAILURE			257
#define		STRING_SYSETUP_PASSWORD_FAILURE			258
#define		STRING_SYSETUP_PASSWORD_FAILURE2		259
#define		BUTTON_SYSETUP_PASSWORD_FAILURE_YES		260
#define		BUTTON_SYSETUP_PASSWORD_FAILURE_NO		261

/*===============================================================*/
/*============== FORM_SYSETUP_PASSWORD_SUCCESS ==================*/
#define		FORM_SYSETUP_PASSWORD_SUCCESS			262
#define		STRING_SYSETUP_PASSWORD_SUCCESS			263
#define		BUTTON_SYSETUP_PASSWORD_SUCCESS_OK		264

/*===============================================================*/
/*============== FORM_SYSETUP_EMAIL =============================*/
#define		FORM_SYSETUP_EMAIL						265
#define		STRING_SYSETUP_EMAIL_EMAIL				266
#define		PUSH_SYSETUP_EMAIL_ISP					267
#define		PUSH_SYSETUP_EMAIL_ISP2					268
#define		PUSH_SYSETUP_EMAIL_ISP3					269
#define		PUSH_SYSETUP_EMAIL_ISP4					270
#define		SCROLLBAR_SYSETUP_EMAIL					271
#define		TABLE_SYSETUP_EMAIL						272
#define		STRING_SYSETUP_EMAIL_ISP				273
#define		FIELD_SYSETUP_EMAIL_ISP					274
#define		FIELD_SYSETUP_EMAIL_TEL					275
#define		FIELD_SYSETUP_EMAIL_FAX					276
#define		FIELD_SYSETUP_EMAIL_ADDR				277
#define		FIELD_SYSETUP_EMAIL_LOGINAME			278
#define		FIELD_SYSETUP_EMAIL_LOGIN_PASSWORD		279
#define		FIELD_SYSETUP_EMAIL_SMTP_SERVER			280
#define		FIELD_SYSETUP_EMAIL_POP3_SERVER			281
#define		FIELD_SYSETUP_EMAIL_USER_NAME			282
#define		FIELD_SYSETUP_EMAIL_PASSWORD			283
#define		STRING_SYSETUP_EMAIL_TEL				284
#define		STRING_SYSETUP_EMAIL_FAX				285
#define		STRING_SYSETUP_EMAIL_ADDR				286
#define		STRING_SYSETUP_EMAIL_LOGINAME			287
#define		STRING_SYSETUP_EMAIL_LOGIN_PASSWORD		288
#define		STRING_SYSETUP_EMAIL_SMTP_SERVER		289
#define		STRING_SYSETUP_EMAIL_POP3_SERVER		290
#define		STRING_SYSETUP_EMAIL_USER_NAME			291
#define		STRING_SYSETUP_EMAIL_PASSWORD			292
#define		BITMAP_SYSETUP_EMAIL_DNARW				293

/*===============================================================*/
/*============== FORM_SYSETUP_EMAIL2 ============================*/
#define		FORM_SYSETUP_EMAIL2						294
#define		STRING_SYSETUP_EMAIL2_EMAIL				295
#define		BITMAP_SYSETUP_EMAIL2_UPARW				296
#define		STRING_SYSETUP_EMAIL2_PRIDNS			297
#define		STRING_SYSETUP_EMAIL2_SECDNS			298
#define		STRING_SYSETUP_EMAIL2_IP_ADDR			299
#define		STRING_SYSETUP_EMAIL2_AUTOMATIC			300
#define		STRING_SYSETUP_EMAIL2_IP_ADDR_			301
#define		STRING_SYSETUP_EMAIL2_APOP				302
#define		STRING_SYSETUP_EMAIL2_DEL_MAIL			303
#define		STRING_SYSETUP_EMAIL2_SCRIPT1			304
#define		STRING_SYSETUP_EMAIL2_SCRIPT2			305
#define		STRING_SYSETUP_EMAIL2_SCRIPT3			306
#define		STRING_SYSETUP_EMAIL2_SCRIPT4			307
#define		STRING_SYSETUP_EMAIL2_SCRIPT5			308
#define		STRING_SYSETUP_EMAIL2_SCRIPT6			309
#define		STRING_SYSETUP_EMAIL2_SCRIPT_USER_NAME	310
#define		STRING_SYSETUP_EMAIL2_SCRIPT_PASSWORD	311
#define		LINE_SYSETUP_EMAIL2_PRIDNS				312
#define		LINE_SYSETUP_EMAIL2_SECDNS				313
#define		LINE_SYSETUP_EMAIL2_IP_ADDR				314
#define		CHECKBOX_SYSETUP_EMAIL2_AUTOMATIC		315
#define		CHECKBOX_SYSETUP_EMAIL2_IP_ADDR			316
#define		CHECKBOX_SYSETUP_EMAIL2_APOP			317
#define		CHECKBOX_SYSETUP_EMAIL2_DEL_MAIL		318
#define		TEXTBOX_SYSETUP_EMAIL2_PRIDNS1			319
#define		TEXTBOX_SYSETUP_EMAIL2_PRIDNS2			320
#define		TEXTBOX_SYSETUP_EMAIL2_PRIDNS3			321
#define		TEXTBOX_SYSETUP_EMAIL2_PRIDNS4			322
#define		TEXTBOX_SYSETUP_EMAIL2_SECDNS1			323
#define		TEXTBOX_SYSETUP_EMAIL2_SECDNS2			324
#define		TEXTBOX_SYSETUP_EMAIL2_SECDNS3			325
#define		TEXTBOX_SYSETUP_EMAIL2_SECDNS4			326
#define		TEXTBOX_SYSETUP_EMAIL2_IP_ADDR1			327
#define		TEXTBOX_SYSETUP_EMAIL2_IP_ADDR2			328
#define		TEXTBOX_SYSETUP_EMAIL2_IP_ADDR3			329
#define		TEXTBOX_SYSETUP_EMAIL2_IP_ADDR4			330

/*===============================================================*/
/*============== FORM_SYSETUP_KEY_MAPPING =======================*/
#define		FORM_SYSETUP_KEY_MAPPING				331
#define		BITMAP_SYSETUP_KEY_MAPPING_KEY1			332
#define		BITMAP_SYSETUP_KEY_MAPPING_KEY2			333
#define		BITMAP_SYSETUP_KEY_MAPPING_KEY3			334
#define		BITMAP_SYSETUP_KEY_MAPPING_KEY4			335
#define		BITMAP_SYSETUP_KEY_MAPPING_KEY5			336
#define		POPUP_SYSETUP_KEY_MAPPING_KEY1			337
#define		POPUP_SYSETUP_KEY_MAPPING_KEY2			338
#define		POPUP_SYSETUP_KEY_MAPPING_KEY3			339
#define		POPUP_SYSETUP_KEY_MAPPING_KEY4			340
#define		POPUP_SYSETUP_KEY_MAPPING_KEY5			341
#define		STRING_SYSETUP_KEY_MAPPING				342

/*===============================================================*/

#define		SYSETUP_MAIN_APP_SAVE		0x80001000
#define		F_email2_popup				0
#define		F_prev_row_num				1
#define		F_prev_col_num				2
#define		F_ActiveFormID				3

/*===============================================================*/


/* System setup function in main */
BOOLEAN		SySetupMenu(EvtType*);
BOOLEAN		SySetupClock(EvtType*);
BOOLEAN		SySetupClock12Hr(EvtType*);
BOOLEAN		SySetupClock24Hr(EvtType*);
BOOLEAN		SySetupDate(EvtType*);
BOOLEAN		SySetupSound(EvtType*);
BOOLEAN		SySetupAutOffTime(EvtType*);
BOOLEAN		SySetupScrCal(EvtType*);
BOOLEAN		SySetupSysInfo(EvtType*);
BOOLEAN		SySetupPassword(EvtType*);
BOOLEAN		SySetupPasswordHints(EvtType*);
BOOLEAN		SySetupPasswordFailure(EvtType*);
BOOLEAN		SySetupPasswordSuccess(EvtType*);
BOOLEAN		SySetupCountry(EvtType*);
BOOLEAN		SySetupOwnInfo(EvtType*);
BOOLEAN		SySetupModem(EvtType*);
BOOLEAN		SySetupModemCustom(EvtType*);
BOOLEAN		SySetupEmail(EvtType*);
BOOLEAN		SySetupEmail2(EvtType*);
BOOLEAN		SySetupKeyMapping(EvtType*);

/* API functions in System Setup */
/*===============================================================*/

/* Country Settings Functions */
BOOLEAN SySetupSetCountrySettings(void);
BOOLEAN SySetupRestoreCountrySettings(void);

/* Password Settings Functions */
SHORT	SySetupSetPassword(BYTE *enter_text, BYTE *change_text, BYTE *confirm_text);
BOOLEAN SySetupEditPasswordHints(void);
BOOLEAN SySetupRestorePasswordHints(void);

/* Owner Information Functions */
BOOLEAN SySetupSetOwnerInfo(void);
BOOLEAN SySetupRestoreOwnerInfo(void);

/* Modem Settings Functions */
BOOLEAN SySetupSetModemSettings(void);
BOOLEAN SySetupSetModemCustomSettings(void);
BOOLEAN SySetupRestoreModemSettings(void);
BOOLEAN SySetupRestoreModemCustomSettings(void);

/* Clock Settings Functions */
BOOLEAN SySetupSetClockSettings(void);
BOOLEAN SySetupRestoreClockSettings(void);
BOOLEAN SySetupSetClockTimeUp(ObjectID control_id, BYTE style);
BOOLEAN SySetupSetClockTimeDn(ObjectID control_id, BYTE style);
BOOLEAN SySetupClockWriteTime(void);
BOOLEAN SySetupClockPutRtmTime(void);
void	SySetupClockSetHomeDSTTime(void);

/* Date Settings Functions */
void	SySetupSetDateSettings(USHORT row_num, USHORT col_num);
BOOLEAN SySetupDateWriteDate(SHORT year, SHORT month, SHORT day, BYTE date_fmt, BOOLEAN write_home_date, BOOLEAN write_visit_date);

/* Email Settings Functions */
BOOLEAN SySetupSetEmailSettings(void);
BOOLEAN SySetupRestoreEmailSettings(void);

/* Sound Settings Functions */
BOOLEAN SySetupSetSoundSettings(void);
BOOLEAN SySetupRestoreSoundSettings(void);

/* Key Mapping Settings Functions */
BOOLEAN SySetupSetKeyMappingSettings(void);
BOOLEAN SySetupRestoreKeyMappingSettings(void);

/* System Information Functions */

/*===============================================================*/
/* Scrollbar related functions */
BOOLEAN SySetupTableSetScrollbar(ObjectID table_id, ObjectID scrollbar_id);
BOOLEAN SySetupGetTableNumLines(ObjectID table_id, USHORT ref_col, WORD *total_num_lines);
BOOLEAN SySetupGetTableMaxNumLines(ObjectID table_id, BYTE font_id, WORD *max_num_lines);
WORD	SySetupGetScrollbarMaxValue(ObjectID table_id, USHORT ref_col);
BOOLEAN SySetupDecideTopRowNum(ObjectID table_id, ObjectID active_id);
BOOLEAN SySetupSetTable(ObjectID form_id, ObjectID table_id);
BOOLEAN SySetupSetScreen(ObjectID form_id);
BOOLEAN SySetupKeyInChangeTable(ObjectID form_id, ObjectID table_id, ObjectID scrollbar_id);
BOOLEAN SySetupScrollbarSetTable(ObjectID table_id, ObjectID scrollbar_id, EvtType *Event);
void	SySetupScrollbarSetField(ObjectID field_id, ObjectID scrollbar_id, EvtType *Event);
BOOLEAN SySetupFieldSetScrollbar(ObjectID field_id, ObjectID scrollbar_id);
BOOLEAN SySetupSetField(ObjectID form_id, ObjectID field_id);




#endif
