/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   clock.h
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Clock module header file
Revision    :   1.1
Note        :   None
===========================================================================
*/

#ifndef _CLOCK_
#define _CLOCK_

#include "include\pr31700s.h"
#include "include\pr31700c.h"

/* For uart.c */
#define ENA_SIBCLK		(CPU->REG_CLK_CTRL |= SIBMCLKDIR | ENSIBMCLK | SIBMCLKDIV(2))
#define ENA_UARTACLK	(CPU->REG_CLK_CTRL &= ~CSERSEL;\
						 CPU->REG_CLK_CTRL |= CSERDIV(3) | ENCSERCLK | ENUARTACLK)

/* For timer.c */
#define ENA_TIMERCLK	(CPU->REG_CLK_CTRL |= ENTIMERCLK)
#define DIS_TIMERCLK	(CPU->REG_CLK_CTRL &= ENTIMERCLK)

#endif	/* _CLOCK_ */
