/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   dev_bety.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Header file for Betty H/W Device Driver
Revision    :   1.1
Note        :   23/09/98   Prepared by Andrew Hui (AH)                     
                23/09/98   V1.0 release (AH)                               
                10/12/98   V1.1 release (AH)                               
                15/12/98   V1.2 release (AH) (Optimize to O3)              
===========================================================================
*/

#include "platform.h"
#ifdef PR31700
#include "include\datatype.h"


/****************************************/
/*      Betty Register Bit Definition   */
/****************************************/

#ifndef         __BETTY_DRIVER__
#define         __BETTY_DRIVER__


        /*      I/O Port Data Register  */

#define BTY_WRT                             (1<<26)
#define BTY_IO_DATA_MASK                    (0x3FF <<0)
#define BTY_IO_DATA(a)                      ((a << 0) & BTY_IO_DATA_MASK)

        /*      I/O Port Direction Register     */
#define BTY_IO_DIR_MASK                     (0x3FF <<0)
#define BTY_IO_DIR(a)                       ((a << 0) & BTY_IO_DIR_MASK)
#define BTY_SIB_ZERO                        (1 << 15)

        /*      Rising Edge Interrupt Enable Register   */
#define BTY_IO_RIS_INT_MASK                 (0x3FF << 0)
#define BTY_IO_RIS_INT(a)                   ((a << 0) & BTY_IO_RIS_INT_MASK)
#define BTY_ADC_RIS_INT                     (1 << 11)
#define BTY_TSPX_RIS_INT                    (1 << 12)
#define BTY_TSMX_RIS_INT                    (1 << 13)
#define BTY_TCLIP_RIS_INT                   (1 << 14)
#define BTY_ACLIP_RIS_INT                   (1 << 15)

        /*      Falling Edge Interrupt Enable Register  */
#define BTY_IO_FAL_INT_MASK                 (0x3FF << 0)
#define BTY_IO_FAL_INT(a)                   ((a << 0) & BTY_IO_FAL_INT_MASK)
#define BTY_ADC_FAL_INT                     (1 << 11)
#define BTY_TSPX_FAL_INT                    (1 << 12)
#define BTY_TSMX_FAL_INT                    (1 << 13)
#define BTY_TCLIP_FAL_INT                   (1 << 14)
#define BTY_ACLIP_FAL_INT                   (1 << 15)

        /*      Interrupt Clear/Status Register */
#define BTY_IO_INT_STAT_MASK                (0x3FF << 0)
#define BTY_IO_INT_STAT(a)                  ((a << 0) & BTY_IO_INT_STAT_MASK)
#define BTY_ADC_INT_STAT                    (1 << 11)
#define BTY_TSPX_INT_STAT                   (1 << 12)
#define BTY_TSMX_INT_STAT                   (1 << 13)
#define BTY_TCLIP_INT_STAT                  (1 << 14)
#define BTY_ACLIP_INT_STAT                  (1 << 15)

        /*      Touch Screen Control Register   */
#define BTY_TSC_MODE_MASK                   (3 << 8)
#define BTY_TSMX_POW                        (1 << 0)
#define BTY_TSPX_POW                        (1 << 1)
#define BTY_TSMY_POW                        (1 << 2)
#define BTY_TSPY_POW                        (1 << 3)
#define BTY_TSMX_GND                        (1 << 4)
#define BTY_TSPX_GND                        (1 << 5)
#define BTY_TSMY_GND                        (1 << 6)
#define BTY_TSPY_GND                        (1 << 7)
#define BTY_TSC_MODE(a)                     ((a << 8) & BTY_TSC_MODE_MASK)
#define BTY_TSC_BIAS_ENA                    (1 << 11)
#define BTY_TSPX_LOW                        (1 << 12)
#define BTY_TSMX_LOW                        (1 << 13)

        /*      ADC Control Register    */
#define BTY_ADC_INPUT_MASK                  (7 << 2)
#define BTY_ADC_SYNC_ENA                    (1 << 0)
#define BTY_VREFBYP_CON                     (1 << 1)
#define BTY_ADC_INPUT(a)                    ((a << 2) & BTY_ADC_INPUT_MASK)
#define BTY_EXT_REF_ENA                     (1 << 5)
#define BTY_ADC_START                       (1 << 7)
#define BTY_ADC_ENA                         (1 << 15)

        /*      Telcom Control Register A   */
#define BTY_TEL_DIV_MASK                    (0x7F)
#define BTY_TEL_DIV(a)                      (a & BTY_TEL_DIV_MASK)
#define BTY_TEL_LOOP                        (1 <<7)



        /*      Telcom Control Register B   */
#define BTY_TEL_ATT_MASK                    (0x1F)

#define BTY_VOICE_ENA                       (1 << 3)
#define BTY_TEL_CLIP_STAT                   (1 << 4)
#define BTY_TEL_ATT                         (1 << 6)
#define BTY_TEL_SIDE_ENA                    (1 << 11)
#define BTY_TEL_MUTE                        (1 << 13)
#define BTY_TEL_IN_ENA                      (1 << 14)
#define BTY_TEL_OUT_ENA                     (1 << 15)




        /*      Audio Control Register A   */
#define BTY_AUD_DIV_MASK                    (0x7F)
#define BTY_AUD_GAIN_MASK                   (0x1F<<7)
#define BTY_AUD_DIV(a)                      (a & BTY_AUD_DIV_MASK)
#define BTY_AUD_GAIN(a)                     ((a <<7)& BTY_AUD_GAIN_MASK )


        /*      Audio Control Register B   */     
#define BTY_AUD_ATT_MASK                    (0x1F)
#define BTY_AUD_ATT(a)                      (a & BTY_AUD_ATT_MASK)
#define BTY_AUD_CLIP_STAT                   (1 << 6)
#define BTY_AUD_LOOP                        (1 << 8)
#define BTY_AUD_MUTE                        (1 << 13)
#define BTY_AUD_IN_ENA                      (1 << 14)
#define BTY_AUD_OUT_ENA                     (1 << 15)


        /*      ADC Data Register       */
#define BTY_ADC_DATA_MASK                 (0x3FF << 5)
#define BTY_ADC_DATA(a)                   ((a << 5) & BTY_ADC_DATA_MASK)
#define BTY_ADC_DAT_VAL                   (1 << 15)

#define BETTY_IO_PORT_DATA                (0 << 27)
#define BETTY_IO_PORT_DIRECTN             (1 << 27)
#define BETTY_RIS_INT_ENABLE              (2 << 27)
#define BETTY_FAL_INT_ENABLE              (3 << 27)
#define BETTY_INT_STATUS                  (4 << 27)
#define BETTY_INT_CLEAR                   (4 << 27)
#define BETTY_TEL_CTRL_A                  (5 << 27)
#define BETTY_TEL_CTRL_B                  (6 << 27)
#define BETTY_AUD_CTRL_A                  (7 << 27)
#define BETTY_AUD_CTRL_B                  (8 << 27)
#define BETTY_TS_CTRL                     (9 << 27)
#define BETTY_ADC_CTRL                    (10 << 27)
#define BETTY_ADC_DATA                    (11 << 27)
#define BETTY_ID                          (12 << 27)
#define BETTY_MODE                        (13 << 27)

#define BtySetReadADCMode()   CPU->REG_SIB_SF0_CTRL = BETTY_ADC_CTRL |BTY_WRT
#define BtyADCComplete()      (((CPU->REG_SIB_SF0_STATUS)>>15)&0x1)
//#define BtySetADCInput(input) CPU->REG_SIB_SF0_CTRL = BETTY_ADC_CTRL |input |BTY_ADC_SYNC_ENA |BTY_VREFBYP_CON |BTY_ADC_ENA |BTY_ADC_START |BTY_WRT
#define BtySetADCInput(input) CPU->REG_SIB_SF0_CTRL = BETTY_ADC_CTRL |input |BTY_VREFBYP_CON |BTY_ADC_ENA |BTY_ADC_START |BTY_WRT



#define BtyEnableSF0Int()     CPU->REG_INT_ENABLE_1 |= SIBSF0INT
#define BtyDisableSF0Int()    CPU->REG_INT_ENABLE_1 &= ~SIBSF0INT
#define BtyClearSF0Int()      CPU->REG_INT_STATUS_1 = SIBSF0INT

#define BtyEnableSF1Int()     CPU->REG_INT_ENABLE_1 |= SIBSF1INT
#define BtyDisableSF1Int()    CPU->REG_INT_ENABLE_1 &= ~SIBSF1INT
#define BtyClearSF1Int()      CPU->REG_INT_STATUS_1 = SIBSF1INT


#define BtyWaitSF0Int()       while (~CPU->REG_INT_STATUS_1 & SIBSF0INT)

#define BtyClearSndInt()      CPU->REG_INT_STATUS_1 = SNDININT
#define BtyWaitSndInt()       while (~CPU->REG_INT_STATUS_1 & SNDININT)

#define BtyClearTelInt()      CPU->REG_INT_STATUS_1 = TELININT
#define BtyWaitTelInt()       while (~CPU->REG_INT_STATUS_1 & TELININT)

void    BettyReset();
void    BettyResetSM();
extern  volatile WORD    BtyRstState;

#endif          __BETTY_DRIVER__
#endif

