/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   ex_rate.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for exchange rate database handling
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef _EX_RATE_H_
#define _EX_RATE_H_

#include "include\system.h"

//=========================================================
//============ EXCHANGE RATE Country Define ===============

#define EXRATE_DZD		0
#define EXRATE_ARP		1
#define EXRATE_AUD		2
#define EXRATE_ATS		3
#define EXRATE_BSD		4
#define EXRATE_BBD		5
#define EXRATE_BEF		6
#define EXRATE_BMD		7
#define EXRATE_BRR		8
#define EXRATE_BGL		9
#define EXRATE_CAD		10
#define EXRATE_CLP		11
#define EXRATE_CNY		12
#define EXRATE_CYP		13
#define EXRATE_CSK		14
#define EXRATE_DKK		15
#define EXRATE_EGP		16	
#define EXRATE_EUR		17
#define EXRATE_FIM		18
#define EXRATE_FJD		19		
#define EXRATE_FRF		20
#define EXRATE_DEM		21
#define EXRATE_GRD		22
#define EXRATE_HKD		23
#define EXRATE_HUF		24
#define EXRATE_ISK		25
#define EXRATE_INR		26
#define EXRATE_IDR		27
#define EXRATE_IEP		28	
#define EXRATE_ILS		29
#define EXRATE_ITL		30
#define EXRATE_JMD		31
#define EXRATE_JPY		32
#define EXRATE_JOD		33
#define EXRATE_LBP		34
#define EXRATE_LUF		35
#define EXRATE_MYR		36
#define EXRATE_MXP		37
#define EXRATE_NLG		38
#define EXRATE_NZD		39
#define EXRATE_NOK		40
#define EXRATE_PKR		41
#define EXRATE_PHP		42
#define EXRATE_PLZ		44
#define EXRATE_PTE		45
#define EXRATE_ROL		46
#define EXRATE_RUR		47
#define EXRATE_SAR		48
#define EXRATE_SGD		49
#define EXRATE_SKK		50		
#define EXRATE_ZAR		51
#define EXRATE_KRW		52
#define EXRATE_ESP		53	
#define EXRATE_SDD		54
#define EXRATE_SEK		55
#define EXRATE_CHF		56
#define EXRATE_TWD		57
#define EXRATE_THB		58
#define EXRATE_TTD		59
#define EXRATE_TRL		60
#define EXRATE_USD		61
#define EXRATE_GBP		62
#define EXRATE_VEB		63
#define EXRATE_ZMK		64

//=========================================================
//============ EXCHANGE RATE Database Format ===============
#define EXCHANGE_INFO		0x80001003
#define EXCHANGE_CURRENCY   0x80005000
#define EXCHANGE_RATE0		0x80010000
#define NUM_OF_COUNTRIES		64

//=========================================================
//============ EXCHANGE RATE function calls ===============
void ExchangeInitExchangeRateDatabase();
void ExchangeSetExchangeRateMappingArray();
//USHORT ExchangeGetMappingNum(USHORT item_num);
double ExchangeGetExchangeRate(USHORT first_country, USHORT second_country);
void ExchangeCloseExchangeRateDB();
BOOLEAN ExchangeCheckDBInited();

#endif

