/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   ioconmsg.h
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for IO/ control manager
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                

#ifndef _IOKEY_CTRL_MSG_
#define _IOKEY_CTRL_MSG_

#include "include\datatype.h"
#include "include\iocon.h"
#include "include\QTYPE.H"
#include "include\print.h"
#include "include\uart.h"
#include "include\pr31700s.h"
#include "include\pr31700c.h"

    /* KEY Definition */
#define IO_PHONE_BOOK         0X00000001
#define IO_SCHEDULER          0X00000004
#define IO_TO_DO_LIST         0X00000002
#define IO_UP_ARROW           0X00000010
#define IO_DOWN_ARROW         0X00000008
#define IO_SOUND_PLAY         0X00000020
#define IO_SOUND_STOP         0X00000040
#define IO_SOUND_RECORD       0X00000080



    /* Command For Accessory */
#define EVT_IO_KEY_CTRL    10010
#define EVT_IO_KEY_PRESS   10011
#define EVT_IO_KEY_REPEAT  10012
#define EVT_POWER_OFF      10013
#define EVT_ON_EL          10014
#define EVT_CHK_POWER      10015
#define EVT_HOTSYN_KEY_PRESS      10016

    /* I/O Control */
#define NUM_OF_REP         0040
#define IO_NUM_OF_REP      0010


    /* Varable */
extern UWORD    count_rep_power_pin;
extern UWORD    count_rep_iokey;
extern UWORD    pre_iokey_data;
extern UWORD    new_iokey_data;
extern UWORD    chg_iokey_data;

void IOKeyCtrlMgr(MsgType* msg);

#endif  /* _IOKEY_CTRL_MSG_ */


