#include "include\lcd_drv.h"
#include "include\qtype.h"

#ifndef _PEN_FUNC_
#define _PEN_FUNC_

#define PEN			1
//#define NULL		0
#define PEN_UP		1
#define PEN_DOWN	2
#define PEN_MOVE	3
#define PEN_HOLD	4

void PenIsr(void);

// Subroutine   : PenGetState
// Function     : Acquire touch state and real position of pen
// Input        : Null
// Output       : Touch state and real position of pen
void PenGetPos(BOOLEAN *touch, UWORD *xcoord1, UWORD *ycoord1);

void PenDecode(MsgType *msg);
#endif _PEN_FUNC_

/* Events for Pen
 *	EvtType {
 *            	eventType = PEN;
 *            	eventID = PEN_UP;
 *            	para1 = xcoord1;
 *            	para2 = ycoord2;
 *            	*evtPBP = NULL;
 *			} pen_up;
 *	EvtType {
 *            	eventType = PEN;
 *            	eventID = PEN_DOWN;
 *            	para1 = xcoord1;
 *            	para2 = ycoord2;
 *            	*evtPBP = NULL;
 *			} pen_down;
 *	EvtType {
 *            	eventType = PEN;
 *            	eventID = PEN_MOVE;
 *            	para1 = xcoord1;
 *            	para2 = ycoord2;
 *            	*evtPBP = NULL;
 *			} pen_move;
 *	EvtType {
 *            	eventType = PEN;
 *            	eventID = PEN_HOLD;
 *            	para1 = xcoord1;
 *            	para2 = ycoord2;
 *            	*evtPBP = NULL;
 *			} pen_hold;
 */

