/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   syscall.s
Author(s)   :   Henry Fok, Kenng Ng, Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   System calls mapping
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#include "include\pr3910.h"

#define SYSCALL(name,number)	\
	.globl	name;				\
	.ent	name;				\
name:;							\
	.set	noat;				\
	li		v0,number;			\
	syscall;					\
	j		ra;					\
	.set	at;					\
	.end	name;				\

	.text
SYSCALL(printf					                    ,0)
SYSCALL(MsgQueueCreate			                    ,1)
SYSCALL(MsgQueueEmpty			                    ,2)
SYSCALL(MsgQueueFull			                    ,3)
SYSCALL(MsgAppend				                    ,4)
SYSCALL(MsgAppendMsg			                    ,5)
SYSCALL(MsgAppendInt			                    ,6)
SYSCALL(MsgServe				                    ,7)
SYSCALL(MsgDecode				                    ,8)
SYSCALL(EvtGetEvent			                    ,9)
SYSCALL(EvtQueueCreate			                    ,10)
SYSCALL(EvtQueueEmpty			                    ,11)
SYSCALL(EvtQueueFull			                    ,12)
SYSCALL(EvtAppend				                    ,13)
SYSCALL(EvtAppendEvt			                    ,14)
SYSCALL(EvtServe				                    ,15)
SYSCALL(TmrIntEnable			                    ,16)
SYSCALL(TmrIntDisable			                    ,17)
SYSCALL(TmrWaitTime			                    ,18)
SYSCALL(RtcGetTime				                    ,19)
SYSCALL(RtcSetTime				                    ,20)
SYSCALL(RtcDiffTime			                    ,21)
SYSCALL(AlmSetStatus			                    ,22)
SYSCALL(AlmGetTime				                    ,23)
SYSCALL(AlmSetTime				                    ,24)
SYSCALL(LcdDrawHoriLine                            ,25)
SYSCALL(LcdDrawVertLine                            ,26)
SYSCALL(LcdInvertHoriLine                          ,27)
SYSCALL(LcdGetPixel                                ,28)
SYSCALL(LcdSetPixel                                ,29)
SYSCALL(LcdDrawLine                                ,30)
SYSCALL(LcdDrawBox                                 ,31)
SYSCALL(LcdInvertBox                               ,32)
SYSCALL(LcdDrawEllipse                             ,33)
SYSCALL(LcdDrawArc                                 ,34)
SYSCALL(LcdEraseRegion                             ,35)
SYSCALL(LcdGetBitmap                               ,36)
SYSCALL(LcdDrawBitmap                              ,37)
SYSCALL(LcdDrawCharacter                           ,38)
SYSCALL(LcdDrawCharSpace                           ,39)
SYSCALL(LcdDrawFixedString                         ,40)
SYSCALL(LcdTextboxDrawString                       ,41)
SYSCALL(LcdDrawVariableString                      ,42)
SYSCALL(LcdEnableInsertPt                          ,43)
SYSCALL(LcdDrawInsertPt                            ,44)
SYSCALL(IntRunHookedISR			                   ,45)
SYSCALL(IntHookISR				                   ,46)
SYSCALL(IntUnhookISR			                   ,47)
SYSCALL(pmalloc                                    ,48)
SYSCALL(pcalloc                                    ,49)
SYSCALL(pfree                                      ,50)
SYSCALL(qmalloc                                    ,51)
SYSCALL(qcalloc                                    ,52)
SYSCALL(qfree                                      ,53)
SYSCALL(DataNewRecord			                   ,54)
SYSCALL(DataNewRecordWithID                        ,55)
SYSCALL(DataRecordInfo                             ,56)
SYSCALL(DataSetRecordAttribute                     ,57)
SYSCALL(DataOpenRecord                             ,58)
SYSCALL(DataCloseDB                                ,59)
SYSCALL(DataOpenNextRecord                         ,60)
SYSCALL(DataOpenPrevRecord                         ,61)
SYSCALL(DataCloseRecord                            ,62)
SYSCALL(DataDeleteDB                               ,63)
SYSCALL(DataCategoryName                           ,64)
SYSCALL(DataCategorySetName                        ,65)
SYSCALL(DataMoveCat                                ,66)
SYSCALL(DataDeleteCat                              ,67)
SYSCALL(DataDeleteRecord                           ,68)
SYSCALL(DataDeleteRecordAction                     ,69)
SYSCALL(DataWriteField                             ,70)
SYSCALL(DataUpdateField                            ,71)
SYSCALL(DataGetField                               ,72)
SYSCALL(DataWriteBData                             ,73)
SYSCALL(DataReadBData                              ,74)
SYSCALL(DataReadBDataUp                            ,75)
SYSCALL(DataCopyBData                              ,76)
SYSCALL(DataResizeField                            ,77)
SYSCALL(DataNewDB                                  ,78)
SYSCALL(DataFindDB                                 ,79)
SYSCALL(DataOpenDB                                 ,80)
SYSCALL(DataBuildSortTable                         ,81)
SYSCALL(DataSortData                               ,82)
SYSCALL(DataFreeSortTable                          ,83)
SYSCALL(DataUpdateSortTable                        ,84)
SYSCALL(DataGetDBSortField                         ,85)
SYSCALL(DataRecordBlock                            ,86)
SYSCALL(DataFindRecord                             ,87)
SYSCALL(DataRecordData                             ,88)
SYSCALL(DataFieldSize                              ,89)
SYSCALL(DataFieldInfo                              ,90)
SYSCALL(DataIsExclusive                            ,91)
SYSCALL(DataIsDBOpen                               ,92)
SYSCALL(DataDBInfo                                 ,93)
SYSCALL(DataReadField                              ,94)
SYSCALL(DataSeekField                              ,95)
SYSCALL(DataSetDBInfo                              ,96)
SYSCALL(DataDBSize                                 ,97)
SYSCALL(DataTotalField                             ,98)
SYSCALL(DataGetDBPtr                               ,99)
SYSCALL(DataIsRecordChange                         ,100)
SYSCALL(DataGetRecordPtr                           ,101)
SYSCALL(DataIsRecordOpen                           ,102)
SYSCALL(DataTotalRecord                            ,103)
SYSCALL(DataRecIDtoNum                             ,104)
SYSCALL(DataNumtoRecID                             ,105)
SYSCALL(DataCategoryNextFree                       ,106)
SYSCALL(DataCategorySort                           ,107)
SYSCALL(ResOpen                                    ,108)
SYSCALL(ResGetField                                ,109)
SYSCALL(ResReadField                               ,110)
SYSCALL(ResFieldSize                               ,111)
SYSCALL(ResGetPointer                              ,112)
SYSCALL(ResClose                                   ,113)
SYSCALL(ResFieldInfo                               ,114)
SYSCALL(ResObjInfo                                 ,115)
SYSCALL(ResObjLocate                               ,116)
SYSCALL(ResSkipByte                                ,117)
SYSCALL(ResReadByte                                ,118)
SYSCALL(strlen                                     ,119)
SYSCALL(strcmp                                     ,120)
SYSCALL(strcpy                                     ,121)
SYSCALL(UartGetc                                   ,122)
SYSCALL(UartPutc                                   ,123)
SYSCALL(BitmapDrawBitmap                           ,124)
SYSCALL(BitmapEraseBitmap                          ,125)
SYSCALL(BitmapGetAttribute                         ,126)
SYSCALL(BitmapSetAttribute                         ,127)
SYSCALL(BitmapSetBitmapBounds                      ,128)
SYSCALL(BitmapGetBitmapBounds                      ,129)
SYSCALL(BitmapDeleteBitmap                         ,130)
SYSCALL(BitmapSetBitmapTemplate                    ,131)
SYSCALL(BitmapGetBitmapTemplate                    ,132)
SYSCALL(BitmapInitBitmap                           ,133)
SYSCALL(ClipboardEraseItem                         ,134)
SYSCALL(ClipboardPutItem                           ,135)
SYSCALL(ClipboardGetItem                           ,136)
SYSCALL(ControlDrawTapButton                       ,137)
SYSCALL(ControlDrawEmptyButton                     ,138)
SYSCALL(ControlDrawArc                             ,139)
SYSCALL(ControlDrawString                          ,140)
SYSCALL(ControlDrawControl                         ,141)
SYSCALL(ControlGetAttributes                       ,142)
SYSCALL(ControlGetLabel                            ,143)
SYSCALL(ControlRestoreBitBehind                    ,144)
SYSCALL(ControlSetLabel                            ,145)
SYSCALL(ControlDeleteControl                       ,146)
SYSCALL(ControlPopupSetTotalItems                  ,147)
SYSCALL(ControlPopupSetSelectedItem                ,148)
SYSCALL(ControlPopupGetSelectedItem                ,149)
SYSCALL(ControlPopupGetTotalItems                  ,150)
SYSCALL(ControlPopupGetCurrentNumOfDisplayedItems  ,151)
SYSCALL(ControlPopupDeleteItem                     ,152)
SYSCALL(ControlPopupDeleteAllItems                 ,153)
SYSCALL(ControlPopupInsertItem                     ,154)
SYSCALL(ControlPopupGetPopupItem                   ,155)
SYSCALL(ControlGetPushedPushButton                 ,156)
SYSCALL(ControlGetCheckedCheckbox                  ,157)
SYSCALL(ControlPopupFindItemNum                    ,158)
SYSCALL(ControlUpdatePopupTrigger                  ,159)
SYSCALL(ControlPopupGetTopItemNumber               ,160)
SYSCALL(ControlHitControl                          ,161)
SYSCALL(ControlSaveBehindBits                      ,162)
SYSCALL(ControlEraseControl                        ,163)
SYSCALL(ControlSetAttributes                       ,164)
SYSCALL(ControlSavePopupBounds                     ,165)
SYSCALL(ControlSearchSelectedItem                  ,166)
SYSCALL(ControlSetPopupTriggerUpDownArrow          ,167)
SYSCALL(ControlPopupClickedRegion                  ,168)
SYSCALL(ControlSetPopupScroll                      ,169)
SYSCALL(ControlInitControl                         ,170)
SYSCALL(FieldGetTotalNumOfLines                    ,171)
SYSCALL(FieldGetNumOfLinesDisplayed                ,172)
SYSCALL(FieldGetMaxNumLinesDisplay                 ,173)
SYSCALL(FieldGetTopLineNum                         ,174)
SYSCALL(FieldDirty                                 ,175)
SYSCALL(FieldEraseField                            ,176)
SYSCALL(FieldGetFieldBounds                        ,177)
SYSCALL(FieldGetInsertPointPosition                ,178)
SYSCALL(FieldDeleteField                           ,179)
SYSCALL(FieldGetCurrentHighlightedSelection        ,180)
SYSCALL(FieldScrollField                           ,181)
SYSCALL(FieldSendHeightChangeNotification          ,182)
SYSCALL(FieldSetBounds                             ,183)
SYSCALL(FieldSetFont                               ,184)
SYSCALL(FieldSetInsertPointOff                     ,185)
SYSCALL(FieldSetInsertPointOn                      ,186)
SYSCALL(FieldSetText                               ,187)
SYSCALL(FieldGetAttribute                          ,188)
SYSCALL(FieldGetFont                               ,189)
SYSCALL(FieldGetMaxNumChars                        ,190)
SYSCALL(FieldGetTextPointer                        ,191)
SYSCALL(FieldGetNumOfChars                         ,192)
SYSCALL(FieldSetScrollbarAttribute                 ,193)
SYSCALL(FieldGetScrollbarAttribute                 ,194)
SYSCALL(FieldSetAttribute                          ,195)
SYSCALL(FieldSetDirty                              ,196)
SYSCALL(FieldSetInsertPointPositionByXY            ,197)
SYSCALL(FieldSetInsertPointPositionByCharPos       ,198)
SYSCALL(FieldSetTopLineNum                         ,199)
SYSCALL(FieldSetMaxNumChars                        ,200)
SYSCALL(FieldSetHighlightSelection                 ,201)
SYSCALL(FieldSendChangeNotification                ,202)
SYSCALL(FieldGetNumBlankLines                      ,203)
SYSCALL(FieldDrawField                             ,204)
SYSCALL(FieldCopy                                  ,205)
SYSCALL(FieldCut                                   ,206)
SYSCALL(FieldInsert                                ,207)
SYSCALL(FieldInsertText                            ,208)
SYSCALL(FieldStoreBackspaceChar                    ,209)
SYSCALL(FieldRestoreBackspaceChar                  ,210)
SYSCALL(FieldInsertFunction                        ,211)
SYSCALL(FieldCutSelectedText                       ,212)
SYSCALL(FieldDelete                                ,213)
SYSCALL(FieldUndo                                  ,214)
SYSCALL(FieldGetFirstVisibleChar                   ,215)
SYSCALL(FieldGetLastVisibleChar                    ,216)
SYSCALL(FieldGetDisplayRowNum                      ,217)
SYSCALL(FieldInsertPtMove                          ,218)
SYSCALL(FieldCharPosToLineNum                      ,219)
SYSCALL(FieldAddKeyInChar                          ,220)
SYSCALL(FieldInitField                             ,221)
SYSCALL(FormPointInObject                          ,222)
SYSCALL(FormGetObjectBounds                        ,223)
SYSCALL(_FormDispatchEvent                          ,224)
SYSCALL(FormPopupForm                              ,225)
SYSCALL(FormDrawForm                               ,226)
SYSCALL(FormSetEventHandler                        ,227)
SYSCALL(FormGetActiveFormID                        ,228)
SYSCALL(FormSetActiveForm                          ,229)
SYSCALL(FormEraseForm                              ,230)
SYSCALL(FormSetControlGroupSelection               ,231)
SYSCALL(FormGetNumberOfObjects                     ,232)
SYSCALL(FormGetObjectPointer                       ,233)
SYSCALL(FormGotoForm                               ,234)
SYSCALL(FormSetFormActiveObject                    ,235)
SYSCALL(FormSetObjectPosition                      ,236)
SYSCALL(FormCheckStyle                             ,237)
SYSCALL(FormSetDialogTitle                         ,238)
SYSCALL(FormSaveAllForms                           ,239)
SYSCALL(FormGetControlValue                        ,240)
SYSCALL(FormGetActiveObject                        ,241)
SYSCALL(FormSetFormUpdateAtt                       ,242)
SYSCALL(FormSetObjectBounds                        ,243)
SYSCALL(FormDeleteForm                             ,244)
SYSCALL(FormDeleteAllFormObjects                   ,245)
SYSCALL(FormObjectSetFocus                         ,246)
SYSCALL(FormObjectReleaseFocus                     ,247)
SYSCALL(FormObjectRestoreFocus                     ,248)
SYSCALL(FormGetMenuID                              ,249)
SYSCALL(FormDrawDialog                             ,250)
SYSCALL(FormDrawNormalForm                         ,251)
SYSCALL(FormSaveBehindBits                         ,252)
SYSCALL(FormRestoreBitBehind                       ,253)
SYSCALL(FormCheckObjectExists                      ,254)
SYSCALL(FormInitForm                               ,255)
SYSCALL(FormInitAllFormObjects                     ,256)
SYSCALL(ControlHandleEvent                         ,257)
SYSCALL(FormHandleEvent                            ,258)
SYSCALL(HardwareButtonHandleEvent                  ,259)
SYSCALL(TableHandleEvent                           ,260)
SYSCALL(BitmapHandleEvent                          ,261)
SYSCALL(MenuHandleEvent                            ,262)
SYSCALL(ListHandleEvent                            ,263)
SYSCALL(ScrollbarHandleEvent                       ,264)
SYSCALL(FieldHandleEvent                           ,265)
SYSCALL(KeyboardHandleEvent                        ,266)
SYSCALL(SchlineHandleEvent                         ,267)
SYSCALL(TextboxHandleEvent                         ,268)
SYSCALL(InlayHandleEvent                           ,269)
SYSCALL(InlayGetClickedRegion                      ,270)
SYSCALL(KeyboardInitKeyboard                       ,271)
SYSCALL(KeyboardDrawKeyboard                       ,272)
SYSCALL(KeyboardDrawKeyboardBitmap                 ,273)
SYSCALL(KeyboardGetClickedKey                      ,274)
SYSCALL(KeyboardSaveBehindBits                     ,275)
SYSCALL(KeyboardRestoreBitBehind                   ,276)
SYSCALL(KeyboardRemoveKeyboard                     ,277)
SYSCALL(KeyboardSendEvent                          ,278)
SYSCALL(KeyboardDrawInvertKey                      ,279)
SYSCALL(KeyboardCheckKeyboardStatus                ,280)
SYSCALL(KeyboardSetKeyboardStatus                  ,281)
SYSCALL(LineDeleteLine                             ,282)
SYSCALL(LineDrawLine                               ,283)
SYSCALL(LineGetAttribute                           ,284)
SYSCALL(LineSetAttribute                           ,285)
SYSCALL(LineSetLineCharacteristics                 ,286)
SYSCALL(LineGetLineCharacteristics                 ,287)
SYSCALL(LineGetPosition                            ,288)
SYSCALL(LineSetPosition                            ,289)
SYSCALL(LineEraseLine                              ,290)
SYSCALL(LineInitLine                               ,291)
SYSCALL(ListEraseList                              ,292)
SYSCALL(ListDeleteList                             ,293)
SYSCALL(ListGetNumOfItems                          ,294)
SYSCALL(ListSearchSelectedItem                     ,295)
SYSCALL(ListSetTotalItems                          ,296)
SYSCALL(ListGetTotalItems                          ,297)
SYSCALL(ListGetListItem                            ,298)
SYSCALL(ListGetNumItemsDisplay                     ,299)
SYSCALL(ListGetMaxNumItemsDisplay                  ,300)
SYSCALL(ListSetNumItemsDisplay                     ,301)
SYSCALL(ListSetSelectedItem                        ,302)
SYSCALL(ListGetSelectedItem                        ,303)
SYSCALL(ListGetTopItemNum                          ,304)
SYSCALL(ListSetTopItemNum                          ,305)
SYSCALL(ListGetListBounds                          ,306)
SYSCALL(ListSetListBounds                          ,307)
SYSCALL(ListDeleteItem                             ,308)
SYSCALL(ListDeleteAllItems                         ,309)
SYSCALL(ListInsertItem                             ,310)
SYSCALL(ListUpdateList                             ,311)
SYSCALL(ListClickedRegion                          ,312)
SYSCALL(ListSetScrollList                          ,313)
SYSCALL(ListDrawList                               ,314)
SYSCALL(ListDrawBackgroundBox                      ,315)
SYSCALL(ListDrawUpDownArrow                        ,316)
SYSCALL(ListGetAttribute                           ,317)
SYSCALL(ListSetAttribute                           ,318)
SYSCALL(ListRecalculateMaxNumItemsDisplay          ,319)
SYSCALL(ListInitList                               ,320)
SYSCALL(ltoa                                       ,321)
SYSCALL(memcpy                                     ,322)
SYSCALL(MenuEraseMenu                              ,323)
SYSCALL(MenuDeleteMenu                             ,324)
SYSCALL(MenuGetNumOfItems                          ,325)
SYSCALL(MenuSetPopupBounds                         ,326)
SYSCALL(MenuSearchSelectedItem                     ,327)
SYSCALL(MenuSetTotalItems                          ,328)
SYSCALL(MenuGetTotalItems                          ,329)
SYSCALL(MenuDeleteItem                             ,330)
SYSCALL(MenuDeleteAllItems                         ,331)
SYSCALL(MenuInsertItem                             ,332)
SYSCALL(MenuGetMenuItem                            ,333)
SYSCALL(MenuDrawMenu                               ,334)
SYSCALL(MenuRestoreBehindBits                      ,335)
SYSCALL(MenuSaveBehindBits                         ,336)
SYSCALL(MenuSetAttrVisible                         ,337)
SYSCALL(MenuGetAttrVisible                         ,338)
SYSCALL(MenuInitMenu                               ,339)
SYSCALL(SchlineEraseSchline                        ,340)
SYSCALL(SchlineDeleteSchline                       ,341)
SYSCALL(SchlineGetAttributes                       ,342)
SYSCALL(SchlineSetAttributes                       ,343)
SYSCALL(SchlineSetDateText                         ,344)
SYSCALL(SchlineGetDateText                         ,345)
//SYSCALL(SchlineSetDateSchedule                     ,346)
//SYSCALL(SchlineGetDateSchedule                     ,347)
SYSCALL(SchlineSetDateBitmaps                      ,348)
SYSCALL(SchlineGetDateBitmaps                      ,349)
SYSCALL(SchlineGetClickedRegion                    ,350)
SYSCALL(SchlineDrawSchline                         ,351)
SYSCALL(SchlineInitSchline                         ,352)
SYSCALL(ScrollbarEraseScrollbar                    ,353)
SYSCALL(ScrollbarDeleteScrollbar                   ,354)
SYSCALL(ScrollbarGetScrollbar                      ,355)
SYSCALL(ScrollbarSetScrollbar                      ,356)
SYSCALL(ScrollbarSetScrollbarType                  ,357)
SYSCALL(ScrollbarSetScrollbarVisible               ,358)
SYSCALL(ScrollbarGetScrollbarVisible               ,359)
SYSCALL(ScrollbarSetScrollbarDrawPagesize          ,360)
SYSCALL(ScrollbarGetClickedRegion                  ,361)
SYSCALL(ScrollbarCalculateCurrentValue             ,362)
SYSCALL(ScrollbarDrawScrollbar                     ,363)
SYSCALL(ScrollbarInitScrollbar                     ,364)
SYSCALL(ScrollbarGetScrollbarText                  ,365)
SYSCALL(ScrollbarSetScrollbarText                  ,366)
SYSCALL(StringDeleteString                         ,367)
SYSCALL(StringEraseString                          ,368)
SYSCALL(StringGetText                              ,369)
SYSCALL(StringSetText                              ,370)
SYSCALL(StringDrawString                           ,371)
SYSCALL(StringGetAttribute                         ,372)
SYSCALL(StringSetAttribute                         ,373)
SYSCALL(StringInitString                           ,374)
SYSCALL(SystemHandleEvent                          ,375)
SYSCALL(TableDeleteTable                           ,376)
SYSCALL(TableEnableTable                           ,377)
SYSCALL(TableGetColumnWidth                        ,378)
SYSCALL(TableGetCellBounds                         ,379)
SYSCALL(TableGetItemText                           ,380)
SYSCALL(TableGetTableBounds                        ,381)
SYSCALL(TableGetNumOfColumns                       ,382)
SYSCALL(TableGetRowColOfSelection                  ,383)
SYSCALL(TableSetColumnWidth                        ,384)
SYSCALL(TableSetItemValue                          ,385)
SYSCALL(TableSetItemType                           ,386)
SYSCALL(TableEraseTable                            ,387)
SYSCALL(TableGetItemType                           ,388)
SYSCALL(TableGetItemValue                          ,389)
SYSCALL(TableGetNumOfRows                          ,390)
SYSCALL(TableGetRowHeight                          ,391)
SYSCALL(TableSetBounds                             ,392)
SYSCALL(TableSetRowHeight                          ,393)
SYSCALL(TableSetItemText                           ,394)
SYSCALL(TableGetClickedCell                        ,395)
SYSCALL(TableDrawTable                             ,396)
SYSCALL(TableDrawDisplay                           ,397)
SYSCALL(TableDrawTableBounds                       ,398)
SYSCALL(TableUpdateTable                           ,399)
SYSCALL(TableDrawUIObject                          ,400)
SYSCALL(TableGetAttributes                         ,401)
SYSCALL(TableSetAttributes                         ,402)
SYSCALL(TableDrawFieldFullSize                     ,403)
SYSCALL(TableGetTopRowNum                          ,404)
SYSCALL(TableSetTopRowNum                          ,405)
SYSCALL(TableGetNumOfRowsDisplayed                 ,406)
SYSCALL(TableSetHighlightCell                      ,407)
SYSCALL(TableCheckCellHighlight                    ,408)
SYSCALL(TableSetCellHasBitmap                      ,409)
SYSCALL(TableCheckCellHasBitmap                    ,410)
SYSCALL(TableSetHighlightEnable                    ,411)
SYSCALL(TableCheckHighlightEnable                  ,412)
SYSCALL(TableUpdateObjectScreenBounds              ,413)
SYSCALL(TableUpdateNumRowDisplay                   ,414)
SYSCALL(TableInitTable                             ,415)
SYSCALL(TextboxGetNumOfCharsDisplayed              ,416)
SYSCALL(TextboxDirty                               ,417)
SYSCALL(TextboxEraseTextbox                        ,418)
SYSCALL(TextboxStoreBackspaceChar                  ,419)
SYSCALL(TextboxRestoreBackspaceChar                ,420)
SYSCALL(TextboxGetTextboxBounds                    ,421)
SYSCALL(TextboxGetInsertPointPosition              ,422)
SYSCALL(TextboxDeleteTextbox                       ,423)
SYSCALL(TextboxGetCurrentHighlightedSelection      ,424)
SYSCALL(TextboxSetBounds                           ,425)
SYSCALL(TextboxSetFont                             ,426)
SYSCALL(TextboxSetInsertPointOff                   ,427)
SYSCALL(TextboxSetInsertPointOn                    ,428)
SYSCALL(TextboxSetText                             ,429)
SYSCALL(TextboxGetAttribute                        ,430)
SYSCALL(TextboxGetFont                             ,431)
SYSCALL(TextboxGetMaxNumChars                      ,432)
SYSCALL(TextboxGetTextPointer                      ,433)
SYSCALL(TextboxGetNumOfChars                       ,434)
SYSCALL(TextboxSetAttribute                        ,435)
SYSCALL(TextboxSetDirty                            ,436)
SYSCALL(TextboxSetInsertPointPositionByXY          ,437)
SYSCALL(TextboxSetInsertPointPositionByCharPos     ,438)
SYSCALL(TextboxSetMaxNumChars                      ,439)
SYSCALL(TextboxSetHighlightSelection               ,440)
SYSCALL(TextboxDrawTextbox                         ,441)
SYSCALL(TextboxDrawRoundTextbox                    ,442)
SYSCALL(TextboxCopy                                ,443)
SYSCALL(TextboxCut                                 ,444)
SYSCALL(TextboxInsert                              ,445)
SYSCALL(TextboxInsertText                          ,446)
SYSCALL(TextboxInsertFunction                      ,447)
SYSCALL(TextboxCutSelectedText                     ,448)
SYSCALL(TextboxDelete                              ,449)
SYSCALL(TextboxUndo                                ,450)
SYSCALL(TextboxInsertPtMove                        ,451)
SYSCALL(TextboxAddKeyInChar                        ,452)
SYSCALL(TextboxGetLeftCharPos                      ,453)
SYSCALL(TextboxGetRightCharPos                     ,454)
SYSCALL(TextboxSetLeftCharPos                      ,455)
SYSCALL(TextboxSetRightCharPos                     ,456)
SYSCALL(TextboxInitTextbox                         ,457)
SYSCALL(UIInit                                     ,458)
SYSCALL(UISearchForAddress                         ,459)
SYSCALL(UIAddressToLookupTable                     ,460)
SYSCALL(UIDeleteLookupTableElement                 ,461)
SYSCALL(UIDeleteLinkListFormElement                ,462)
SYSCALL(UIAddLinkListFormElement                   ,463)
SYSCALL(UIColorConversion                          ,464)
SYSCALL(UIDeleteAllAppObjects                      ,465)
SYSCALL(UIGetUndoStatus                            ,466)
SYSCALL(SysGetFontHeight                           ,467)
SYSCALL(_valid_ptr                                 ,468)
SYSCALL(MemoryGetMatPtr                            ,469)
SYSCALL(MemoryMemInfo                              ,470)
SYSCALL(MemoryBuildMAT                             ,471)
SYSCALL(MemoryBlockType                            ,472)
SYSCALL(MemorySetMATFragment                       ,473)
SYSCALL(MemoryCheckMAT                             ,474)
SYSCALL(MemoryReadData                             ,475)
SYSCALL(MemoryShiftData                            ,476)
SYSCALL(MemoryPrevBlock                            ,477)
SYSCALL(MemoryNextBlock                            ,478)
SYSCALL(MemoryNewBlock                             ,479)
SYSCALL(MemoryInsertBlock                          ,480)
SYSCALL(MemoryReleaseBlock                         ,481)
SYSCALL(MemoryCopyData                             ,482)
SYSCALL(MemoryMoveBlock                            ,483)
SYSCALL(MemoryFindStartBlock                       ,484)
SYSCALL(MemoryTotalFree                            ,485)
SYSCALL(MemoryTotalFreeBlock                       ,486)
SYSCALL(MemoryGetConBlock                          ,487)
SYSCALL(MemoryGetSpace                             ,488)
SYSCALL(MemoryBlockFreeSpace                       ,489)
SYSCALL(MemoryResolveBlock                         ,490)
SYSCALL(MemoryGroupUsage                           ,491)
SYSCALL(MemoryMATCheckSum                          ,492)
SYSCALL(MemoryDMANew                               ,493)
SYSCALL(MemoryDMAStart                             ,494)
SYSCALL(MemoryClearAppDM                           ,495)
SYSCALL(MemoryPageTableAppend                      ,496)
SYSCALL(MemoryDMAInfo                              ,497)
SYSCALL(MemoryPageTableInit                        ,498)
SYSCALL(MemoryGetPageTable                         ,499)
SYSCALL(MemoryInstallProg                          ,500)
SYSCALL(MemoryRegFlashProg                         ,501)
SYSCALL(MemoryAppStartBlock                        ,502)
SYSCALL(MemoryRemoveProg                           ,503)
SYSCALL(MMUInit                                    ,504)
SYSCALL(StrExtract                                 ,505)
SYSCALL(StrGetWidth                                ,506)
SYSCALL(StrAnalyzeWord                             ,507)
SYSCALL(StrAnalyzeLine                             ,508)
SYSCALL(StrGetInsertPtPos                          ,509)
SYSCALL(StrCharPosToXY                             ,510)
SYSCALL(StrXYToCharPos                             ,511)
SYSCALL(StrTextboxGetInsertPtPos                   ,512)
SYSCALL(StrTextboxCharPosToXY                      ,513)
SYSCALL(StrTextboxXYToCharPos                      ,514)
SYSCALL(StrTextboxAnalyze                          ,515)
SYSCALL(ComOpenPort                                ,516)
SYSCALL(ComIsHandleValid                           ,517)
SYSCALL(ComClosePort                               ,518)
SYSCALL(ComReset                                   ,519)
SYSCALL(ComCapture                                 ,520)
SYSCALL(ComGetMode                                 ,521)
SYSCALL(ComConfigPort                              ,522)
SYSCALL(ComGetConfig                               ,523)
SYSCALL(ComSendData                                ,524)
SYSCALL(ComSendChar                                ,525)
SYSCALL(ComGetUartBuffer                           ,526)
SYSCALL(ComWriteOutData                            ,527)
SYSCALL(UartMgr                                    ,528)
SYSCALL(UartMgrInit                                ,529)
SYSCALL(KeyboardSetKeyboardVisible                 ,530)
SYSCALL(KeyboardSetKeyboardInvisible               ,531)
SYSCALL(sprintf									   ,532)
SYSCALL(RtcGetDaysInMonth                          ,533)
SYSCALL(RtcYMDToWday1                              ,534)
SYSCALL(RtcWday1ToYMD                              ,535)
SYSCALL(RtcYMDToWday2                              ,536)
SYSCALL(RtcWday2ToYMD                              ,537)
SYSCALL(SysRunApp								   ,538)
SYSCALL(SysSetActiveAppID						   ,539)
SYSCALL(SysGetActiveAppID						   ,540)
SYSCALL(SysLoadAppPageTable						   ,541)
SYSCALL(UIApplicationInit						   ,542)
SYSCALL(atol                                       ,543)
SYSCALL(atod                                       ,544)
SYSCALL(dtoa                                       ,545)
SYSCALL(pow10                                      ,546)
SYSCALL(subtract                                   ,547)
SYSCALL(sin                                        ,548)
SYSCALL(cos                                        ,549)
SYSCALL(tan                                        ,550)
SYSCALL(expm1                                      ,551)
SYSCALL(log1p                                      ,552)
SYSCALL(sqrt                                       ,553)
SYSCALL(RtcDaysShift                               ,554)
SYSCALL(SySetupDatabaseInit                        ,555)
SYSCALL(SySetupGetClockSettings                    ,556)
SYSCALL(SySetupGetCountrySettings                  ,557)
SYSCALL(SySetupGetEmailSettings                    ,558)
SYSCALL(SySetupGetModemSettings                    ,559)
SYSCALL(SySetupGetOwnerInfo                        ,560)
SYSCALL(SySetupGetPasswordSettings                 ,561)
SYSCALL(SySetupGetSoundSettings                    ,562)
SYSCALL(SySetupGetSystemInfo                       ,563)
SYSCALL(SySetupScrollbarSetSoundSettings           ,564)
SYSCALL(bcmp                                       ,565)
SYSCALL(bcopy                                      ,566)
SYSCALL(bzero                                      ,567)
SYSCALL(index                                      ,568)
SYSCALL(memchr                                     ,569)
SYSCALL(memcmp                                     ,570)
SYSCALL(_memcpy                                     ,571)
SYSCALL(memmove                                    ,572)
SYSCALL(memset                                     ,573)
SYSCALL(rindex                                     ,574)
SYSCALL(strcat                                     ,575)
SYSCALL(strchr                                     ,576)
SYSCALL(_strcmp                                     ,577)
SYSCALL(strcoll                                    ,578)
SYSCALL(_strcpy                                     ,579)
SYSCALL(strcspn                                    ,580)
SYSCALL(_strlen                                     ,581)
SYSCALL(strncat                                    ,582)
SYSCALL(strncmp                                    ,583)
SYSCALL(strncpy                                    ,584)
SYSCALL(strpbrk                                    ,585)
SYSCALL(strrchr                                    ,586)
SYSCALL(strspn                                     ,587)
SYSCALL(strstr                                     ,588)
SYSCALL(ReduceFreq								   ,589)
SYSCALL(RtcCompareTime							   ,590)
SYSCALL(SIOInit									   ,591)
SYSCALL(JotUpdate								   ,592)
SYSCALL(dpcmp									   ,593)
SYSCALL(dpsub									   ,594)
SYSCALL(dpdiv									   ,595)
SYSCALL(dpadd									   ,596)
SYSCALL(dpmul									   ,597)

SYSCALL(AlarmGetVariable                                       ,619)
SYSCALL(RtcFormatDate                                          ,620)
SYSCALL(AlarmOnHit                                             ,621)
SYSCALL(AlarmTotalEvent                                        ,622)
SYSCALL(AlarmFindEvent                                         ,623)
SYSCALL(AlarmAddEvent                                          ,624)
SYSCALL(AlarmDelEvent                                          ,625)
SYSCALL(AlarmDelEventEx                                        ,626)
SYSCALL(AlarmAddHit                                            ,627)
SYSCALL(AlarmDelHit                                            ,628)
SYSCALL(AlarmAddQuery                                          ,629)
SYSCALL(AlarmDelQuery                                          ,630)
SYSCALL(AlarmSetAlarm                                          ,631)
SYSCALL(AlarmMgrInit                                           ,632)
SYSCALL(GlobalFindInit                                         ,633)
SYSCALL(GlobalFindDeleteAllItems                               ,634)
SYSCALL(GlobalFindAddItem                                      ,635)
SYSCALL(GlobalFindSearchText                                   ,636)
SYSCALL(GlobalFindStringHandleEvent                            ,637)
SYSCALL(GlobalFindSetMatchString                               ,638)
SYSCALL(GlobalFindPutDataToTable                               ,639)
SYSCALL(GlobalFindScrollbarSetTable                            ,640)
SYSCALL(GlobalFindSetupScrollbar                               ,641)
SYSCALL(GlobalFindInput                                        ,642)
SYSCALL(GlobalFindResult                                       ,643)
SYSCALL(StrChopString                                          ,644)
SYSCALL(DataFindBinRecord                                      ,645)
SYSCALL(ListSetHighlightedItem                                 ,646)
SYSCALL(SchlineSetLineBitmap                                   ,647)
SYSCALL(RtcYMDToWday3                                          ,648)
SYSCALL(RtcYMDToWday4                                          ,649)
SYSCALL(SchlineSetLineState                                    ,650)
SYSCALL(RtcWday4ToYMD                                          ,651)
SYSCALL(SchlineSetLineLabel                                    ,652)
SYSCALL(SchlineSetHourSettings                                 ,653) 
SYSCALL(SchlineSetHighlightText                                ,654) 
SYSCALL(SySetupGetDateSettings				       ,655)	
SYSCALL(SySetupRestoreDateSettings			       ,656)	
SYSCALL(SySetupDateUpdateYearBar			       ,657)
SYSCALL(SySetupDateUpdateTable  	                       ,658)
SYSCALL(ScrollbarHardButtonSetScrollbar			       ,659) 	
SYSCALL(ShellHandleEvent				       ,660)
SYSCALL(GlobalFindPrepareAppSeparator                          ,661)                           
SYSCALL(GlobalFindSearchData                                   ,662)  
SYSCALL(SysTotalInstalledApp                                   ,663)  
SYSCALL(SysGetAppName                                          ,664) 
SYSCALL(SysGetAppIDFromIndex                                   ,665)
SYSCALL(GlobalFindPopupGlobalFind                              ,666) 
//SYSCALL(GlobalFindCheckEnableStatus                            ,667)                           
//SYSCALL(GlobalFindSetEnableStatus                              ,668)  
SYSCALL(InlayCheckEnableStatus                                 ,669) 
SYSCALL(InlaySetEnableStatus                                   ,670)
SYSCALL(SchlineDrawSmallSector                                 ,671)
SYSCALL(SysGetAppID                                            ,672) 
SYSCALL(AlarmDelAllHit                                         ,673)
SYSCALL(AlarmPwrUpCheck                                        ,674)
SYSCALL(SndStop		                                       ,675)
SYSCALL(SndPause		                               ,676)
SYSCALL(SndRec		                                       ,677)
SYSCALL(SndRERec	                                       ,678)
SYSCALL(SndPlay	                                       	       ,679)
SYSCALL(SndREPlay                                              ,680)
SYSCALL(SndMgr		                                       ,681)
SYSCALL(SndDataHandler	                                       ,682)
SYSCALL(SndDataRec	                                       ,683)
SYSCALL(SndDataPlayStart                                       ,684)
SYSCALL(SndDataPlay	                                       ,685)
SYSCALL(AdpcmEncoder                                           ,686)
SYSCALL(AdpcmDecoder	                                       ,687)
SYSCALL(Iwindow		                                       ,688)
SYSCALL(Iautoco		                                       ,689)
SYSCALL(Icalcoef		                               ,690)
SYSCALL(Ipack		                                       ,691)
SYSCALL(Iunpack		                                       ,692)
SYSCALL(SndDDInit		                               ,693)
SYSCALL(SySetupSetCheckPasswordFlag                            ,694)
SYSCALL(SySetupGetKeyMappingSettings                           ,695)
SYSCALL(AlarmDelAppEvent                                       ,696)
SYSCALL(AlarmQueryApp                                          ,697)
SYSCALL(SySetupCheckPassword                                   ,698)
SYSCALL(SysEnableDebug                                         ,699)
SYSCALL(SysDisableDebug                                        ,700)
SYSCALL(AlarmMgrEnable                                         ,701)
SYSCALL(AlarmHitCount                                          ,702)
SYSCALL(UIPrintMallocCounter	                              ,703)
SYSCALL(SySetupScrollbarSetVolSettings                                  ,704)
SYSCALL(exp														,705)
SYSCALL(log														,706)
SYSCALL(infinity												,707)
SYSCALL(nan														,708)
SYSCALL(isinf													,709)
SYSCALL(isnan													,710)
SYSCALL(pow														,711)
SYSCALL(LcdDrawFixedStringS                                     ,712)
SYSCALL(ExchangeInitExchangeRateDatabase                        ,713)
SYSCALL(ExchangeGetExchangeRate                                 ,714)
SYSCALL(ExchangeCloseExchangeRateDB                             ,715)
SYSCALL(ExchangeSetExchangeRateMappingArray                     ,716)
SYSCALL(ExchangeGetMappingNum                                   ,717)  
SYSCALL(DisHotSynCheck                                     ,718)  
SYSCALL(HotSynDebounCheck                                       ,719)  
SYSCALL(SystemSetMappedHardwareKeyStatus                        ,720)  
SYSCALL(SystemCheckMappedHardwareKeyStatus                      ,721)  
SYSCALL(SystemApplicationInit                                   ,722)
SYSCALL(AlarmSetAppCall                                         ,723)
SYSCALL(AlarmResetAppCall                                       ,724)
SYSCALL(ListHighlightOneItem                                    ,725)
SYSCALL(BmpQ1ToBmpQ4                                            ,726)
SYSCALL(BmpQ4ToBmpQ1                                            ,727)
SYSCALL(AllApplicationDatabaseInit                              ,728)
SYSCALL(litodp                                                  ,729)
SYSCALL(dptoli                                                  ,730)
SYSCALL(BettyInit                                               ,731)
SYSCALL(MsgAppendMsgInt                                         ,732)
SYSCALL(AlarmGetLastAlarmTime									,733)
SYSCALL(SndPlaySndEffect                                        ,734)
SYSCALL(SndSetSndSettings                                       ,735)
SYSCALL(DataResizeField2                                        ,736)
SYSCALL(SBlockAddr                                              ,737)
SYSCALL(BlockAddr                                               ,738)
SYSCALL(HELIOSYSTEMBLACKHOLE                                    ,739)
SYSCALL(MemoryTotalSysMem                                       ,740)
SYSCALL(add                                                     ,741)
SYSCALL(BatChkMainLevel											,742)
SYSCALL(RtcGetTimeEvt											,743)
SYSCALL(PenSetCalMode                                       	,744)
SYSCALL(PenSetNormalMode                                       	,745)
SYSCALL(ComSetDataMode                                          ,746)
SYSCALL(ComGetDataMode                                          ,747)
SYSCALL(SysGetCrashStatus                                       ,748)
SYSCALL(SysSetCrashStatus                                       ,749)
SYSCALL(SySetupSetCheckPassword                                 ,750)
SYSCALL(BatteryWarningSetEnableStatus                           ,751)
SYSCALL(ListSetFont                                             ,752)
SYSCALL(SysEventLoop											,753)
SYSCALL(SysGetPrevAppID                                         ,754)
SYSCALL(PenSetCalValue											,755)
SYSCALL(SysClearDBData                                          ,756)
SYSCALL(SySetupSetAutoOffTime									,757)
SYSCALL(SySetupSetKeyMapping									,758)
SYSCALL(SySetupSetCalPenMode									,759)
SYSCALL(SySetupGetCalPenMode									,760)
SYSCALL(OnPdaInit                                               ,761)
SYSCALL(DisOnPdaTimerInt                                        ,762)
SYSCALL(FieldPasteString                                        ,763)
SYSCALL(TextboxPasteString                                      ,764)
SYSCALL(MenuCloseMenu                                           ,765)
SYSCALL(UICheckObjectPopupStatus                                ,766)
SYSCALL(CpuChangeSpeed                                          ,767)
SYSCALL(AlarmGetAlertType                                       ,768)
SYSCALL(UIResetMallocCounter                                    ,769)
SYSCALL(CheckBatteryLow                                         ,770)
SYSCALL(SysGetOSVersionNo                                       ,771)
SYSCALL(ControlPopupTriggerClosePopupTrigger                    ,772)
SYSCALL(FormAddOneObject                                        ,773)
SYSCALL(SysGetInstallAppHandle									,774)
SYSCALL(SysRemoveApp                                            ,775)
SYSCALL(SysGetAppEntryIndex                                     ,776)
SYSCALL(ResGetInstallIconData                                   ,777)
SYSCALL(UartInit                                                ,778)
SYSCALL(AlarmSetAlertType                                       ,779)
SYSCALL(AppDisOnPdaTimerInt                                     ,780)
SYSCALL(RtcWday5ToYMD                                          	,781)
SYSCALL(SysGetRegistryData										,782)
SYSCALL(SysCheckModemExist										,783)
SYSCALL(MemoryCheckMemLow										,784)
SYSCALL(SysGetAppSize											,785)
SYSCALL(BatChkMainLevelBakup									,786)
SYSCALL(CheckPdaPwr                                             ,787)
SYSCALL(DataClearFieldCache                                     ,788)
SYSCALL(SySetupGetSyncSpeedSettings								,789)
SYSCALL(SySetupSetVolSettings									,790)
SYSCALL(ExchangeCheckDBInited                                   ,791)
SYSCALL(ControlPopupPopupTrigger                                ,792)
SYSCALL(SysRunMode1App                                          ,793)
SYSCALL(LcdGetOrientation                                       ,794)
SYSCALL(SysHookIntHandler                                       ,795)
SYSCALL(IntSetActive                                            ,796)
SYSCALL(SysHookSyscall                                          ,797)
SYSCALL(SysLoadInterruptPageTable                               ,798)
SYSCALL(SysCall                                                 ,799)
SYSCALL(GetUIVariable                                           ,800)
SYSCALL(OnEL                                                    ,801)
SYSCALL(OffEL                                                   ,802)
SYSCALL(SysGetAppAttribute                                      ,803)
SYSCALL(SysGetIndexAppID                                        ,804)
SYSCALL(DataReasignRecID                                        ,805)
SYSCALL(ELState                                                 ,806)
SYSCALL(RtcCheckYMDValid                                        ,807)
SYSCALL(SysCallHooked                                           ,808)
SYSCALL(SibReadData                                             ,809)
SYSCALL(SibWriteData                                            ,810)  
SYSCALL(SibReadDataHandle                                       ,811)
SYSCALL(SibWriteDataHandle                                      ,812)
SYSCALL(SibCapture                                              ,813)
SYSCALL(SibRelease                                              ,814)
SYSCALL(TelStartDma                                             ,815)
SYSCALL(TelStopDma                                              ,816)
SYSCALL(TelSetDmaAddress                                        ,817)
SYSCALL(TelSetSamplingRate                                      ,818)
SYSCALL(TelSetBufferSize                                        ,819)
SYSCALL(TelSetUpBty                                             ,820)
SYSCALL(TelGetBufferPtr                                         ,821)
SYSCALL(EvtAddEventHandler                                      ,822)
SYSCALL(EvtRemoveEventHandler                                   ,823)
SYSCALL(TelInit                                                 ,824)
SYSCALL(TelOnHook                                               ,825)
SYSCALL(TelOffHook                                              ,826)
SYSCALL(IntSetHookAddr                                          ,827)
SYSCALL(IntClearHookAddr                                        ,828)
SYSCALL(SySetupRestoreSettingsAfterSync                         ,829)
SYSCALL(EvtAppendEvtReplaceByTypeOnly                           ,830)
SYSCALL(EvtAppendEvtReplace                                     ,831)
SYSCALL(TelHookStatus                                           ,832)
