
typedef struct {
  char name[32];
  int size;
  int totalrecs;
  int *startptr;
  int curptr;
  DatabaseID dbid;
  RecordID baserec;
  int hasungetc;
  unsigned char ungetc;
  // Buffer below
  int bankrec;
  int banklen;
  int bankoff;
  unsigned char bank[5000];
} DOCFILE;

int IsDocFile(char *name);
DOCFILE *doc_fopen(char *name, char *mode); //mode ignored
void doc_fclose(DOCFILE *fp);
int doc_fseek(DOCFILE *file, int off, int origin);
int doc_ftell(DOCFILE *fp);
int doc_feof(DOCFILE *fp);
int doc_fsize(DOCFILE *fp);
int doc_fgetc(DOCFILE *fp);
int doc_fread(unsigned char *buffer, int size, int count, DOCFILE *file);
int doc_ungetc(unsigned char c, DOCFILE *fp);

extern int isdoc;
#define FSEEK(a, b)  {if (isdoc) doc_fseek(dfp, a, b); else fseek(fp, a, b);}
#define FTELL()      (isdoc?doc_ftell(dfp):ftell(fp))
#define FSIZE()      (isdoc?doc_fsize(dfp):fsize(fp))
#define FPISNULL     (isdoc?dfp==NULL:fp==NULL)
#define FCLOSE()     {if (isdoc) doc_fclose(dfp); else fclose(fp);}
#define FREAD(a,b,c) (isdoc?doc_fread(a,b,c,dfp):fread(a,b,c,fp))
#define FGETC()      (isdoc?doc_fgetc(dfp):fgetc(fp))
#define FEOF()       (isdoc?doc_feof(dfp):feof(fp))
#define UNGETC(a)    {if (isdoc) doc_ungetc(a, dfp); else ungetc(a, fp);}

