#include <system.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "main.h"
#include "../stdlib/fnt.h"
#include "../stdlib/my_stdio.h"
#include "res/resource.h"
#include "res/menu.h"
#include "docfile.h"


#define CPU_CLK_75M        (0<<10)
#define CPU_CLK_37M        (1<<10)
extern void CpuChangeSpeed(int);
BOOLEAN (*FormDispatchEvent)(EvtType *Event);
#define ARYSIZE 1000
#define HALFARY 500
#define REALARYSIZE (ARYSIZE+64)
void TimerCallback();


#define EVT_MOVEIT 0xbabe
#define TIMERDELAY 300
static UWORD timer = 0;


void LoadPrefs();
void SavePrefs();

Pref pref;
int active = 0;
int isdoc = 0;

int __main(WORD cmd, void *cmd_arg)
{
  switch(cmd) {
  case LAUNCH_CMD_NORMAL_LAUNCH:
    UIApplicationInit();		//initialize UI resources
#ifdef DEBUG
    DBG_APP_BEGIN();
#endif
    FormPopupForm(FORM_IFACE);	//start main form
    EventLoop();			//run main event loop
    SavePrefs();
#ifdef DEBUG
    DBG_APP_END();
#endif
    UIDeleteAllAppObjects();	        //main event loop has stopped, cleanup
    break;
  case LAUNCH_CMD_GOTO_REC:
    if(((GotoRec*)cmd_arg)->find_string)
      pfree(((GotoRec*)cmd_arg)->find_string);
  case LAUNCH_CMD_FIND:
  case LAUNCH_CMD_ALARM_HIT:
    pfree(cmd_arg);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

void EventLoop(void)
{
  EvtType event;

  while (1) {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);

    if(event.eventType==EVT_APP_STOP) break;
  }
}

BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(Event->eventType) {
  case EVT_FORM_LOAD:
    if((Event->para1==1)||(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects((ObjectID)Event->eventID);
    if(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)Event->eventID) {
    case FORM_MAIN:  evtHandler = (void*)FormMainHandleEvent; break;
    case FORM_IFACE: evtHandler = (void*)FormIfaceHandleEvent; break;
    case FORM_TYPE:  evtHandler = (void*)FormTypeHandleEvent; break;
    case FORM_LINE:  evtHandler = (void*)FormLineHandleEvent; break;
    case FORM_BOOKMARK:  evtHandler = (void*)FormBookmarkHandleEvent; break;
    case FORM_ADDBOOKMARK:  evtHandler = (void*)FormAddBookmarkHandleEvent; break;
    case FORM_ABOUT: evtHandler = (void*)FormAboutHandleEvent; break;
    case FORM_FONT: evtHandler = (void*)FormFontHandleEvent; break;
    case FORM_INFO: evtHandler = (void*)FormInfoHandleEvent; break;
    case FORM_SEARCHWORD: evtHandler = (void*)FormSearchWordHandleEvent; break;
    case FORM_SEARCH: evtHandler = (void*)FormSearchHandleEvent; break;
    case FORM_SETTINGS: evtHandler = (void*)FormSettingsHandleEvent; break;
    case FORM_TOC: evtHandler = (void*)FormTOCHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler((ObjectID)Event->eventID,(void**)&FormDispatchEvent,evtHandler);
    FormSetActiveForm((ObjectID)Event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

FILE *fp;
DOCFILE *dfp;
int screeny;
int chary;
extern char savename[];
extern int savesmall;
int dimx, dimy;
int linestart[REALARYSIZE+64];
int biglinestart[REALARYSIZE+64]; // Every 500 lines keep track
int topline=0; // What does linestart begin with?
int curline=0;
int maxlines=MAXLINES;
int size=1;
int leftover=0;
void FontChanged();
void Initialize()
{
  DatabaseID dbid;
  int *pos;
  int recsize;

  LoadPrefs();
  dimx = 160;
  dimy = 160;
  isdoc = IsDocFile(savename);
  dfp = NULL;
  fp = NULL;
  FntDrawString("Opening...",0,0,TRUE);
  if (isdoc) {
    dfp = doc_fopen(savename, "rb");
    if (dfp==NULL) return;
  } else {
    fp=fopen(savename, "rb");
    if (fp==NULL) return;
  }
  FSEEK(0, SEEK_END);
  size = FTELL();
  FSEEK(0, SEEK_SET);
  linestart[0]=0;
  maxlines=MAXLINES;
  curline=0;
  topline = 0;
  FontChanged();
  memset(linestart, 0, REALARYSIZE*sizeof(int));
  memset(biglinestart, 0, REALARYSIZE*sizeof(int));
  if (DataFindDB(savename, &dbid)==TRUE)
    if (DataOpenDB(dbid, 0, OPEN_RO)==TRUE)
      if (DataGetField(dbid, RESUMERECORD, 0, (BYTE**)&pos, &recsize)==TRUE) {
	if (recsize==sizeof(int))
	  GotoLine(-1, *pos);
	qfree(pos);
      }
  DataCloseRecord(dbid, RESUMERECORD);
  DataCloseDB(dbid);
}


void Draw( int really );
void FontChanged()
{
  int pos;
  if (FPISNULL) return;
  pos = FTELL();
  FntInstallFont(pref.fontname);
  FntSetFont(pref.font);
  chary = FntLineHeight();
  screeny = 160/chary;
  if (screeny*FntLineHeight()-160!=0) leftover=1;
  else leftover=0;
  maxlines=MAXLINES;
  curline=0;
  topline=0;
  memset(linestart, 0, REALARYSIZE*sizeof(int));
  memset(biglinestart, 0, REALARYSIZE*sizeof(int));
  FSEEK(0, SEEK_SET);
  pref.font = FntGetFont();
  GotoLine(-1, pos);
}

void SavePosition()
{
  DatabaseID dbid;
  Err err;
  int pos;

  if (FPISNULL) return;
  pos = 0;
  pos = FTELL();
  err=DataFindDB(savename, &dbid);
  err=DataOpenDB(dbid, 0, OPEN_RW);
  if (err!=TRUE) return;
  err = DataNewRecordWithID(dbid, RESUMERECORD, 0, 1);
  err = DataWriteField(dbid, RESUMERECORD, 0, sizeof(int), (BYTE*)&pos);
  DataCloseRecord(dbid, RESUMERECORD);
  DataCloseDB(dbid);
}

void SaveResumeFile()
{
  FILE *file;
  char buff[64];

  unlink("TextViewResume");
  file = fopen("TextViewResume","wb");
  if (file) {
    strcpy(buff, savename);
    fwrite(buff, 1, 64, file);
    fclose(file);
  }
}

void Deinitialize()
{
  SavePrefs();
  SavePosition();
  if (!FPISNULL) FCLOSE();
  fp = NULL;
  dfp = NULL;
  TmrIntDisable(timer);
  timer = 0;
}

void Draw(int really) // really==0 => nodraw
{
  int off, end, x, y, c, w, q, drawline, saveoff, len;
  char buff[80], b1[80];
  ObjectBounds bnds;

  if (FPISNULL) return;
  off=FTELL();
  x=0;
  y=0;
  drawline = curline;
  linestart[drawline] = FTELL();
  bnds.height = chary;
  while (y<dimy) {
    bnds.ycoord = y;
    if (linestart[drawline+1]!=0 && linestart[drawline+1]!=EOF && linestart[drawline]!=0 && linestart[drawline]!=EOF) {
      w = linestart[drawline+1]-linestart[drawline];
      if (w>0) {
	int eol;
	eol=0;
	FREAD(buff, 1, w);
	if (w<=0) { w=1; buff[0]=0;}
	if (w>1) {if (buff[w-2]=='\r' && buff[w-1]=='\n') {eol=1; w--;} }
	if (buff[w-1]=='\r' || buff[w-1]=='\n') {eol=1;w--;}
	if (really && pref.justified) {
	  int numspace, i, laststart, startspace;
	  unsigned char wordw[80];
	  while (w>0) {
	    if (buff[w-1]==' ') w--;
	    else break;
	  }
	  startspace = 0;
	  while (startspace<(w-1)) {
	    if (buff[startspace]==' ') startspace++;
	    else break;
	  }
	  numspace=0;
	  laststart=startspace;
	  for (i=startspace; i<w; i++)
	    if (buff[i]==' ') {
	      wordw[numspace] = i-laststart+1;
	      laststart = i+1;
	      numspace++;
	    }
	  wordw[numspace] = w-laststart;
	  if ((numspace==0) || (eol==1)) {
	    FntDrawChars(buff, w, x, y, FALSE);
	    x+=FntCharsWidth(buff, w);
	  } else {
	    int linew;
	    double pos, skip;
	    char *ptr;
	    bnds.xcoord = 0;
	    bnds.width = dimx;
	    if (really) LcdEraseRegion(&bnds);

	    linew = FntCharsWidth(buff+startspace, w-startspace);
	    pos = startspace*FntCharWidth(' ');
	    skip = (160.0-linew-pos)/((double)numspace);

	    ptr = buff+startspace;
	    for (i=0; i<numspace; i++) {
	      FntDrawChars(ptr, wordw[i], (int)pos, y, FALSE);
	      pos += FntCharsWidth(ptr, wordw[i]);
	      pos += skip;
	      ptr += wordw[i];
	    }
	    // Draw last guy
	    FntDrawChars(ptr, wordw[i], 160-FntCharsWidth(ptr, wordw[i]), y, FALSE);
	    x=dimx+1;
	  }
	} else {
	  if (really) FntDrawChars(buff, w, x, y, FALSE);
	  if (really) x+=FntCharsWidth(buff, w);
	}
	bnds.xcoord = x;
	bnds.width = max(0, dimx-x);
	if (really) LcdEraseRegion(&bnds);
      } else {
	bnds.xcoord = 0;
	bnds.width = dimx;
	if (really) LcdEraseRegion(&bnds);
      }
    } else {
      bnds.ycoord = y;
      bnds.xcoord=0;
      bnds.width = dimx;
      if (really) LcdEraseRegion(&bnds);
      while(x<dimx) {
	w=0;
	buff[0]='\r';
	saveoff=FTELL(); // begin word offset
	if (saveoff>=size) { x=dimx;
	} else {
	  // Get the 1st full word up-to but not including space
	  while (FTELL()<size && w<70) {
	    buff[w]=FGETC();
	    w++;
	    if (buff[w-1]==' '||buff[w-1]=='\r'||buff[w-1]=='\n') break;
	  }
	  if (buff[0]=='\r' || buff[0]=='\n'||buff[0]==EOF) {  // Newline
	    x = dimx;
	    if (buff[0]=='\r') { 
	      // Try and hide \r\n
	      int c;
	      c=FGETC();
	      if (c!=EOF && c!='\n')
		UNGETC(c);
	    }
	  } else {
	    if (buff[w-1]==' '||buff[w-1]=='\r'||buff[w-1]=='\n'||buff[w-1]==EOF) q=w-1;
	    else q=w;
	    len=FntCharsWidth(buff,q);
	    if (x+len>dimx) {// Word wrap!
	      if (x==0) { // Long-word special case
		FSEEK(saveoff, SEEK_SET);
		while (x<dimx) {
		  c=FGETC();
		  if (FntCharWidth(c)+x<dimx){
		    if (really) FntDrawChar(c, x, y, FALSE);
		    x += FntCharWidth(c);
		  } else {
		    FSEEK(-1, SEEK_CUR);
		    x=dimx;
		  }
		}
	      } else {
		FSEEK(saveoff, SEEK_SET);
		x=dimx;
	      }
	    } else {  // Word fits, draw it
	      if (really) FntDrawChars(buff, q, x, y, FALSE);
	      x += len;
	      if (buff[w-1]==' ') x+= FntCharWidth(' ');
	      else if (buff[w-1]=='\r'||buff[w-1]=='\n') x=dimx;
	      if (buff[w-1]=='\r') { 
		// Try and hide \r\n
		int c;
		c=FGETC();
		if (c!=EOF && c!='\n')
		  UNGETC(c);
	      }
	      if (FTELL()>=size) x=dimx;
	    }
	  }
	}
      }
    }
    drawline++;
    if (FTELL()<size) {
      linestart[drawline] = FTELL();
      if ((topline+drawline)/500<REALARYSIZE)
	if (((topline+drawline)%500)==0) biglinestart[(topline+drawline)/500] = FTELL();
    }
    else if (FTELL()==size && maxlines==MAXLINES) {linestart[drawline] = FTELL(); linestart[drawline+1] = EOF; if (really)maxlines=topline+drawline-1;}
    y += chary;
    x=0;
  }
  end=FTELL();
  FSEEK(off, SEEK_SET);
  if (!pref.status) return;
  if (maxlines==MAXLINES) {
    sprintf(b1, " line %d - (%d/%d)", curline+topline, end, size);
  } else {
    sprintf(b1, " line %d of %d - (%d/%d) ", curline+topline, maxlines, end, size );
  }
  for(x=0;x<80;x++) buff[x]=' ';
  for(x=0;x<strlen(b1);x++) buff[x]=b1[x];
  buff[79]='0';
  if (really) FntDrawString(buff, 0, 160-(chary-1), TRUE);
}

void GotoLine(int line, int offset)
{
  int w, zz;
  char buff[64];

  if (FPISNULL) return;
  // Warn that this could take some time...
  CpuChangeSpeed(CPU_CLK_75M);
  StippleBackground();
  FntDrawString("Locating...   ",0,0,TRUE);
  w = FntStringWidth("Locating... ");
#ifdef DEBUG
  DBG_BREAK();
#endif

  if ((line>0 && topline<line) || (offset>0 && FTELL()<offset)) {
    // No need to reset search position start
    FSEEK(linestart[curline], SEEK_SET);
    topline = topline+curline;
    curline = 0;
  } else {
    topline = 0;
    FSEEK(0, SEEK_SET);
  }

  if (line>0) {
    // See if we have precomputed this start
    if (line/500 < REALARYSIZE)
      if (biglinestart[line/500]!=0) {
	topline = (line/500)*500;
	FSEEK(biglinestart[line/500], SEEK_SET);
      }
  } else if (offset>0) {
    for (zz=1; zz<REALARYSIZE; zz++) {
      if (biglinestart[zz]>offset || biglinestart[zz]==0) break;
    }
    if (zz<REALARYSIZE) {
      if (biglinestart[zz-1]!=0) {
	topline = (zz-1)*500;
	FSEEK(biglinestart[zz-1], SEEK_SET);
      }
    }
  }

  zz=0;
  if (line==0 || offset==0) {
    curline = 0;
    memset(linestart, 0, REALARYSIZE*sizeof(int));
    Draw(0);
    Draw(1);
    return;
  }
  memset(linestart, 0, 64*sizeof(int)); // no more than 64 lines on screen!
  while (!FEOF() && (line>=0?(topline<line):1)) {
    curline = 0;
    memset(linestart, 0, 64*sizeof(int)); // no more than 64 lines on screen!
    Draw(0); // Just figure out
    topline += screeny;

    // Progress Report
    zz++;
    if (zz>20) {
      sprintf(buff, "%d", topline);
      FntDrawString(buff,w,0,TRUE);
      zz = 0;
    }

    if (linestart[screeny]==0 || linestart[screeny]==EOF ||
	(leftover&&linestart[screeny+1]==0) || (leftover&&linestart[screeny+1]==EOF) ||
	(offset>=0 && linestart[screeny]>offset)) break;
    else FSEEK(linestart[screeny], SEEK_SET);
  }
  if (FEOF() || linestart[screeny]==0 || linestart[screeny]==EOF ||
      (leftover &&linestart[screeny+1]==0) || (leftover&&linestart[screeny+1]==EOF)) {
    FntBeep();
    topline -= screeny;
    curline = 0;
    FSEEK(linestart[0], SEEK_SET);
    memset(linestart, 0, REALARYSIZE*sizeof(int));
    Draw(0);
    Draw(1);
    CpuChangeSpeed(CPU_CLK_37M);
    return;
  }
  curline = screeny;
  while ((line>=0?(topline>line):(linestart[curline]>offset)) && curline>0) {
    topline--;
    curline--;
  }
  FSEEK(linestart[curline], SEEK_SET);
  curline = 0;
  memset(linestart, 0, REALARYSIZE*sizeof(int));
  Draw(0);
  Draw(1);
  CpuChangeSpeed(CPU_CLK_37M);
}

void ScrollUpOneLine()
{
  int readlines;
  int linesback;
  int w;
  int zz;
  char buff[64];
  
  curline--;
  if (curline<0) {
    if (topline==0) curline=0;
    else {
      CpuChangeSpeed(CPU_CLK_75M);
      // Warn that this could take some time...
      StippleBackground();
      FntDrawString("Locating...   ",0,0,TRUE);
      w = FntStringWidth("Locating... ");
      if (topline>=HALFARY)
	linesback = HALFARY;
      else
	linesback = topline-1;
      topline -= linesback;
      memset(linestart, 0, REALARYSIZE*sizeof(int));
      if (topline/500<REALARYSIZE) {
	if (biglinestart[topline/500]) {
	  FSEEK(biglinestart[topline/500], SEEK_SET);
	  readlines = (topline/500)*500;
	} else {
	  FSEEK(0, SEEK_SET);
	  readlines = 0;
	}
      } else {
	FSEEK(0, SEEK_SET);
	readlines = 0;
      }
      curline = 0;
      zz = 0;
      while (readlines<topline) {
	memset(linestart, 0, 64*sizeof(int)); // no more than 64 lines on screen!
	curline = 0;
	Draw(0); // Just figure out
	FSEEK(linestart[screeny], SEEK_SET);
	readlines += screeny;
	// Progress Report
	zz++;
	if (zz>4) {
	  sprintf(buff, "%d", readlines);
	  FntDrawString(buff,w,0,TRUE);
	  zz = 0;
	}
	if (linestart[screeny]==0 || linestart[screeny]==EOF) break;
      }
      curline = screeny;
      while (readlines>topline) {
	readlines--;
	curline--;
      }
      FSEEK(linestart[curline], SEEK_SET);
      
      FntDrawString("Precomputing...",0,0,TRUE);
      // Positioned at proper line, now precompute
      curline = 0;
      memset(linestart, 0, (ARYSIZE+64)*sizeof(int)); // Start fresh
      while (curline<linesback/*HALFARY*//*+64*/) {
	Draw(0); // Just figure out
	curline += screeny;
	FSEEK(linestart[curline], SEEK_SET);
      }
      curline = linesback-1; //HALFARY-1;
      CpuChangeSpeed(CPU_CLK_37M);
    }
  }
  
  FSEEK(linestart[curline], SEEK_SET);
}

void ScrollUp()
{
  int i;
  int lines;

  if (FPISNULL) return;
  if (pref.byline) ScrollUpOneLine();
  else {
    if (!leftover) lines=screeny-1;
    else lines=screeny;
    if (pref.status) lines--;
    for (i=0; i<lines; i++)
      ScrollUpOneLine();
  }
}

void ScrollDownOneLine()
{
  curline++;
  if ((topline+curline)>maxlines) curline=maxlines-topline;
  if (curline>ARYSIZE) {
    int i;
    FSEEK(linestart[curline], SEEK_SET);
    // Shift by 1/2, clear below
    for (i=0; i<HALFARY+2; i++)
      linestart[i] = linestart[i+HALFARY];
    for (;i<ARYSIZE+64; i++)
      linestart[i] = 0;
    curline -= HALFARY;
    topline += HALFARY;
    Draw(0);
  } else
    FSEEK(linestart[curline], SEEK_SET);
}

void ScrollDown()
{
  int i;
  int lines;

  if (FPISNULL) return;
  if (pref.byline) ScrollDownOneLine();
  else {
    if (!leftover) lines=screeny-1;
    else lines=screeny;
    if (pref.status) lines--;
    for (i=0; i<lines; i++)
      ScrollDownOneLine();
  }

}
static int indrag = 0;
static int onewaits = 0;
void AddTimerEvent(int x, int y);
static int lastx, lasty;

void TimerCallback()
{
  if (indrag) {
    TmrIntDisable(timer);
    timer = 0;
    if (!onewaits) EvtAppendEvt(EVT_MOVEIT, 0, 0, 0, NULL);
    onewaits = 1;
  }
}

void AddTimerEvent(int x, int y)
{
  if (indrag) {
    if (y<dimy/3) { ScrollUpOneLine(); Draw(0); Draw(1); }
    else if (y>(2*dimy)/3) { ScrollDownOneLine(); Draw(0); Draw(1); }
  }
  onewaits = 0;
  timer = TmrIntEnable(TIMERDELAY,TimerCallback);
}

BOOLEAN FormMainHandleEvent(EvtType* Event)
{
  int i;

  switch(Event->eventType) {
  case EVT_MOVEIT:
    AddTimerEvent(lastx, lasty);
    return TRUE;

  case EVT_FORM_OPEN:
    FormDrawForm(Event->eventID);
    onewaits = 0;
    if (timer==0)
      timer = TmrIntEnable(TIMERDELAY,TimerCallback);
    if (!active) Initialize();
    active = 0;
    indrag = 0;
    Draw(0);
    Draw(1);
    break;

  case PEN_EVENT:
    switch (Event->eventID) {
    case PEN_DOWN:
      lastx = Event->para1;
      lasty = Event->para2;
      if (lasty>dimy/3 && lasty<(2*dimy)/3) indrag=1;
      break;
      
    case PEN_MOVE:
      if (indrag) {
	lastx = Event->para1;
	lasty = Event->para2;
      }
      break;

    case PEN_UP:
      if (indrag) {
	indrag = 0;
      } else {
	i=(Event->para1 - lastx)*(Event->para1 - lastx) + (Event->para2 - lasty)*(Event->para2 - lasty);
	if (i<15) {
	  if (lasty<dimy/3) ScrollUp();
	  else if (lasty>(2*dimy)/3) ScrollDown();
	  Draw(0);
	  Draw(1);
	}
      }
      break;
    }
    break;
  case EVT_IO_KEY_CTRL:
    if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT) {
      if (Event->para2 == IO_UP_ARROW)
	ScrollUp();
      else if (Event->para2 == IO_DOWN_ARROW)
	ScrollDown();
      Draw(0);
      Draw(1);
      return TRUE;
    }
    return FALSE;
  
  case EVT_MENU_SELECT_ITEM:
    switch(Event->para1) {
    case MENU_SETTINGS: active=1; FormPopupForm(FORM_SETTINGS); break;
    case MENU_SEARCH: active=1; FormPopupForm(FORM_SEARCHWORD); break;
    case MENU_LINE: active=1; FormPopupForm(FORM_LINE); break;
    case MENU_BOOKMARK: active=1; FormPopupForm(FORM_BOOKMARK); break;
    case MENU_TOC: active=1; FormPopupForm(FORM_TOC); break;
    case MENU_QUIT: Deinitialize(); FormPopupForm(FORM_IFACE); break;
    }
    Draw(0);
    Draw(1);
    break;

  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      {
	extern int searchhits;
	extern int wenttosearch;
	extern int wenttotoc;
	extern int tocs;
	extern unsigned int searchoff[100];
	extern TOC *toc;

	if (wenttosearch>=0) {
	  wenttosearch++;
	  if (wenttosearch>=searchhits) wenttosearch=0;
	  GotoLine(-1, searchoff[wenttosearch]);
	} else if (wenttotoc>=0) {
	  wenttotoc++;
	  if (wenttotoc>=tocs) wenttotoc=0;
	  GotoLine(-1, toc[wenttotoc].offset);
	}
      }
      break;

    case INLAY_EXIT:
      Deinitialize();
      FormPopupForm(FORM_IFACE);
      break;
    case INLAY_MAIN_MENU:
      Deinitialize();
      FormGotoApp("Mainmenu");
      break;
    default: SavePrefs(); SavePosition(); return FALSE;
    }
    break;
  case EVT_APP_STOP:
    SavePrefs();
    SavePosition();
    SaveResumeFile();
    break;
  default:
    return FALSE;
  }
  return FALSE;
}

void FormGotoApp(BYTE* app_name)
{
  ObjectID objid;
  FormGetActiveFormID(&objid);
  EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
  SysGetAppID(app_name,&objid);
  EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
  EvtAppendEvt(EVT_APP_LAUNCH,objid,0,0,NULL);
}
