#ifndef __MAIN_H_
#define __MAIN_H_

#include <system.h>
#include "res\resource.h"
#include "emudbg.h"

BOOLEAN ApplicationHandleEvent(EvtType *Event);
BOOLEAN FormMainHandleEvent(EvtType* Event);
BOOLEAN FormIfaceHandleEvent(EvtType* Event);
BOOLEAN FormTypeHandleEvent(EvtType* Event);
BOOLEAN FormLineHandleEvent(EvtType* Event);
BOOLEAN FormAddBookmarkHandleEvent(EvtType* Event);
BOOLEAN FormBookmarkHandleEvent(EvtType* Event);
BOOLEAN FormAboutHandleEvent(EvtType* Event);
BOOLEAN FormFontHandleEvent(EvtType* Event);
BOOLEAN FormInfoHandleEvent(EvtType* Event);
BOOLEAN FormSearchWordHandleEvent(EvtType* Event);
BOOLEAN FormSearchHandleEvent(EvtType* Event);
BOOLEAN FormSettingsHandleEvent(EvtType* Event);
BOOLEAN FormTOCHandleEvent(EvtType* Event);
void EventLoop(void);
BOOLEAN ApplicationHandleEvent(EvtType *Event);
void FormGotoApp(BYTE* app_name);

typedef struct {
  unsigned char filetype[64];
  unsigned int byline;
  unsigned int font;
  unsigned int status;
  unsigned char fontname[64];
  
  // New in V1.5
  unsigned char oldtype1[32];
  unsigned char oldtype2[32];
  unsigned char oldtype3[32];
  unsigned char oldtype4[32];

  int casesensitive;
  unsigned char oldsearch1[64];
  unsigned char oldsearch2[64];
  unsigned char oldsearch3[64];
  unsigned char oldsearch4[64];

  int justified;
} Pref;

typedef struct {
  unsigned int offset;
  unsigned char name[36];
} Bookmark;

typedef struct TOC {
  unsigned int offset;
  unsigned char label[64];
} TOC;


#define BOOKMARKRECORD 0x80002000
#define RESUMERECORD   0x80002001

extern Pref pref;
extern int curline;
extern int topline;
extern int maxlines;

#define MAXLINES 1000000

extern void GotoLine(int line, int offset);

#endif
