/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on March 1st, 2000

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Richard Gaski
Company     :   Pandora Technology
Project     :   Helio 
Date:	    :   March 1st, 2000
Purpose:    :   main file
Revision    :   1.1
Note        :   None
===========================================================================
*/        

#include "main.h"

//main entry point of program
__main(WORD cmd, void *cmd_arg)
{
  switch(cmd)
  {
    case LAUNCH_CMD_NORMAL_LAUNCH:
      UIApplicationInit();		//initialize UI resources
      FormPopupForm(FORM_MAIN);	        //start main form
      EventLoop();			//run main event loop
      UIDeleteAllAppObjects();		//main event loop has stopped, cleanup
      break;
    case LAUNCH_CMD_GOTO_REC:
      if(((GotoRec*)cmd_arg)->find_string)
        pfree(((GotoRec*)cmd_arg)->find_string);
    case LAUNCH_CMD_FIND:
    case LAUNCH_CMD_ALARM_HIT:
      pfree(cmd_arg);
      break;
    default:
      return FALSE;
    }
    return TRUE;
}

void EventLoop(void)
{
  EvtType event;

  while(1)
  {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event))
      continue;
    if(MenuHandleEvent(&event))
      continue;
    if(ApplicationHandleEvent(&event))
      continue;
    FormDispatchEvent(&event);
    if(event.eventType==EVT_APP_STOP)
      break;
  }
  return;
}

BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
  Form* form_ptr;
  BYTE  object_type;
  void* evtHandler;
	
  switch(Event->eventType)
  {
    case EVT_FORM_LOAD:
      if((Event->para1==1)||(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
        FormInitAllFormObjects((ObjectID)Event->eventID);
      if(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
        return FALSE;
      switch((ObjectID)Event->eventID)
      {
        case FORM_MAIN:
          evtHandler = (void*)FormMainHandleEvent;
	  break;
	default:
	  return FALSE;
      }
      FormSetEventHandler((ObjectID)Event->eventID,(void**)&FormDispatchEvent,evtHandler);
      FormSetActiveForm((ObjectID)Event->eventID);
      break;
    default:
      return FALSE;
  }
  return TRUE;
}

BOOLEAN FormMainHandleEvent(EvtType* Event)
{
  switch(Event->eventType)
  {
    case EVT_FORM_OPEN:
      FormDrawForm(Event->eventID);
      break;
    case EVT_CONTROL_SELECT:
      switch(Event->eventID)
      {
        case BUTTON_MAIN:
          AddNewControl();
          break;
        case NEW_CONTROL:
	  FormGotoApp("Mainmenu");
	  break;
      }
      break;
    case EVT_INLAY_SELECT:
      switch(Event->para1)
      {
        case INLAY_EXIT:
	case INLAY_MAIN_MENU:
	  FormGotoApp("Mainmenu");
	  break;
      }
      break;
    default:
      return FALSE;
  }
  return TRUE;
}

void FormGotoApp(BYTE* app_name)
{
  ObjectID object_id;

  FormGetActiveFormID(&object_id);
  EvtAppendEvt(EVT_FORM_CLOSE, object_id, 0, 0, NULL);
  SysGetAppID(app_name,&object_id);
  EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
  EvtAppendEvt(EVT_APP_LAUNCH,object_id,0,0,NULL);
  return;
}

void AddNewControl(void)
{
  Control* control;
  BYTE* control_text = "Exit App\0";

  if(FormCheckObjectExists(NEW_CONTROL))
    return;

  //create new UI object
  UIAddressToLookupTable(NEW_CONTROL,CONTROL,(void**)&control);
  control->control_template = (ControlTemplateButton*)qmalloc(sizeof(ControlTemplateButton));

  //let's set generic control parameters
  control->identification.ui_object_id = NEW_CONTROL;
  control->identification.ui_object_type = CONTROL;
  control->identification.table_related = 0xffff;
  control->bounds.xcoord = 60;
  control->bounds.ycoord = 75;
  control->bounds.width = 40;
  control->bounds.height = 14;
  control->control_style = BUTTON;
  control->control_subtype = BUTTON_STYLE_1;
  control->control_text = (BYTE*)qmalloc((strlen(control_text)+1)*sizeof(BYTE));
  strcpy(control->control_text,control_text);
  control->text_alignment = CENTRE_ALIGN;
  control->control_attr.control_enable = TRUE;
  control->control_attr.control_active = FALSE;
  control->control_attr.control_visible = TRUE;
  control->control_attr.control_drawn = FALSE;
  control->control_attr.control_save_behind = FALSE;
  control->control_attr.control_enter = FALSE;
  control->control_attr.control_enter1 = FALSE;
  control->control_attr.control_enter2 = FALSE;

  //set specific control params for button
  ((ControlTemplateButton*)(control->control_template))->button_radius = 2;
  ((ControlTemplateButton*)(control->control_template))->button_color_on = COLOR_BLACK;
  ((ControlTemplateButton*)(control->control_template))->button_color_off = COLOR_WHITE;
  ((ControlTemplateButton*)(control->control_template))->control_value = FALSE;

  FormAddOneObject(FORM_MAIN,NEW_CONTROL,CONTROL);
  ControlDrawControl(NEW_CONTROL);
}