/*
===========================================================================
File        :   main.c
Author(s)   :   The Dude From X
Company     :   WaffleGadgets
Website     :   www.wafflegadgets.com
Project     :   CountDown - example on using the timer
Date	    :   July 23 2000
Revision    :   1.0
Note        :   Portions of this source were adapted from VT-OS SDK
===========================================================================
*/     

#include <system.h>
#include "res\resource.h"
#include "emudbg.h"

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

static UWORD   hTmr;
static int     CountDown;

//-------------------------------------------------------------------------------
void DrawAlienNumber(int x, int y, int num) {
   int          i, digit, Tx, Ty, Tw, Th;
   ObjectBounds bnds;
   char         tmp[10];

   bnds.xcoord = x+32*3;
   bnds.ycoord = y;
   bnds.height = 32;
   bnds.width  = 32;
   for (i = 0; i < 4; i++) {
      digit = ((num >> (i*2)) & 3);
      LcdDrawBox(&bnds, 0, 0, 0);
      switch (digit) {
         case 0: // Circle
            Tx = bnds.xcoord+bnds.width/2;
            Ty = bnds.ycoord+bnds.height/2;
            LcdDrawEllipse(Tx, Ty, 14, 14, 15, 0, 0);
            LcdDrawEllipse(Tx, Ty, 13, 13, 15, 0, 0);
            LcdDrawEllipse(Tx, Ty, 12, 12, 15, 0, 0);
            break;
         case 1: // Triangle
            Tx = bnds.xcoord+2;
            Ty = bnds.ycoord+2;
            Th = bnds.height-4;
            Tw = bnds.width-4;           
            LcdDrawLine(Tx, Ty+Th, Tx+Tw, Ty+Th, 3, 1, 15, 15);
            LcdDrawLine(Tx+Tw/2, Ty, Tx, Ty+Th, 3, 1, 15, 15);
            LcdDrawLine(Tx+Tw/2, Ty, Tx+Tw, Ty+Th, 3, 1, 15, 15);
            break;
         case 2: // Square
            Tx = bnds.xcoord+2;
            Ty = bnds.ycoord+2;
            Th = bnds.height-4;
            Tw = bnds.width-4;           
            LcdDrawLine(Tx, Ty, Tx+Tw, Ty, 3, 1, 15, 15);
            LcdDrawLine(Tx, Ty, Tx, Ty+Th, 3, 1, 15, 15);
            LcdDrawLine(Tx, Ty+Th, Tx+Tw, Ty+Th, 3, 1, 15, 15);
            LcdDrawLine(Tx+Tw, Ty, Tx+Tw, Ty+Th, 3, 1, 15, 15);
            break;
         case 3: // An X
            Tx = bnds.xcoord+2;
            Ty = bnds.ycoord+2;
            Th = bnds.height-4;
            Tw = bnds.width-4;           
            LcdDrawLine(Tx, Ty, Tx+Tw, Ty+Th, 3, 1, 15, 15);
            LcdDrawLine(Tx, Ty+Th, Tx+Tw, Ty, 3, 1, 15, 15);
            break;
      }
      bnds.xcoord -= bnds.width;
   }
   SndPlaySndEffect(SNDRES5_BEEP);
   bnds.ycoord = y + bnds.height+4;
   bnds.xcoord = x + 52;
   bnds.height = 14;
   bnds.width = 32;
   sprintf(tmp, " %i        ", num);
   LcdDrawFixedString(&bnds, tmp, 15, 0, MEDIUM_FONT, FALSE, 0);
}
//-------------------------------------------------------------------------------
void ClockTicker(void) {
   EvtAppendEvt(EVT_MYTIMER_TICK, 0, 0, 0, NULL);
}
//-------------------------------------------------------------------------------
static BOOLEAN EH_MainHandler(EvtType *event) {
   static char msg[] = "Oh, oh... You best be running!!";
   static ObjectBounds bnds;

   switch (event->eventType) {
      case EVT_FORM_OPEN:
         FormDrawForm(MAIN_FORM);
         CountDown = 0;
         bnds.xcoord = 16;
         bnds.ycoord = 40;
         bnds.height = 12;
         bnds.width  = 128;
         LcdDrawFixedString(&bnds, msg, 15, 0, MEDIUM_FONT, FALSE, 0);
         return TRUE;
      case EVT_MYTIMER_TICK:
         if (CountDown == 0) CountDown = 255; else CountDown--;
         DrawAlienNumber(16, 54, CountDown);
         return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
static BOOLEAN AppHandleEvent(EvtType *event) {
   ObjectID formID;
   Err      found;
   void    *formPTR;
   BYTE     objectType;

   if (event->eventType == EVT_FORM_LOAD) {
      formID = event->eventID;
      found = UISearchForAddress(formID, &objectType, &formPTR);
      if (event->para1 == 1 || found != TRUE) {
         FormInitForm(formID);
         found = UISearchForAddress(formID, &objectType, &formPTR);
         if (!found) return FALSE;
      }
      switch (formID) {
         case MAIN_FORM:
            FormSetEventHandler(MAIN_FORM, (void **) &FormDispatchEvent, EH_MainHandler);
            break;
      }
      FormSetActiveForm(formID);
      return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
void EventLoop(void) {
   EvtType event;

   do {
      EvtGetEvent(&event);
      if (!SystemHandleEvent(&event)) {
         if (!MenuHandleEvent(&event)) {
            if (!AppHandleEvent(&event)) {
               FormDispatchEvent(&event);
            }
         }
      }
   } while(event.eventType != EVT_APP_STOP);
}
//-------------------------------------------------------------------------------
void ProgramInit(void) {
   hTmr = TmrIntEnable(1000, ClockTicker);
   FormPopupForm(MAIN_FORM);
}
//-------------------------------------------------------------------------------
void ProgramExit(void) {
   TmrIntDisable(hTmr);
}
//-------------------------------------------------------------------------------
__main(WORD cmd, void *cmd_ptr) {
   switch (cmd) {
      case LAUNCH_CMD_NORMAL_LAUNCH:
         UIApplicationInit();
         ProgramInit();
         EventLoop();
         ProgramExit();
         UIDeleteAllAppObjects();
         return TRUE;
      case LAUNCH_CMD_FIND:
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_GOTO_REC:
         if (((GotoRec*)cmd_ptr)->find_string != NULL)
            pfree(((GotoRec*)cmd_ptr)->find_string);
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_ALARM_HIT:
         pfree(cmd_ptr);
         return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------

/*
===========================================================================
History

July 23 2000 - Original creation
===========================================================================
*/     
