/*
===========================================================================
File        :   main.c
Author(s)   :   The Dude From X
Company     :   WaffleGadgets
Website     :   www.wafflegadgets.com
Project     :   Lists - example on using buttons & lists
Date	    :   July 18 2000
Revision    :   1.0.01
Note        :   Portions of this source were adapted from VT-OS SDK
===========================================================================
*/     

#include <system.h>
#include "res\resource.h"
#include "emudbg.h"

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

//-------------------------------------------------------------------------------
static BOOLEAN EH_MainHandler(EvtType *event) {
   char  Lbl[40], *G;
   SHORT Source;
   SHORT Target;
   SHORT Nitems;
   SHORT Ditems;

   switch (event->eventType) {
      case EVT_FORM_OPEN:
         FormDrawForm(MAIN_FORM);
         return TRUE;
      case EVT_CONTROL_SELECT:
         ListGetSelectedItem(SOURCE_LIST, &Source);
         ListGetSelectedItem(TARGET_LIST, &Target);
         switch (event->eventID) {
            case IN_BTN:
               if (Source == NO_SELECTION) return TRUE;
               ListGetListItem(SOURCE_LIST, Source, (BYTE **) &G);
               strcpy(Lbl, G);
               ListDeleteItem(SOURCE_LIST, Source);
               ListSetSelectedItem(SOURCE_LIST, Source);
               ListSetHighlightedItem(SOURCE_LIST, Source);
               if (Target == NO_SELECTION) ListGetTotalItems(TARGET_LIST, &Target);
               ListInsertItem(TARGET_LIST, Target, Lbl); 
               ListSetSelectedItem(TARGET_LIST, Target);
               ListSetHighlightedItem(TARGET_LIST, Target);
               break;
            case OUT_BTN:
               if (Target == NO_SELECTION) return FALSE;
               ListGetListItem(TARGET_LIST, Target, (BYTE **) &G);
               strcpy(Lbl, G);
               ListDeleteItem(TARGET_LIST, Target);
               ListSetSelectedItem(TARGET_LIST, Target);
               ListSetHighlightedItem(TARGET_LIST, Target);
               if (Source == NO_SELECTION) ListGetTotalItems(SOURCE_LIST, &Source);
               ListInsertItem(SOURCE_LIST, Source, Lbl); 
               ListSetSelectedItem(SOURCE_LIST, Source);
               ListSetHighlightedItem(SOURCE_LIST, Source);
               break;
         }
         ListGetTotalItems(SOURCE_LIST, &Nitems);
         ListGetMaxNumItemsDisplay(SOURCE_LIST, &Ditems);
         if (Nitems <= Ditems) ListSetTopItemNum(SOURCE_LIST, 0);
         ListDrawList(SOURCE_LIST);
         ListGetTotalItems(TARGET_LIST, &Nitems);
         ListGetMaxNumItemsDisplay(TARGET_LIST, &Ditems);
         if (Nitems <= Ditems) ListSetTopItemNum(TARGET_LIST, 0);
         ListDrawList(TARGET_LIST);
         return TRUE;
      case EVT_LIST_SELECT:
         ListSetSelectedItem(event->eventID, event->para1);
         ListSetHighlightedItem(event->eventID, event->para1);
         ListDrawList(event->eventID);
         return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
static BOOLEAN AppHandleEvent(EvtType *event) {
   ObjectID formID;
   Err      found;
   void    *formPTR;
   BYTE     objectType;

   if (event->eventType == EVT_FORM_LOAD) {
      formID = event->eventID;
      found = UISearchForAddress(formID, &objectType, &formPTR);
      if (event->para1 == 1 || found != TRUE) {
         FormInitForm(formID);
         found = UISearchForAddress(formID, &objectType, &formPTR);
         if (!found) return FALSE;
      }
      switch (formID) {
         case MAIN_FORM:
            FormSetEventHandler(MAIN_FORM, (void **) &FormDispatchEvent, EH_MainHandler);
            break;
      }
      FormSetActiveForm(formID);
      return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
void EventLoop(void) {
   EvtType event;

   do {
      EvtGetEvent(&event);
      if (!SystemHandleEvent(&event)) {
         if (!MenuHandleEvent(&event)) {
            if (!AppHandleEvent(&event)) {
               FormDispatchEvent(&event);
            }
         }
      }
   } while(event.eventType != EVT_APP_STOP);
}
//-------------------------------------------------------------------------------
void ProgramInit(void) {
   FormPopupForm(MAIN_FORM);
}
//-------------------------------------------------------------------------------
void ProgramExit(void) {
}
//-------------------------------------------------------------------------------
__main(WORD cmd, void *cmd_ptr) {
   switch (cmd) {
      case LAUNCH_CMD_NORMAL_LAUNCH:
         UIApplicationInit();
         ProgramInit();
         EventLoop();
         ProgramExit();
         UIDeleteAllAppObjects();
         return TRUE;
      case LAUNCH_CMD_FIND:
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_GOTO_REC:
         if (((GotoRec*)cmd_ptr)->find_string != NULL)
            pfree(((GotoRec*)cmd_ptr)->find_string);
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_ALARM_HIT:
         pfree(cmd_ptr);
         return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------

/*
===========================================================================
History

June 13 2000 - Original creation
July 18 2000 - Minor stuff so that it can be posted on the web
===========================================================================
*/     
