/*
===========================================================================
File        :   main.c
Author(s)   :   The Dude From X
Company     :   WaffleGadgets
Website     :   www.wafflegadgets.com
Project     :   Doodles - example on tracking the pen
Date	    :   July 23 2000
Revision    :   1.0
Note        :   Portions of this source were adapted from VT-OS SDK
===========================================================================
*/     

#include <system.h>
#include "res\resource.h"
#include "emudbg.h"

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

//-------------------------------------------------------------------------------
static BOOLEAN EH_MainHandler(EvtType *event) {
static int LastX, LastY;
   switch (event->eventType) {
      case EVT_FORM_OPEN:
         FormDrawForm(MAIN_FORM);
         return TRUE;
      case PEN_EVENT:
         switch (event->eventID) {
            case PEN_DOWN:
               LcdDrawEllipse(event->para1, event->para2, 2, 2, 15, 15, 1);
               LastX = event->para1;
               LastY = event->para2;
               break;
            case PEN_MOVE:
               LcdDrawLine(LastX, LastY, event->para1, event->para2, 1, 1, 15, 15);
               LastX = event->para1;
               LastY = event->para2;
               break;
            case PEN_UP:
               LcdDrawEllipse(event->para1, event->para2, 2, 2, 15, 15, 1);
               break;
         }
         return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
static BOOLEAN AppHandleEvent(EvtType *event) {
   ObjectID formID;
   Err      found;
   void    *formPTR;
   BYTE     objectType;

   if (event->eventType == EVT_FORM_LOAD) {
      formID = event->eventID;
      found = UISearchForAddress(formID, &objectType, &formPTR);
      if (event->para1 == 1 || found != TRUE) {
         FormInitForm(formID);
         found = UISearchForAddress(formID, &objectType, &formPTR);
         if (!found) return FALSE;
      }
      switch (formID) {
         case MAIN_FORM:
            FormSetEventHandler(MAIN_FORM, (void **) &FormDispatchEvent, EH_MainHandler);
            break;
      }
      FormSetActiveForm(formID);
      return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
void EventLoop(void) {
   EvtType event;

   do {
      EvtGetEvent(&event);
      if (!SystemHandleEvent(&event)) {
         if (!MenuHandleEvent(&event)) {
            if (!AppHandleEvent(&event)) {
               FormDispatchEvent(&event);
            }
         }
      }
   } while(event.eventType != EVT_APP_STOP);
}
//-------------------------------------------------------------------------------
void ProgramInit(void) {
   FormPopupForm(MAIN_FORM);
}
//-------------------------------------------------------------------------------
void ProgramExit(void) {
}
//-------------------------------------------------------------------------------
__main(WORD cmd, void *cmd_ptr) {
   switch (cmd) {
      case LAUNCH_CMD_NORMAL_LAUNCH:
         UIApplicationInit();
         ProgramInit();
         EventLoop();
         ProgramExit();
         UIDeleteAllAppObjects();
         return TRUE;
      case LAUNCH_CMD_FIND:
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_GOTO_REC:
         if (((GotoRec*)cmd_ptr)->find_string != NULL)
            pfree(((GotoRec*)cmd_ptr)->find_string);
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_ALARM_HIT:
         pfree(cmd_ptr);
         return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------

/*
===========================================================================
History

July 23 2000 - Original creation
===========================================================================
*/     
