#include <system.h>
#include <string.h>
#include "../stdlib/fnt.h"
#include "makeres.h"
#include "getline.h"
#include "compass.h"


static char *strsave;
static int donecompass=0;
static int madecompass=0;
static BOOLEAN FormCompassHandleEvent(EvtType* event);
//extern BOOLEAN ApplicationHandleEvent(EvtType *event);

typedef enum {FORM_COMPASS=3930, STRING_COMPASS, COMPASS_CANCEL,
	      COMPASS_NW, COMPASS_N, COMPASS_NE, COMPASS_W, COMPASS_X, COMPASS_E, COMPASS_SW, COMPASS_S, COMPASS_SE, COMPASS_UP, COMPASS_DN} COMPASSIDS;

static void MakeCompass() 
{
  MakeForm(FORM_COMPASS, 100, 85, 60, 75, NON_BITMAP_DIALOG, "", NULL);
  MakeString(STRING_COMPASS, 105, 87, 37, 13, CENTRE_ALIGN, "Compass", TRUE);
  MakeButton0(COMPASS_CANCEL, 146, 87, 11, 11, "X", TRUE);

  MakeButton0(COMPASS_NW, 100, 100, 20, 13, "NW", FALSE);
  MakeButton0(COMPASS_N , 120, 100, 20, 13, "N", FALSE);
  MakeButton0(COMPASS_NE, 140, 100, 20, 13, "NE", FALSE);
  MakeButton0(COMPASS_W , 100, 115, 20, 13, "W", FALSE);
  MakeButton0(COMPASS_X , 120, 115, 20, 13, "*", FALSE);
  MakeButton0(COMPASS_E , 140, 115, 20, 13, "E", FALSE);
  MakeButton0(COMPASS_SW, 100, 130, 20, 13, "SW", FALSE);
  MakeButton0(COMPASS_S , 120, 130, 20, 13, "S", FALSE);
  MakeButton0(COMPASS_SE, 140, 130, 20, 13, "SE", FALSE);
  
  MakeButton0(COMPASS_UP, 100, 145, 30, 13, "up", FALSE);
  MakeButton0(COMPASS_DN, 130, 145, 30, 13, "down", FALSE);

  FormAddOneObject(FORM_COMPASS, STRING_COMPASS, STRING);
  FormAddOneObject(FORM_COMPASS, COMPASS_CANCEL, CONTROL);

  FormAddOneObject(FORM_COMPASS, COMPASS_NW, CONTROL);
  FormAddOneObject(FORM_COMPASS, COMPASS_N, CONTROL);
  FormAddOneObject(FORM_COMPASS, COMPASS_NE, CONTROL);
  FormAddOneObject(FORM_COMPASS, COMPASS_W, CONTROL);
  FormAddOneObject(FORM_COMPASS, COMPASS_X, CONTROL);
  FormAddOneObject(FORM_COMPASS, COMPASS_E, CONTROL);
  FormAddOneObject(FORM_COMPASS, COMPASS_SW, CONTROL);
  FormAddOneObject(FORM_COMPASS, COMPASS_S, CONTROL);
  FormAddOneObject(FORM_COMPASS, COMPASS_SE, CONTROL);
  FormAddOneObject(FORM_COMPASS, COMPASS_UP, CONTROL);
  FormAddOneObject(FORM_COMPASS, COMPASS_DN, CONTROL);
  madecompass = 1;
}

static BOOLEAN CompassApplicationHandleEvent(EvtType *event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(event->eventType)  {
  case EVT_FORM_LOAD:
    if((event->para1==1)||(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects(event->eventID);
    if(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)event->eventID) {
    case FORM_COMPASS: evtHandler = (void*)FormCompassHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler(event->eventID, (void*)&FormDispatchEvent, evtHandler);
    FormSetActiveForm(event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

int DoCompass(char *buff)
{
  EvtType event;
  ObjectID oldForm;

  donecompass=0;
  if (!madecompass) MakeCompass();
  FormGetActiveFormID(&oldForm);
  strsave = buff;
  FormPopupForm(FORM_COMPASS);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(CompassApplicationHandleEvent(&event)) continue;
    //    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP)  {PowerOff();break;}
  } while (!donecompass);
  if (event.eventType!=EVT_APP_STOP) FormPopupForm(oldForm);
  return event.eventType;
}

BOOLEAN FormCompassHandleEvent(EvtType* Event)
{
  char *inject;

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    FormSaveBehindBits(FORM_COMPASS);
    FormDrawForm(FORM_COMPASS);
    break;

  case EVT_CONTROL_SELECT:
    switch (Event->eventID) {
    case COMPASS_CANCEL: inject=NULL; break; // Cancel
    case COMPASS_NW: inject = "Northwest|"; break;
    case COMPASS_N: inject = "North|"; break;
    case COMPASS_NE: inject = "Northeast|"; break;
    case COMPASS_W: inject = "West|"; break;
    case COMPASS_X: inject = "Enter "; break;
    case COMPASS_E: inject = "East|"; break;
    case COMPASS_SW: inject = "Southwest|"; break;
    case COMPASS_S: inject = "South|"; break;
    case COMPASS_SE: inject = "Southeast|"; break;
    case COMPASS_UP: inject = "Up|"; break;
    case COMPASS_DN: inject = "Down|"; break;
    default: inject = NULL; break;
    }
    if (inject) {
      if (strsave[strlen(strsave)-1]!=' ' && strlen(strsave)>0) strcat(strsave," ");
      strcat(strsave, inject);
      FntBeep();
    }
    FormRestoreBitBehind(FORM_COMPASS);
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_COMPASS, 0, 0, NULL);
    donecompass=1;
    break;

  default:
    return FALSE;
  }
  return FALSE;
}
