#include <system.h>
#include <setjmp.h>
#include <stdio.h>
#include "glk.h"
#include "cheapglk.h"
#include "emudbg.h"
#include "../stdlib/fnt.h"
#include "makeres.h"
#include "screenmap.h"
#include "heliomain.h"
#include "getline.h"
#include "iface.h"
#include "glkiface.h"

static void FormGotoApp(BYTE* app_name);

jmp_buf env;

static int argc=2;
static char *argv[]={"tadsr", "test.gam"};
static void myputc_raw(char str, int style, window_t *win);
extern int _glk_main(int argc, char *argv[]);

void exit(int code)
{
  longjmp(env, 1);
}

int __main(WORD cmd, void *cmd_arg)
{
  char buff[64];

  switch(cmd) {
    case LAUNCH_CMD_NORMAL_LAUNCH:
      UIApplicationInit();
      DBG_APP_BEGIN();
      DBG_BREAK();
      if (DoIface(buff)) {
	argv[1] = buff;
	SetGameName(buff);
	os_erase_area(0, 0, 159, 159);
	os_set_cursor(0, 0);
	if (setjmp(env)==0) {
	  _glk_main(argc, argv);
	}
      }
      DBG_APP_END();
      my_cleanup();
      FormGotoApp("Mainmenu");
      UIDeleteAllAppObjects();
      break;
    case LAUNCH_CMD_GOTO_REC:
      if(((GotoRec*)cmd_arg)->find_string)
        pfree(((GotoRec*)cmd_arg)->find_string);
    case LAUNCH_CMD_FIND:
    case LAUNCH_CMD_ALARM_HIT:
      pfree(cmd_arg);
      break;
    default:
      return FALSE;
    }
  return TRUE;
}

static void FormGotoApp(BYTE* app_name)
{
  ObjectID objid;

  FormGetActiveFormID(&objid);
  EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
  SysGetAppID(app_name,&objid);
  EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
  EvtAppendEvt(EVT_APP_LAUNCH,objid,0,0,NULL);
}

static int disflush = 0;

static void NewLine(window_t *win)
{
  int maxline;
  char buff[20];

  FntSetFont(win->font);
  win->curline++;
  maxline = win->h/FntLineHeight();
  win->curr_x = 0;
  if ( win->curr_y < (win->y + (maxline-1) * FntLineHeight()) )	{
    win->curr_y += FntLineHeight();
  } else {
    os_scroll_area(win->y, win->x, win->y+maxline*FntLineHeight(), win->x+win->w, FntLineHeight() );
    win->curr_y = win->y+((maxline-1) * FntLineHeight());
    LcdDrawHoriLine(win->x, win->x+win->w, win->y+win->h+1, NON_DOTTED_LINE, COLOR_WHITE, COLOR_BLACK);
  }
  os_set_cursor(win->curr_y, win->curr_x);
  if ((win->curline+1)>=maxline) {
    if (win->type != wintype_TextGrid) {
      win->curline = 0;
      myputc_raw('*', style_Emphasized, win);
      myputc_raw('*', style_Emphasized, win);
      myputc_raw('M', style_Emphasized, win);
      myputc_raw('O', style_Emphasized, win);
      myputc_raw('R', style_Emphasized, win);
      myputc_raw('E', style_Emphasized, win);
      myputc_raw('*', style_Emphasized, win);
      myputc_raw('*', style_Emphasized, win);
      disflush=1;
      mygetline(buff, "", 0, TRUE);
      disflush=0;
    }
    os_erase_area(win->y+(maxline-1)*FntLineHeight(), win->x, win->y+maxline*FntLineHeight(), win->x+win->w);
    win->curr_x=0;
  }
}


static void myputc_raw(char str, int style, window_t *win)
{
  FntSetFont(win->font);
  if (str=='\n') NewLine(win);
  else {
    os_set_cursor(win->curr_y, win->curr_x);
    if (win->type==wintype_TextGrid) {
      if (style==style_Emphasized) FntSetUnderlineMode(solidUnderline);
      else FntSetUnderlineMode(noUnderline);

      os_display_char(str, FALSE);
       win->curr_x+=FntCharWidth(str);
   } else {
      if (win->curr_x+FntCharWidth(str)>win->x+win->w) NewLine(win);
      if (style==style_Emphasized) FntSetUnderlineMode(solidUnderline);
      else FntSetUnderlineMode(noUnderline);
      os_display_char(str, FALSE);
      win->curr_x+=FntCharWidth(str);
    }
  }
}

void myputc(char str, window_t *win)
{
  int ww, j;

  FntSetFont(win->font);
  if (win->type==wintype_TextGrid) {
    myputc_raw(str, win->style, win);
    win->tempptr = 0;
    LcdDrawHoriLine(win->x, win->x+win->w, win->y+win->h, NON_DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
  } else {
    win->tempstyle[win->tempptr] = win->style;
    win->tempbuff[win->tempptr++]=str;
    win->tempbuff[win->tempptr]=0;
    if (str==' ' || str=='\n') { // Flush!
      if (str=='\n') ww = FntCharsWidth(win->tempbuff, max(win->tempptr-1, 0));
      else           ww = FntCharsWidth(win->tempbuff, win->tempptr);
      
      if (win->curr_x+ww>win->x+win->w) NewLine(win);
      for (j=0; j<win->tempptr; j++)
	myputc_raw(win->tempbuff[j], win->tempstyle[j], win);
      win->tempptr = 0;
    }
  }

}

void flush()
{
  int ww, i;
  window_t *win = gli_window_get();

  if (disflush) return;
  FntSetFont(win->font);
  if (win->type==wintype_TextGrid) {
    for (i=0; i<win->tempptr; i++)
      myputc_raw(win->tempbuff[i], win->tempstyle[i], win);
    win->tempptr = 0;
  } else {
    ww = FntCharsWidth(win->tempbuff, win->tempptr);
    if ((win->curr_x-win->x+ww)>win->w) NewLine(win);
    for (i=0; i<win->tempptr; i++)
      myputc_raw(win->tempbuff[i], win->tempstyle[i], win);
    win->tempptr = 0;
  }
}


void myputs(char *str, window_t *win)
{
  while (*str) {
    myputc(*str, win);
    str++;
  }
}

extern window_t *gli_window_get_main();
extern window_t *gli_window_get_status();
extern window_t *gli_window_get_aux();
void ResetLinePointer()
{
  window_t *win = gli_window_get_main();
  if (win) win->curline=0;
  win = gli_window_get_status();
  if (win) win->curline=0;
  win = gli_window_get_aux();
  if (win) win->curline=0;
}
