#include <system.h>
#include "..\stdlib\my_stdio.h"
#include "..\stdlib\fnt.h"
#include "about.h"
#include "font.h"
#include "makeres.h"
#include "glkiface.h"

static char savename[64];
static int savesmall;
static int savego = 0;

static int madeiface=0;
static int doneiface;

extern int textFont;
extern int fixedFont;

static char textName[64];
static char fixedName[64];

static int wantfixed;
static char *fonttitle = NULL;
static BOOLEAN FormIfaceHandleEvent(EvtType* event);
typedef enum {FORM_IFACE=3920, STRING_IFACE, LIST_MAIN, OPEN_BUTTON,
	      FIXED_BUTTON, TEXT_BUTTON, MENU_IFACE, IFACE_CANCEL} IFACEIDS;
typedef enum {MENU_ABOUT=0} IFACEMENUIDS;

static BOOLEAN IfaceApplicationHandleEvent(EvtType *event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(event->eventType)  {
  case EVT_FORM_LOAD:
    if((event->para1==1)||(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects(event->eventID);
    if(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)event->eventID) {
    case FORM_IFACE: evtHandler = (void*)FormIfaceHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler(event->eventID, (void*)&FormDispatchEvent, evtHandler);
    FormSetActiveForm(event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}



static void MakeIface()
{
  MakeForm(FORM_IFACE, 0, 0, 160, 160, 1, GetAppName(), NULL);
  MakeString(STRING_IFACE, 5, 20, 150, 9, CENTRE_ALIGN, "Select A Game To Play", FALSE);
  MakeList(LIST_MAIN, 5, 32, 150, 104, LEFT_ALIGN, 8);
  MakeButton(OPEN_BUTTON, 10, 141, 44, 14, "Play");
  MakeButton(FIXED_BUTTON, 58, 141, 44, 14, "Set Fixed");
  MakeButton(TEXT_BUTTON, 106, 141, 44, 14, "Set Text");
  MakeMenu(MENU_IFACE);
  MenuInsertItem(MENU_IFACE, MENU_ABOUT, "About...");
  MakeButton0(IFACE_CANCEL, 148, 1, 11, 11, "X", TRUE);
  FormAddOneObject(FORM_IFACE, STRING_IFACE, STRING);
  FormAddOneObject(FORM_IFACE, LIST_MAIN, LIST);
  FormAddOneObject(FORM_IFACE, OPEN_BUTTON, CONTROL);
  FormAddOneObject(FORM_IFACE, FIXED_BUTTON, CONTROL);
  FormAddOneObject(FORM_IFACE, TEXT_BUTTON, CONTROL);
  FormAddOneObject(FORM_IFACE, IFACE_CANCEL, CONTROL);
  FormAddOneObject(FORM_IFACE, MENU_IFACE, MENU);
  madeiface = 1;
}

static void ReadPrefs()
{
  FILE *fp;
  
  textFont  = smallFont;
  fixedFont = smallFixedFont;
  textName[0] = 0;
  fixedName[0] = 0;
  fp = fopen(GetPrefFileName(), "rb");
  if (fp) {
    fread(&textFont, 1, sizeof(int), fp);
    fread(textName, 1, 64, fp);
    fread(&fixedFont, 1, sizeof(int), fp);
    fread(fixedName, 1, 64, fp);
    fclose(fp);
  }
}

static void WritePrefs()
{
  FILE *fp;
  filetype(GetPrefFileType());
  fp = fopen(GetPrefFileName(), "wb");
  if (fp) {
    fwrite(&textFont, 1, sizeof(int), fp);
    fwrite(textName, 1, 64, fp);
    fwrite(&fixedFont, 1, sizeof(int), fp);
    fwrite(fixedName, 1, 64, fp);
    fclose(fp);
  }
}

static void LoadFonts()
{
  if (textFont==userFont0)
    FntInstallFontNum(textName, 0);
  if (fixedFont==userFont1)
    FntInstallFontNum(fixedName, 1);
}

int DoIface(char *fname)
{
  EvtType event;

  if (!madeiface) MakeIface();
  doneiface=0;
  strcpy(savename, "");
  savesmall = 0;
  savego = 0;
  ReadPrefs();
  FormPopupForm(FORM_IFACE);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(IfaceApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP) break;
  } while(!doneiface);
  FormDeleteForm(FORM_IFACE);
  strcpy(fname, savename);
  WritePrefs();
  LoadFonts();
  return savego;
}


static BOOLEAN FormIfaceHandleEvent(EvtType* Event)
{
  SHORT item;
  BYTE *ptr;
	
  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    FormDrawForm(Event->eventID);
    ListDeleteAllItems(LIST_MAIN);
    ListAllDBs(GetGameFileType(), LIST_MAIN);
    ListSetSelectedItem(LIST_MAIN, NO_SELECTION);
    ListDrawList(LIST_MAIN);
    ControlDrawControl(IFACE_CANCEL);
    break;

  case EVT_MENU_SELECT_ITEM:
    if (GameAbout()==EVT_APP_STOP) {
      savego = 0;
      doneiface = 1;
    }
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(Event->eventID, Event->para1);
    ListSetHighlightedItem(Event->eventID, Event->para1);
    ListDrawList(Event->eventID);
    return TRUE;
		
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      ListGetTotalItems(LIST_MAIN, &item);
      if (item==0) break;
      ListGetSelectedItem(LIST_MAIN, &item);
      if (item == NO_SELECTION) return TRUE;
      ListGetListItem(LIST_MAIN, item, (BYTE **)&ptr);
      strcpy(savename, ptr);
      savego = 1;
      doneiface = 1;
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      doneiface = 1;
      savego = 0;
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    if (Event->eventID == IFACE_CANCEL){
      doneiface = 1;
      savego = 0;
      return TRUE;
    }
    switch (Event->eventID) {
    case FIXED_BUTTON:
      strcpy(savename, ptr);
      fonttitle = "Please Select A Fixed-Width Font";
      wantfixed = 1;
      savego=0;
      if (DoFont(wantfixed, fonttitle, &fixedFont, fixedName)==EVT_APP_STOP)
	doneiface=1;
      if (fixedFont==userFont) fixedFont=userFont1;
      return TRUE;
    case TEXT_BUTTON:
      strcpy(savename, ptr);
      fonttitle = "Please Select A Proportional Font";
      wantfixed = 0;
      if (DoFont(wantfixed, fonttitle, &textFont, textName)==EVT_APP_STOP)
	doneiface=1;
      if (textFont==userFont) textFont=userFont0;
      return TRUE;
    }
    ListGetTotalItems(LIST_MAIN, &item);
    if (item==0) break;
    ListGetSelectedItem(LIST_MAIN, &item);
    if (item == NO_SELECTION) return TRUE;
    ListGetListItem(LIST_MAIN, item, (BYTE **)&ptr);
    switch (Event->eventID) {
    case OPEN_BUTTON:
      strcpy(savename, ptr);
      savego = 1;
      doneiface = 1;
      break;
    }
    break;
		
  default:
    return FALSE;
  }
  return TRUE;
}

