#include <system.h>
#include "makeres.h"

static int demunged=0;
char icon[]={
  0xff, 0x0f, 0x00, 0xff, 0xff, 0, 0, 0,
  0xf0, 0x0f, 0xf0, 0x0f, 0xff, 0, 0, 0,
  0x00, 0xff, 0xf0, 0x0f, 0xff, 0, 0, 0,
  0x0f, 0xf0, 0xff, 0x00, 0xff, 0, 0, 0,
  0x0f, 0xff, 0xff, 0xf0, 0xff, 0, 0, 0,
  0x00, 0xff, 0xff, 0xf0, 0xff, 0, 0, 0,
  0xf0, 0xff, 0xf0, 0xf0, 0xff, 0, 0, 0,
  0xf0, 0xff, 0x0f, 0xf0, 0x0f, 0, 0, 0,
  0x00, 0xff, 0xff, 0xff, 0x00, 0, 0, 0,
  0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0, 0, 0,
  0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0, 0, 0,
  0x0f, 0xff, 0xff, 0xff, 0xff, 0, 0, 0 };


Err MakeForm(int id, int x, int y, int w, int h, int style, char *title, char *cusicon)
{
  Form *addr;
  Err Error;
  BYTE object_type;

  if (!demunged) DeMunge(icon, sizeof(icon));
  demunged = 1;

  object_type = FORM;
  Error = UIAddLinkListFormElement(id,&addr);
  if (Error != TRUE) return Error;
  addr->identification.ui_object_id = id;

  /* Field 0 */
  addr->identification.ui_object_type = FORM;
  addr->identification.table_related = 0xFFFF;

  /* Field 1 */
  addr->bounds.xcoord = x;
  addr->bounds.ycoord = y;
  addr->bounds.width = w;
  addr->bounds.height = h;

  /* Field 2 */
  addr->form_focus = 0;

  /* Field 3 */
  addr->form_style = style;

  /* Field 4 */
  addr->form_dialog_title = (BYTE*)qmalloc((strlen(title) + 1)*sizeof(BYTE));
  strcpy(addr->form_dialog_title, title);

  /* Field 5 */
  if (addr->form_style == 1 || addr->form_style == 2) {
    addr->form_bitmap.xcoord = 0;
    addr->form_bitmap.ycoord = 0;
    addr->form_bitmap.width = 10;
    addr->form_bitmap.height = 12;
    addr->form_bitmap.compressed = 0;
    addr->form_bitmap.quantisation = 0;
    addr->form_bitmap.size = 96;
    addr->form_bitmap.bitmap_data = (UWORD*)qmalloc(96);
    memcpy(addr->form_bitmap.bitmap_data, cusicon?cusicon:icon, 96);
  }
  /* Field 6 */
  addr->form_num_objects = 0;

  /* Field 7 */
  addr->form_objects_list = (FormObjectsList*)qmalloc(1*sizeof(FormObjectsList));

  /* Field 8 */
  addr->form_attr.form_drawn = FALSE;
  addr->form_attr.form_active = FALSE;
  addr->form_attr.form_updated = FALSE;
  addr->form_attr.form_save_behind = FALSE;
  addr->save_behind.bitmap_data = NULL;

  return TRUE;
}

Err MakeTextbox(int id, int x, int y, int w, int h )
{
  BYTE *buffer;
  void *temp;
  Textbox *addr;
  Err Error;
  BYTE object_type;
  USHORT temp_length;
  USHORT temp_length1;
	
  object_type = TEXTBOX;
  Error = UIAddressToLookupTable(id,object_type,&temp);
  if (Error != TRUE) return Error;
  addr = (Textbox *)temp;
  addr->identification.ui_object_id = id;
  /* textbox 0 */
  addr->identification.ui_object_type = TEXTBOX;
  /* textbox 1 */
  addr->identification.table_related = 0xffff;
  /* textbox 2 */
  addr->bounds.xcoord = x;
  addr->bounds.ycoord = y;
  addr->bounds.width = w;
  addr->bounds.height = h;

  /* textbox 3 */
  buffer="";
  temp_length = strlen(buffer);
  temp_length1 = ((temp_length)/STEP_SIZE + 1) * STEP_SIZE;
  addr->textbox_string = (BYTE*)qmalloc(temp_length1*sizeof(BYTE));
  strcpy(addr->textbox_string,buffer);
  addr->textbox_current_num_chars = temp_length;

  /* textbox 4 */
  addr->textbox_style = TEXTBOX_STYLE_0;
  /* textbox 5 */
  addr->textbox_back_line = DOT_LINE;
  /* textbox 6 */
  addr->textbox_font_id = SMALL_FONT;
  /* textbox 7 */
  addr->textbox_font_color = COLOR_BLACK;
  /* textbox 8 */
  addr->textbox_background_color = COLOR_WHITE;
  /* textbox 9 */
  addr->textbox_max_chars = 256;
  /* textbox 10 */
  addr->textbox_left_char_pos = 0;
  /* TEXTBOX 11 */
  addr->textbox_right_char_pos = 0;
  StrTextboxAnalyze(addr);
  /* textbox 12 */
  addr->textbox_insert_pt_char_pos = 0;
  StrTextboxAnalyze(addr);
  StrTextboxCharPosToXY(addr,addr->textbox_insert_pt_char_pos,
			&(addr->textbox_insert_pt_x), &(addr->textbox_insert_pt_y));
	
  addr->textbox_insert_pt_movement = NO_MOVEMENT;
	
  /* textbox 13 */
  addr->textbox_highlight_start_char = 0;
  /* textbox 14 */
  addr->textbox_highlight_end_char = 0;
	
  addr->textbox_highlight_length = addr->textbox_highlight_end_char - addr->textbox_highlight_start_char;
  addr->textbox_repeat_count = 0;
	
  /* textbox 15 */
  addr->textbox_attr.textbox_drawn = FALSE;
  addr->textbox_attr.textbox_active = TRUE;
  addr->textbox_attr.textbox_enable = TRUE;
  addr->textbox_attr.textbox_dirty = FALSE;
  addr->textbox_attr.textbox_highlight = FALSE;
  addr->textbox_attr.textbox_insert_pt_visible = FALSE;
  addr->textbox_attr.textbox_visible = TRUE;
  return TRUE;
}



Err MakeButton(int id, int x, int y, int w, int h, char *title)
{
  Control* control;
  Err Error;

  //create new UI object
  Error = UIAddressToLookupTable(id,CONTROL,(void**)&control);
  if (Error != TRUE) return Error;

  control->control_template = (ControlTemplateButton*)qmalloc(sizeof(ControlTemplateButton));
  
  //let's set generic control parameters
  control->identification.ui_object_id = id;
  control->identification.ui_object_type = CONTROL;
  control->identification.table_related = 0xffff;
  control->bounds.xcoord = x;
  control->bounds.ycoord = y;
  control->bounds.width = w;
  control->bounds.height = h;
  control->control_style = BUTTON;
  control->control_subtype = BUTTON_STYLE_1;
  control->control_text = (BYTE*)qmalloc((strlen(title)+1)*sizeof(BYTE));
  strcpy(control->control_text,title);
  control->text_alignment = CENTRE_ALIGN;
  control->control_attr.control_enable = TRUE;
  control->control_attr.control_active = FALSE;
  control->control_attr.control_visible = TRUE;
  control->control_attr.control_drawn = FALSE;
  control->control_attr.control_save_behind = FALSE;
  control->control_attr.control_enter = FALSE;
  control->control_attr.control_enter1 = FALSE;
  control->control_attr.control_enter2 = FALSE;

  //set specific control params for button
  ((ControlTemplateButton*)(control->control_template))->button_radius = 2;
  ((ControlTemplateButton*)(control->control_template))->button_color_on = COLOR_BLACK;
  ((ControlTemplateButton*)(control->control_template))->button_color_off = COLOR_WHITE;
  ((ControlTemplateButton*)(control->control_template))->control_value = FALSE;

  return TRUE;
}

Err MakeButton0(int id, int x, int y, int w, int h, char *title, int reverse)
{
  Control* control;
  Err Error;

  //create new UI object
  Error = UIAddressToLookupTable(id,CONTROL,(void**)&control);
  if (Error != TRUE) return Error;

  control->control_template = (ControlTemplateButton*)qmalloc(sizeof(ControlTemplateButton));
  
  //let's set generic control parameters
  control->identification.ui_object_id = id;
  control->identification.ui_object_type = CONTROL;
  control->identification.table_related = 0xffff;
  control->bounds.xcoord = x;
  control->bounds.ycoord = y;
  control->bounds.width = w;
  control->bounds.height = h;
  control->control_style = BUTTON;
  control->control_subtype = BUTTON_STYLE_0;
  control->control_text = (BYTE*)qmalloc((strlen(title)+1)*sizeof(BYTE));
  strcpy(control->control_text,title);
  control->text_alignment = CENTRE_ALIGN;
  control->control_attr.control_enable = TRUE;
  control->control_attr.control_active = FALSE;
  control->control_attr.control_visible = TRUE;
  control->control_attr.control_drawn = FALSE;
  control->control_attr.control_save_behind = FALSE;
  control->control_attr.control_enter = FALSE;
  control->control_attr.control_enter1 = FALSE;
  control->control_attr.control_enter2 = FALSE;

  //set specific control params for button
  ((ControlTemplateButton*)(control->control_template))->button_radius = 2;
  ((ControlTemplateButton*)(control->control_template))->button_color_on = reverse?COLOR_WHITE:COLOR_BLACK;
  ((ControlTemplateButton*)(control->control_template))->button_color_off = reverse?COLOR_BLACK:COLOR_WHITE;
  ((ControlTemplateButton*)(control->control_template))->control_value = FALSE;

  return TRUE;
}


Err MakeList(int id, int x, int y, int w, int h, int align, int numitemsondisplay)
{
  void *temp;
  List *addr;
  Err Error;
  BYTE object_type;
	
  object_type = LIST;
  Error = UIAddressToLookupTable(id,object_type,&temp);
  if (Error != TRUE) return Error;
  addr = (List *)temp;
  addr->identification.ui_object_id = id;
  /* Field 0 */
  addr->identification.ui_object_type = LIST;
  /* Field 1 */
  addr->identification.table_related = 0xffff;
  /* Field 2 */
  addr->bounds.xcoord = x;
  addr->bounds.ycoord = y;
  addr->bounds.width = w;
  addr->bounds.height = h;

  /* Field 3 */
  addr->list_num_related_list = 0;

  /* Field 4 */
  addr->list_related_list_id = (ObjectID *)qmalloc(1);

  /* Field 5 */
  addr->list_total_num_items = 0;
	
  /* Field 6 */
  addr->list_num_items_on_display = numitemsondisplay;
	
  /* Field 7 */
  addr->list_top_item_num = 0;
	
  /* Field 8 */
  addr->list_text_alignment = align;
	
  /* Field 9 */
  addr->list_selected_item = 0;
	
  addr->list_highlighted_item = -1;
	
  /* Field 10 */
  addr->list_style = LIST_STYLE_3;
	
  /* Field 11 */
  addr->list_text_color = COLOR_BLACK;
	
  /* Field 12 */
  addr->list_bg_color = COLOR_WHITE;
	
  addr->list_arrow_up = FALSE;
  addr->list_arrow_down = FALSE;
	
  /* Field 13 */
  addr->list_items = NULL;
    
  /* Field 14 */
  addr->list_attr.list_enable = TRUE;
  addr->list_attr.list_visible = TRUE;
  addr->list_attr.list_active = TRUE;
  addr->list_attr.list_set_scroll = TRUE;
  addr->list_attr.list_synchronous = FALSE;
  /* Set up List variable */
  addr->list_text_font = SMALL_FONT;
  addr->list_item_height = 8+LIST_SEPARATOR*2;
  ListRecalculateMaxNumItemsDisplay(id);
	
  addr->list_attr.list_drawn = FALSE;
  addr->list_attr.list_enter1 = FALSE;
  addr->list_attr.list_enter2 = FALSE;
	
  //	ListConvertStyle(addr);
  return TRUE;
}

Err MakeString(int id, int x, int y, int w, int h, int align, char *title, int reverse)
{
  String *addr;
  Err Error;
  BYTE object_type;
	
  object_type = STRING;
  /*put the pointer to the DBID lookup table */
  Error = UIAddressToLookupTable(id,object_type,(void**)&addr); 
  if (Error != TRUE) return Error;
  /*check whether the resource file is opened */
  addr->identification.ui_object_id = id;
  /* get field 0 of resource file */
  addr->identification.ui_object_type = STRING;
  /* get field 1 of resource file */
  addr->identification.table_related = 0xffff;
  /* get field 2 from byte 0 for 2 bytes */
  addr->bounds.xcoord = x;
  addr->bounds.ycoord = y;
  addr->bounds.width = w;
  addr->bounds.height = h;
  /* get field 3 of resource file */
  addr->string_style = STRING_STYLE_0;
  /* get field 4 of resource file */
  addr->string_text = (BYTE*)qmalloc((strlen(title) + 1) * sizeof(BYTE));
  strcpy(addr->string_text, title);
  /* get field 5 of resource file */
  addr->string_color = reverse?COLOR_WHITE:COLOR_BLACK;
  /* get field 6 of resource file */
  addr->string_bg_color = reverse?COLOR_BLACK:COLOR_WHITE;
  /* get field 7 of resource file */
  addr->text_font = SMALL_FONT;
  /* get field 8 of resource file */
  addr->text_alignment = align;
  /* get field 9 from byte 0 for 2 bytes */
  addr->string_attr.string_visible = TRUE;
  addr->string_attr.string_drawn  = FALSE;
  return TRUE;
}

Err MakeBitmap(int id, int x, int y, int w, int h, void *bm1, int size, void *bm2)
{
  Bitmap *addr;
  Err Error;
  BYTE object_type;
	
  object_type = BITMAP;
  Error = UIAddressToLookupTable(id,object_type,(void**)&addr); 
  if (Error != TRUE) return Error;

  addr->identification.ui_object_id = id;
  /* get field 0 of resource file */
  addr->identification.ui_object_type = BITMAP;
  /* get field 1 of resource file */
  addr->identification.table_related = 0xffff;
  /* get field 2 from byte 0 for 2 bytes */
  addr->bounds.xcoord = x;
  addr->bounds.ycoord = y;
  addr->bounds.width = w;
  addr->bounds.height = h;
  /* get field34 of resource file */
  addr->bitmap_style = bm2?BITMAP_STYLE_1:BITMAP_STYLE_0;
  /* get field 4 of resource file */
  addr->bitmap_bitmap1.xcoord = x;
  addr->bitmap_bitmap1.ycoord = y;
  addr->bitmap_bitmap1.width = w;
  addr->bitmap_bitmap1.height = h;
  addr->bitmap_bitmap1.compressed = FALSE;
  addr->bitmap_bitmap1.quantisation = Q_FOUR_BIT;
  addr->bitmap_bitmap1.size = size;
  addr->bitmap_bitmap1.bitmap_data = qmalloc(size);
  memcpy(addr->bitmap_bitmap1.bitmap_data, bm1, size);
  if (bm2) {
    addr->bitmap_bitmap2.xcoord = x;
    addr->bitmap_bitmap2.ycoord = y;
    addr->bitmap_bitmap2.width = w;
    addr->bitmap_bitmap2.height = h;
    addr->bitmap_bitmap2.compressed = FALSE;
    addr->bitmap_bitmap2.quantisation = Q_FOUR_BIT;
    addr->bitmap_bitmap2.size = size;
    addr->bitmap_bitmap2.bitmap_data = qmalloc(size);
    memcpy(addr->bitmap_bitmap2.bitmap_data, bm2, size);
  }
  /* get field 6 from byte 0 for 2 bytes */
  addr->bitmap_attr.bitmap_enable = TRUE;
  addr->bitmap_attr.bitmap_active = TRUE;
  addr->bitmap_attr.bitmap_visible = TRUE;
  addr->bitmap_attr.bitmap_drawn = FALSE;
  addr->bitmap_attr.bitmap_enter = FALSE;
  return TRUE;
}

Err MakeMenu(int id)
{
  void *temp;
  Menu *addr;
  Err Error;
  BYTE object_type;
  
  object_type = MENU;
  Error = UIAddressToLookupTable(id, object_type, &temp);
  addr = (Menu *)temp;

  addr->identification.ui_object_id = id;
  /* Field 0 */
  addr->identification.ui_object_type = MENU;
  addr->identification.table_related = 0xFFFF;
  /* Field 1 */
  addr->bounds.xcoord = 0;
  addr->bounds.ycoord = 0;
  addr->bounds.width = 1;
  addr->bounds.height = 1;
  /* Field 2 */
  addr->menu_num_items = 0;
  /* Field 3 */
  addr->menu_selected_item = 0;
  addr->menu_highlighted_item = -1;
  /* Field 4 */
  addr->menu_items = NULL;
  /* Field 5 */
  addr->menu_attr.menu_visible = TRUE;
  addr->menu_attr.menu_drawn = FALSE;
  addr->save_behind.bitmap_data = NULL;
  return TRUE;
}


// Fix bitmaps
void DeMunge(char *ptr, int size)
{
  int i;
  char a,b,c,d;
  for (i=0; i<size; i+=4) {
    a=ptr[0]; b=ptr[1]; c=ptr[2]; d=ptr[3];
    ptr[0]=d; ptr[1]=c; ptr[2]=b; ptr[3]=a;
    ptr+=4;
  }
}
