#include <system.h>
#include <string.h>
#include <setjmp.h>
#include "glk.h"
#include "cheapglk.h"
#include "..\stdlib\fnt.h"
#include "makeres.h"
#include "screenmap.h"
#include "yesno.h"
#include "history.h"
#include "compass.h"
#include "getline.h"
#include "heliomain.h"

static int madegetline=0;

static char compass[] = {
  0x00, 0x0f, 0xff, 0x00, 0x00,  0, 0, 0,
  0x0f, 0xf0, 0xf0, 0xff, 0x00,  0, 0, 0,
  0x0f, 0x00, 0xf0, 0x0f, 0x00,  0, 0, 0,
  0xf0, 0x00, 0xf0, 0x00, 0xf0,  0, 0, 0,
  0xff, 0xff, 0xff, 0xff, 0xf0,  0, 0, 0,
  0xf0, 0x00, 0xf0, 0x00, 0xf0,  0, 0, 0,
  0x0f, 0x00, 0xf0, 0x0f, 0x00,  0, 0, 0,
  0x0f, 0xf0, 0xf0, 0xff, 0x00,  0, 0, 0,
  0x00, 0x0f, 0xff, 0x00, 0x00,  0, 0, 0 };

static char compassinv[] = {
  0x00, 0x0f, 0xff, 0x00, 0x00,  0, 0, 0,
  0x0f, 0xff, 0x0f, 0xff, 0x00,  0, 0, 0,
  0x0f, 0xff, 0x0f, 0xff, 0x00,  0, 0, 0,
  0xff, 0xff, 0x0f, 0xff, 0xf0,  0, 0, 0,
  0xf0, 0x00, 0x00, 0x00, 0xf0,  0, 0, 0,
  0xff, 0xff, 0x0f, 0xff, 0xf0,  0, 0, 0,
  0x0f, 0xff, 0x0f, 0xff, 0x00,  0, 0, 0,
  0x0f, 0xff, 0x0f, 0xff, 0x00,  0, 0, 0,
  0x00, 0x0f, 0xff, 0x00, 0x00,  0, 0, 0 };


char arrow[] = {
  0x00, 0x00, 0x00, 0x00, 0x00,  0, 0, 0,
  0x00, 0x00, 0x00, 0x00, 0x00,  0, 0, 0,
  0xff, 0xff, 0xff, 0xff, 0xf0,  0, 0, 0,
  0xff, 0xff, 0xff, 0xff, 0xf0,  0, 0, 0,
  0x0f, 0xff, 0xff, 0xff, 0x00,  0, 0, 0,
  0x00, 0xff, 0xff, 0xf0, 0x00,  0, 0, 0,
  0x00, 0x0f, 0xff, 0x00, 0x00,  0, 0, 0,
  0x00, 0x00, 0xf0, 0x00, 0x00,  0, 0, 0,
  0x00, 0x00, 0x00, 0x00, 0x00,  0, 0, 0 };

char arrowinv[] = {
  0x00, 0x00, 0x00, 0x00, 0x00,  0, 0, 0,
  0x00, 0x00, 0x00, 0x00, 0x00,  0, 0, 0,
  0xff, 0xff, 0xff, 0xff, 0xf0,  0, 0, 0,
  0xf0, 0x00, 0x00, 0x00, 0xf0,  0, 0, 0,
  0x0f, 0x00, 0x00, 0x0f, 0x00,  0, 0, 0,
  0x00, 0xf0, 0x00, 0xf0, 0x00,  0, 0, 0,
  0x00, 0x0f, 0x0f, 0x00, 0x00,  0, 0, 0,
  0x00, 0x00, 0xf0, 0x00, 0x00,  0, 0, 0,
  0x00, 0x00, 0x00, 0x00, 0x00,  0, 0, 0 };


typedef enum {FORM_GETLINE=3970, TEXTBOX_GETLINE, COMPASS_BITMAP, ARROW_BITMAP, MENU_GETLINE} MYGETLINEIDS;

BOOLEAN (*FormDispatchEvent)(EvtType *Event);
static BOOLEAN FormMainHandleEvent(EvtType* Event);


static int noclear;
static int hard_exit=0;
static char strsave[200];
static char *string;
static char *preload;
static int doneline=0;
static int timedout = 0;


static void MakeGetline()
{
  DeMunge(compass, sizeof(compass));
  DeMunge(compassinv, sizeof(compassinv));
  DeMunge(arrow, sizeof(arrow));
  DeMunge(arrowinv, sizeof(arrowinv));
  MakeForm(FORM_GETLINE, 0, 0, 160, 160, BACKGROUND, "GETLINE", NULL);
  MakeTextbox(TEXTBOX_GETLINE, 0, 149, 140, 11);
  MakeBitmap(COMPASS_BITMAP, 150, 150, 9, 9, compass, sizeof(compass), compassinv);
  MakeBitmap(ARROW_BITMAP, 140, 150, 10, 9, arrow, sizeof(arrow), arrowinv);
  MakeMenu(MENU_GETLINE);
  MenuInsertItem(MENU_GETLINE, 0, "Save.");
  MenuInsertItem(MENU_GETLINE, 1, "Restore.");
  MenuInsertItem(MENU_GETLINE, 2, "Look.");
  MenuInsertItem(MENU_GETLINE, 3, "Examine ");
  MenuInsertItem(MENU_GETLINE, 4, "Take All.");
  MenuInsertItem(MENU_GETLINE, 5, "Take ");
  MenuInsertItem(MENU_GETLINE, 6, "Inventory.");
  MenuInsertItem(MENU_GETLINE, 7, "Read ");
  MenuInsertItem(MENU_GETLINE, 8, "Open ");
  MenuInsertItem(MENU_GETLINE, 9, "Close ");
  MenuInsertItem(MENU_GETLINE, 10, "Drop ");
  MenuInsertItem(MENU_GETLINE, 11, "Quit.");
  FormAddOneObject(FORM_GETLINE, TEXTBOX_GETLINE, TEXTBOX);
  FormAddOneObject(FORM_GETLINE, COMPASS_BITMAP, BITMAP);
  FormAddOneObject(FORM_GETLINE, ARROW_BITMAP, BITMAP);
  FormAddOneObject(FORM_GETLINE, MENU_GETLINE, MENU);
  madegetline=1;
}




void PowerOff()
{
  hard_exit=1;
}

static int more_prompt=0;


#define EVT_TIMEOUT 0xdead

static void AddTimerEvent()
{
  EvtAppendEvt(EVT_TIMEOUT, 0, 0, 0, NULL);
}

static void TimerCallback()
{
  MsgAppendMsgInt(AddTimerEvent, 0, 0, 0, NULL);
}

static  BitmapTemplate slb;
static BOOLEAN GetlineApplicationHandleEvent(EvtType *event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(event->eventType)  {
  case EVT_FORM_LOAD:
    if((event->para1==1)||(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects(event->eventID);
    if(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)event->eventID) {
    case FORM_GETLINE: evtHandler = (void*)FormMainHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler(event->eventID, (void*)&FormDispatchEvent, evtHandler);
    FormSetActiveForm(event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

extern jmp_buf env;

int mygetline(char *str, char *pl, int timeout, int onechar)
{
  EvtType event;
  UWORD timer;
  extern void PowerOffSave();
 
  ResetLinePointer();
  if (!madegetline) MakeGetline();
  flush();
  more_prompt = onechar;
  string = str;
  preload = pl;
  if (hard_exit) longjmp(env, 1);
  //return FALSE;
  str[0]=0;

  noclear=0;
  doneline=0;
  FormPopupForm(FORM_GETLINE);	        //start main form
  timedout=timer=0;
  if (timeout)
    timer = TmrIntEnable(timeout*1000/10,TimerCallback);
  slb.xcoord = 0;
  slb.ycoord = 149-62;
  slb.width = 160;
  slb.height = 16;
  LcdGetBitmap(&slb);

  while (!doneline) {
    if (hard_exit) break;;
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(GetlineApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP || hard_exit) break;
  }
  if (timeout)
    TmrIntDisable(timer);

  qfree(slb.bitmap_data);

  if (event.eventType==EVT_APP_STOP || hard_exit) {
    PowerOff();
    PowerOffSave();
    longjmp(env, 1);
  }
  return timedout;
}
static int noturnon=0;
static void OK()
{
  BYTE *text_ptr;
  TextboxSetInsertPointOff(TEXTBOX_GETLINE);
  TextboxGetTextPointer(TEXTBOX_GETLINE, &text_ptr);
  strcpy(string, text_ptr);
  UpdateHistory(string);
  strcat(string, "\n");
  TextboxSetText(TEXTBOX_GETLINE, "");
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_GETLINE, 0, 0, NULL);
  doneline=1;
  if (KeyboardCheckKeyboardStatus()) {
    EvtType tmp;

    KeyboardRestoreBitBehind();
    KeyboardRemoveKeyboard();
    tmp.eventType=EVT_KEYBOARD_STATUS;
    tmp.para1=KEYBOARD_OFF;
    noturnon=1;
    FormMainHandleEvent(&tmp);
    noturnon=0;
  }
}



static BOOLEAN FormMainHandleEvent(EvtType* Event)
{
  ObjectBounds bnds;
  BYTE *str, *text_ptr;
  int i;
  static int lastx, lasty;
  static int pen_ok;

  switch(Event->eventType) {
  case EVT_TIMEOUT:
    timedout=1;
    OK();
    string[strlen(string)-1]=0;
    break;


  case PEN_EVENT:
    switch (Event->eventID) {
    case PEN_DOWN:
      lastx = Event->para1;
      lasty = Event->para2;
      if (lasty<150) pen_ok=1;
      else pen_ok=0;
      break;
    case PEN_UP:
      if (!pen_ok) break;
      if (more_prompt) {
	FntBeep();
	OK(); 
	break;
      }
      i=(Event->para1 - lastx)*(Event->para1 - lastx) + (Event->para2 - lasty)*(Event->para2 - lasty);
      if (i<10) {
	char buff[200];
	buff[0]=0;
	os_find_click(Event->para1, Event->para2, buff);
	if (buff[0]){
	  TextboxGetTextPointer(TEXTBOX_GETLINE, &text_ptr) ;
	  if (strlen(text_ptr)>0)
	    if (text_ptr[strlen(text_ptr)-1]!=' ') TextboxAddKeyInChar(TEXTBOX_GETLINE, (BYTE)' ');
	  for (i=0; i<strlen(buff); i++) TextboxAddKeyInChar(TEXTBOX_GETLINE, (BYTE)buff[i]);
	  FntBeep();
	}
      }
      break;
    }
    break;

  case EVT_BITMAP_SELECT:
    FormSetFormActiveObject(FORM_GETLINE, TEXTBOX_GETLINE);
    FormObjectSetFocus(TEXTBOX_GETLINE);
    noclear=1;
    TextboxGetTextPointer(TEXTBOX_GETLINE, &text_ptr) ;
    strcpy(strsave, text_ptr );
    if (Event->eventID==COMPASS_BITMAP) {
      if (DoCompass(strsave)==EVT_APP_STOP)
	return TRUE;
    } else if (Event->eventID==ARROW_BITMAP) {
      if (DoHistory(strsave)==EVT_APP_STOP)
	return TRUE;
    }
    break;

  case EVT_MENU_SELECT_ITEM:
    MenuGetMenuItem(MENU_GETLINE, Event->para1, &str);
    TextboxGetTextPointer(TEXTBOX_GETLINE, &text_ptr) ;
    if (text_ptr[strlen(text_ptr)-1]!=' ' && strlen(text_ptr)>0) TextboxAddKeyInChar(TEXTBOX_GETLINE, (BYTE)' ');
    for (i=0; i<strlen(str); i++) {
      if (str[i]!='.') 
	TextboxAddKeyInChar(TEXTBOX_GETLINE, (BYTE)str[i]);
      else
    	OK();
    }
    break;

  case EVT_KEY:
    FormObjectSetFocus(TEXTBOX_GETLINE);
    if (Event->eventID == SOFT_KEY) {		
      if (more_prompt) {
	FntBeep();
	OK();
	string[0] = Event->para1;
	string[1] = 0;
      }
      if ((BYTE)(Event->para1) == 13) OK();
      else TextboxAddKeyInChar(TEXTBOX_GETLINE, (BYTE)(Event->para1));
      return TRUE;
    }
    break;

  case EVT_IO_KEY_CTRL:
    if (Event->eventID == EVT_IO_KEY_PRESS && Event->para2 == IO_DOWN_ARROW)
      OK();
    return FALSE;
      
  case EVT_KEYBOARD_STATUS:
    if (!noturnon) TextboxSetInsertPointOff(TEXTBOX_GETLINE);
    TextboxGetTextboxBounds(TEXTBOX_GETLINE, &bnds);
    if (Event->para1==KEYBOARD_ON) {
      bnds.ycoord = 149-61;
    } else if (Event->para1==KEYBOARD_OFF) {
      bnds.ycoord = 149;
      LcdDrawBitmap(&slb, FALSE);
    }
    TextboxSetBounds(TEXTBOX_GETLINE, bnds);
    TextboxGetTextPointer(TEXTBOX_GETLINE, &text_ptr) ;
    TextboxSetInsertPointPositionByCharPos(TEXTBOX_GETLINE, strlen(text_ptr));
    TextboxDrawTextbox(TEXTBOX_GETLINE);
    if (!noturnon) TextboxSetInsertPointOn(TEXTBOX_GETLINE);
    FormObjectSetFocus(TEXTBOX_GETLINE);
    break;


  case EVT_FORM_OPEN:
    if (hard_exit) return TRUE;
    pen_ok = 0;
    FormObjectSetFocus(TEXTBOX_GETLINE);
    FormSetFormActiveObject(FORM_GETLINE, TEXTBOX_GETLINE);
    FormObjectSetFocus(TEXTBOX_GETLINE);
    if (noclear) {
      noclear=0;
      if (strsave[strlen(strsave)-1]=='|') {
	strsave[strlen(strsave)-1]=0;
	EvtAppendEvt(EVT_KEY,SOFT_KEY,13,0,NULL);
      }
      TextboxSetText(TEXTBOX_GETLINE, strsave);
      TextboxSetInsertPointPositionByCharPos(TEXTBOX_GETLINE, strlen(strsave)); }
    else {
      TextboxSetText(TEXTBOX_GETLINE, "");
      TextboxSetInsertPointPositionByCharPos(TEXTBOX_GETLINE, 0);
    }
    if (preload) {
      TextboxSetText(TEXTBOX_GETLINE, preload);
      TextboxSetInsertPointPositionByCharPos(TEXTBOX_GETLINE, strlen(preload));
      preload = NULL;
    }
    TextboxSetLeftCharPos(TEXTBOX_GETLINE, 0);
    TextboxSetRightCharPos(TEXTBOX_GETLINE, 0);
    TextboxDrawTextbox(TEXTBOX_GETLINE);
    TextboxSetInsertPointOn(TEXTBOX_GETLINE);
    BitmapDrawBitmap(COMPASS_BITMAP);
    BitmapDrawBitmap(ARROW_BITMAP);
    break;
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      OK();
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      noclear=1;
      TextboxGetTextPointer(TEXTBOX_GETLINE, &text_ptr) ;
      strcpy(strsave, text_ptr );
      if(DoYesNo("Really Exit?", FORM_GETLINE)) {
	PowerOff();
	OK();
      }
      break;
    default:
      return FALSE;
    }
    break;

  default:
    return FALSE;
  }
  return FALSE;
}
