#include <system.h>
#include "../stdlib/fnt.h"
#include "makeres.h"
#include "yesno.h"

static int yesno;
static char *yesnoPrompt;
static int doneyesno=0;
static int madeyesno=0;

typedef enum {FORM_YESNO=3980, STRING_YESNO, BUTTON_YESNOOK, BUTTON_YESNOCANCEL, YESNO_CANCEL} YESNOIDS;

static void MakeYesNo()
{
  MakeForm(FORM_YESNO, 5, 40, 150, 60, NON_BITMAP_DIALOG, "Warning!", NULL);
  MakeString(STRING_YESNO, 10, 60, 140, 15, CENTRE_ALIGN, "x", FALSE);
  MakeButton(BUTTON_YESNOOK, 30, 80, 40, 15, "OK");
  MakeButton(BUTTON_YESNOCANCEL, 90, 80, 40, 15, "Cancel");
  MakeButton0(YESNO_CANCEL, 140, 41, 11, 11, "X", TRUE);
  FormAddOneObject(FORM_YESNO, STRING_YESNO, STRING);
  FormAddOneObject(FORM_YESNO, BUTTON_YESNOOK, CONTROL);
  FormAddOneObject(FORM_YESNO, BUTTON_YESNOCANCEL, CONTROL);
  FormAddOneObject(FORM_YESNO, YESNO_CANCEL, CONTROL);
  madeyesno = 1;
}
static BOOLEAN FormYesNoHandleEvent(EvtType* event);

static BOOLEAN YesNoApplicationHandleEvent(EvtType *event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(event->eventType)  {
  case EVT_FORM_LOAD:
    if((event->para1==1)||(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects(event->eventID);
    if(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)event->eventID) {
    case FORM_YESNO: evtHandler = (void*)FormYesNoHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler(event->eventID, (void*)&FormDispatchEvent, evtHandler);
    FormSetActiveForm(event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

int DoYesNo(char *prompt, int form)
{
  EvtType event;
  void *back;
  int oldform;
  ObjectID oldFormID;

  oldform = FormGetActiveFormID(&oldFormID);
  if (!madeyesno) MakeYesNo();
  back = SaveBackground();
  doneyesno = 0;
  yesno = 0;
  yesnoPrompt = prompt;
  FormPopupForm(FORM_YESNO);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(YesNoApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
  } while (!doneyesno);
  RestoreBackground(back);

  if (form>=0) FormPopupForm(form);
  return yesno;
}


static void YesNoOK(int OK)
{
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_YESNO, 0, 0, NULL);
  yesno = OK;
  doneyesno = 1;
}


static BOOLEAN FormYesNoHandleEvent(EvtType* event)
{
  switch(event->eventType) {
    case EVT_FORM_OPEN:
      StippleBackground();
      StringSetText(STRING_YESNO, yesnoPrompt);
      FormDrawForm(FORM_YESNO);
      ControlDrawControl(YESNO_CANCEL);
      break;

    case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_OK:
      YesNoOK(1);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      YesNoOK(0);
      break;
    default:
      return FALSE;
    }
  case EVT_CONTROL_SELECT:
    switch (event->eventID) {
    case BUTTON_YESNOOK:
      YesNoOK(1);
      break;
    case YESNO_CANCEL:
    case BUTTON_YESNOCANCEL:
      YesNoOK(0);
      break;
    }

    default:
      return FALSE;
    }
  return FALSE;
}
