/*
	HESET.C

	contains:
		RunSet
		SetCompound

	for the Hugo Engine

	Copyright (c) 1995-2001 by Kent Tessman
*/


#include "heheader.h"

/* Function prototypes: */
int SetCompound(int t);

#define MAX_GAME_TITLE 64
char game_title[MAX_GAME_TITLE] = "";

char arrexpr = 0;                       /* true when assigning array       */
char multiprop = 0;                     /* true in multiple prop. assign.  */

static int set_value = 0;


/* RUNSET

	If gotvalue is passed as -1, then no value has already been
	as the (potential) object, etc. comprising the first part of the
	object.property, for example, to be set.
*/

void RunSet(int gotvalue)
{
	char inc = 0;                   /* increment/decrement */
	char temparrexpr, propval = 0;
	char outofrange = 0;
	int a = 0, t = 0, obj = 0;
	int newl = 0;                   /* new length */
	int newp = 0;			/* new property val */
	unsigned int element = 0;		/* of an array */

	unsigned short n, m, v;		/* must be 16 bits */

	inobj = 0;

	if (gotvalue!=-1)
	{
		obj = gotvalue;
		t = SetCompound(t);
		goto StoreVal;
	}

	t = mem[codeptr];

	switch (t)
	{
		case OBJECTNUM_T:
		{
			codeptr++;
			obj = PeekWord(codeptr);
			codeptr += 2;
			t = SetCompound(t);
			break;
		}

		case VAR_T:
		{
			a = mem[codeptr + 1];

			/* Check for ++, --, +=, etc. */
			inc = IsIncrement(codeptr+2);

			if (mem[codeptr + 2]==EQUALS_T or inc)
			{
				if (a < MAXGLOBALS) SaveUndo(VAR_T, a, var[a], 0, 0);

				if (inc)
				{
					var[a] = (Increment(var[a], inc)) + incdec;

					/* backward-compatibility tweak */
					if ((game_version<23) and mem[codeptr]!=CLOSE_BRACE_T) codeptr--;

					codeptr++;      /* eol */
				}
				else
				{
					codeptr += 3;
					inexpr = 1;
					SetupExpr();
					inexpr = 0;
					v = EvalExpr(0);
					var[a] = v;
				}

				/* If a global variable */
				if (a < MAXGLOBALS)
				{
/*
					if (varset) PrintSetting(VAR_T, a, var[a], 0, 0);
*/
					if (a==wordcount) words = var[wordcount];
				}

				return;
			}

			obj = var[a];
			codeptr += 2;
			t = SetCompound(t);

			break;
		}

		case WORD_T:			/* "word" */
		{
			codeptr += 2;           /* skip "[" */
			n = GetValue();
#if defined (DEBUGGER)
			if ((debug_eval) and debug_eval_error)
				return;
#endif
			codeptr += 2;           /* skip "] =" */
			inexpr = 1;
			SetupExpr();
			inexpr = 0;

GetNextWord:
			if (n >= MAXWORDS) n = MAXWORDS-1;
			SaveUndo(WORD_T, n, wd[n], 0, 0);
			wd[n] = EvalExpr(0);

/*
			if (arrset) PrintSetting(WORD_T, n, 0, 0, 0);
*/

			if (mem[codeptr]==COMMA_T)
			{
				codeptr++;
				n++;
				goto GetNextWord;
			}

			/* Have to (rather unfortunately) rebuild the entire
			   input buffer and word array here
			*/
			strcpy(buffer, "");
			t = 0;
			for (a=1; a<=(int)MAXWORDS; a++)
			{
				if ((unsigned short)wd[a]!=UNKNOWN_WORD)
					strcpy(buffer+t, GetWord(wd[a]));
				else
					itoa(parsed_number, buffer+t, 10);
			        word[a] = buffer + t;
				t+=strlen(word[a])+1;
			}

			if (n>(unsigned)var[wordcount])
				var[wordcount] = n;
/* Must be up to the program to reset the words global
			words = var[wordcount];
*/
			return;
		}

		case ARRAYDATA_T:
		case ARRAY_T:
		{
			/* array[n]... */
			if (t==ARRAYDATA_T)
			{
				m = PeekWord(codeptr + 1);
				codeptr += 4;   /* "[" */
				n = GetValue();
#if defined (DEBUGGER)
				if ((debug_eval) and debug_eval_error)
					return;
#endif
				codeptr++;      /* "]" */
			}

			/* ...or array val[n] */
			else
			{
				codeptr++;
				m = GetValue();
#if defined (DEBUGGER)
				if ((debug_eval) and debug_eval_error)
					return;
#endif
				codeptr++;      /* "[" */
				n = GetValue();
#if defined (DEBUGGER)
				if ((debug_eval) and debug_eval_error)
					return;
#endif
				codeptr++;      /* "]" */
			}

			if (game_version>=22)
			{
				/* Convert to word value */
				m*=2;

				if (game_version>=23)
					/* Space for array length */
					a = 2;
			}

#if defined (DEBUGGER)
			CheckinRange(m+a+n*2, debug_workspace, "array data");
#endif
			/* Check for ++, --, +=, etc. */
			inc = IsIncrement(codeptr);
			if (inc)
			{
				defseg = arraytable;
				v = PeekWord(m+n+a*2);
				defseg = gameseg;
				v = (Increment(v, inc)) + incdec;

				codeptr++;      /* eol */

				goto WriteArrayValue;
			}

			if (mem[codeptr]==EQUALS_T)
			{
				codeptr++;
				while (mem[codeptr] != EOL_T)
				{
					element = m+a+n*2;

					temparrexpr = arrexpr;
					arrexpr = true;
					v = GetValue();
#if defined (DEBUGGER)
					if ((debug_eval) and debug_eval_error)
						return;
#endif
					if (arrexpr==false and mem[codeptr-1]==76)
						codeptr--;
					arrexpr = temparrexpr;

					if (mem[codeptr]==COMMA_T or mem[codeptr]==CLOSE_BRACKET_T)
						codeptr++;
WriteArrayValue:
					defseg = arraytable;

					/* Make sure the value to be written is within range */
					if ((element>0) and (element < (unsigned)(dicttable-arraytable)*16))
					{
						SaveUndo(ARRAYDATA_T, m+a, n, PeekWord(element), 0);

						PokeWord(element, (unsigned int)v);
/*
						if (arrset) PrintSetting(ARRAYDATA_T, m, n, v, 0);
*/
					}

					defseg = gameseg;

					if (inc) return;

					n++;
				}
				codeptr++;
				return;
			}

			defseg = arraytable;
			obj = PeekWord((unsigned int)(m+a + n*2));
			defseg = gameseg;
			t = SetCompound(t);

			break;
		}
	}


StoreVal:

	/* Now store the evaluated expression in the appropriate place... */

	/*
		t = 1:  property
		t = 2:  attribute
		t = 3:  not attribute
		t = 4:  property reference
	*/

	n = 1;

	if (t==4)
	{
		inobj = true;
		n = GetValue();

#if defined (DEBUGGER)
		if ((debug_eval) and debug_eval_error)
			return;
#endif
		inobj = false;

LoopBack:
		if (mem[codeptr]==IS_T or mem[codeptr]==DECIMAL_T)
		{
			obj = GetProp(obj, set_value, n, 0);
			t = SetCompound(t);
			goto LoopBack;
		}
		// Don't set t = 1 if it changed above before going back
		// to LoopBack:
		else if (t==4)
			t = 1;          /* Just a property */
	}
	else if (t==1)
	{
		while (mem[codeptr]==IS_T or mem[codeptr]==DECIMAL_T)
		{
			obj = GetProp(obj, set_value, n, 0);
			t = SetCompound(t);
		}
	}

	switch (t)
	{
		case 1:
		{
			outofrange = 0;

			incdec = 0;

			if (mem[codeptr] != EQUALS_T)
			{
				/* Check for ++, --, +=, etc. */
				if (!(inc = IsIncrement(codeptr)))
				{
#if defined (DEBUGGER)
					if (debug_eval)
					{
						debug_eval_error = true;
						return;
					}
#endif
					FatalError(ILLEGAL_OP_E);
				}
				else if (mem[codeptr]==EOL_T)
				{
					goto GetNextPropVal;
				}
			}
			else
				codeptr++;

			/* Property routine... */
			if (mem[codeptr]==EOL_T)
			{
				/* m = skipptr to the end of the property
				   routine block (i.e., the next statement
				   following it)
				*/
				m = PeekWord(codeptr + 1);

				newl = PROP_ROUTINE;
				newp =(unsigned int)(((codeptr + 4)+(codeptr + 4)%address_scale)/address_scale);
				codeptr = (long)m*address_scale;
				m = PropAddr(obj, set_value, 0);
			}

			/* ...or not */
			else
			{
GetNextPropVal:
				inexpr = false;
				temparrexpr = multiprop;
				multiprop = true;
				propval = true;
				if (!inc) newp = GetValue();
#if defined (DEBUGGER)
				if ((debug_eval) and debug_eval_error)
					return;
#endif

				if (!multiprop)
					codeptr--;
				multiprop = temparrexpr;

				m = PropAddr(obj, set_value, 0);
				if (m)
				{
					defseg = proptable;
					newl = Peek((unsigned int)m + 1);
					if (newl==PROP_ROUTINE) newl = 1;
				}

				/* Deal with setting built-in display object
				   properties
				*/
				else if ((obj==display_object) and n==1)
				{
					if (set_value==title_caption)
					{
						strncpy(game_title, GetWord(newp), MAX_GAME_TITLE);
						hugo_setgametitle(game_title);
					}
				}
			}

			/* Write property obj.z = newl words of newp */

			if (m and (int)n <= 0)
			{
#if defined (DEBUGGER)
				RuntimeWarning("Property element <= 0");
#endif
				if (inc) codeptr++;
			}
			else if (m and (int)n <= newl)
			{
				defseg = proptable;

#if defined (DEBUGGER)
				CheckinRange((unsigned)n, (unsigned)Peek(m+1), "property element");
#endif
				/* Check to make sure this property value is within range */
				if ((unsigned)(m+2+(n-1)*2)<(unsigned)(eventtable-proptable)*16)
				{
					SaveUndo(PROP_T, obj, (unsigned int)set_value, Peek((unsigned int)m+1), PeekWord((unsigned int)(m+2+(n-1)*2)));

					/* Save the (possibly changed) length) */
					Poke((unsigned int)m + 1, (unsigned char)newl);

					/* An assignment such as obj.prop++ or
					   obj.prop += ...
					*/
					if (inc)
					{
						PokeWord((unsigned int)(m+2+(n-1)*2), Increment(PeekWord((unsigned int)(m+2+(n-1)*2)), inc) + incdec);
						codeptr++;      /* eol */
					}

					/* A regular obj.prop = ... assignment */
					else
						PokeWord((unsigned int)(m+2+(n-1)*2), newp);
				}
			}
			else if (inc) codeptr++;	/* eol */
/*
			if (propset)
			{
				if (newl and (int)n < newl) outofrange = 2;
				if (!m) notfound = 1;
				PrintSetting(outofrange+notfound, obj, (int)set_value, n, newp);
			}
*/

			defseg = gameseg;

			if (inc) return;

			if (propval and mem[codeptr]==COMMA_T)
				{n++;
				codeptr++;
				goto GetNextPropVal;}

			if (propval) codeptr++;
			if (mem[codeptr]==EOL_T) codeptr++;
			return;
		}

		case 2:
		case 3:
		{
ModifyAttribute:

#if defined (DEBUGGER)
			CheckinRange((unsigned int)set_value, (unsigned)attributes, "attribute");
#endif
			SaveUndo(ATTR_T, obj, (unsigned int)set_value, TestAttribute(obj, (unsigned int)set_value, 0), 0);

			SetAttribute(obj, set_value, (t==2));

			if (mem[codeptr++]==EOL_T) return;

			/* Allow multiple attributes, comma-separated */
			if (mem[codeptr]==COMMA_T)
				codeptr++;

			if (mem[codeptr]==NOT_T)
			{
				t = 3;
				codeptr++;
			}

			set_value = GetValue();
			goto ModifyAttribute;
		}

		default:
		{
#if defined (DEBUGGER)
			if (debug_eval)
			{
				debug_eval_error = true;
				return;
			}
#endif
			/* Not any sort of variable data type */
			FatalError(ILLEGAL_OP_E);
		}
	}
}


/* SETCOMPOUND */

int SetCompound(int t)
{
/*
	if (Peek(codeptr)==CLOSE_BRACKET_T) codeptr++;
*/

	if (Peek(codeptr)==DECIMAL_T)		/* obj.property */
	{
		codeptr++;
		inobj = 1;
		set_value = GetValue();		/* the prop. # */
		inobj = 0;

		if (Peek(codeptr)==POUND_T)	/* if obj.prop #... */
		{
			codeptr++;
			return 4;
		}
		return 1;
	}

	if (Peek(codeptr)==IS_T)		/* obj is ... */
	{
		inobj = 1;
		if (Peek(codeptr+1)==NOT_T)
		{
			codeptr += 2;
                        set_value = GetValue();	/* the attr. # */
			inobj = 0;
			return 3;
		}

		codeptr++;
		set_value = GetValue();		/* the attr. # */
		inobj = 0;
		return 2;
	}

#if defined (DEBUGGER)
	if (debug_eval)
		debug_eval_error = true;
	else
#endif

	FatalError(ILLEGAL_OP_E);

	return 0;
}
