/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   dev_pwr.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Header file for power Management Device Driver
Revision    :   1.1
Note        :   None
===========================================================================
*/


#include "platform.h"

#ifdef PR31700
#ifndef __PWR_DEVICE_DRIVER__
#define __PWR_DEVICE_DRIVER__

#include    "include\DataType.h"

#define BATTERY_LOW_WARNING_PERIOD     (1*60000)     /* 1 minute */

/*    ADC_VALUE = 137 * Voltage -9     */

//#define BAT_LEVEL_MAX           370 /* Threshold for battery low (3.0V) */
//#define BAT_LEVEL_LOW           262 /* Threshold for battery low (2.2V) */
//#define BAT_LEVEL_EMPTY         236 /* Threshold for battery empty (2.0V)*/

#define BAT_LEVEL_MAX           402 /* Threshold for battery low (3.0V) */
#define BAT_LEVEL_LOW_P           301 /* Threshold for battery low (2.3V) */
#define BAT_LEVEL_LOW           287 /* Threshold for battery low (2.2V) */
#define BAT_LEVEL_EMPTY         259 /* Threshold for battery empty (2.0V)*/

#define BATTERY_WAIT_SOME_TIME 1000 /* 1 sec */

#define BAT_NORMAL              0xAA
#define BAT_LOW                 0x55

#define CPU_IDLE_SPEED_MASK (3 <<10)

#define CPU_CLK_75M        (0<<10)
#define CPU_CLK_37M        (1<<10)
#define CPU_CLK_18M        (2<<10)
#define CPU_CLK_9M         (3<<10)

#define CP0_IDLE_MASK       0x1


void CpuDoze();
WORD CheckBatteryLow(); //Henry



#define UART_TX_ENABLE  (1<<10)
#define UART_RX_DISABLE (1<<16)
#define AUDIO_DISABLE   (1<<6)


                           /* Storage for saving reg. when Power Off */
extern WORD SaveIoRegLoc[];/* This locations should be permanetly */
                           /* allocated in a protected region  */

extern volatile WORD NormalOperation    ;    /* check by Interrupt handler   */
extern volatile WORD WakeCpuUp          ;    /* condition to power-up system */
extern volatile WORD ChkBatTmrHandle    ;
extern volatile WORD PwrTmrHandle       ;
extern volatile WORD ChkBatState        ;
extern volatile WORD BatCheckLevel      ;
extern volatile WORD BatLowHandlerState ;
extern volatile WORD BatChkMainLevelReq ;
extern volatile WORD BatteryLevelStatus ;



typedef struct
    {
        WORD PwrOn         : 1 ;
        WORD KeyRec        : 1 ;
        WORD KeyPlay       : 1 ;
        WORD KeyStop       : 1 ;
        WORD KeyPhoneBook  : 1 ;
        WORD KeyToDoList   : 1 ;
        WORD KeyScheduler  : 1 ;

        WORD SioDevDect    : 1 ;
        WORD SioDataRdy    : 1 ;

        WORD HotSync       : 1 ;

        WORD RtcInt        : 1 ;
        WORD AlarmInt      : 1 ;

        WORD Rsrv1         : 1 ;
        WORD Rsrv2         : 1 ;
        WORD Rsrv3         : 1 ;
        WORD Rsrv4         : 1 ;
        WORD Rsrv5         : 1 ;
        WORD Rsrv6         : 1 ;
        WORD Rsrv7         : 1 ;

        WORD Reserved      : 11;

    } PwrType;

extern PwrType PowerOnStatus;




/* interrupt enable definition for power up */



#define KEY_INT_POWER_ON    (1<<23)     /* IE 5 */

#define KEY_INT_SCHEDULE    (1<<9)      /* IE 5 */
#define KEY_INT_TO_DO       (1<<8)      /* IE 5 */
#define KEY_INT_PHONEBOOK   (1<<7)      /* IE 5 */
#define KEY_INT_PLAY        (1<<12)     /* IE 5 */
#define KEY_INT_STOP        (1<<13)     /* IE 5 */

#define KEY_INT_RECORD      (1<<0)      /* IE 3 */

#define KEY_HOT_SYNC        (1<<25)     /* IE 4 */

#define WAKE_INT_ENABLE_1   0
#define WAKE_INT_ENABLE_2   0
#define WAKE_INT_ENABLE_3   KEY_INT_RECORD

#define WAKE_INT_ENABLE_4   KEY_HOT_SYNC        //HotSync


#define WAKE_INT_ENABLE_5   (  RTCINT  | ALARMINT | PERINT \
                             | KEY_INT_SCHEDULE  | KEY_INT_TO_DO \
                             | KEY_INT_PHONEBOOK | KEY_INT_PLAY \
                             | KEY_INT_STOP      | KEY_INT_POWER_ON )



#define SIO_WAKE_INT_MASK  ((1<<30)|(1<<28))  /* IE 4*/






/*
 * Status register of CP0
 */
#define SR_CUMASK       0xf0000000      /* coproc usable bits */
#define SR_CU3          0x80000000      /* Coprocessor 3 usable */
#define SR_CU2          0x40000000      /* Coprocessor 2 usable */
#define SR_CU1          0x20000000      /* Coprocessor 1 usable */
#define SR_CU0          0x10000000      /* Coprocessor 0 usable */

/* Diagnostic status bits */
#define SR_PE           0x00100000      /* cache parity error */
#define SR_CM           0x00080000      /* cache miss */
#define SR_PZ           0x00040000      /* cache parity zero */
#define SR_SWC          0x00020000      /* swap cache */
#define SR_ISC          0x00010000      /* Isolate data cache */

#define SR_TS           0x00200000      /* TLB shutdown */
#define SR_BEV          0x00400000      /* use boot exception vectors */

#define SR_IBIT8        0x00008000      /* bit level 8 */
#define SR_IBIT7        0x00004000      /* bit level 7 */
#define SR_IBIT6        0x00002000      /* bit level 6 */
#define SR_IBIT5        0x00001000      /* bit level 5 */
#define SR_IBIT4        0x00000800      /* bit level 4 */
#define SR_IBIT3        0x00000400      /* bit level 3 */
#define SR_IBIT2        0x00000200      /* bit level 2 */
#define SR_IBIT1        0x00000100      /* bit level 1 */

/*  define MEMORY_MAP_POSEIDON for power.*/
#define HIGH_PRIORITY_INTERRUPT_MASK    SR_IBIT7
#define LOW_PRIORITY_INTERRUPT_MASK     SR_IBIT5

#define RUNTIME_INTERRUPT_MASK (  HIGH_PRIORITY_INTERRUPT_MASK | \
                                  LOW_PRIORITY_INTERRUPT_MASK )

#define SR_KUO          0x00000020      /* old kernel/user, 0=>k, 1=>u */
#define SR_IEO          0x00000010      /* old interrupt enable, 1=>enable */
#define SR_KUP          0x00000008      /* prev kernel/user, 0=>k, 1=>u */
#define SR_IEP          0x00000004      /* prev interrupt enable, 1=>enable */
#define SR_KUC          0x00000002      /* cur kernel/user, 0=>k, 1=>u */
#define SR_IEC          0x00000001      /* cur interrupt enable, 1=>enable */
#define SR_PREVMODE     SR_KUP          /* previous kernel/user mode */


void ChkBatterySM() ;
void PowerInit();
void PowerMgrInit();
int BatMapLifeTime( int v );




#define POWER_EVENT             133     /* Power Management Event Type */

#define BAT_MAIN_LEVEL          1       /* battery level */

#define BAT_DOOR_OPEN           5       /* power event emergency shut down */

#define BAT_MAIN_LOW            11      /* power event emergency shut down */
#define BAT_MAIN_EMPTY          12      /* power event emergency shut down */


#define BAT_DOOR_INT        (1<<8)

#define IntDisableBatLowInt()   (CPU->REG_INT_ENABLE_5 &= ~NEGPWRINT)
#define IntDisableBatEmptyInt() (CPU->REG_INT_ENABLE_5 &= ~NEGPWROKINT)
#define IntDisableBatDoorInt()  (CPU->REG_INT_ENABLE_3 &= ~BAT_DOOR_INT)

#define IntEnableBatLowInt()    (CPU->REG_INT_ENABLE_5 |= NEGPWRINT)
#define IntEnableBatEmptyInt()  (CPU->REG_INT_ENABLE_5 |= NEGPWROKINT)
#define IntEnableBatDoorInt()   (CPU->REG_INT_ENABLE_3 |= BAT_DOOR_INT)

#define IntClearBatLowInt()    (CPU->REG_INT_STATUS_5 = NEGPWRINT)
#define IntClearBatEmptyInt()  (CPU->REG_INT_STATUS_5 = NEGPWROKINT)
#define IntClearBatDoorInt()   (CPU->REG_INT_STATUS_3 = BAT_DOOR_INT)



extern WORD ChkBatTmrHandle;
extern WORD PwrTmrHandle;
extern WORD ChkBatState;
extern WORD BatCheckLevel;
extern WORD BatADCValue;
extern WORD BatADCCount;
extern WORD SemiPowerOff;


#endif __PWR_DEVICE_DRIVER__

#endif

