/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   kernel.h
Author(s)   :   Kenny Ng, Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for Kernel operating system
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                
#ifndef _KERNEL_
#define _KERNEL_


#define APP_MAX		60
#define TOTAL_PRE_INSTALL_APP 12

#include "include\datatype.h"
#include "include\mmu.h"
#include "include\dm_os.h"

#ifdef PR31700
#include "include\pr31700s.h"
#include "include\pr31700c.h"
#include "include\intc.h"
#endif

#define SetAttribute(attribute, bit) \
                        (attribute |= bit)
#define ClrAttribute(attribute, bit) \
                        (attribute &=  ~bit)
#define ChkAttribute(attribute, bit) \
                        (attribute & bit)

#define HOOKABLE_ADDR   255  /* int addr: 0x3 00  -  0x3 ff */

#define APP_RUN_75M     0
#define APP_RUN_37M     1
#define APP_RUN_18M     2
#define APP_RUN_9M      3
#define APP_RUN_DEFAULT APP_RUN_37M

#define AppRunSpeed(reg)        ((reg.run_spec & (UBYTE)0x03) << 10)

#define BOOT_WARM_PATT    0x55555555
#define BOOT_COLD_PATT	  0xAAAAAAAA

#define BOOT_INFO_ADDRESS   (int*)0x80000020  /* to 0x80000023 */

typedef struct
{
	BYTE app_name[20];
	USHORT app_id;
	UWORD *res_addr;
        UBYTE attribute;
        UBYTE run_spec;
	UWORD *page_table;
        UWORD page_need;
        UWORD start_block;
/* data + bss size, if size < 2 block, no need to allocate when prog start */
/* if size >= 2 block, the first 2 block is pre-allocated in the top of avaliable ram
   when app install */
	UWORD data_size;
} REGISTRY;


typedef struct
{
	UBYTE reg_entry_index;
	UBYTE icon_index;
} InstallAppInf;

typedef struct _PROG_ATTRI
{
	unsigned int alaram:1;
	unsigned int type:2;
} ProgAttribute;


/*attribute

   bit 7 6 5 4 3 2 1 0
       x x x x x A T R

   R:   Running
		0 -> Not running
		1 -> Running
   T:	Application type
		0 -> Noraml application
		1 -> Device driver
   A:   Alarm feature
		0 -> No alarm function
		1 -> Has alarm
*/

#define BIT_RUN    (UBYTE)1        /* 0 -> not running, 1 -> active app */
#define BIT_TYPE   (UBYTE)2        /* 0 -> normal, 1 -> drv */
#define BIT_ALARM (UBYTE)4        /* 0 -> no, 1 -> Yes */
#define BIT_FIND  (UBYTE) 8        /* 0 -> no find, 1 -> has global find */
#define BIT_RAM_PRG (UBYTE)16     /* 0 -> no resource addin, 1 -> has */
#define BIT_FLASH_PRG (UBYTE)32     /* 0 -> not flash/sys prg, 1 -> Yes */
#define BIT_ATTR_6    (UBYTE)64     /* reserved */
#define BIT_ALL_APP   (UBYTE)128

#define ERR_SYS_APP_EXIST	520
#define ERR_SYS_REG_FULL	521

#define RUN_MODE_NORMAL	1
#define RUN_MODE_MODE1	2

#define APP_ICON_WIDTH	48
#define APP_ICON_HEIGHT 34
#define APP_ICON_BIT_PER_PIXEL	2


typedef struct INT_LOOKUP_TBL
{
        UBYTE appid;
        UWORD *page_table;
} int_lookup_tbl;


void SysInit();
BOOLEAN SysLoadAppPageTable(AppID app_id);
BOOLEAN SysLoadInterruptPageTable(AppID app_id);
Err SysNewApp(BYTE app_name[20], UBYTE attr, UWORD prg_addr, UBYTE run_spec, UWORD *res_addr, UWORD data_size, UWORD *page_table, AppID *app);
BOOLEAN SysRemoveApp(AppID app_id);
BOOLEAN SysRunApp(USHORT app_id, UWORD cmd, UWORD *cmd_ptr);
void SysSwitchUser();
void SysCall(UWORD code);
void SysCreateProcess(UWORD prog_id);
void SysJumpToAddr(UWORD addr);
void SysIncPC();
UWORD SysCallGetCode();
BOOLEAN SysGetAppAttribute(AppID app_id, UBYTE query_bit, UWORD *res_addr);
void SysRunHookedIntHandler(USHORT int_no);
USHORT SysHookIntHandler(USHORT int_no, UWORD *start_addr);
void SysUnhookIntHandler(USHORT hook_no);
UWORD SysSearchFreeASID();
USHORT SysSearchLastHookCell(USHORT int_no);
USHORT SysSearchFreeHookCell(USHORT int_no);
USHORT SysSearchNextPtr(USHORT hook_no);
BOOLEAN SysGetAppEntryIndex(UWORD app_id, USHORT *index);
BOOLEAN SysGetPageTable(UWORD app, UWORD **page_table);
UWORD SysSetPageTable(UWORD app, UWORD *page_table);
AppID SysNextAppID();
BOOLEAN SysClearAppData(AppID app);
BOOLEAN SysClearInterruptData(AppID app);
BOOLEAN SysGetAppStatus(UWORD app_id, UWORD *res_addr);
AppID SysGetActiveAppID();
AppID SysGetRealActiveAppID();
USHORT SysTotalInstalledApp(UBYTE type);
BOOLEAN SysGetAppID(BYTE *app_name, AppID *app_id);
BOOLEAN SysGetAppName(AppID app, BYTE *app_name);
AppID SysGetAppIDFromIndex(USHORT index, UBYTE type);
BOOLEAN SysLoadAppMode1PageTable(AppID app_id);
BOOLEAN SysClearSysData();
void SysClearAppMode1PageTable(AppID app);
BOOLEAN SysClearMode1AppData(AppID app);
BOOLEAN SysBuildPageTable(USHORT index);
BOOLEAN SysRunMode1App(AppID app_id, WORD cmd, void *cmd_ptr);
BOOLEAN SysCheckModemExist();
AppID SysGetIndexAppID(USHORT index);
void SysHookSyscall(AppID app, UWORD sc_no, UWORD *address);
void SysUnHookSyscallByAppID(AppID appid);
BOOLEAN SysCheckModemExist();
void SysBuildAllIntPageTable();
#endif _SYSTEM_
