/* Program File	: lcd_func.c
 * Company		: VTech Info-Tech Ltd.
 * Project		: PDA
 * Programmer	: Thomas Cheng
 * Date			: June 29, 1998
 * Revision		: 1.0
 * Comment		: LCD function calls, which functions aim to support UI,
 *				  mainly include LCD drawing functions and LCD display-text
 *				  functions
 */

#ifndef _LCD_FUNC_
#define _LCD_FUNC_

#include "include\dm_os.h"
#include "include\lcd_drv.h"

/* LCD Drawing Functions */
void LcdGetPixel(USHORT xcoord1, USHORT ycoord1, BYTE *color);
void LcdSetPixel(USHORT xcoord1, USHORT ycoord1, BYTE color);
void LcdDrawLine(USHORT xcoord1, USHORT ycoord1, USHORT xcoord2, USHORT ycoord2,
	BYTE line_thick, BYTE line_style, BYTE color);
void LcdDrawBox(ObjectBounds *bounds, BYTE color, BYTE fill);
void LcdInvertBox(ObjectBounds *bounds);
void LcdDrawEllipse(USHORT xcoord1, USHORT ycoord1, USHORT major_radius,
	USHORT minor_radius, BYTE color, BYTE fill);
void LcdDrawArc(USHORT xcoord1, USHORT ycoord1, USHORT radius, BYTE style,
	BYTE color, BYTE fill, BYTE arc_location);
void LcdEraseRegion(ObjectBounds *bounds);
void LcdGetBitmap(BitmapTemplate *save_behind);
void LcdDrawBitmap(BitmapTemplate *bitmap_struct, BOOLEAN invert);
/* LCD Drawing Functions */

/* LCD Display-Text Functions */
void LcdEnableInsertPt(USHORT xcoord1, USHORT ycoord1, BOOLEAN enable);
void LcdDrawCharacter(USHORT xcoord1, USHORT ycoord1, BYTE character,
	BYTE color, BYTE font);
void LcdDrawFixedString(ObjectBounds *bounds, BYTE *string,	BYTE color,
	BYTE font, BOOLEAN dotdot);
void LcdDrawVariableString(ObjectBounds *bounds, BYTE *string,
	BYTE color, BYTE font, USHORT offset, USHORT length, LineInfo *line_info);
/* LCD Display-Text Functions */

void LcdGetInsertPtPos(ObjectBounds *bounds, BYTE *string, LineInfo *line_info,
	USHORT xcoord1, USHORT ycoord1, USHORT *xcoord2, USHORT *ycoord2,
	USHORT *xcoord3, USHORT *ycoord3);
USHORT LcdGetCharOffset(ObjectBounds *bounds, BYTE *string, LineInfo *line_info,
	USHORT xcoord, USHORT ycoord);
BYTE *StrExtract(BYTE *, WORD start, WORD length);
#endif _LCD_FUNC_