/* 	File		: lcd_drv.h
 *	Company		: VTech Info-Tech Ltd.
 *	Project		: PDA
 *	Programmer	: Thomas Cheng
 *	Date		: June 29, 1998
 *	Revision	: 1.0
 *	Comment		: LCD driver, which functions are hardware dependent,
 *				  mainly include four drivers, which are word (32-bit)
 *				  processing drivers, string analyzing drivers, LCD drawing
 *				  drivers, LCD interface drivers.
 */

#ifndef _LCD_DRV_
#define _LCD_DRV_

#include "include\ui.h"
#include "include\font.h"

//#define DOUBLE_SIZE
//#define GREY_DISPLAY

/* LCD Drawing and Interface Definition */
/* LCD_WIDTH should be the multiples of WORD_SIZE, ie. 32 */
#define LCD_WIDTH	160
#define LCD_HEIGHT	160
/* LCD Drawing and Interface Definition */

/* Word Processing Definition */
/* Don't change it normally */
#define BYTE_SIZE	8
#define BYTE_MASK	0xFF
#define WORD_SIZE	32
#define WORD_MASK	0xFFFFFFFF
/* Word Processing Definition */

/* LCD Drawing Definition */
/* These definitions are arbitrary */
//#define COLOR_BLACK		1
//#define COLOR_WHITE		0
#define COLOR_NIL		-1
#define FILL_SOLID		1
#define FILL_EMPTY		0
/* LCD Drawing Definition */

/* String Analyzing Definition */
/* These definitions can be changed according to your needs */
#define SPACE_CHAR		1
#define SPACE_LINE		1
#define STRING_MAX		1000
#define LINE_MAX		1000
#define HEIGHT_MAX		160
#define DOTDOT			1
#define NO_DOTDOT		0
#define DOT_LINE		0
#define NON_DOT_LINE	1
#define DOT_LINE_MASK	0xAAAAAAAA
/* String Analyzing Definition */

/* LCD Drawing Definition */
/* Invert color */
#ifdef GREY_DISPLAY
#else
#define ColorInvert(color)	(color == COLOR_BLACK ? COLOR_WHITE : COLOR_BLACK)
#endif GREY_DISPLAY
/* Return true if specified point locate within display; otherwise, false */
#define CheckWithinScreen(xcoord1, ycoord1)	if(xcoord1>=0 && ycoord1>=0 &&\
	xcoord1<LCD_WIDTH && ycoord1<LCD_HEIGHT)
/* LCD Drawing Definition */

/* LCD Interface Definition */
#ifdef DOUBLE_SIZE
#define MapLin(xcoord1, ycoord1) (xcoord1+(UWORD)ycoord1*LCD_WIDTH*2)/WORD_SIZE+1
#define MapLinear(xcoord1, ycoord1)	((xcoord1+(UWORD)ycoord1*LCD_WIDTH*2)/(WORD_SIZE*2))*2+1
#define MapPosition(xcoord1)	(WORD_SIZE-1-xcoord1%WORD_SIZE)
#else
#define MapLinear(xcoord1, ycoord1)	(xcoord1+ycoord1*LCD_WIDTH)/WORD_SIZE+1
#define MapPosition(xcoord1)	(WORD_SIZE-1-xcoord1%WORD_SIZE)
#endif DOUBLE_SIZE
/* LCD Interface Definition */

/* Word Processing Drivers*/
UWORD WordPack(UWORD word1, UBYTE word1_shift, UWORD word2, UBYTE word2_shift,
	UBYTE merge_pt);
UWORD WordHead1Pack(UWORD word1, UWORD word2, UBYTE merge_pt);
UWORD WordHead2Pack(UWORD word1, UWORD word2, UBYTE merge_pt1, UBYTE merge_pt2);
UWORD WordBodyPack(UWORD word1, UWORD word2, UBYTE merge_pt);
UWORD WordTail1Pack(UWORD word1, UBYTE word1_shift, UWORD word2, UBYTE merge_pt);
UWORD WordTail2Pack(UWORD word1, UWORD word2, UWORD word3, UBYTE merge_pt1,
	UBYTE merge_pt2);
UWORD WordSwap(UWORD word1);
void WordDouble(UWORD word1, UWORD *word2, UWORD *word3);
/* Word Processing Drivers */

/* String Analyzing Drivers */
void StringAnalyzeWord(BYTE *string, UWORD *char_num, USHORT *char_width);
void StringAnalyzeLine(BYTE *string, USHORT line_width, USHORT line_height,
	LineInfo *line_info);
void StringExtract(BYTE *string, UWORD char_start, UWORD char_end, BYTE *char_string);
USHORT StringFindWidth(BYTE *string);
/* String Analyzing Drivers */

/* LCD Drawing Drivers */
BYTE PixelRead(USHORT xcoord1, USHORT ycoord1);
void PixelWrite(USHORT xcoord1, USHORT ycoord1, BYTE color);
UWORD WordRead(USHORT xcoord1, USHORT ycoord1);
void WordWrite(USHORT xcoord1, USHORT ycoord1, UWORD word1);
/* LCD Drawing Drivers */

/* LCD Interface Drivers */
void LcdDrawInsertPt(USHORT xcoord1, USHORT ycoord1, BYTE color);
void LcdDrawHoriLine(USHORT xcoord1, USHORT xcoord2, USHORT ycoord1, BYTE line_style, BYTE color);
void LcdDrawVertLine(USHORT xcoord1, USHORT ycoord1, USHORT ycoord2, BYTE line_style, BYTE color);
void LcdInvertLine(USHORT xcoord1, USHORT xcoord2, USHORT ycoord1);
void LcdInit(void);
void LcdRefresh(void);
/* LCD Interface Drivers */

#endif _LCD_DRV_