#include "include\datatype.h"

#ifndef __SIB_DD_FUNCTION__
#define __SIB_DD_FUNCTION__

#define IntChkSib()      ((CPU->REG_INT_STATUS_1 >>5) & 3)
#define IntClearSib()    CPU->REG_INT_STATUS_1 |= SIBIRQPOSINT
#define IntEnableSib()   CPU->REG_INT_ENABLE_1 |= SIBIRQPOSINT


#define BtyEnableRisInt()  CPU->REG_SIB_SF0_CTRL = BETTY_RIS_INT_ENABLE |BTY_TSPX_RIS_INT |BTY_ADC_RIS_INT |BTY_WRT
#define BtyEnableFalInt()  CPU->REG_SIB_SF0_CTRL = BETTY_FAL_INT_ENABLE |BTY_TSPX_FAL_INT |BTY_ADC_FAL_INT |BTY_WRT


//#define BtyEnableRisInt()  CPU->REG_SIB_SF0_CTRL = BETTY_RIS_INT_ENABLE |BTY_TSMX_RIS_INT |BTY_TSPX_RIS_INT |BTY_WRT
//#define BtyEnableFalInt()  CPU->REG_SIB_SF0_CTRL = BETTY_FAL_INT_ENABLE |BTY_TSMX_FAL_INT |BTY_TSPX_FAL_INT |BTY_WRT
//#define BtyClearInt()      CPU->REG_SIB_SF0_CTRL = BETTY_INT_STATUS |BTY_TSMX_INT_STAT |BTY_TSPX_INT_STAT |BTY_WRT

//#define BtyEnableFalInt()  CPU->REG_SIB_SF0_CTRL = BETTY_FAL_INT_ENABLE |BTY_TSPX_FAL_INT |BTY_WRT



#define IntEnableSF0()     CPU->REG_INT_ENABLE_1 |= SIBSF0INT
#define IntDisableSF0()    CPU->REG_INT_ENABLE_1 &= ~SIBSF0INT
#define IntClearSF0()      CPU->REG_INT_STATUS_1 |= SIBSF0INT



/* Betty Register Access */

#define BtyReadReg(input)    CPU->REG_SIB_SF0_CTRL = input
#define BtyWriteReg(input)   CPU->REG_SIB_SF0_CTRL = input |BTY_WRT
#define BtyReadADCValue()    (CPU->REG_SIB_SF0_STATUS)
#define BtyRegData()    (CPU->REG_SIB_SF0_STATUS & 0xffff)

#define SibEnable()  CPU->REG_SIB_CTRL |= ENSIB       /* Enable  SIB   */

/* Request for SIB service  ALL should init to zero */

/* state variable of sib routine */
extern WORD SibIntState;      /* SIB write state should init to zero */
extern WORD SibRdState;       /* SIB read  state should init to zero */
extern WORD SibWrtState;      /* SIB write state should init to zero */

/* Sib access variable*/
extern WORD SibDataInBuf;
extern WORD SibReg;             /* set by read or write caller routine */
/* mirror of betty register */
extern WORD BtyRegIoPortData ;      /* reg  0 */
extern WORD BtyRegIoPortDirectn ;   /* reg  1 */

extern WORD BtyRegRisIntEnable ;    /* reg  2 */
extern WORD BtyRegFalIntEnable ;    /* reg  3 */
extern WORD BtyRegIntStatus ;       /* reg  4 */

extern WORD BtyRegTelCtrlA ;        /* reg  5 */
extern WORD BtyRegTelCtrlB ;        /* reg  6 */
extern WORD BtyRegAudCtrlA ;        /* reg  7 */
extern WORD BtyRegAudCtrlB ;        /* reg  8 */

extern WORD BtyRegTsCtrl ;          /* reg  9 */

extern WORD BtyRegAdcCtrl ;         /* reg 10 */
extern WORD BtyRegAdcData ;         /* reg 11 */

extern WORD BtyRegId ;              /* reg 12 */
extern WORD BtyRegMode ;            /* reg 13 */


/* call back the caller routine */
extern void (*SibAccessReqAck)();  /* SIB access grant acknowledge; init to zero*/
extern void (*SibReadReqAck)();    /* Return from SibRead : Internal use only */
extern void (*SibWriteReqAck)();   /* Return from SibWrite: Internal use only */

extern void (*BtyAdcRdyReqAck)();  /* ADC ready acknowledge */
extern void (*BtyPenDownAck)();    /* Pen Down acknowledge  */



/* Must be declared as global variable  */

void InterruptInit();
void SibRead ();
void SibWrite ();
void SibIntHandler();
void SF0Isr();
void BtyAdcIsr();


#define BTY_ADC_INT     BTY_ADC_INT_STAT
#define BTY_TTP_INT     BTY_TSPX_INT_STAT
#define BTY_IO_INT      BTY_IO_INT_STAT

#endif __SIB_DD_FUNCTION__

