/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   ttp.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for TTP
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "include\datatype.h"
#ifndef         __PEN_DRIVER__
#define         __PEN_DRIVER__



/* used by TTPGetx() and  TtpGety()  */
#define TtpSetModePenUp()   CPU->REG_SIB_SF0_CTRL = BETTY_TS_CTRL |BTY_TSMX_POW |BTY_TSPX_POW |BTY_TSMY_GND |BTY_TSPY_GND |BTY_TSC_MODE(0) |BTY_WRT
#define TtpSetModeX_POS()   CPU->REG_SIB_SF0_CTRL = BETTY_TS_CTRL |BTY_TSMY_POW |BTY_TSPY_GND |BTY_TSC_MODE(2) |BTY_TSC_BIAS_ENA |BTY_WRT
#define TtpSetModeY_POS()   CPU->REG_SIB_SF0_CTRL = BETTY_TS_CTRL |BTY_TSMX_GND |BTY_TSPX_POW |BTY_TSC_MODE(2) |BTY_TSC_BIAS_ENA |BTY_WRT


#define TtpPenUp()          ((CPU->REG_SIB_SF0_STATUS)>>12) & 0x1


#define TTP_ADC_PX          0x0
#define TTP_ADC_MX          0x4
#define TTP_ADC_PY          0x8
#define TTP_ADC_MY          0xC
#define TTP_ADC_AD0         0x10
#define TTP_ADC_AD1         0x14
#define TTP_ADC_AD2         0x18
#define TTP_ADC_AD3         0x1C

#define TTP_SW_TIME         0x80
#define TTP_WAIT_STABLE     0x20
#define PENUP               0
#define PENDOWN             1

void    SIBInit();
WORD     TtpGetx();
WORD     TtpGety();
WORD     TtpGetxy(WORD *cor_x, WORD *cor_y);
void    TtpSetPenChkMode();
WORD     TtpInit();


#endif          __PEN_DRIVER__

