/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   dev_sib.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for CPU H/W SIB low level access
Revision    :   1.1
Note        :   23/09/98   Prepared by Andrew Hui (AH)         
                23/09/98   V1.0 release (AH)                   
                09/12/98   V1.1 release (AH)                   
                10/12/98   V1.2 release (AH)                   
                15/12/98   V1.3 release (AH) (Optimize to O3)  
                05/01/99   V1.4 release (AH) (Optimize to O3)  
                08/09/99   V2.0 SibCapture and SibRelease added
===========================================================================
*/              
                
                
#include "platform.h"
#ifdef PR31700


#include "include\datatype.h"

#ifndef __SIB_DEVICE_DRIVER__
#define __SIB_DEVICE_DRIVER__

#define IntChkSib()      ((CPU->REG_INT_STATUS_1 >>5) & 3)
#define IntClearSib()    CPU->REG_INT_STATUS_1 = SIBIRQPOSINT
#define IntEnableSib()   CPU->REG_INT_ENABLE_1 |= SIBIRQPOSINT


#define BtyEnableRisInt()  CPU->REG_SIB_SF0_CTRL = BETTY_RIS_INT_ENABLE |BTY_TSPX_RIS_INT |BTY_ADC_RIS_INT |BTY_WRT
#define BtyEnableFalInt()  CPU->REG_SIB_SF0_CTRL = BETTY_FAL_INT_ENABLE |BTY_TSPX_FAL_INT |BTY_ADC_FAL_INT |BTY_WRT


        //#define BtyEnableRisInt()  CPU->REG_SIB_SF0_CTRL = BETTY_RIS_INT_ENABLE |BTY_TSMX_RIS_INT |BTY_TSPX_RIS_INT |BTY_WRT
        //#define BtyEnableFalInt()  CPU->REG_SIB_SF0_CTRL = BETTY_FAL_INT_ENABLE |BTY_TSMX_FAL_INT |BTY_TSPX_FAL_INT |BTY_WRT
        //#define BtyClearInt()      CPU->REG_SIB_SF0_CTRL = BETTY_INT_STATUS |BTY_TSMX_INT_STAT |BTY_TSPX_INT_STAT |BTY_WRT

        //#define BtyEnableFalInt()  CPU->REG_SIB_SF0_CTRL = BETTY_FAL_INT_ENABLE |BTY_TSPX_FAL_INT |BTY_WRT



#define IntEnableSF0()     CPU->REG_INT_ENABLE_1 |= SIBSF0INT
#define IntDisableSF0()    CPU->REG_INT_ENABLE_1 &= ~SIBSF0INT
#define IntClearSF0()      CPU->REG_INT_STATUS_1 = SIBSF0INT

#define IntEnableSF1()     CPU->REG_INT_ENABLE_1 |= SIBSF1INT
#define IntDisableSF1()    CPU->REG_INT_ENABLE_1 &= ~SIBSF1INT
#define IntClearSF1()      CPU->REG_INT_STATUS_1 = SIBSF1INT



/* Betty Register Access */

#define BtyReadReg(input)    CPU->REG_SIB_SF0_CTRL = input
#define BtyWriteReg(input)   CPU->REG_SIB_SF0_CTRL = input |BTY_WRT
#define BtyReadADCValue()    (CPU->REG_SIB_SF0_STATUS)
#define BtyRegData()    (CPU->REG_SIB_SF0_STATUS & 0xffff)

#define SibEnable()  CPU->REG_SIB_CTRL |= ENSIB       /* Enable  SIB   */

extern volatile int SibReadDataComplete;
extern volatile int SibWriteDataComplete;

int SibReadData( int BtyReg );
void SibWriteData(int register, int cmd);
void SibReadDataHandle(void);     /* called by SibAccess in interrupt */
void SibWriteDataHandle(void);    /* called by SibAccess in interrupt */
/* Request for SIB service  ALL should init to zero */

extern volatile WORD SibEngaged   ;


/* state variable of sib routine */
extern volatile WORD SibIntState;      /* SIB write state should init to zero */
extern volatile WORD SibRdState;       /* SIB read  state should init to zero */
extern volatile WORD SibWrtState;      /* SIB write state should init to zero */

/* Sib access variable*/
extern volatile WORD SibDataInBuf;
extern volatile WORD SibReg;             /* set by read or write caller routine */


/* call back the caller routine */
extern void (*SibAccessReqAck)();  /* SIB access grant acknowledge; init to zero*/
extern void (*SibReadReqAck)();    /* Return from SibRead : Internal use only */
extern void (*SibWriteReqAck)();   /* Return from SibWrite: Internal use only */

extern void (*BtyAdcRdyReqAck)();  /* ADC ready acknowledge */
extern void (*BtyPenDownAck)();    /* Pen Down acknowledge  */



/* Must be declared as global variable  */

void SibRead ();
void SibWrite ();
void SibIntHandler();
void SF0Isr();
void SF1Isr();
void BtyAdcIsr();
void DummySibAccess();        /* this routine is dummy */

/*---------------------------------------------*/

/* Sib setting */
#define SIB_CLK_RATE            9216000           /* SIB Clock Rate */


void SibCapture();
void SibRelease();

/*---------------------------------------------*/


/*  SibQueueItem.status */
#define SIB_Q_WAITING       0   /* set when queue in */
#define SIB_Q_PROCESSING    1   /* set in SIBSF0INT  */
#define SIB_Q_PROCESSED     2   /* set in SIBSF1INT and it is a Rd command */
#define SIB_Q_COMPLETE      3   /* set in SIBSF1INT, clear in Rd()/Wr()    */

#define ADC_Q_WAITING       0   /* set when queue in */
#define ADC_Q_PROCESSING    1   /* set in SIBSF0INT  */
#define ADC_Q_PROCESSED     2   /* set in SIBSF1INT and it is a Rd command */
#define ADC_Q_COMPLETE      3   /* set in SIBSF1INT, clear in Rd()/Wr()    */

#define SIB_Q_SIZE         40   /* minimum 20 */
#define ADC_Q_SIZE         20   /* minimum 15 */

#define SIB_Q_FULL         -1
#define SIB_Q_OK            1

#define ADC_Q_FULL         -1
#define ADC_Q_OK            1

typedef struct
{
    void (*caller) ();
    WORD cmd;
    WORD status;
} SibQueueItem;

typedef struct
{
    WORD    front    ;   /* serving */
    WORD    rear     ;
}SibQueuePointer;


extern SibQueuePointer     SibQPtr;            /* point to the front & rear of Sib Q */
extern SibQueueItem        SibQueue[SIB_Q_SIZE];


typedef struct
{
    void (*calling) ();
    WORD status;
} AdcQueueItem;

typedef struct
{
    WORD    front    ;   /* serving */
    WORD    rear     ;
}AdcQueuePointer;


extern AdcQueuePointer     AdcQPtr;            /* point to the front & rear of Sib Q */
extern AdcQueueItem        AdcQueue[ADC_Q_SIZE];




#define SIB_CB_ST  0
#define SIB_CB_WR  1
#define SIB_CB_RD  2

void dSibWriteData( void (*caller)());




/*---------------------------------------------*/

#define BTY_ADC_INT     BTY_ADC_INT_STAT
#define BTY_TTP_INT     BTY_TSPX_INT_STAT
#define BTY_IO_INT      BTY_IO_INT_STAT

#endif  __SIB_DEVICE_DRIVER__
#endif

