/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   intc.h
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for interrupt module
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                
#ifndef _INTC_
#define _INTC_

#include "include\datatype.h"
#include "include\mmu.h"
#include "include\pr31700s.h"
#include "include\pr31700c.h"

typedef struct
{
	USHORT ISRID;
 	UWORD offset;
 	UBYTE active;
 	UBYTE priority;
 	USHORT next_ptr;
        UWORD *page_table;
} HOOKTABLE;

/* IRQ */
#define CHK_IRQHIGH(a)	(a & STATUS_IP4)
#define CHK_IRQLOW(a)	(a & STATUS_IP2)

/* Priority */
#define ENA_PRI_PWROKINT		(CPU->REG_INT_ENABLE_6 |= PRI_PWROKINT)
#define ENA_PRI_ALARMINT		(CPU->REG_INT_ENABLE_6 |= PRI_ALARMINT)
#define ENA_PRI_PERINT			(CPU->REG_INT_ENABLE_6 |= PRI_PERINT)
#define ENA_PRI_UARTARXINT		(CPU->REG_INT_ENABLE_6 |= PRI_UARTARXINT)
#define ENA_PRI_UARTBRXINT		(CPU->REG_INT_ENABLE_6 |= PRI_UARTBRXINT)
#define ENA_PRI_IOPOSINT_56		(CPU->REG_INT_ENABLE_6 |= PRI_IOPOSINT_56)
#define ENA_PRI_IONEGINT_56		(CPU->REG_INT_ENABLE_6 |= PRI_IONEGINT_56)
#define ENA_PRI_SNDDMACNTINT	(CPU->REG_INT_ENABLE_6 |= PRI_SNDDMACNTINT)
#define ENA_PRI_TELDMACNTINT	(CPU->REG_INT_ENABLE_6 |= PRI_TELDMACNTINT)
#define ENA_PRI_CHIDMACNTINT	(CPU->REG_INT_ENABLE_6 |= PRI_CHIDMACNTINT)
#define ENA_PRI_IOINT_0			(CPU->REG_INT_ENABLE_6 |= PRI_IOINT_0)
#define ENA_PRI_STDINT			(CPU->REG_INT_ENABLE_6 |= PRI_STDINT)

#define DIS_PRI_PWROKINT		(CPU->REG_INT_ENABLE_6 &= ~PRI_PWROKINT)
#define DIS_PRI_ALARMINT		(CPU->REG_INT_ENABLE_6 &= ~PRI_ALARMINT)
#define DIS_PRI_PERINT			(CPU->REG_INT_ENABLE_6 &= ~PRI_PERINT)
#define DIS_PRI_UARTARXINT		(CPU->REG_INT_ENABLE_6 &= ~PRI_UARTARXINT)
#define DIS_PRI_UARTBRXINT		(CPU->REG_INT_ENABLE_6 &= ~PRI_UARTBRXINT)
#define DIS_PRI_IOPOSINT_56		(CPU->REG_INT_ENABLE_6 &= ~PRI_IOPOSINT_56)
#define DIS_PRI_IONEGINT_56		(CPU->REG_INT_ENABLE_6 &= ~PRI_IONEGINT_56)
#define DIS_PRI_SNDDMACNTINT	(CPU->REG_INT_ENABLE_6 &= ~SNDDMACNTINT)
#define DIS_PRI_TELDMACNTINT	(CPU->REG_INT_ENABLE_6 &= ~TELDMACNTINT)
#define DIS_PRI_CHIDMACNTINT	(CPU->REG_INT_ENABLE_6 &= ~CHIDMACNTINT)
#define DIS_PRI_IOINT_0			(CPU->REG_INT_ENABLE_6 &= ~IOINT_0)
#define DIS_PRI_STDINT			(CPU->REG_INT_ENABLE_6 &= ~STDINT)

/* Enable and disable global interrupt */
#define ENA_GBL_INT	(CPU->REG_INT_ENABLE_6 |= GLOBALEN);
#define DIS_GBL_INT	(CPU->REG_INT_ENABLE_6 &= ~GLOBALEN);
/*
#define DIS_GBL_INT __asm("nop");\
					__asm("subu $sp, 10*4");\
					__asm("sw	$2, 5*4($sp)");\
					__asm("sw	$4, 4*4($sp)");\
//					__asm("addu	$4, $sp, 0");\
//					__asm("jal	ChkPt");\
//					__asm("nop");\
					__asm("lui	$2, 0xb0c0");\
					__asm("sw	$0, 0x12c($2)");\
					__asm("lw	$2, 5*4($sp)");\
					__asm("lw	$4, 4*4($sp)");\
					__asm("addu $sp, 10*4")
#define ENA_GBL_INT __asm("nop");\
					__asm("subu $sp, 10*4");\
					__asm("sw	$2, 5*4($sp)");\
					__asm("sw	$3, 4*4($sp)");\
					__asm("lui	$2, 0xb0c0");\
					__asm("lui	$3, 0x0004");\
					__asm("sw	$3, 0x12c($2)");\
					__asm("lw	$2, 5*4($sp)");\
					__asm("lw	$3, 4*4($sp)");\
					__asm("addu $sp, 10*4")

#define DIS_GBL_INT __asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("nop");\
					__asm("subu $sp, 10*4");\
					__asm("sw	$2, 5*4($sp)");\
					__asm("lui	$2, 0xb0c0");\
					__asm("sw	$0, 0x12c($2)");\
					__asm("lw	$2, 5*4($sp)");\
					__asm("addu $sp, 10*4")
#define ENA_GBL_INT __asm("nop");\
					__asm("subu $sp, 10*4");\
					__asm("sw	$2, 5*4($sp)");\
					__asm("sw	$3, 4*4($sp)");\
					__asm("lui	$2, 0xb0c0");\
					__asm("lui	$3, 0x0004");\
					__asm("sw	$3, 0x12c($2)");\
					__asm("lw	$2, 5*4($sp)");\
					__asm("lw	$3, 4*4($sp)");\
					__asm("addu $sp, 10*4")
*/
/* Disable interrupt */
#define DIS_INT_1	(CPU->REG_INT_ENABLE_1 = 0)
#define DIS_INT_2	(CPU->REG_INT_ENABLE_2 = 0)
#define DIS_INT_3	(CPU->REG_INT_ENABLE_3 = 0)
#define DIS_INT_4	(CPU->REG_INT_ENABLE_4 = 0)
#define DIS_INT_5	(CPU->REG_INT_ENABLE_5 = 0)
#define DIS_INT_6	(CPU->REG_INT_ENABLE_6 = 0)
#define DIS_INT_ALL	DIS_INT_1; DIS_INT_2; DIS_INT_3; DIS_INT_4; DIS_INT_5; DIS_INT_6

/* Clear Interrrupt */
#define CLR_INT_1	(CPU->REG_INT_STATUS_1 = WORD_MASK)
#define CLR_INT_2	(CPU->REG_INT_STATUS_2 = WORD_MASK)
#define CLR_INT_3	(CPU->REG_INT_STATUS_3 = WORD_MASK)
#define CLR_INT_4	(CPU->REG_INT_STATUS_4 = WORD_MASK)
#define CLR_INT_5	(CPU->REG_INT_STATUS_5 = WORD_MASK)
#define CLR_INT_ALL	CLR_INT_1; CLR_INT_2; CLR_INT_3; CLR_INT_4; CLR_INT_5

#define CHK_INT_1	(CPU->REG_INT_ENABLE_1 & CPU->REG_INT_STATUS_1)
#define CHK_INT_2	(CPU->REG_INT_ENABLE_2 & CPU->REG_INT_STATUS_2)
#define CHK_INT_3	(CPU->REG_INT_ENABLE_3 & CPU->REG_INT_STATUS_3)
#define CHK_INT_4	(CPU->REG_INT_ENABLE_4 & CPU->REG_INT_STATUS_4)
#define CHK_INT_5	(CPU->REG_INT_ENABLE_5 & CPU->REG_INT_STATUS_5)

/* Check interrupt */
	/* Interrupt 1 register */
#define CHK_LCDINT(a)				(a & LCDINT)
#define CHK_DFINT(a)				(a & DFINT)
#define CHK_CHI0_5INT(a)			(a & CHI0_5INT)
#define CHK_CHI1_0INT(a)			(a & CHI1_0INT)
#define CHK_CHIDMACNTINT(a)			(a & CHIDMACNTINT)
#define CHK_CHIININTA(a)			(a & CHIININTA)
#define CHK_CHIININTB(a)			(a & CHIININTB)
#define CHK_CHIACTINT(a)			(a & CHIACTINT)
#define CHK_CHIERRINT(a)			(a & CHIERRINT)
#define CHK_SND0_5INT(a)			(a & SND0_5INT)
#define CHK_SND1_0INT(a)			(a & SND1_0INT)
#define CHK_TEL0_5INT(a)			(a & TEL0_5INT)
#define CHK_TEL1_0INT(a)			(a & TEL1_0INT)
#define CHK_SNDDMACNTINT(a)			(a & SNDDMACNTINT)
#define CHK_TELDMACNTINT(a)			(a & TELDMACNTINT)
#define CHK_LSNDCLIPINT(a)			(a & LSNDCLIPINT)
#define CHK_RSNDCLIPINT(a)			(a & RSNDCLIPINT)
#define CHK_VALSNDPOSINT(a)			(a & VALSNDPOSINT)
#define CHK_VALSNDNEGINT(a)			(a & VALSNDNEGINT)
#define CHK_VALTELPOSINT(a)			(a & VALTELPOSINT)
#define CHK_VALTELNEGINT(a)			(a & VALTELNEGINT)
#define CHK_SNDININT(a)				(a & SNDININT)
#define CHK_TELININT(a)				(a & TELININT)
#define CHK_SIBSF0INT(a)			(a & SIBSF0INT)
#define CHK_SIBSF1INT(a)			(a & SIBSF1INT)
#define CHK_SIBIRQPOSINT(a)			(a & SIBIRQPOSINT)
#define CHK_SIBIRQNEGINT(a)			(a & SIBIRQNEGINT)

	/* Interrupt 2 register */
#define CHK_UARTARXINT(a)			(a & UARTARXINT)
#define CHK_UARTARXOVERRUNINT(a)	(a & UARTARXOVERRUNINT)
#define CHK_UARTAFRAMEERRINT(a)		(a & UARTAFRAMEERRINT)
#define CHK_UARTABREAKINT(a)		(a & UARTABREAKINT)
#define CHK_UARTAPARITYERRINT(a)	(a & UARTAPARITYERRINT)
#define CHK_UARTATXINT(a)			(a & UARTATXINT)
#define CHK_UARTATXOVERRUNINT(a)	(a & UARTATXOVERRUNINT)
#define CHK_UARTAEMPTYINT(a)		(a & UARTAEMPTYINT)
#define CHK_UARTADMAFULLINT(a)		(a & UARTADMAFULLINT)
#define CHK_UARTADMAHALFINT(a)		(a & UARTADMAHALFINT)
#define CHK_UARTBRXINT(a)			(a & UARTBRXINT)
#define CHK_UARTBRXOVERRUNINT(a)	(a & UARTBRXOVERRUNINT)
#define CHK_UARTBFRAMEERRINT(a)		(a & UARTBFRAMEERRINT)
#define CHK_UARTBBREAKINT(a)		(a & UARTBBREAKINT)
#define CHK_UARTBPARITYERRINT(a)	(a & UARTBPARITYERRINT)
#define CHK_UARTBTXINT(a)			(a & UARTBTXINT)
#define CHK_UARTBTXOVERRUNINT(a)	(a & UARTBTXOVERRUNINT)
#define CHK_UARTBEMPTYINT(a)		(a & UARTBEMPTYINT)
#define CHK_UARTBDMAFULLINT(a)		(a & UARTBDMAFULLINT)
#define CHK_UARTBDMAHALFINT(a)		(a & UARTBDMAHALFINT)

	/* Interrupt 3 register */
#define CHK_MFIOPOSINT(a, b)		(b & MFIOPOSINT(a))

	/* Interrupt 4 register */
#define CHK_MFIONEGINT(a, b)		(b & MFIONEGINT(a))

	/* Interrupt 5 register */
#define CHK_RTCINT(a)				(a & RTCINT)
#define CHK_ALARMINT(a)				(a & ALARMINT)
#define CHK_PERINT(a)				(a & PERINT)
#define CHK_STPTIMERINT(a)			(a & STPTIMERINT)
#define CHK_POSPWRINT(a)			(a & POSPWRINT)
#define CHK_NEGPWRINT(a)			(a & NEGPWRINT)
#define CHK_POSPWROKINT(a)			(a & POSPWROKINT)
#define CHK_NEGPWROKINT(a)			(a & NEGPWROKINT)
#define CHK_POSONBUTNINT(a)			(a & POSONBUTNINT)
#define CHK_NEGONBUTNINT(a)			(a & NEGONBUTNINT)
#define CHK_SPIBUFAVAILINT(a)		(a & SPIBUFAVAILINT)
#define CHK_SPIERRINT(a)			(a & SPIERRINT)
#define CHK_SPIRCVINT(a)			(a & SPIRCVINT)
#define CHK_SPIEMPTYINT(a)			(a & SPIEMPTYINT)
#define CHK_IRCONSMINT(a)			(a & IRCONSMINT)
#define CHK_CARSTINT(a)				(a & CARSTINT)
#define CHK_POSCARINT(a)			(a & POSCARINT)
#define CHK_NEGCARINT(a)			(a & NEGCARINT)
#define CHK_IOPOSINT(a, b)			(b & IOPOSINT(a))
#define CHK_IONEGINT(a, b)			(b & IONEGINT(a))

/* Acknowledge interrupt */
	/* Interrupt 1 register */
#define ACK_LCDINT				(CPU->REG_INT_STATUS_1 = LCDINT)
#define ACK_DFINT				(CPU->REG_INT_STATUS_1 = DFINT)
#define ACK_CHI0_5INT			(CPU->REG_INT_STATUS_1 = CHI0_5INT)
#define ACK_CHI1_0INT			(CPU->REG_INT_STATUS_1 = CHI1_0INT)
#define ACK_CHIDMACNTINT		(CPU->REG_INT_STATUS_1 = CHIDMACNTINT)
#define ACK_CHIININTA			(CPU->REG_INT_STATUS_1 = CHIININTA)
#define ACK_CHIININTB			(CPU->REG_INT_STATUS_1 = CHIININTB)
#define ACK_CHIACTINT			(CPU->REG_INT_STATUS_1 = CHIACTINT)
#define ACK_CHIERRINT			(CPU->REG_INT_STATUS_1 = CHIERRINT)
#define ACK_SND0_5INT			(CPU->REG_INT_STATUS_1 = SND0_5INT)
#define ACK_SND1_0INT			(CPU->REG_INT_STATUS_1 = SND1_0INT)
#define ACK_TEL0_5INT			(CPU->REG_INT_STATUS_1 = TEL0_5INT)
#define ACK_TEL1_0INT			(CPU->REG_INT_STATUS_1 = TEL1_0INT)
#define ACK_SNDDMACNTINT		(CPU->REG_INT_STATUS_1 = SNDDMACNTINT)
#define ACK_TELDMACNTINT		(CPU->REG_INT_STATUS_1 = TELDMACNTINT)
#define ACK_LSNDCLIPINT			(CPU->REG_INT_STATUS_1 = LSNDCLIPINT)
#define ACK_RSNDCLIPINT			(CPU->REG_INT_STATUS_1 = RSNDCLIPINT)
#define ACK_VALSNDPOSINT		(CPU->REG_INT_STATUS_1 = VALSNDPOSINT)
#define ACK_VALSNDNEGINT		(CPU->REG_INT_STATUS_1 = VALSNDNEGINT)
#define ACK_VALTELPOSINT		(CPU->REG_INT_STATUS_1 = VALTELPOSINT)
#define ACK_VALTELNEGINT		(CPU->REG_INT_STATUS_1 = VALTELNEGINT)
#define ACK_SNDININT			(CPU->REG_INT_STATUS_1 = SNDININT)
#define ACK_TELININT			(CPU->REG_INT_STATUS_1 = TELININT)
#define ACK_SIBSF0INT			(CPU->REG_INT_STATUS_1 = SIBSF0INT)
#define ACK_SIBSF1INT			(CPU->REG_INT_STATUS_1 = SIBSF1INT)
#define ACK_SIBIRQPOSINT		(CPU->REG_INT_STATUS_1 = SIBIRQPOSINT)
#define ACK_SIBIRQNEGINT		(CPU->REG_INT_STATUS_1 = SIBIRQNEGINT)

	/* Interrupt 2 register */
#define ACK_UARTARXINT			(CPU->REG_INT_STATUS_2 = UARTARXINT)
#define ACK_UARTARXOVERRUNINT	(CPU->REG_INT_STATUS_2 = UARTARXOVERRUNINT)
#define ACK_UARTAFRAMEERRINT	(CPU->REG_INT_STATUS_2 = UARTAFRAMEERRINT)
#define ACK_UARTABREAKINT		(CPU->REG_INT_STATUS_2 = UARTABREAKINT)
#define ACK_UARTAPARITYERRINT	(CPU->REG_INT_STATUS_2 = UARTAPARITYERRINT)
#define ACK_UARTATXINT			(CPU->REG_INT_STATUS_2 = UARTATXINT)
#define ACK_UARTATXOVERRUNINT	(CPU->REG_INT_STATUS_2 = UARTATXOVERRUNINT)
#define ACK_UARTAEMPTYINT		(CPU->REG_INT_STATUS_2 = UARTAEMPTYINT)
#define ACK_UARTADMAFULLINT		(CPU->REG_INT_STATUS_2 = UARTADMAFULLINT)
#define ACK_UARTADMAHALFINT		(CPU->REG_INT_STATUS_2 = UARTADMAHALFINT)
#define ACK_UARTBRXINT			(CPU->REG_INT_STATUS_2 = UARTBRXINT)
#define ACK_UARTBRXOVERRUNINT	(CPU->REG_INT_STATUS_2 = UARTBRXOVERRUNINT)
#define ACK_UARTBFRAMEERRINT	(CPU->REG_INT_STATUS_2 = UARTBFRAMEERRINT)
#define ACK_UARTBBREAKINT		(CPU->REG_INT_STATUS_2 = UARTBBREAKINT)
#define ACK_UARTBPARITYERRINT	(CPU->REG_INT_STATUS_2 = UARTBPARITYERRINT)
#define ACK_UARTBTXINT			(CPU->REG_INT_STATUS_2 = UARTBTXINT)
#define ACK_UARTBTXOVERRUNINT	(CPU->REG_INT_STATUS_2 = UARTBTXOVERRUNINT)
#define ACK_UARTBEMPTYINT		(CPU->REG_INT_STATUS_2 = UARTBEMPTYINT)
#define ACK_UARTBDMAFULLINT		(CPU->REG_INT_STATUS_2 = UARTBDMAFULLINT)
#define ACK_UARTBDMAHALFINT		(CPU->REG_INT_STATUS_2 = UARTBDMAHALFINT)

	/* Interrupt 3 register */
#define ACK_MFIOPOSINT(a)		(CPU->REG_INT_STATUS_3 = MFIOPOSINT(a))

	/* Interrupt 4 register */
#define ACK_MFIONEGINT(a)		(CPU->REG_INT_STATUS_4 = MFIONEGINT(a))

	/* Interrupt 5 register */
#define ACK_RTCINT				(CPU->REG_INT_STATUS_5 = RTCINT)
#define ACK_ALARMINT			(CPU->REG_INT_STATUS_5 = ALARMINT)
#define ACK_PERINT				(CPU->REG_INT_STATUS_5 = PERINT)
#define ACK_STPTIMERINT			(CPU->REG_INT_STATUS_5 = STPTIMERINT)
#define ACK_POSPWRINT			(CPU->REG_INT_STATUS_5 = POSPWRINT)
#define ACK_NEGPWRINT			(CPU->REG_INT_STATUS_5 = NEGPWRINT)
#define ACK_POSPWROKINT			(CPU->REG_INT_STATUS_5 = POSPWROKINT)
#define ACK_NEGPWROKINT			(CPU->REG_INT_STATUS_5 = NEGPWROKINT)
#define ACK_POSONBUTNINT		(CPU->REG_INT_STATUS_5 = POSONBUTNINT)
#define ACK_NEGONBUTNINT		(CPU->REG_INT_STATUS_5 = NEGONBUTNINT)
#define ACK_SPIBUFAVAILINT		(CPU->REG_INT_STATUS_5 = SPIBUFAVAILINT)
#define ACK_SPIERRINT			(CPU->REG_INT_STATUS_5 = SPIERRINT)
#define ACK_SPIRCVINT			(CPU->REG_INT_STATUS_5 = SPIRCVINT)
#define ACK_SPIEMPTYINT			(CPU->REG_INT_STATUS_5 = SPIEMPTYINT)
#define ACK_IRCONSMINT			(CPU->REG_INT_STATUS_5 = IRCONSMINT)
#define ACK_CARSTINT			(CPU->REG_INT_STATUS_5 = CARSTINT)
#define ACK_POSCARINT			(CPU->REG_INT_STATUS_5 = POSCARINT)
#define ACK_NEGCARINT			(CPU->REG_INT_STATUS_5 = NEGCARINT)
#define ACK_IOPOSINT(a)			(CPU->REG_INT_STATUS_5 = IOPOSINT(a))
#define ACK_IONEGINT(a)			(CPU->REG_INT_STATUS_5 = IONEGINT(a))

/* Enable interrupt */
	/* Interrupt 1 register */
#define ENA_LCDINT				(CPU->REG_INT_ENABLE_1 |= LCDINT)
#define ENA_DFINT				(CPU->REG_INT_ENABLE_1 |= DFINT)
#define ENA_CHI0_5INT			(CPU->REG_INT_ENABLE_1 |= CHI0_5INT)
#define ENA_CHI1_0INT			(CPU->REG_INT_ENABLE_1 |= CHI1_0INT)
#define ENA_CHIDMACNTINT		(CPU->REG_INT_ENABLE_1 |= CHIDMACNTINT)
#define ENA_CHIININTA			(CPU->REG_INT_ENABLE_1 |= CHIININTA)
#define ENA_CHIININTB			(CPU->REG_INT_ENABLE_1 |= CHIININTB)
#define ENA_CHIACTINT			(CPU->REG_INT_ENABLE_1 |= CHIACTINT)
#define ENA_CHIERRINT			(CPU->REG_INT_ENABLE_1 |= CHIERRINT)
#define ENA_SND0_5INT			(CPU->REG_INT_ENABLE_1 |= SND0_5INT)
#define ENA_SND1_0INT			(CPU->REG_INT_ENABLE_1 |= SND1_0INT)
#define ENA_TEL0_5INT			(CPU->REG_INT_ENABLE_1 |= TEL0_5INT)
#define ENA_TEL1_0INT			(CPU->REG_INT_ENABLE_1 |= TEL1_0INT)
#define ENA_SNDDMACNTINT		(CPU->REG_INT_ENABLE_1 |= SNDDMACNTINT)
#define ENA_TELDMACNTINT		(CPU->REG_INT_ENABLE_1 |= TELDMACNTINT)
#define ENA_LSNDCLIPINT			(CPU->REG_INT_ENABLE_1 |= LSNDCLIPINT)
#define ENA_RSNDCLIPINT			(CPU->REG_INT_ENABLE_1 |= RSNDCLIPINT)
#define ENA_VALSNDPOSINT		(CPU->REG_INT_ENABLE_1 |= VALSNDPOSINT)
#define ENA_VALSNDNEGINT		(CPU->REG_INT_ENABLE_1 |= VALSNDNEGINT)
#define ENA_VALTELPOSINT		(CPU->REG_INT_ENABLE_1 |= VALTELPOSINT)
#define ENA_VALTELNEGINT		(CPU->REG_INT_ENABLE_1 |= VALTELNEGINT)
#define ENA_SNDININT			(CPU->REG_INT_ENABLE_1 |= SNDININT)
#define ENA_TELININT			(CPU->REG_INT_ENABLE_1 |= TELININT)
#define ENA_SIBSF0INT			(CPU->REG_INT_ENABLE_1 |= SIBSF0INT)
#define ENA_SIBSF1INT			(CPU->REG_INT_ENABLE_1 |= SIBSF1INT)
#define ENA_SIBIRQPOSINT		(CPU->REG_INT_ENABLE_1 |= SIBIRQPOSINT)
#define ENA_SIBIRQNEGINT		(CPU->REG_INT_ENABLE_1 |= SIBIRQNEGINT)

	/* Interrupt 2 register */
#define ENA_UARTARXINT			(CPU->REG_INT_ENABLE_2 |= UARTARXINT)
#define ENA_UARTARXOVERRUNINT	(CPU->REG_INT_ENABLE_2 |= UARTARXOVERRUNINT)
#define ENA_UARTAFRAMEERRINT	(CPU->REG_INT_ENABLE_2 |= UARTAFRAMEERRINT)
#define ENA_UARTABREAKINT		(CPU->REG_INT_ENABLE_2 |= UARTABREAKINT)
#define ENA_UARTAPARITYERRINT	(CPU->REG_INT_ENABLE_2 |= UARTAPARITYERRINT)
#define ENA_UARTATXINT			(CPU->REG_INT_ENABLE_2 |= UARTATXINT)
#define ENA_UARTATXOVERRUNINT	(CPU->REG_INT_ENABLE_2 |= UARTATXOVERRUNINT)
#define ENA_UARTAEMPTYINT		(CPU->REG_INT_ENABLE_2 |= UARTAEMPTYINT)
#define ENA_UARTADMAFULLINT		(CPU->REG_INT_ENABLE_2 |= UARTADMAFULLINT)
#define ENA_UARTADMAHALFINT		(CPU->REG_INT_ENABLE_2 |= UARTADMAHALFINT)
#define ENA_UARTBRXINT			(CPU->REG_INT_ENABLE_2 |= UARTBRXINT)
#define ENA_UARTBRXOVERRUNINT	(CPU->REG_INT_ENABLE_2 |= UARTBRXOVERRUNINT)
#define ENA_UARTBFRAMEERRINT	(CPU->REG_INT_ENABLE_2 |= UARTBFRAMEERRINT)
#define ENA_UARTBBREAKINT		(CPU->REG_INT_ENABLE_2 |= UARTBBREAKINT)
#define ENA_UARTBPARITYERRINT	(CPU->REG_INT_ENABLE_2 |= UARTBPARITYERRINT)
#define ENA_UARTBTXINT			(CPU->REG_INT_ENABLE_2 |= UARTBTXINT)
#define ENA_UARTBTXOVERRUNINT	(CPU->REG_INT_ENABLE_2 |= UARTBTXOVERRUNINT)
#define ENA_UARTBEMPTYINT		(CPU->REG_INT_ENABLE_2 |= UARTBEMPTYINT)
#define ENA_UARTBDMAFULLINT		(CPU->REG_INT_ENABLE_2 |= UARTBDMAFULLINT)
#define ENA_UARTBDMAHALFINT		(CPU->REG_INT_ENABLE_2 |= UARTBDMAHALFINT)

	/* Interrupt 3 register */
#define ENA_MFIOPOSINT(a)		(CPU->REG_INT_ENABLE_3 |= MFIOPOSINT(a))

	/* Interrupt 4 register */
#define ENA_MFIONEGINT(a)		(CPU->REG_INT_ENABLE_4 |= MFIONEGINT(a))

	/* Interrupt 5 register */
#define ENA_RTCINT				(CPU->REG_INT_ENABLE_5 |= RTCINT)
#define ENA_ALARMINT			(CPU->REG_INT_ENABLE_5 |= ALARMINT)
#define ENA_PERINT				(CPU->REG_INT_ENABLE_5 |= PERINT)
#define ENA_STPTIMERINT			(CPU->REG_INT_ENABLE_5 |= STPTIMERINT)
#define ENA_POSPWRINT			(CPU->REG_INT_ENABLE_5 |= POSPWRINT)
#define ENA_NEGPWRINT			(CPU->REG_INT_ENABLE_5 |= NEGPWRINT)
#define ENA_POSPWROKINT			(CPU->REG_INT_ENABLE_5 |= POSPWROKINT)
#define ENA_NEGPWROKINT			(CPU->REG_INT_ENABLE_5 |= NEGPWROKINT)
#define ENA_POSONBUTNINT		(CPU->REG_INT_ENABLE_5 |= POSONBUTNINT)
#define ENA_NEGONBUTNINT		(CPU->REG_INT_ENABLE_5 |= NEGONBUTNINT)
#define ENA_SPIBUFAVAILINT		(CPU->REG_INT_ENABLE_5 |= SPIBUFAVAILINT)
#define ENA_SPIERRINT			(CPU->REG_INT_ENABLE_5 |= SPIERRINT)
#define ENA_SPIRCVINT			(CPU->REG_INT_ENABLE_5 |= SPIRCVINT)
#define ENA_SPIEMPTYINT			(CPU->REG_INT_ENABLE_5 |= SPIEMPTYINT)
#define ENA_IRCONSMINT			(CPU->REG_INT_ENABLE_5 |= IRCONSMINT)
#define ENA_CARSTINT			(CPU->REG_INT_ENABLE_5 |= CARSTINT)
#define ENA_POSCARINT			(CPU->REG_INT_ENABLE_5 |= POSCARINT)
#define ENA_NEGCARINT			(CPU->REG_INT_ENABLE_5 |= NEGCARINT)
#define ENA_IOPOSINT(a)			(CPU->REG_INT_ENABLE_5 |= IOPOSINT(a))
#define ENA_IONEGINT(a)			(CPU->REG_INT_ENABLE_5 |= IONEGINT(a))

/* Disable interrupt */
	/* Interrupt 1 register */
#define DIS_LCDINT				(CPU->REG_INT_ENABLE_1 &= ~LCDINT)
#define DIS_DFINT				(CPU->REG_INT_ENABLE_1 &= ~DFINT)
#define DIS_CHI0_5INT			(CPU->REG_INT_ENABLE_1 &= ~CHI0_5INT)
#define DIS_CHI1_0INT			(CPU->REG_INT_ENABLE_1 &= ~CHI1_0INT)
#define DIS_CHIDMACNTINT		(CPU->REG_INT_ENABLE_1 &= ~CHIDMACNTINT)
#define DIS_CHIININTA			(CPU->REG_INT_ENABLE_1 &= ~CHIININTA)
#define DIS_CHIININTB			(CPU->REG_INT_ENABLE_1 &= ~CHIININTB)
#define DIS_CHIACTINT			(CPU->REG_INT_ENABLE_1 &= ~CHIACTINT)
#define DIS_CHIERRINT			(CPU->REG_INT_ENABLE_1 &= ~CHIERRINT)
#define DIS_SND0_5INT			(CPU->REG_INT_ENABLE_1 &= ~SND0_5INT)
#define DIS_SND1_0INT			(CPU->REG_INT_ENABLE_1 &= ~SND1_0INT)
#define DIS_TEL0_5INT			(CPU->REG_INT_ENABLE_1 &= ~TEL0_5INT)
#define DIS_TEL1_0INT			(CPU->REG_INT_ENABLE_1 &= ~TEL1_0INT)
#define DIS_SNDDMACNTINT		(CPU->REG_INT_ENABLE_1 &= ~SNDDMACNTINT)
#define DIS_TELDMACNTINT		(CPU->REG_INT_ENABLE_1 &= ~TELDMACNTINT)
#define DIS_LSNDCLIPINT			(CPU->REG_INT_ENABLE_1 &= ~LSNDCLIPINT)
#define DIS_RSNDCLIPINT			(CPU->REG_INT_ENABLE_1 &= ~RSNDCLIPINT)
#define DIS_VALSNDPOSINT		(CPU->REG_INT_ENABLE_1 &= ~VALSNDPOSINT)
#define DIS_VALSNDNEGINT		(CPU->REG_INT_ENABLE_1 &= ~VALSNDNEGINT)
#define DIS_VALTELPOSINT		(CPU->REG_INT_ENABLE_1 &= ~VALTELPOSINT)
#define DIS_VALTELNEGINT		(CPU->REG_INT_ENABLE_1 &= ~VALTELNEGINT)
#define DIS_SNDININT			(CPU->REG_INT_ENABLE_1 &= ~SNDININT)
#define DIS_TELININT			(CPU->REG_INT_ENABLE_1 &= ~TELININT)
#define DIS_SIBSF0INT			(CPU->REG_INT_ENABLE_1 &= ~SIBSF0INT)
#define DIS_SIBSF1INT			(CPU->REG_INT_ENABLE_1 &= ~SIBSF1INT)
#define DIS_SIBIRQPOSINT		(CPU->REG_INT_ENABLE_1 &= ~SIBIRQPOSINT)
#define DIS_SIBIRQNEGINT		(CPU->REG_INT_ENABLE_1 &= ~SIBIRQNEGINT)

	/* Interrupt 2 register */
#define DIS_UARTARXINT			(CPU->REG_INT_ENABLE_2 &= ~UARTARXINT)
#define DIS_UARTARXOVERRUNINT	(CPU->REG_INT_ENABLE_2 &= ~UARTARXOVERRUNINT)
#define DIS_UARTAFRAMEERRINT	(CPU->REG_INT_ENABLE_2 &= ~UARTAFRAMEERRINT)
#define DIS_UARTABREAKINT		(CPU->REG_INT_ENABLE_2 &= ~UARTABREAKINT)
#define DIS_UARTAPARITYERRINT	(CPU->REG_INT_ENABLE_2 &= ~UARTAPARITYERRINT)
#define DIS_UARTATXINT			(CPU->REG_INT_ENABLE_2 &= ~UARTATXINT)
#define DIS_UARTATXOVERRUNINT	(CPU->REG_INT_ENABLE_2 &= ~UARTATXOVERRUNINT)
#define DIS_UARTAEMPTYINT		(CPU->REG_INT_ENABLE_2 &= ~UARTAEMPTYINT)
#define DIS_UARTADMAFULLINT		(CPU->REG_INT_ENABLE_2 &= ~UARTADMAFULLINT)
#define DIS_UARTADMAHALFINT		(CPU->REG_INT_ENABLE_2 &= ~UARTADMAHALFINT)
#define DIS_UARTBRXINT			(CPU->REG_INT_ENABLE_2 &= ~UARTBRXINT)
#define DIS_UARTBRXOVERRUNINT	(CPU->REG_INT_ENABLE_2 &= ~UARTBRXOVERRUNINT)
#define DIS_UARTBFRAMEERRINT	(CPU->REG_INT_ENABLE_2 &= ~UARTBFRAMEERRINT)
#define DIS_UARTBBREAKINT		(CPU->REG_INT_ENABLE_2 &= ~UARTBBREAKINT)
#define DIS_UARTBPARITYERRINT	(CPU->REG_INT_ENABLE_2 &= ~UARTBPARITYERRINT)
#define DIS_UARTBTXINT			(CPU->REG_INT_ENABLE_2 &= ~UARTBTXINT)
#define DIS_UARTBTXOVERRUNINT	(CPU->REG_INT_ENABLE_2 &= ~UARTBTXOVERRUNINT)
#define DIS_UARTBEMPTYINT		(CPU->REG_INT_ENABLE_2 &= ~UARTBEMPTYINT)
#define DIS_UARTBDMAFULLINT		(CPU->REG_INT_ENABLE_2 &= ~UARTBDMAFULLINT)
#define DIS_UARTBDMAHALFINT		(CPU->REG_INT_ENABLE_2 &= ~UARTBDMAHALFINT)

	/* Interrupt 3 register */
#define DIS_MFIOPOSINT(a)		(CPU->REG_INT_ENABLE_3 &= ~MFIOPOSINT(a))

	/* Interrupt 4 register */
#define DIS_MFIONEGINT(a)		(CPU->REG_INT_ENABLE_4 &= ~MFIONEGINT(a))

	/* Interrupt 5 register */
#define DIS_RTCINT				(CPU->REG_INT_ENABLE_5 &= ~RTCINT)
#define DIS_ALARMINT			(CPU->REG_INT_ENABLE_5 &= ~ALARMINT)
#define DIS_PERINT				(CPU->REG_INT_ENABLE_5 &= ~PERINT)
#define DIS_STPTIMERINT			(CPU->REG_INT_ENABLE_5 &= ~STPTIMERINT)
#define DIS_POSPWRINT			(CPU->REG_INT_ENABLE_5 &= ~POSPWRINT)
#define DIS_NEGPWRINT			(CPU->REG_INT_ENABLE_5 &= ~NEGPWRINT)
#define DIS_POSPWROKINT			(CPU->REG_INT_ENABLE_5 &= ~POSPWROKINT)
#define DIS_NEGPWROKINT			(CPU->REG_INT_ENABLE_5 &= ~NEGPWROKINT)
#define DIS_POSONBUTNINT		(CPU->REG_INT_ENABLE_5 &= ~POSONBUTNINT)
#define DIS_NEGONBUTNINT		(CPU->REG_INT_ENABLE_5 &= ~NEGONBUTNINT)
#define DIS_SPIBUFAVAILINT		(CPU->REG_INT_ENABLE_5 &= ~SPIBUFAVAILINT)
#define DIS_SPIERRINT			(CPU->REG_INT_ENABLE_5 &= ~SPIERRINT)
#define DIS_SPIRCVINT			(CPU->REG_INT_ENABLE_5 &= ~SPIRCVINT)
#define DIS_SPIEMPTYINT			(CPU->REG_INT_ENABLE_5 &= ~SPIEMPTYINT)
#define DIS_IRCONSMINT			(CPU->REG_INT_ENABLE_5 &= ~IRCONSMINT)
#define DIS_CARSTINT			(CPU->REG_INT_ENABLE_5 &= ~CARSTINT)
#define DIS_POSCARINT			(CPU->REG_INT_ENABLE_5 &= ~POSCARINT)
#define DIS_NEGCARINT			(CPU->REG_INT_ENABLE_5 &= ~NEGCARINT)
#define DIS_IOPOSINT(a)			(CPU->REG_INT_ENABLE_5 &= ~IOPOSINT(a))
#define DIS_IONEGINT(a)			(CPU->REG_INT_ENABLE_5 &= ~IONEGINT(a))

#define INT_MAX_PRIORITY		5

void UtlbLoadExcHandle();
void UtlbStoreExcHandle();
void OtherGenExcHandle();
void OtherIntHighHandle();
void OtherIntLow1Handle();
void OtherIntLow2Handle();
void OtherIntLow3Handle();
void OtherIntLow4Handle();
void OtherIntLow5Handle();
void IntInit();
void IntEnableGlobal();
void IntDisableGlobal();
void IntSetPriority(USHORT int_no, USHORT priority);
void IntBuildPriorityMask();
void IntMaskIntEnable(UWORD int_no);
USHORT IntSearchLastHookCell(USHORT int_no);
USHORT IntSearchFreeHookCell(USHORT int_no);
USHORT IntSearchNextPtr(USHORT hook_no);
USHORT IntHookISR(USHORT ISRID, USHORT int_no, UWORD offset);
void IntUnhookISR(USHORT hook_no);
void IntRunHookedISR(USHORT int_no, BYTE *arg);
void IntSetActive(USHORT hook_no);
UBYTE IntGetActive(USHORT hook_no);
void IntUnhookISRbyAppID(USHORT appid);
void IntClearHookAddr(UBYTE addr);
void IntSetHookAddr(UBYTE addr, UWORD* page_table, AppID appid);

#endif	/* _INTERRUP_ */


