/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   uifunc.h
Author(s)   :   Henry Fok, David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for ui API calls
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#ifndef _FUNCTION_H_
#define _FUNCTION_H_

#include "include\uidef.h"
#include "include\str.h"
#include "include\ResMgr.h"
#include "include\inlay.h"


/* ==================================================================== */
/* ========================= Global Functions ========================= */
/* ==================================================================== */
void UIInit();
void UIApplicationInit();
Err UISearchForAddress(ObjectID, BYTE *,void **);
Err UIAddressToLookupTable(ObjectID,BYTE,void **);
Err UIDeleteLookupTableElement(ObjectID form_id);
Err UIDeleteLinkListFormElement(ObjectID form_id);
Err UIAddLinkListFormElement(ObjectID form_id,Form **form_ptr);
BYTE UIColorConversion(BYTE color_in);
void UIDeleteAllAppObjects();
BYTE UIGetUndoStatus();
void UIPrintMallocCounter();
void UIResetMallocCounter();
Err UICheckObjectPopupStatus(BOOLEAN *menu_popup_status, BOOLEAN *popup_popup_status);
/* ==================================================================== */
/* ============================== Data Init =========================== */
/* ==================================================================== */
void DataInit();
/* ==================================================================== */
/* ========================= Event Handler ============================ */
/* ==================================================================== */
BOOLEAN FormHandleEvent(EvtType * Event);
BOOLEAN ControlHandleEvent(Control *addr,EvtType *Event);
//BOOLEAN HardwareButtonHandleEvent(EvtType *Event);
BOOLEAN KeyboardHandleEvent(EvtType *Event);
BOOLEAN TableHandleEvent(Table *addr, EvtType *Event);
BOOLEAN BitmapHandleEvent(Bitmap *addr, EvtType *Event);
BOOLEAN ScrollbarHandleEvent(Scrollbar *addr, EvtType *Event);
BOOLEAN ListHandleEvent(List *addr, EvtType *Event);
BOOLEAN MenuHandleEvent(EvtType *Event);
BOOLEAN FieldHandleEvent(Field *addr, EvtType *Event);
BOOLEAN TextboxHandleEvent(Textbox *addr, EvtType *Event);
BOOLEAN SchlineHandleEvent(Schline *addr,EvtType *Event);
/* ==================================================================== */
/* ============================= Form ================================= */
/* ==================================================================== */
Err FormPopupForm(ObjectID form_id);
Err FormDrawForm(ObjectID form_id);
Err FormGetActiveFormID(ObjectID *form_id);
Err FormSetActiveForm(ObjectID form_id);
Err FormEraseForm(ObjectID form_id);
Err FormSetControlGroupSelection(ObjectID form_id, ObjectID object_id);
Err FormPointInObject(ObjectID object_id, SHORT x_coord, SHORT y_coord);
Err FormGetObjectBounds(ObjectID object_id, ObjectBounds *bounds);
Err FormGetNumberOfObjects(ObjectID form_id,USHORT *num_objects);
Err FormGetObjectPointer(ObjectID object_id, BYTE *type, void **address);
Err FormGotoForm(ObjectID form_id);
Err FormCheckStyle(ObjectID form_id, BYTE *form_style);
//Err FormSetEventHandler(ObjectID form_id, BOOLEAN function(EvtType *));
Err FormSetEventHandler(ObjectID form_id, void **src, void *dest);
Err FormSetDialogTitle (ObjectID form_id,BYTE *title_text);
void FormSaveAllForms();
Err FormGetControlValue(ObjectID control_id, BOOLEAN *ctl_value);
Err FormGetActiveObject(ObjectID form_id, ObjectID *active_id);
Err FormSetFormUpdateAtt(ObjectID form_id, BOOLEAN set_value);
Err FormSetObjectBounds(ObjectID object_id, ObjectBounds bounds);
Err FormObjectSetFocus(ObjectID object_id);
Err FormObjectReleaseFocus(BYTE current_pressed_object_type);
Err FormObjectRestoreFocus();
Err FormGetMenuID(ObjectID form_id,ObjectID *menu_id);
void FormDrawDialog(Form *addr);
void FormDrawNormalForm(Form *addr);
Err FormRestoreBitBehind(ObjectID form_id);
Err FormSaveBehindBits(ObjectID form_id);
Err FormInitForm(ObjectID form_id);
Err FormDeleteForm(ObjectID form_id);
Err FormInitAllFormObjects(ObjectID form_id);
extern BOOLEAN (*FormDispatchEvent)(EvtType *);
Err FormSetFormActiveObject(ObjectID form_id, ObjectID object_id);
BOOLEAN FormCheckObjectExists(ObjectID object_id);
Err FormDeleteAllFormObjects(ObjectID form_id);
Err FormSetObjectPosition(ObjectID object_id, SHORT x, SHORT y);
void FormDrawDialogBackground(ObjectBounds *bounds, BYTE bg_color);
Err FormAddOneObject(ObjectID form_id, ObjectID object_id, BYTE object_type);

/* ==================================================================== */
/* ============================= Control ================================= */
/* ==================================================================== */
void ControlDrawFillButton(ObjectBounds *bounds,SHORT draw_radius);
void ControlDrawEmptyButton(ObjectBounds *bounds,SHORT draw_radius, BYTE bg_color);
void ControlDrawArc(ObjectBounds *bounds,BOOLEAN draw_fill,
					SHORT draw_radius, BYTE bg_color);
void ControlDrawString(Control *addr,ObjectBounds *bounds,
					   BYTE draw_color,BYTE *draw_text,BYTE bg_color);
Err ControlDrawControl(ObjectID control_id);
Err ControlGetAttributes(ObjectID control_id, BOOLEAN *enable_attr,
				   BOOLEAN *drawn_attr,BOOLEAN *savebehind_attr,
				   BOOLEAN *active_attr, BOOLEAN *visible_attr);
Err ControlGetLabel(ObjectID control_id, BYTE **control_label);
Err ControlRestoreBitBehind(ObjectID control_id);
Err ControlSetLabel(ObjectID control_id,BYTE *control_label);
Err ControlDeleteControl(ObjectID control_id);
Err ControlPopupSetTotalItems (ObjectID control_id,USHORT total_num_items);
Err ControlPopupGetTotalItems (ObjectID control_id,USHORT *total_num_items);
Err ControlPopupGetCurrentNumOfDisplayedItems (ObjectID control_id,USHORT *items_displayed);
Err ControlPopupDeleteItem(ObjectID control_id,USHORT item_number);
Err ControlPopupInsertItem(ObjectID control_id,USHORT item_number,BYTE *item_text);
Err ControlPopupGetPopupItem(ObjectID control_id,USHORT item_number,BYTE **item_text);
Err ControlUpdatePopupTrigger(ObjectID control_id,USHORT new_top_num);
Err ControlPopupGetTopItemNumber(ObjectID control_id,USHORT *top_num);
Err ControlHitControl(ObjectID control_id);
Err ControlSaveBehindBits(ObjectID control_id);
Err ControlEraseControl(ObjectID control_id);
Err ControlSetAttributes(ObjectID control_id,BOOLEAN att_enable,BOOLEAN att_drawn,
						 BOOLEAN att_save_behind,BOOLEAN att_active,
						 BOOLEAN att_visible);
Err ControlSavePopupBounds(ObjectID control_id);
SHORT ControlSearchSelectedItem(Control *control_ptr,SHORT input_xcoord,SHORT input_ycoord);
void ControlSetPopupTriggerUpDownArrow(Control *addr,ObjectBounds *popup_bounds);
USHORT ControlPopupClickedRegion(Control *addr,SHORT x_input,SHORT y_input);
void ControlSetPopupScroll(Control *addr,BYTE up_down);
void ControlSetPopupTriggerUpDownArrowOnly(Control *addr);
Err ControlInitControl(ObjectID control_id);
Err ControlPopupDeleteAllItems(ObjectID control_id);
Err ControlPopupGetSelectedItem(ObjectID control_id,SHORT *item_num);
Err ControlPopupSetSelectedItem(ObjectID control_id,SHORT item_num);
Err ControlPopupFindItemNum(ObjectID control_id, BYTE *text,USHORT *item_num);
Err ControlGetPushedPushButton(ObjectID form_id, USHORT group_id, ObjectID *control_id);
Err ControlGetCheckedCheckbox(ObjectID form_id, USHORT group_id, ObjectID *control_id);
Err ControlHighlightOneItem (Control *addr, SHORT item_num, BOOLEAN item_onoff);
Err ControlPopupTriggerClosePopupTrigger();

Err ControlPopupKeyboardHandleControlPopup(EvtType *Event);
Err ControlPopupPopupTrigger(ObjectID control_id);

/* ==================================================================== */
/* ============================= Table ================================= */
/* ==================================================================== */
Err TableDeleteTable(ObjectID table_id);
Err TableEnableTable(ObjectID table_id, BOOLEAN enable_attr);
Err TableGetColumnWidth(ObjectID table_id, USHORT column_number, SHORT *column_width);
Err TableGetCellBounds(ObjectID table_id, USHORT row_number,
					   USHORT column_number, ObjectBounds *cell_bounds);
Err TableGetItemText (ObjectID table_id, USHORT row_number,
					  USHORT column_number, BYTE **item_text);
Err TableGetNumOfColumns(ObjectID table_id, USHORT *num_columns);
Err TableGetRowColOfSelection(ObjectID table_id, USHORT *row_number, USHORT *col_number);
Err TableSetColumnWidth(ObjectID table_id, USHORT col_number, SHORT new_width);
Err TableSetItemValue(ObjectID table_id, USHORT col_number,
					  USHORT row_number,WORD new_value);
Err TableSetItemType (ObjectID table_id, USHORT row_number,
					  USHORT col_number, BYTE new_type);
Err TableGetClickedCell (ObjectID table_id, SHORT x, SHORT y,
						 USHORT *row_number, USHORT *col_number,
						 USHORT *cell_number);
Err TableEraseTable(ObjectID table_id);
Err TableGetItemType(ObjectID table_id,USHORT row,USHORT column,BYTE *table_data_type);
Err TableGetItemValue(ObjectID table_id,USHORT row,USHORT column,WORD *table_value);
Err TableGetNumOfRows(ObjectID table_id,USHORT *table_num_row);
Err TableGetRowHeight(ObjectID table_id,USHORT row_num,SHORT *row_height);
Err TableSetBounds(ObjectID table_id,ObjectBounds table_bounds);
Err TableSetRowHeight(ObjectID table_id,USHORT row_num,SHORT row_height);
Err TableSetItemText(ObjectID table_id,USHORT row,USHORT column,BYTE *text_string);
Err TableGetClickedCell(ObjectID table_id,SHORT x_coord,SHORT y_coord,
						USHORT *row_number,USHORT *col_number,USHORT *cell_number);
Err TableDrawDisplay(ObjectID table_id,ObjectBounds cell,USHORT count,BYTE cell_color);
Err TableDrawTable(ObjectID table_id);
Err TableDrawTableBounds(ObjectID table_id);
Err TableDrawUIObject(ObjectID table_id,ObjectID table_item_id,ObjectBounds table, ObjectBounds cell);
Err TableGetAttributes(ObjectID table_id, BOOLEAN *enable_attr,
						BOOLEAN *drawn_attr, BOOLEAN *active_attr,
						BOOLEAN *visible_attr, BOOLEAN *scrollbar_attr);
Err TableSetAttributes(ObjectID table_id,BOOLEAN att_drawn,BOOLEAN att_enable,
					  BOOLEAN att_active, BOOLEAN att_visible, BOOLEAN att_scrollbar);
Err TableUpdateTable(ObjectID table_id,USHORT top_row_num);
Err TableDrawFieldFullSize(Table *addr);
Err TableGetTopRowNum(ObjectID table_id, USHORT *top_num);
Err TableSetTopRowNum(ObjectID table_id, USHORT top_num);
Err TableGetNumOfRowsDisplayed(ObjectID table_id, USHORT *num_row);
Err TableSetHighlightCell(ObjectID table_id, USHORT row_num, 
						  USHORT col_num, BOOLEAN highlight_on);
Err TableCheckCellHighlight(ObjectID table_id, USHORT row_num, 
						    USHORT col_num, BOOLEAN *cell_highlight);
Err TableSetCellHasBitmap(ObjectID table_id, USHORT row_num, 
						  USHORT col_num, BOOLEAN bitmap_on);
Err TableCheckCellHasBitmap(ObjectID table_id, USHORT row_num, 
						    USHORT col_num, BOOLEAN *cell_bitmap);
Err TableSetHighlightEnable(ObjectID table_id, BOOLEAN highlight_enable);
Err TableCheckHighlightEnable(ObjectID table_id, BOOLEAN *highlight_enable);
Err TableInitTable(ObjectID table_id);
Err TableGetTableBounds (ObjectID table_id, ObjectBounds *table_bounds);
Err TableEraseNotUIRegion(ObjectID table_item_id, ObjectBounds table_cell);
BOOLEAN TableUpdateObjectScreenBounds(ObjectID table_id, ObjectID object_id/*, USHORT row_num, USHORT col_num*/);
BOOLEAN TableUpdateNumRowDisplay(ObjectID table_id, USHORT ref_col);
/* =================================================================== */
/* ============================= Line ================================= */
/* ==================================================================== */
Err LineDeleteLine(ObjectID line_id);
Err LineDrawLine(ObjectID line_id);
Err LineGetAttribute(ObjectID line_id,BOOLEAN *line_drawn, BOOLEAN *line_visible);
Err LineSetAttribute(ObjectID line_id, BOOLEAN att_drawn, BOOLEAN att_visible);
Err LineSetLineCharacteristics(ObjectID line_id,BYTE line_color,
							   BYTE line_style, USHORT line_thick);
Err LineGetLineCharacteristics(ObjectID line_id,BYTE *line_color,
							   BYTE *line_style, USHORT *line_thick);
Err LineGetPosition(ObjectID line_id,SHORT *start_x, SHORT *start_y,
					SHORT *end_x, SHORT *end_y);
Err LineSetPosition(ObjectID line_id,SHORT start_x, SHORT start_y,
					SHORT end_x, SHORT end_y);
Err LineEraseLine(ObjectID line_id);
Err LineInitLine(ObjectID line_id);
/* ==================================================================== */
/* ============================ BITMAP================================= */
/* ==================================================================== */
Err BitmapDrawBitmap(ObjectID bitmap_id);
Err BitmapEraseBitmap(ObjectID bitmap_id);
Err BitmapGetAttribute(ObjectID bitmap_id, BOOLEAN *att_drawn, BOOLEAN *att_enable, BOOLEAN *att_active, BOOLEAN *att_visible);
Err BitmapSetAttribute(ObjectID bitmap_id, BOOLEAN att_drawn, BOOLEAN att_enable, BOOLEAN att_active, BOOLEAN att_visible);
Err BitmapDeleteBitmap(ObjectID bitmap_id);
Err BitmapSetBitmapTemplate(ObjectID bitmap_id, BitmapTemplate bitmap_template_0,
							BitmapTemplate bitmap_template_1);
Err BitmapGetBitmapTemplate(ObjectID bitmap_id, BitmapTemplate *bitmap_template_0,
							BitmapTemplate *bitmap_template_1);
Err BitmapInitBitmap(ObjectID bitmap_id);
Err BitmapGetBitmapBounds(ObjectID bitmap_id, ObjectBounds *bitmap_bounds);
Err BitmapSetBitmapBounds(ObjectID bitmap_id, ObjectBounds bitmap_bounds);
/* ==================================================================== */
/* ============================ STRING ================================= */
/* ==================================================================== */
Err StringEraseString(ObjectID string_id);
Err StringDeleteString(ObjectID string_id);
Err StringGetText(ObjectID string_id, BYTE **text);
Err StringSetText(ObjectID string_id, BYTE *text);
Err StringDrawString(ObjectID string_id);
Err StringGetAttribute(ObjectID string_id, BOOLEAN *att_drawn, BOOLEAN *att_visible);
Err StringSetAttribute(ObjectID string_id, BOOLEAN att_drawn, BOOLEAN att_visible);
Err StringInitString(ObjectID string_id);
/* ==================================================================== */
/* ============================ MENU ================================= */
/* ==================================================================== */
Err MenuDrawMenu(ObjectID menu_id);
Err MenuDeleteMenu(ObjectID menu_id);
Err MenuGetNumOfItems(ObjectID menu_id, USHORT *num_items);
Err MenuSetPopupBounds(ObjectID menu_id);
Err MenuSetTotalItems (ObjectID menu_id,USHORT total_num_items);
Err MenuGetTotalItems (ObjectID menu_id,USHORT *total_num_items);
SHORT MenuSearchSelectedItem(Menu *addr, SHORT input_xcoord, SHORT input_ycoord);
Err MenuDeleteItem(ObjectID menu_id,USHORT item_number);
Err MenuInsertItem(ObjectID menu_id,USHORT item_number,BYTE *item_text);
Err MenuGetMenuItem(ObjectID menu_id,USHORT item_number,BYTE **item_text);
Err MenuDrawMenu (ObjectID menu_id);
Err MenuSaveBehindBits(ObjectID menu_id);
Err MenuRestoreBehindBits(ObjectID menu_id);
Err MenuInitMenu(ObjectID menu_id);
Err MenuDeleteAllItems(ObjectID menu_id);
Err MenuSetAttrVisible(ObjectID menu_id, BOOLEAN menu_visible);
Err MenuGetAttrVisible(ObjectID menu_id, BOOLEAN *menu_visible);
Err MenuCloseMenu();
Err MenuKeyboardHandleMenu(EvtType *Event);
/* ==================================================================== */
/* ============================ SCROLLBAR ================================= */
/* ==================================================================== */
Err ScrollbarEraseScrollbar(ObjectID scrollbar_id);
Err ScrollbarDeleteScrollbar(ObjectID scrollbar_id);
Err ScrollbarGetScrollbar(ObjectID scrollbar_id, WORD *value,
                          WORD *max_value, WORD *min_value,
                          WORD *pagesize, WORD *total_num_lines);
Err ScrollbarSetScrollbar(ObjectID scrollbar_id, WORD scrollbar_value,
						  WORD scrollbar_min_value, WORD scrollbar_max_value,
                          WORD scrollbar_pagesize, WORD scrollbar_total_num_lines);
Err ScrollbarSetType(ObjectID scrollbar_id, BYTE scrollbar_type);
Err ScrollbarSetScrollbarType(ObjectID scrollbar_id, BYTE scrollbar_type);
BYTE ScrollbarGetClickedRegion(Scrollbar *addr,SHORT input_x,SHORT input_y);
Err ScrollbarCalculateCurrentValue(ObjectID scrollbar_id, SHORT input_x, SHORT input_y, WORD *scrollbar_value);
Err ScrollbarCalculateCurrentValue1(ObjectID scrollbar_id,SHORT input_x,SHORT input_y,WORD *scroll_value);
Err ScrollbarDrawScrollbar(ObjectID scrollbar_id);
Err ScrollbarInitScrollbar(ObjectID scollbar_id);
Err ScrollbarSetScrollbarVisible(ObjectID scrollbar_id, BOOLEAN visible);
Err ScrollbarGetScrollbarVisible(ObjectID scrollbar_id, BOOLEAN *visible);
Err ScrollbarGetScrollbarText(ObjectID scrollbar_id, BYTE **scrollbar_text);
Err ScrollbarSetScrollbarText(ObjectID scrollbar_id,BYTE *scrollbar_text);
Err	ScrollbarSetScrollbarDrawPagesize(ObjectID scrollbar_id,SHORT draw_pagesize);
Err ScrollbarHardButtonSetScrollbar(ObjectID scrollbar_id, BYTE UP_DOWN);
SHORT	ScrollbarGetCarStartCoord(Scrollbar *addr, WORD scroll_value);
/* ==================================================================== */
/* ============================ LIST ================================= */
/* ==================================================================== */
Err ListEraseList(ObjectID list_id);
Err ListDeleteList(ObjectID list_id);
Err ListGetNumOfItems(ObjectID list_id, USHORT *num_items);
SHORT ListSearchSelectedItem(List *addr, SHORT input_xcoord, SHORT input_ycoord);
Err ListSetTotalItems (ObjectID list_id,USHORT total_num_items);
Err ListGetListItem(ObjectID list_id,USHORT item_number,BYTE **item_text);
Err ListGetNumItemsDisplay (ObjectID list_id,USHORT *num_items);
Err ListSetNumItemsDisplay (ObjectID list_id,USHORT num_items);
Err ListGetMaxNumItemsDisplay (ObjectID list_id,USHORT *max_num_items);
Err ListSetSelectedItem(ObjectID list_id,SHORT item_num);
Err ListGetSelectedItem(ObjectID list_id,SHORT *item_num);
Err ListSetHighlightedItem(ObjectID list_id,SHORT item_num);
Err ListGetHighlightedItem(ObjectID list_id,SHORT *item_num);
Err ListGetTopItemNum(ObjectID list_id,USHORT *item_num);
Err ListSetTopItemNum(ObjectID list_id,USHORT item_num);
Err ListSetListBounds(ObjectID list_id,ObjectBounds bounds);
Err ListGetListBounds(ObjectID list_id,ObjectBounds *bounds);
Err ListDeleteItem(ObjectID list_id,USHORT item_number);
Err ListInsertItem(ObjectID list_id,USHORT item_number,BYTE *item_text);
Err ListUpdateList(ObjectID list_id,USHORT new_top_num);
USHORT ListClickedRegion(List *addr,SHORT x_input,SHORT y_input);
Err ListSetScrollList(ObjectID list_id,BYTE up_down);
Err ListDrawList (ObjectID list_id);
void ListDrawUpDownArrow(List *addr,ObjectBounds *list_bounds);
Err ListSetAttribute(ObjectID list_id,BOOLEAN att_enable,BOOLEAN att_drawn,
					 BOOLEAN att_active, BOOLEAN att_visible, BOOLEAN att_set_scroll);
Err ListGetAttribute(ObjectID list_id,BOOLEAN *att_enable,BOOLEAN *att_drawn,
					 BOOLEAN *att_active, BOOLEAN *att_visible, BOOLEAN *att_set_scroll);
Err ListInitList(ObjectID list_id);
Err ListDeleteAllItems(ObjectID list_id);
Err ListGetTotalItems (ObjectID list_id,USHORT *total_num_items);
Err ListRecalculateMaxNumItemsDisplay(ObjectID list_id);
void ListDrawBackgroundBox (List *addr,ObjectBounds bounds,USHORT list_border);
Err ListHighlightOneItem (List *addr, SHORT item_num, BOOLEAN item_onoff);
Err ListSetFont(ObjectID list_id, BYTE font);
/* ==================================================================== */
/* ============================ FIELD ================================= */
/* ==================================================================== */
Err FieldGetTotalNumOfLines(ObjectID field_id, WORD *total_num_lines);
Err FieldGetNumOfLinesDisplayed(ObjectID field_id, WORD *num_lines_displayed);
Err FieldGetTopLineNum(ObjectID field_id, WORD *line_num);
Err FieldDirty(ObjectID field_id, BOOLEAN *dirty);
Err FieldEraseField(ObjectID field_id);
Err FieldGetFieldBounds(ObjectID field_id, ObjectBounds *bounds);
Err FieldGetInsertPointPosition(ObjectID field_id, WORD *char_pos);
Err FieldDeleteField(ObjectID field_id);
Err FieldGetCurrentHighlightedSelection(ObjectID field_id, WORD *star_char_pos,
										WORD *end_char_pos);
Err FieldScrollField(ObjectID field_id, WORD line_to_scroll);
Err FieldSendHeightChangeNotification(ObjectID field_id);
Err FieldSetBounds(ObjectID field_id, ObjectBounds bounds);
Err FieldSetFont(ObjectID field_id, BYTE font);
Err FieldSetInsertPointOn(ObjectID field_id);
Err FieldSetInsertPointOff(ObjectID field_id);
Err FieldSetText(ObjectID field_id, BYTE *in_string);
Err FieldGetAttribute(ObjectID field_id, FieldAttr *field_attr);
Err FieldGetFont(ObjectID field_id, BYTE *font_id);
Err FieldGetMaxNumChars(ObjectID field_id, WORD *max_num_of_chars);
Err FieldGetTextPointer(ObjectID field_id, BYTE **text_ptr);
Err FieldGetNumOfChars(ObjectID field_id, WORD *num_chars);
Err FieldSetScrollbarAttribute(ObjectID field_id, BOOLEAN has_scrollbar);
Err FieldGetScrollbarAttribute(ObjectID field_id, BOOLEAN *has_scrollbar);
Err FieldSetAttribute(ObjectID field_id, FieldAttr input_field_attr);
Err FieldSetDirty(ObjectID field_id, BOOLEAN field_dirty);
Err FieldSetInsertPointPositionByXY(ObjectID field_id, SHORT insert_xcoord, SHORT insert_ycoord);
Err FieldSetInsertPointPositionByCharPos(ObjectID field_id, WORD char_pos);
Err FieldSetTopLineNum(ObjectID field_id, WORD top_line_num);
Err FieldSetMaxNumChars(ObjectID field_id, WORD max_num_of_chars);
Err FieldSetHighlightSelection(ObjectID field_id, WORD start_char, WORD stop_char);
BOOLEAN FieldSendChangeNotification(ObjectID field_id);
Err FieldDrawField (ObjectID field_id);
Err FieldDrawField2 (ObjectID field_id);
Err FieldCopy (ObjectID field_id);
Err FieldCut (ObjectID field_id);
Err FieldDelete (ObjectID field_id, WORD start_char, WORD cut_length);
Err FieldInsert (ObjectID field_id, WORD *paste_size);
Err FieldInsertText (ObjectID field_id, BYTE *insert_string, WORD field_len);
void FieldInsertFunction (Field *addr, BYTE *paste_text, WORD paste_size);
void FieldCutSelectedText (Field *addr);
Err FieldGetNumBlankLines (ObjectID field_id, UWORD *num_blank_line);
Err FieldUndo (ObjectID field_id);
Err FieldGetFirstVisibleChar (ObjectID field_id, WORD *char_pos);
Err FieldGetLastVisibleChar (ObjectID field_id, WORD *char_pos);
Err FieldGetDisplayRowNum (ObjectID field_id, SHORT input_y, WORD *row_num);
Err FieldInsertPtMove (ObjectID field_id);
Err FieldCharPosToLineNum (Field *addr, WORD char_pos, WORD *line_num);
Err FieldAddKeyInChar(ObjectID field_id, BYTE key);
Err FieldInitField(ObjectID field_id);
Err FieldGetMaxNumLinesDisplay(ObjectID field_id, WORD *max_num_lines);
Err FieldStoreBackspaceChar(ObjectID field_id, UBYTE character);
Err FieldRestoreBackspaceChar(ObjectID field_id, UBYTE *character);

Err FieldPasteString(ObjectID field_id, BYTE *paste_string);
Err FieldInsertString(ObjectID field_id, BYTE *paste_string);
Err FieldDeleteString(ObjectID field_id, WORD start_char, WORD cut_length);
void FieldCutBackspaceHighlightText(Field *addr);

/* ==================================================================== */
/* ============================ ClipBoard ================================= */
/* ==================================================================== */
Err ClipboardPutItem(BYTE data_type, void *data_ptr, WORD data_size);
Err ClipboardEraseItem();
void *ClipboardGetItem(BYTE *data_type, WORD *data_size);
/* ==================================================================== */
/* ============================ Keyboard ================================= */
/* ==================================================================== */
void KeyboardInitKeyboard();
void KeyboardDrawKeyboard();
void KeyboardDrawKeyboardBitmap(BYTE bitmap_index);
UBYTE KeyboardGetClickedKey(SHORT xcoord, SHORT ycoord);
void KeyboardRestoreBitBehind();
void KeyboardSaveBehindBits();
void KeyboardSendEvent(UBYTE key, BOOLEAN cap, BOOLEAN shift, BOOLEAN international);
Err KeyboardDrawInvertKey(UBYTE key);
void KeyboardRemoveKeyboard();
BOOLEAN KeyboardCheckKeyboardStatus();
void KeyboardSetKeyboardStatus(BOOLEAN status);
void KeyboardSetKeyboardVisible();
void KeyboardSetKeyboardInvisible();
/* ==================================================================== */
/* ============================ SCHEDULE LINE ========================= */
/* ==================================================================== */
Err SchlineEraseSchline(ObjectID schline_id);
Err SchlineDeleteSchline(ObjectID schline_id);
Err SchlineSetAttribute(ObjectID schline_id,BOOLEAN schline_drawn,BOOLEAN schline_visible,
					    BOOLEAN schline_active, BOOLEAN schline_enable, BOOLEAN schline_enter);
Err SchlineGetAttribute(ObjectID schline_id,BOOLEAN *drawn,BOOLEAN *visible, BOOLEAN *active, 
						BOOLEAN *enable, BOOLEAN *enter);
SHORT SchlineGetClickedRegion(Schline *addr,SHORT input_x,SHORT input_y);
Err SchlineDrawSchline(ObjectID schline_id);
//Err SchlineSetDateText (ObjectID schline_id, BYTE date_num, BYTE *date_text);
Err SchlineGetDateText (ObjectID schline_id, BYTE date_num, BYTE **date_text);
//Err SchlineSetDateSchedule (ObjectID schline_id, BYTE date_num, BYTE *date_state);
//Err SchlineGetDateSchedule (ObjectID schline_id, BYTE date_num, BYTE **date_state);
Err SchlineSetDateBitmaps (ObjectID schline_id, BYTE date_num, BYTE *date_bitmaps);
Err SchlineGetDateBitmaps (ObjectID schline_id, BYTE date_num, BYTE *date_bitmaps);
Err SchlineInitSchline(ObjectID schline_id);
Err SchlineSetLineState(ObjectID schline_id, SHORT line_num, SHORT section_num);
Err SchlineSetLineLabel(ObjectID schline_id, SHORT line_num, BYTE *schline_label);
Err SchlineSetLineBitmap(ObjectID schline_id, SHORT line_num, SHORT section_num, BYTE bitmap_num);
Err SchlineSetHighlightText(ObjectID schline_id, SHORT line_num);
Err SchlineSetHourSettings(ObjectID schline_id, BOOLEAN hour_mode);
Err SchlineDrawSmallSector(Schline *schline_addr, SHORT line_num, SHORT section_num);

/* ==================================================================== */
/* ============================ Textbox ================================= */
/* ==================================================================== */
Err TextboxGetNumOfCharsDisplayed(ObjectID textbox_id, WORD *num_chars);
Err TextboxDirty(ObjectID textbox_id, BOOLEAN *dirty);
Err TextboxEraseTextbox(ObjectID textbox_id);
Err TextboxGetTextboxBounds(ObjectID textbox_id, ObjectBounds *bounds);
Err TextboxGetInsertPointPosition(ObjectID textbox_id, WORD *char_pos);
Err TextboxDeleteTextbox(ObjectID textbox_id);
Err TextboxGetCurrentHighlightedSelection(ObjectID textbox_id, WORD *star_char_pos,
                                        WORD *end_char_pos);
Err TextboxSetBounds(ObjectID textbox_id, ObjectBounds bounds);
Err TextboxSetFont(ObjectID textbox_id, BYTE font);
Err TextboxSetInsertPointOff(ObjectID textbox_id);
Err TextboxSetInsertPointOn(ObjectID textbox_id);
Err TextboxSetText(ObjectID textbox_id, BYTE *string);
Err TextboxGetAttribute(ObjectID textbox_id, TextboxAttr *textbox_attr);
Err TextboxGetFont(ObjectID textbox_id, BYTE *font_id);
Err TextboxGetMaxNumChars(ObjectID textbox_id, WORD *max_num_of_chars);
Err TextboxGetTextPointer(ObjectID textbox_id, BYTE **text_ptr);
Err TextboxGetNumOfChars(ObjectID textbox_id, WORD *num_chars);
Err TextboxSetAttribute(ObjectID textbox_id, TextboxAttr input_textbox_attr);
Err TextboxSetDirty(ObjectID textbox_id, BOOLEAN textbox_dirty);
Err TextboxSetInsertPointPositionByXY(ObjectID textbox_id, SHORT insert_xcoord, SHORT insert_ycoord);
Err TextboxSetInsertPointPositionByCharPos(ObjectID textbox_id, WORD char_pos);
Err TextboxSetMaxNumChars(ObjectID textbox_id, WORD max_num_of_chars);
Err TextboxSetHighlightSelection(ObjectID textbox_id, WORD start_char, WORD stop_char);
Err TextboxDrawTextbox (ObjectID textbox_id);
Err TextboxDrawTextbox2(ObjectID textbox_id);
Err TextboxCopy (ObjectID textbox_id);
Err TextboxCut (ObjectID textbox_id);
Err TextboxInsert (ObjectID textbox_id, WORD *paste_size);
Err TextboxInsertText (ObjectID textbox_id, BYTE *insert_string, WORD textbox_len);
void TextboxInsertFunction (Textbox *addr, BYTE *paste_text, WORD paste_size);
void TextboxCutSelectedText (Textbox *addr);
Err TextboxDelete (ObjectID textbox_id, WORD start_char, WORD cut_length);
Err TextboxUndo (ObjectID textbox_id);
Err TextboxInsertPtMove (ObjectID textbox_id);
Err TextboxAddKeyInChar(ObjectID textbox_id, BYTE key);
Err TextboxGetLeftCharPos(ObjectID textbox_id, WORD *left_char_pos);
Err TextboxGetRightCharPos(ObjectID textbox_id, WORD *right_char_pos);
Err TextboxSetLeftCharPos(ObjectID textbox_id, WORD left_char_pos);
Err TextboxSetRightCharPos(ObjectID textbox_id, WORD right_char_pos);
Err TextboxInitTextbox(ObjectID textbox);
void TextboxDrawRoundTextbox(ObjectBounds *bounds);
Err TextboxStoreBackspaceChar(ObjectID textbox_id, UBYTE character);
Err TextboxRestoreBackspaceChar(ObjectID textbox_id, UBYTE *character);

Err TextboxPasteString(ObjectID textbox_id, BYTE *paste_string);
Err TextboxInsertString(ObjectID textbox_id, BYTE *paste_string);
Err TextboxDeleteString(ObjectID textbox_id, WORD start_char, WORD cut_length);
void TextboxCutBackspaceHighlightText(Textbox *addr);

#endif
