/* history.c - HelioFrotz History Dialog
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <system.h>
#include <string.h>
#include "res/resource.h"
#include "frotz.h"
#include "heliofro.h"
#include "../stdlib/fnt.h"

static char *strsave;
static char hist1[200];
static char hist2[200];
static char hist3[200];
static char hist4[200];
static char hist5[200];

int DoHistory(char *buff)
{
  EvtType event;

  strsave = buff;
  FormPopupForm(FORM_HIST);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP) {PowerOff(); break;}
  } while (event.eventType!=EVT_FORM_CLOSE);
  if (event.eventType!=EVT_APP_STOP) FormPopupForm(FORM_MAIN);
  return event.eventType;
}


BOOLEAN FormHistoryHandleEvent(EvtType* event)
{
  char *inject;

  switch(event->eventType) {
  case EVT_FORM_OPEN:
    FormSaveBehindBits(FORM_HIST);
    ControlSetLabel(HIST_LAST1, hist5);
    ControlSetLabel(HIST_LAST2, hist4);
    ControlSetLabel(HIST_LAST3, hist3);
    ControlSetLabel(HIST_LAST4, hist2);
    ControlSetLabel(HIST_LAST5, hist1);
    FormDrawForm(FORM_HIST);
    break;

  case EVT_BITMAP_SELECT:
    FormRestoreBitBehind(FORM_HIST);
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_HIST, 0, 0, NULL);
    break;

  case EVT_CONTROL_SELECT:
    switch (event->eventID) {
    case HIST_CANCEL:inject = NULL; break; 
    case HIST_LAST1: inject = hist5; break;
    case HIST_LAST2: inject = hist4; break;
    case HIST_LAST3: inject = hist3; break;
    case HIST_LAST4: inject = hist2; break;
    case HIST_LAST5: inject = hist1; break;
    default: inject=NULL; break;
    }
    if (inject) {
      if (strsave[strlen(strsave)-1]!=' ' && strlen(strsave)>0) strcat(strsave," ");
      strcat(strsave, inject);
      FntBeep();
    }
    FormRestoreBitBehind(FORM_HIST);
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_HIST, 0, 0, NULL);
    break;

  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_EXIT:
      FormRestoreBitBehind(FORM_HIST);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_HIST, 0, 0, NULL);
      break;
    default:
      return FALSE;
    }
    break;

  default:
    return FALSE;
  }
  return FALSE;
}

void UpdateHistory(char *string) 
{
  if (string[0]) {
    strncpy(hist5, hist4, 200);
    strncpy(hist4, hist3, 200);
    strncpy(hist3, hist2, 200);
    strncpy(hist2, hist1, 200);
    strncpy(hist1, string, 200);
  }
}
