/* grayscal.app V1.4 */
/* Earle F. Philhower, III */
/* http://www.ziplabel.com    earle@ziplabel.com */
/* To be used w/makegray */

#include "main.h"
#include "..\stdlib\my_stdio.h"
#include "..\stdlib\fnt.h"

#define EVT_MOVEIT 0xbabe
#define TIMERDELAY 300

static int invert = 0;
static BYTE openimage[64];
static int offx, offy;
static int xsize, ysize, bigxsize, bigysize;
static BYTE *mem = NULL;
static int xoff, yoff;
static int oldimage = 1;
static int zoom = 0;
static UWORD timer = 0;
static int listsel = 0;


void TimerCallback();
void SetList(int);
void CenterList(int);
BOOLEAN FormImageHandleEvent(EvtType*);
BOOLEAN FormAboutHandleEvent(EvtType*);
extern void CpuChangeSpeed(int);

int __main(WORD cmd, void *cmd_arg)
{
  switch(cmd) {
  case LAUNCH_CMD_NORMAL_LAUNCH:
    UIApplicationInit();		//initialize UI resources
    FormPopupForm(FORM_MAIN);	        //start main form
    EventLoop();			//run main event loop
    UIDeleteAllAppObjects();	        //main event loop has stopped, cleanup
    break;
  case LAUNCH_CMD_GOTO_REC:
    if(((GotoRec*)cmd_arg)->find_string)
      pfree(((GotoRec*)cmd_arg)->find_string);
  case LAUNCH_CMD_FIND:
  case LAUNCH_CMD_ALARM_HIT:
    pfree(cmd_arg);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

void EventLoop(void)
{
  EvtType event;

  while(1) {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if(event.eventType==EVT_APP_STOP) break;
  }
}


BOOLEAN ApplicationHandleEvent(EvtType *event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(event->eventType) {
  case EVT_FORM_LOAD:
    if((event->para1==1)||(UISearchForAddress((ObjectID)event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects((ObjectID)event->eventID);
    if(UISearchForAddress((ObjectID)event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)event->eventID) {
    case FORM_MAIN: evtHandler = (void*)FormMainHandleEvent; break;
    case FORM_IMAGE: evtHandler = (void*)FormImageHandleEvent; break;
    case FORM_ABOUT: evtHandler = (void*)FormAboutHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler((ObjectID)event->eventID,(void**)&FormDispatchEvent,evtHandler);
    FormSetActiveForm((ObjectID)event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}


void LoadImage(char *name)
{
  FILE *fp;
  UWORD size;
  USHORT vers;
  AppID own;
  RTM crdt, bkdt;
  BYTE dbname[80], ownstr[80], *ptr;
  DatabaseID dbid;
  BYTE *bufptr;
  RecordID rec_id;
  unsigned char a,b,c,d;

  DataFindDB(name, &dbid);
  DataDBInfo(dbid, &vers, &own, &crdt, &bkdt, dbname, ownstr);
  if (strcmp(ownstr, "GrayscaleFile")==0) {
    DataOpenDB(dbid, 0, OPEN_RO);
    DataOpenRecord(dbid, 0, &rec_id, NULL);
    DataReadField(dbid, rec_id, 0, 0, READ_TO_END, &bufptr, &size);
    ptr = bufptr;
    xsize = 255&(*ptr);
    ptr+=4;
    ysize = 255&(*ptr);
    ptr+=4;
    mem = qmalloc(size-8);
    memcpy(mem, ptr, size-8);
    qfree(bufptr);
    DataCloseRecord(dbid, rec_id);
    DataCloseDB(dbid);
    oldimage = 1;
  } else {
    fp=fopen(name, "rb");
    if (fp==NULL) return;
    a=fgetc(fp);
    b=fgetc(fp);
    c=fgetc(fp);
    d=fgetc(fp);
    bigxsize=(a<<24)|(b<<16)|(c<<8)|(d<<0);
    a=fgetc(fp);
    b=fgetc(fp);
    c=fgetc(fp);
    d=fgetc(fp);
    bigysize=(a<<24)|(b<<16)|(c<<8)|(d<<0);

    fseek(fp, 8+((bigxsize*4)*bigysize), SEEK_SET);
    
    a=fgetc(fp);
    b=fgetc(fp);
    c=fgetc(fp);
    d=fgetc(fp);
    xsize=(a<<24)|(b<<16)|(c<<8)|(d<<0);
    a=fgetc(fp);
    b=fgetc(fp);
    c=fgetc(fp);
    d=fgetc(fp);
    ysize=(a<<24)|(b<<16)|(c<<8)|(d<<0);
    mem = qmalloc(xsize*4*ysize);
    fread(mem, 1, xsize*4*ysize, fp);
    oldimage = 0;
    fclose(fp);
  }
}

void DrawImage(char *savename)
{
  FILE *fp;
  int i, y;
  UWORD *lcd;
  BYTE *ptr;
  BYTE *space;
  UWORD *spaceword;
  int drawysize, drawxsize;

  CpuChangeSpeed(0);

  if ((yoff+160)>bigysize) drawysize = bigysize-yoff;
  else if (bigysize>160) drawysize = 160;
  else drawysize = bigysize;

  if ((xoff+20)>bigxsize) drawxsize = bigxsize-xoff;
  else if (bigxsize>20) drawxsize = 20;
  else drawxsize = bigxsize;

  lcd=LcdGetLcdMemAddress();
  if (oldimage || (!oldimage && !zoom)) {
    for (y=0; y<ysize; y++) {
      ptr = mem + (y*xsize*4);
      spaceword = (UWORD*)ptr;
      if (invert)
	for (i=0; i<xsize; i++) lcd[i] = spaceword[i] ^ 0xffffffff;
      else
	for (i=0; i<xsize; i++) lcd[i] = spaceword[i];
      if (invert) {for (i=xsize; i<20; i++) lcd[i] = 0xffffffff;}
      else { for (i=xsize; i<20; i++) lcd[i] = 0x00000000; }
      lcd += 20;
    }
  } else {
    fp = fopen(savename, "rb");
    space = qmalloc(drawxsize*4);
    spaceword = (UWORD*)space;
    for (y=0; y<drawysize; y++) {
      fseek(fp, 8+((yoff+y)*bigxsize*4) + xoff*4, SEEK_SET);
      fread(space, 1, drawxsize*4, fp);
      if (invert)
	for (i=0; i<drawxsize; i++) lcd[i] = spaceword[i] ^ 0xffffffff;
      else
	for (i=0; i<drawxsize; i++) lcd[i] = spaceword[i];
      if (invert) { for (i=drawxsize; i<20; i++) lcd[i] = 0xffffffff; }
      else { for (i=drawxsize; i<20; i++) lcd[i] = 0x00000000; }
      lcd += 20;
    }
    fclose(fp);
    qfree(space);
  }

  if (invert) {
    for (; y<160; y++) {
      for (i=0; i<20; i++)
	lcd[i] = 0xffffffff;
      lcd += 20;
    }
  } else {
    for (; y<160; y++) {
      for (i=0; i<20; i++) lcd[i] = 0x00000000;
      lcd += 20;
    }
  }
}



void SaveResumeFile()
{
  FILE *file;

  unlink("GrayscalResume14");
  file = fopen("GrayscalResume14","wb");
  if (file) {
    fwrite(openimage, 1, 64, file);
    fwrite(&xoff, 1, sizeof(int), file);
    fwrite(&yoff, 1, sizeof(int), file);
    fwrite(&invert, 1, sizeof(int), file);
    fwrite(&zoom, 1, sizeof(int), file);
    fclose(file);
  }
}

int CheckResumeFile()
{
  FILE *file;

  openimage[0]=0;
  file = fopen("GrayscalResume14","rb");
  if (file) {
    fread(openimage, 1, 64, file);
    fread(&xoff, 1, sizeof(int), file);
    fread(&yoff, 1, sizeof(int), file);
    fread(&invert, 1, sizeof(int), file);
    fread(&zoom, 1, sizeof(int), file);
    fclose(file);
  }
  unlink("GrayscalResume14");
  
  if (openimage[0]) {
    file = fopen(openimage,"rb");
    if (!file) openimage[0] = 0;
    else fclose(file);
  }
  return openimage[0];
}


BOOLEAN FormMainHandleEvent(EvtType* event)
{
  SHORT item,curtop,viewnum,total;
  BYTE *ptr;
  static int setup = 0;

  switch(event->eventType) {
  case EVT_FORM_OPEN:
    if (!setup) {
      ListDeleteAllItems(LIST_MAIN);
      ListAllDBs("GrayscaleFile", LIST_MAIN);
      ListAllDBs("GrayscaleFile2", LIST_MAIN);
      ListSetSelectedItem(LIST_MAIN, NO_SELECTION);
      setup = 1;
      listsel = 0;
    }
   if (CheckResumeFile()) {
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_MAIN, 0, 0, NULL);
      FormPopupForm(FORM_IMAGE);
      break;
    }
    if (mem) qfree(mem);
    mem = NULL;
    zoom=0;
    FormDrawForm(event->eventID);
    xoff = 0;
    yoff = 0;
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(event->eventID, event->para1);
    ListSetHighlightedItem(event->eventID, listsel = event->para1);
    ListDrawList(event->eventID);
    return TRUE;
		
  case EVT_MENU_SELECT_ITEM:
    if (event->para1==0) FormPopupForm(FORM_ABOUT);
    break;

  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormGotoApp("Mainmenu");
      break;
    case INLAY_OK:
      EvtAppendEvt(EVT_CONTROL_SELECT, OPEN_BUTTON, 0, 0, NULL);
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    ListGetTotalItems(LIST_MAIN, &item);
    if (item==0) break;
    ListGetSelectedItem(LIST_MAIN, &item);
    if (item == NO_SELECTION) return TRUE;
    ListGetListItem(LIST_MAIN, item, (BYTE **)&ptr);
    switch (event->eventID) {
    case OPEN_BUTTON:
      strcpy(openimage, ptr);
      FormPopupForm(FORM_IMAGE);
      break;
    case DELETE_BUTTON:
      unlink(ptr);
      ListDeleteAllItems(LIST_MAIN);
      ListAllDBs("GrayscaleFile", LIST_MAIN);
      ListAllDBs("GrayscaleFile2", LIST_MAIN);
      ListSetSelectedItem(LIST_MAIN, NO_SELECTION);
      ListDrawList(LIST_MAIN);
      break;
      break;
    }
    break;
		
  case EVT_IO_KEY_CTRL:
    if (event->eventID == EVT_IO_KEY_PRESS || event->eventID == EVT_IO_KEY_REPEAT) {
      ListGetTotalItems(LIST_MAIN, &total);
      ListGetNumItemsDisplay(LIST_MAIN,&viewnum);

      ListGetTopItemNum(LIST_MAIN, &curtop);
      if (event->para2 == IO_DOWN_ARROW)
	ListSetScrollList(LIST_MAIN,MOVE_DOWN);
      else if (event->para2 == IO_UP_ARROW)
	ListSetScrollList(LIST_MAIN,MOVE_UP);
      ListGetTopItemNum(LIST_MAIN, &item);
      if (curtop != item) {
        SetList(item);
      } else if (total<=viewnum) {
        if (event->para2 == IO_DOWN_ARROW)
	  SetList(listsel+1);
        else if (event->para2 == IO_UP_ARROW)
	  SetList(listsel-1);
      }
      ListDrawList(LIST_MAIN);
    }
    break;

  default:
    return FALSE;
  }
  return TRUE;
}

BOOLEAN FormAboutHandleEvent(EvtType* event)
{
  switch(event->eventType) {
  case EVT_FORM_OPEN:
    FormSaveBehindBits(event->eventID);
    FormDrawForm(event->eventID);
    break;

  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_OK:
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormRestoreBitBehind(FORM_ABOUT);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_ABOUT, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}

void AddTimerEvent()
{
  int zx, zy;

  zx=zy=0;
  xoff += offx;
  yoff += offy;
  if (xoff>=bigxsize) {xoff--; zx=1;}
  if (xoff<0) {zx=1; xoff++;}
  if (yoff>=bigysize) {zy=1;yoff -= 8;}
  if (yoff<0) {zy=1;yoff +=8;}
  if (offx || offy) DrawImage(openimage);
  if (zx) offx=0;
  if (zy) offy=0;
  timer = TmrIntEnable(TIMERDELAY,TimerCallback);
}

void TimerCallback()
{
  TmrIntDisable(timer);
  EvtAppendEvt(EVT_MOVEIT, 0, 0, 0, NULL);
}

void SetList(int img)
{
  SHORT total;

  ListGetTotalItems(LIST_MAIN, &total);
  if (img>=total) img=0;
  if (img<0) img=total-1;
  
  listsel=img;

  ListSetSelectedItem(LIST_MAIN, listsel);
  ListSetHighlightedItem(LIST_MAIN, listsel);

}

void CenterList(int img)
{
  SHORT viewnum,total;
  int topnum;

  ListGetNumItemsDisplay(LIST_MAIN,&viewnum);

  ListGetTotalItems(LIST_MAIN, &total);
  if (img>=total) img=0;
  if (img<0) img=total-1;
  
  listsel=img;

  ListSetSelectedItem(LIST_MAIN, listsel);
  ListSetHighlightedItem(LIST_MAIN, listsel);

  topnum=listsel-(viewnum/2)+1;
  if (topnum<0) topnum=0;

  if (topnum+viewnum>total) {
    topnum=total-viewnum;
    if (topnum<0) topnum=listsel;
  }

  ListSetTopItemNum(LIST_MAIN,topnum);

}

void GoToImage(int img)
{
  BYTE *ptr;

  CenterList(img);
  ListGetListItem(LIST_MAIN, listsel, (BYTE **)&ptr);

  strcpy(openimage, ptr);
  if (mem) qfree(mem);
  mem=NULL;
  LoadImage(openimage);
  offx = 0;
  offy = 0;
  zoom = 0;
  DrawImage(openimage);
}

BOOLEAN FormImageHandleEvent(EvtType* event)
{
  static int lastx, lasty;
  int dist;


  switch(event->eventType) {
  case EVT_FORM_OPEN:
    LcdSetColorMode(GREYSCALE_MODE);
    FormDrawForm(event->eventID);
    LoadImage(openimage);
    offx = 0;
    offy = 0;
    DrawImage(openimage);
    timer = TmrIntEnable(TIMERDELAY,TimerCallback);
    break;

  case EVT_MOVEIT:
    AddTimerEvent();
    return TRUE;

  case PEN_EVENT:
    switch (event->eventID) {
    case PEN_DOWN:
      lastx = event->para1;
      lasty = event->para2;
      break;
    case PEN_UP:
      dist=(event->para1 - lastx)*(event->para1 - lastx) + (event->para2 - lasty)*(event->para2 - lasty);
      if (dist<20) {
	if (zoom) {
	  if (lastx>((160*3)/4))      offx = 1;
	  else if (lastx<((160*1)/4)) offx = -1;
	  else                        offx = 0;
	  if (lasty>((160*3)/4))      offy = +8;
	  else if (lasty<((160*1)/4)) offy = -8;
	  else                        offy = 0;
	  xoff += offx;
	  yoff += offy;
	  if (xoff>=bigxsize) xoff--;
	  if (xoff<0) xoff++;
	  if (yoff>=bigysize) yoff -= 8;
	  if (yoff<0) yoff +=8;
	  DrawImage(openimage);
	  FntBeep();
	  return TRUE;
	} else {
	  double pctx, pcty;
	  if ((lastx/8)>=xsize || lasty>=ysize) return FALSE;
	  offx = 0;
	  offy = 0;
	  zoom = 1;
	  pctx = (double)(lastx/8)/(double)xsize;
	  pcty = (double)lasty/(double)ysize;
	  xoff = pctx*bigxsize;
	  yoff = pcty*bigysize;
	  xoff -= 80/8;
	  yoff -= 80;
	  if (xoff<0) xoff=0;
	  if (yoff<0) yoff=0;
	  DrawImage(openimage);
	  FntBeep();
	}
      }
      break;
    }
		
  case EVT_MENU_SELECT_ITEM:
    switch (event->para1) {
    case 0:
      zoom = zoom?0:1;
      offx = 0;
      offy = 0;
      xoff=0;
      yoff=0;
      DrawImage(openimage);
      break;
    case 1:
      invert = invert?0:1;
      DrawImage(openimage);
      break;
    case 2:
      LcdSetColorMode(BLACK_AND_WHITE_MODE);
      if (mem) qfree(mem);
      mem = NULL;
      FormPopupForm(FORM_MAIN);
     break;
    }
    return TRUE;

  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_EXIT:
    case INLAY_OK:
      if (zoom) {
	zoom=0;
	offx = 0;
	offy = 0;
	xoff=0;
	yoff=0;
	DrawImage(openimage);
      } else {
	LcdSetColorMode(BLACK_AND_WHITE_MODE);
	FormPopupForm(FORM_MAIN);
	if (mem) qfree(mem);
	mem = NULL;
      }
      return TRUE;
    case INLAY_MAIN_MENU:
      LcdSetColorMode(BLACK_AND_WHITE_MODE);
      FormGotoApp("Mainmenu");
      if (mem) qfree(mem);
      mem = NULL;
      break;
    default:
      return FALSE;
    }
    break;

  case EVT_IO_KEY_CTRL:
    if (event->eventID == EVT_IO_KEY_PRESS || event->eventID == EVT_IO_KEY_REPEAT) {
      if (event->para2 == IO_DOWN_ARROW)
	GoToImage(listsel+1);
      else if (event->para2 == IO_UP_ARROW)
	GoToImage(listsel-1);
    }
    break;

  case EVT_APP_STOP:
    SaveResumeFile();
    break;

  default:
    return FALSE;
  }
  return TRUE;
}



void FormGotoApp(BYTE* app_name)
{
  ObjectID objid;

  FormGetActiveFormID(&objid);
  EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
  SysGetAppID(app_name,&objid);
  EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
  EvtAppendEvt(EVT_APP_LAUNCH,objid,0,0,NULL);
}
