#include <system.h>
#include "..\stdlib\my_stdio.h"
#include "..\stdlib\fnt.h"
#include "makeres.h"

static int doneabout=0;
static int madeabout=0;

typedef enum {FORM_ABOUT=3990, ABOUT_CANCEL, A1, A2, A3, A4, A5} ABOUTIDS;
static BOOLEAN FormAboutHandleEvent(EvtType* event);

static BOOLEAN AboutApplicationHandleEvent(EvtType *event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(event->eventType)  {
  case EVT_FORM_LOAD:
    if((event->para1==1)||(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects(event->eventID);
    if(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)event->eventID) {
    case FORM_ABOUT: evtHandler = (void*)FormAboutHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler(event->eventID, (void*)&FormDispatchEvent, evtHandler);
    FormSetActiveForm(event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

static void MakeAbout(char *title, char *l1, char *l2, char *l3, char *l4, char *l5) 
{
  MakeForm(FORM_ABOUT, 1, 40, 158, 79, NON_BITMAP_DIALOG, title, NULL);
  MakeButton0(ABOUT_CANCEL, 145, 41, 11, 11, "X", TRUE);
  MakeString(A1, 5, 60, 150, 10, CENTRE_ALIGN, l1, FALSE);
  MakeString(A2, 5, 70, 150, 10, CENTRE_ALIGN, l2, FALSE);
  MakeString(A3, 5, 80, 150, 10, CENTRE_ALIGN, l3, FALSE);
  MakeString(A4, 5, 90, 150, 10, CENTRE_ALIGN, l4, FALSE);
  MakeString(A5, 5, 100, 150, 10, CENTRE_ALIGN, l5, FALSE);
  FormAddOneObject(FORM_ABOUT, ABOUT_CANCEL, CONTROL);
  FormAddOneObject(FORM_ABOUT, A1, STRING);
  FormAddOneObject(FORM_ABOUT, A2, STRING);
  FormAddOneObject(FORM_ABOUT, A3, STRING);
  FormAddOneObject(FORM_ABOUT, A4, STRING);
  FormAddOneObject(FORM_ABOUT, A5, STRING);
  madeabout = 1;
}


static BOOLEAN FormAboutHandleEvent(EvtType* event)
{
  switch(event->eventType) {
  case EVT_FORM_OPEN:
    StippleBackground();
    FormDrawForm(FORM_ABOUT);
    ControlDrawControl(ABOUT_CANCEL);
    break;
    
  case EVT_CONTROL_SELECT:
    if (event->eventID == ABOUT_CANCEL) doneabout = 1;
    return TRUE;

  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_OK:
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      doneabout = 1;
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}


int DoAbout(char *title, char *l1, char *l2, char *l3, char *l4, char *l5)
{
  EvtType event;
  void *back;
  ObjectID oldForm;
  int old;

  old = FormGetActiveFormID(&oldForm);
  doneabout=0;
  if (!madeabout) MakeAbout(title, l1, l2, l3, l4, l5);
  back = SaveBackground();

  FormPopupForm(FORM_ABOUT);	        //start main form
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(AboutApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
  } while(!doneabout && event.eventType!=EVT_APP_STOP);
  RestoreBackground(back);
  if (old) FormPopupForm(oldForm);
  return event.eventType;
}


