#include <system.h>
#include <stdio.h>
#include <stdlib.h>
#include "..\stdlib\my_stdio.h"
#include "..\stdlib\fnt.h"
#include "yesno.h"
#include "makeres.h"

static int demunged = 0;
static char fontico[] = {
  0x00,0x00,0x00,0x00,0x00, 0, 0, 0,
  0x0f,0xff,0xff,0xff,0xf0, 0, 0, 0,
  0x00,0xff,0x00,0x0f,0xf0, 0, 0, 0,
  0xf0,0xff,0x00,0x00,0x00, 0, 0, 0,
  0xf0,0xff,0x00,0xf0,0xff, 0, 0, 0,
  0xf0,0xff,0xff,0xf0,0xff, 0, 0, 0,
  0xf0,0xff,0x00,0xf0,0xff, 0, 0, 0,
  0xf0,0xff,0x00,0x00,0xff, 0, 0, 0,
  0xf0,0xff,0x0f,0xff,0xff, 0, 0, 0,
  0x00,0xff,0x00,0xff,0xff, 0, 0, 0,
  0x0f,0xff,0xf0,0xff,0xff, 0, 0, 0,
  0x00,0x00,0x00,0xff,0xff, 0, 0, 0 };


static BOOLEAN FormFontHandleEvent(EvtType* event);
typedef enum {FORM_FONT=3910, STRING_FONT, LIST_FONT, OPEN_FONT, DELETE_FONT,
	      FONT_CANCEL} FONTIDS;

static BOOLEAN FontApplicationHandleEvent(EvtType *event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(event->eventType)  {
  case EVT_FORM_LOAD:
    if((event->para1==1)||(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects(event->eventID);
    if(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)event->eventID) {
    case FORM_FONT: evtHandler = (void*)FormFontHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler(event->eventID, (void*)&FormDispatchEvent, evtHandler);
    FormSetActiveForm(event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

static char *fonttitle;
static int wantfixed;
static int *fntptr;
static char *fntname;
static int madefont=0;
static int donefont=0;

static void MakeFont()
{
  if (!demunged) DeMunge(fontico, sizeof(fontico));
  demunged=1;
  MakeForm(FORM_FONT, 0, 0, 160, 160, 1, "Font Chooser", fontico);
  MakeString(STRING_FONT, 5, 20, 150, 9, CENTRE_ALIGN, "Select", FALSE);
  MakeList(LIST_FONT, 5, 32, 150, 104, LEFT_ALIGN, 8);
  MakeButton(OPEN_FONT, 10, 141, 65, 14, "Select Font");
  MakeButton(DELETE_FONT, 85, 141, 65, 14, "Delete Font");
  MakeButton0(FONT_CANCEL, 148, 1, 11, 11, "X", TRUE);
  FormAddOneObject(FORM_FONT, STRING_FONT, STRING);
  FormAddOneObject(FORM_FONT, LIST_FONT, LIST);
  FormAddOneObject(FORM_FONT, OPEN_FONT, CONTROL);
  FormAddOneObject(FORM_FONT, DELETE_FONT, CONTROL);
  FormAddOneObject(FORM_FONT, FONT_CANCEL, CONTROL);
  madefont = 1;
}

void ChangeToFont(char *str)
{
  char buff[100];

  if (strcmp(str, "Small Fixed Font")==0) {
    *fntptr = smallFixedFont;
  } else if (strcmp(str, "Standard Fixed Font")==0) {
    *fntptr = stdFixedFont;
  } else if (strcmp(str, "Small Proportional Font")==0) {
    *fntptr = smallFont;
  } else if (strcmp(str, "Standard Proportional Font")==0) {
    *fntptr = stdFont;
  } else {
    FntInstallFontNum(str, wantfixed?1:0);
    if (FntIsFixedWidth(wantfixed?userFont1:userFont0) || !wantfixed) {
    } else {
      sprintf(buff, "'%s' Var-Width, Continue?", str);
      if (!DoYesNo(buff, -1)) {
	FormPopupForm(FORM_FONT);
	return;
      }
    }
    *fntptr = userFont;
    strcpy(fntname, str);
  }
  FntBeep();
  donefont=1;
}


BOOLEAN FormFontHandleEvent(EvtType* Event)
{
  SHORT item;
  BYTE *ptr;
	
  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    StringSetText(STRING_FONT, fonttitle);
    FormDrawForm(Event->eventID);
    ControlDrawControl(FONT_CANCEL);
    ListDeleteAllItems(LIST_FONT);
    ListAllDBs("FontPDB", LIST_FONT);
    ListInsertItem(LIST_FONT, 0, "Small Fixed Font");
    ListInsertItem(LIST_FONT, 1, "Standard Fixed Font");
    if (!wantfixed) {
      ListInsertItem(LIST_FONT, 2, "Small Proportional Font");
      ListInsertItem(LIST_FONT, 3, "Standard Proportional Font");
    }
    ListSetSelectedItem(LIST_FONT, NO_SELECTION);
    ListDrawList(LIST_FONT);
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(Event->eventID, Event->para1);
    ListSetHighlightedItem(Event->eventID, Event->para1);
    ListDrawList(Event->eventID);
    return TRUE;
		
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      ListGetTotalItems(LIST_FONT, &item);
      if (item==0) break;
      ListGetSelectedItem(LIST_FONT, &item);
      if (item == NO_SELECTION) return TRUE;
      ListGetListItem(LIST_FONT, item, (BYTE **)&ptr);
      ChangeToFont(ptr);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      donefont=1;
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    if (Event->eventID==FONT_CANCEL) {
      donefont=1;
      return TRUE;
    }
    ListGetTotalItems(LIST_FONT, &item);
    if (item==0) break;
    ListGetSelectedItem(LIST_FONT, &item);
    if (item == NO_SELECTION) return TRUE;
    ListGetListItem(LIST_FONT, item, (BYTE **)&ptr);
    switch (Event->eventID) {
    case OPEN_FONT:
      ChangeToFont(ptr);
      break;
    case DELETE_FONT:
      if (DoYesNo("Really Delete Font?",-1)) {
	if (unlink(ptr)) FntBeep();
      }
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_FONT, 0, 0, NULL);
      FormPopupForm(FORM_FONT);
      break;
    }
    break;
		
  default:
    return FALSE;
  }
  return TRUE;
}
 
int DoFont(int wf, char *prompt, int *fontPtr, char *fn)
{
  EvtType event;
  ObjectID oldForm;
  int old;

  fonttitle = prompt;
  wantfixed = wf;
  fntptr = fontPtr;
  fntname = fn;

  old = FormGetActiveFormID(&oldForm);
  if (!madefont) MakeFont();
  donefont=0;
  FormPopupForm(FORM_FONT);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(FontApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP) break;
  } while(!donefont);
  if (old) FormPopupForm(oldForm);
  return event.eventType;
}

