#include <system.h>
#include <stdio.h>
#include "../stdlib/fnt.h"
#include "../stdlib/my_stdio.h"
#include "makeres.h"
#include "getline.h"
#include "yesno.h"

static int madesaveload=0;
typedef enum {FORM_SAVELOAD=3960, STRING_SAVELOAD, LIST_SAVELOAD,
	      TEXT_SAVELOAD, BITMAP_SAVELOAD, SAVELOAD_CANCEL,
	      MENU_SAVELOAD} SAVELOADIDS;
typedef enum {MENU_ALL=0} SAVELOADMENUIDS;

static char delbmp[] = {
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,      0x00, 0x00,
  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,      0x00, 0x00,
  0xf0, 0x00, 0xff, 0x00, 0xff, 0xf0, 0xf0, 0x00, 0x00, 0xf0,      0x00, 0x00,
  0xf0, 0x00, 0xf0, 0xf0, 0xf0, 0x00, 0xf0, 0x00, 0x00, 0xf0,      0x00, 0x00,
  0xf0, 0x00, 0xf0, 0xf0, 0xff, 0xf0, 0xf0, 0x00, 0x00, 0xf0,      0x00, 0x00,
  0xf0, 0x00, 0xf0, 0xf0, 0xf0, 0x00, 0xf0, 0x00, 0x00, 0xf0,      0x00, 0x00,
  0xf0, 0x00, 0xff, 0x00, 0xff, 0xf0, 0xff, 0xf0, 0x00, 0xf0,      0x00, 0x00,
  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,      0x00, 0x00,
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,      0x00, 0x00 };

static char invbmp[]= {
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,      0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,      0x00, 0x00,
  0xff, 0xff, 0x00, 0xff, 0x00, 0x0f, 0x0f, 0xff, 0xff, 0xf0,      0x00, 0x00,
  0xff, 0xff, 0x0f, 0x0f, 0x0f, 0xff, 0x0f, 0xff, 0xff, 0xf0,      0x00, 0x00,
  0xff, 0xff, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0xff, 0xff, 0xf0,      0x00, 0x00,
  0xff, 0xff, 0x0f, 0x0f, 0x0f, 0xff, 0x0f, 0xff, 0xff, 0xf0,      0x00, 0x00,
  0xff, 0xff, 0x00, 0xff, 0x00, 0x0f, 0x00, 0x0f, 0xff, 0xf0,      0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,      0x00, 0x00,
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,      0x00, 0x00 };

static int demunged = 0;
static char fileico[] = {
  0xff,0xff,0xff,0xff,0xff, 0, 0, 0,
  0x00,0x00,0x00,0xff,0xff, 0, 0, 0,
  0x0f,0xff,0xf0,0x00,0x00, 0, 0, 0,
  0x0f,0x00,0xff,0xff,0xf0, 0, 0, 0,
  0x0f,0x00,0x00,0x00,0xf0, 0, 0, 0,
  0x0f,0x00,0x00,0x00,0xf0, 0, 0, 0,
  0x0f,0x00,0x00,0x00,0xf0, 0, 0, 0,
  0x0f,0x00,0x00,0x00,0xf0, 0, 0, 0,
  0x0f,0xff,0xff,0xff,0xf0, 0, 0, 0,
  0x00,0x00,0x00,0x00,0x00, 0, 0, 0,
  0xff,0xff,0xff,0xff,0xff, 0, 0, 0,
  0xff,0xff,0xff,0xff,0xff, 0, 0, 0 };


static void MakeSaveLoad() 
{
  if (!demunged) {
    DeMunge(fileico, sizeof(fileico));
    DeMunge(delbmp, sizeof(delbmp));
    DeMunge(invbmp, sizeof(invbmp));
  }
  demunged = 1;
  MakeForm(FORM_SAVELOAD, 0, 0, 160, 160, 1, "File Chooser", fileico);
  MakeString(STRING_SAVELOAD, 5, 20, 150, 9, CENTRE_ALIGN, "Prompt", FALSE);
  MakeList(LIST_SAVELOAD, 5, 32, 150, 103, LEFT_ALIGN, 8);
  MakeTextbox(TEXT_SAVELOAD, 0, 149, 140, 10);
  MakeBitmap(BITMAP_SAVELOAD, 140, 150, 19, 9, delbmp, sizeof(delbmp), invbmp);
  MakeButton0(SAVELOAD_CANCEL, 148, 1, 11, 11, "X", TRUE);
  MakeMenu(MENU_SAVELOAD);
  MenuInsertItem(MENU_SAVELOAD, MENU_ALL, "List All Files");
  FormAddOneObject(FORM_SAVELOAD, STRING_SAVELOAD, STRING);
  FormAddOneObject(FORM_SAVELOAD, LIST_SAVELOAD, LIST);
  FormAddOneObject(FORM_SAVELOAD, TEXT_SAVELOAD, TEXTBOX);
  FormAddOneObject(FORM_SAVELOAD, BITMAP_SAVELOAD, BITMAP);
  FormAddOneObject(FORM_SAVELOAD, SAVELOAD_CANCEL, CONTROL);
  FormAddOneObject(FORM_SAVELOAD, MENU_SAVELOAD, MENU);
  madesaveload = 1;
}

static BOOLEAN FormSaveLoadHandleEvent(EvtType* event);

static BOOLEAN SaveLoadApplicationHandleEvent(EvtType *event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(event->eventType)  {
  case EVT_FORM_LOAD:
    if((event->para1==1)||(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects(event->eventID);
    if(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)event->eventID) {
    case FORM_SAVELOAD: evtHandler = (void*)FormSaveLoadHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler(event->eventID, (void*)&FormDispatchEvent, evtHandler);
    FormSetActiveForm(event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

static int donefile;
static int hitok;
static char *fileType=NULL;
static char *filePrompt=NULL;
static char outFile[40]={0};
static int checkOver=0;

int GetFileName(char *def, char *type, char *prompt, char *outfile, int checkover)
{
  EvtType event;
  void *back;
  int old;
  ObjectID oldForm;

  donefile=0;
  hitok=0;
  old=FormGetActiveFormID(&oldForm);
  if (!madesaveload) MakeSaveLoad();
  back = SaveBackground();
  strcpy(outFile, def);
  fileType = type;
  filePrompt = prompt;
  checkOver = checkover;
  FormPopupForm(FORM_SAVELOAD);	        //start main form
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(SaveLoadApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP) break;
  } while(!donefile);
  if (event.eventType==EVT_APP_STOP) PowerOff();
  RestoreBackground(back);
  if (hitok) strcpy(outfile, outFile);
  if (old) FormPopupForm(oldForm);
  return hitok;
}

static void SaveLoadOK(int OK)
{
  BYTE *text_ptr;
  char buff[100];

  if (!OK) hitok = 0;
  else hitok = 1;
  
  TextboxSetInsertPointOff(TEXT_SAVELOAD);
  TextboxGetTextPointer(TEXT_SAVELOAD, &text_ptr) ;
  strcpy(outFile, text_ptr);
  if (checkOver && OK) {
    FILE *fp;
    fp=fopen(text_ptr, "rb");
    if (fp) {
      fclose(fp);
      sprintf(buff, "Overwrite '%s'?", text_ptr);
      if (DoYesNo(buff,-1)) {
	donefile = 1;
	EvtAppendEvt(EVT_FORM_CLOSE, FORM_SAVELOAD, 0, 0, NULL);
      } else
	FormPopupForm(FORM_SAVELOAD);
      return;
    }
  }
  donefile = 1;
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_SAVELOAD, 0, 0, NULL);
}

static BOOLEAN FormSaveLoadHandleEvent(EvtType* event)
{
  ObjectBounds bnds;
  BYTE *text_ptr;
  char buff[100];

  switch(event->eventType) {
  case EVT_FORM_OPEN:
    StringSetText(STRING_SAVELOAD, filePrompt);
    TextboxSetInsertPointOn(TEXT_SAVELOAD);
    TextboxSetText(TEXT_SAVELOAD, outFile);
    TextboxSetInsertPointPositionByCharPos(TEXT_SAVELOAD, strlen(outFile));
    FormSetFormActiveObject(FORM_SAVELOAD, TEXT_SAVELOAD);
    FormObjectSetFocus(TEXT_SAVELOAD);
    FormSetFormActiveObject(FORM_SAVELOAD, TEXT_SAVELOAD);
    FormDrawForm(FORM_SAVELOAD);
    ControlDrawControl(SAVELOAD_CANCEL);
    BitmapDrawBitmap(BITMAP_SAVELOAD);
    ListDeleteAllItems(LIST_SAVELOAD);
    ListAllDBs(fileType, LIST_SAVELOAD);
    ListSetSelectedItem(LIST_SAVELOAD, NO_SELECTION);
    ListDrawList(LIST_SAVELOAD);
    break;

  case EVT_MENU_SELECT_ITEM:
    ListDeleteAllItems(LIST_SAVELOAD);
    ListAllDBs(NULL, LIST_SAVELOAD);
    ListSetSelectedItem(LIST_SAVELOAD, NO_SELECTION);
    ListDrawList(LIST_SAVELOAD);
    break;

  case EVT_BITMAP_SELECT:
    if (event->eventID==BITMAP_SAVELOAD) { // Delete button
      TextboxGetTextPointer(TEXT_SAVELOAD, &text_ptr) ;
      if (text_ptr[0]==0) {
	FntBeep();
	break;
      }
      strcpy(outFile, text_ptr);
      
      sprintf(buff, "Really delete %s?", text_ptr);
      if (DoYesNo(buff, FORM_SAVELOAD)) {
	TextboxGetTextPointer(TEXT_SAVELOAD, &text_ptr) ;
	unlink(text_ptr);
      } 
    }
    break;

  case EVT_KEY:
    if (event->eventID == SOFT_KEY) {		
      if ((BYTE)(event->para1) == 13) SaveLoadOK(1);
      else TextboxAddKeyInChar(TEXT_SAVELOAD, (BYTE)(event->para1));
      return TRUE;
    }
    break;

  case EVT_KEYBOARD_STATUS:
    TextboxGetTextboxBounds(TEXT_SAVELOAD, &bnds);
    if (event->para1==KEYBOARD_ON) {
      bnds.ycoord -= 61;
    } else if (event->para1==KEYBOARD_OFF) {
      bnds.ycoord += 61;
    }
    TextboxSetBounds(TEXT_SAVELOAD, bnds);
    TextboxSetInsertPointOff(TEXT_SAVELOAD);
    TextboxGetTextPointer(TEXT_SAVELOAD, &text_ptr) ;
    TextboxSetInsertPointPositionByCharPos(TEXT_SAVELOAD, strlen(text_ptr));
    if (event->para1==KEYBOARD_OFF) FormDrawForm(FORM_SAVELOAD);
    TextboxDrawTextbox(TEXT_SAVELOAD);
    TextboxSetInsertPointOn(TEXT_SAVELOAD);
    break;


  case EVT_LIST_SELECT:
    ListSetSelectedItem(event->eventID, event->para1);
    ListSetHighlightedItem(event->eventID, event->para1);
    ListDrawList(event->eventID);
    ListGetListItem(LIST_SAVELOAD, event->para1, (BYTE **)&text_ptr);
    TextboxSetInsertPointOn(TEXT_SAVELOAD);
    TextboxSetText(TEXT_SAVELOAD, text_ptr);
    TextboxSetInsertPointPositionByCharPos(TEXT_SAVELOAD, strlen(text_ptr));
    TextboxDrawTextbox(TEXT_SAVELOAD);
    return TRUE;
		
  case EVT_CONTROL_SELECT:
    if (event->eventID == SAVELOAD_CANCEL) SaveLoadOK(0);
    return TRUE;
    
  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_OK:
      SaveLoadOK(1);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      SaveLoadOK(0);
      break;
    default:
      return FALSE;
    }
    break;

  default:
    return FALSE;
  }
  return FALSE;
}
