#include <system.h>
#include <string.h>
#include "../stdlib/fnt.h"
#include "makeres.h"
#include "getline.h"
#include "history.h"

static char *strsave;
static char hist1[200];
static char hist2[200];
static char hist3[200];
static char hist4[200];
static char hist5[200];

static int donehist=0;
static int madehist=0;

typedef enum {FORM_HIST=3950, HIST_CANCEL, HIST_LAST1, HIST_LAST2, HIST_LAST3, HIST_LAST4, HIST_LAST5, HIST_ARROW} HISTORYIDS;
static BOOLEAN FormHistoryHandleEvent(EvtType* event);
extern char arrow[];
extern char arrowinv[];

static void MakeHist() 
{
  MakeForm(FORM_HIST, 5, 40, 150, 100, NON_BITMAP_DIALOG, "History", NULL);
  MakeButton0(HIST_CANCEL, 141, 42, 11, 11, "X", TRUE);
  MakeButton(HIST_LAST1, 10, 60, 140, 14, "1");
  MakeButton(HIST_LAST2, 10, 75, 140, 14, "2");
  MakeButton(HIST_LAST3, 10, 90, 140, 14, "3");
  MakeButton(HIST_LAST4, 10,105, 140, 14, "4");
  MakeButton(HIST_LAST5, 10,120, 140, 14, "5");
  MakeBitmap(HIST_ARROW, 140, 150, 9, 9, arrow, 8*9, arrowinv);
  FormAddOneObject(FORM_HIST, HIST_CANCEL, CONTROL);
  FormAddOneObject(FORM_HIST, HIST_LAST1, CONTROL);
  FormAddOneObject(FORM_HIST, HIST_LAST2, CONTROL);
  FormAddOneObject(FORM_HIST, HIST_LAST3, CONTROL);
  FormAddOneObject(FORM_HIST, HIST_LAST4, CONTROL);
  FormAddOneObject(FORM_HIST, HIST_LAST5, CONTROL);
  FormAddOneObject(FORM_HIST, HIST_ARROW, BITMAP);
  madehist = 1;
}


static BOOLEAN HistoryApplicationHandleEvent(EvtType *event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(event->eventType)  {
  case EVT_FORM_LOAD:
    if((event->para1==1)||(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects(event->eventID);
    if(UISearchForAddress(event->eventID, &object_type, (void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)event->eventID) {
    case FORM_HIST: evtHandler = (void*)FormHistoryHandleEvent; break;
    default: return FALSE;
    }
    FormSetEventHandler(event->eventID, (void*)&FormDispatchEvent, evtHandler);
    FormSetActiveForm(event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}


int DoHistory(char *buff)
{
  EvtType event;
  ObjectID oldID;

  FormGetActiveFormID(&oldID);
  if (!madehist) MakeHist(); // If only it were that simple...
  strsave = buff;
  donehist=0;
  FormPopupForm(FORM_HIST);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(HistoryApplicationHandleEvent(&event)) continue;
    //    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP) {PowerOff(); break;}
  } while (!donehist);
  FormPopupForm(oldID);
  return event.eventType;
}


static BOOLEAN FormHistoryHandleEvent(EvtType* event)
{
  char *inject;

  switch(event->eventType) {
  case EVT_FORM_OPEN:
    FormSaveBehindBits(FORM_HIST);
    ControlSetLabel(HIST_LAST1, hist5);
    ControlSetLabel(HIST_LAST2, hist4);
    ControlSetLabel(HIST_LAST3, hist3);
    ControlSetLabel(HIST_LAST4, hist2);
    ControlSetLabel(HIST_LAST5, hist1);
    FormDrawForm(FORM_HIST);
    break;

  case EVT_BITMAP_SELECT:
    donehist=1;
    FormRestoreBitBehind(FORM_HIST);
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_HIST, 0, 0, NULL);
    break;

  case EVT_CONTROL_SELECT:
    switch (event->eventID) {
    case HIST_CANCEL:inject = NULL; break; 
    case HIST_LAST1: inject = hist5; break;
    case HIST_LAST2: inject = hist4; break;
    case HIST_LAST3: inject = hist3; break;
    case HIST_LAST4: inject = hist2; break;
    case HIST_LAST5: inject = hist1; break;
    default: inject=NULL; break;
    }
    if (inject) {
      if (strsave[strlen(strsave)-1]!=' ' && strlen(strsave)>0) strcat(strsave," ");
      strcat(strsave, inject);
      FntBeep();
    }
    donehist=1;
    FormRestoreBitBehind(FORM_HIST);
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_HIST, 0, 0, NULL);
    break;

  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_EXIT:
      FormRestoreBitBehind(FORM_HIST);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_HIST, 0, 0, NULL);
      donehist=1;
      break;
    default:
      return FALSE;
    }
    break;

  default:
    return FALSE;
  }
  return FALSE;
}

void UpdateHistory(char *string) 
{
  if (string[0]) {
    strncpy(hist5, hist4, 200);
    strncpy(hist4, hist3, 200);
    strncpy(hist3, hist2, 200);
    strncpy(hist2, hist1, 200);
    strncpy(hist1, string, 200);
  }
}
