#include <system.h>
#include "../stdlib/fnt.h"

static int curr_x = 0;
static int curr_y = 0;
static char screenmap[160][160];


void os_get_cursor(int *y, int *x)
{
  *y = curr_y;
  *x = curr_x;
}


void os_display_char (char c, int reverse)
{
  int x, y;

  if (curr_y>150) return;

  FntDrawChar(c, curr_x, curr_y, reverse);

  for (y=FntLineHeight(); y>=0; y--)
    for (x=FntCharWidth(c); x>=0; x--)
      screenmap[curr_y+y][curr_x+x]=(x==0)?0:c;
  
  for (y=FntLineHeight(); y<FntLineHeight(); y++)
    for (x=FntCharWidth(c); x>=0; x--)
      screenmap[curr_y+y][curr_x+x]=' ';

  curr_x += FntCharWidth(c);
}


void os_set_cursor (int y, int x)
{
  curr_y = y;
  curr_x = x;
}

void os_erase_area (int top, int left, int bottom, int right)
{
  ObjectBounds bnds;
  int x, y;
 
  bnds.xcoord = left;
  bnds.ycoord = top;
  bnds.width = right - left + 1;
  bnds.height = bottom - top + 1;

  LcdEraseRegion(&bnds);

  for (y=top; y<=bottom; y++)
    for (x=left; x<=right; x++)
      screenmap[y][x] = ' ';
}

void os_scroll_area (int top, int left, int bottom, int right, int units)
{
  ObjectBounds bnds;
  BitmapTemplate b;
  int x, y;
  
  top++;
  left++;
  bottom++;
  right++;

  if (units == 0)
    return;
  else if (units > bottom - top || units < top - bottom) {
    FntClearScreen();
    memset(screenmap, ' ', 160*150);
  } else if (units > 0) {
    b.xcoord = left - 1;
    b.ycoord = top - 1 + units;
    b.width = right - left + 1;
    b.height = bottom - top - units + 1;
    LcdGetBitmap(&b);
    b.ycoord = top - 1;
    LcdDrawBitmap(&b, FALSE);
    qfree(b.bitmap_data);

    for (y=0; y<b.height; y++)
      for (x=0; x<b.width; x++)
	screenmap[b.ycoord + y][b.xcoord+x] = screenmap[b.ycoord+y+units][b.xcoord+x];
    
    bnds.xcoord = left - 1;
    bnds.ycoord = bottom - units;
    bnds.width = right - left + 1;
    bnds.height = units;
    LcdEraseRegion(&bnds);

    for (y=0; y<bnds.height; y++)
      for (x=0; x<bnds.width; x++)
	screenmap[bnds.ycoord + y][bnds.xcoord+x] = ' ';

  }
  else {
    b.xcoord = left - 1;
    b.ycoord = top - 1;
    b.width = right - left + 1;
    b.height = bottom - top + units + 1;
    LcdGetBitmap(&b);
    b.ycoord = top - 1 + units;
    LcdDrawBitmap(&b, FALSE);
    qfree(b.bitmap_data);

    for (y=0; y<b.height; y++)
      for (x=0; x<b.width; x++)
	screenmap[b.ycoord + y-units][b.xcoord+x] = screenmap[b.ycoord+y][b.xcoord+x];

    bnds.xcoord = left - 1;
    bnds.ycoord = top - 1;
    bnds.width = right - left + 1;
    bnds.height = -units;
    LcdEraseRegion(&bnds);

    for (y=0; y<bnds.height; y++)
      for (x=0; x<bnds.width; x++)
	screenmap[bnds.ycoord + y][bnds.xcoord+x] = ' ';
  }
}

static int endchar(char a)
{
  switch(a) {
  case ' ':
  case '<':
  case '>':
  case '(':
  case ')':
  case '\\':
  case '/':
  case '.':
  case '?':
  case '!':
  case '`':
  case '\"':
  case ',':
  case ':':
  case ';':
    return TRUE;
  default:
    return FALSE;
  }
}

static int h_screen_width = 160;
static int h_screen_height = 150;

void os_find_click(int x, int y, char *buff)
{
  int r, c;

  buff[0] = 0;
  c = x;
  r = y;
  if (c>=h_screen_width) return;
  if (r>=h_screen_height) return;

  if (endchar(screenmap[r][c])) return;
  while (!endchar(screenmap[r][c]) && c>0) c--;
  if (endchar(screenmap[r][c])) c++;
  do {
    if (screenmap[r][c]==0 && c<(h_screen_width-1)) {
      if(!endchar(screenmap[r][c+1])) {
	*buff = screenmap[r][c+1];
	buff++;
      }
    }
    c++;
  } while (!endchar(screenmap[r][c]) && c<h_screen_width);
  *buff = 0;
}

