/* FNT.C */
/* Custom Font Driver */
/* Earle F. Philhower, III */
/* earle@ziplabel.com */

#include <system.h>
#include "fnt.h"
#include "my_stdio.h"

#define numFonts 5

#define smallFontHeight			8
#define stdFontHeight			10
#define smallFixedFontHeight	7
#define stdFixedFontHeight		9

static USHORT *userFontBitmap=NULL;

static BYTE widthSmall[256] = {
  1,1,1,1,1,1,1,1,1,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  2,2,4,8,6,8,7,2,4,4,6,6,3,4,2,4,5,3,5,5,6,5,5,4,5,5,2,3,5,6,5,5,
  8,5,5,5,5,4,4,5,5,2,5,5,5,6,6,5,5,6,5,5,4,5,6,8,6,6,5,4,4,4,8,8,
  3,4,4,4,4,4,4,4,4,2,4,4,2,6,4,4,4,4,4,4,4,5,4,6,4,4,4,4,2,4,7,7,
  6,6,1,5,1,1,4,4,4,10,6,1,7,6,8,5,8,3,3,5,5,1,1,1,5,10,5,1,6,6,7,6,
  1,2,5,6,6,6,1,6,4,8,4,7,1,1,8,1,4,4,1,1,1,5,1,1,1,1,4,7,1,1,1,5,
  5,5,5,6,5,5,7,5,4,4,4,4,3,3,4,4,6,5,5,5,5,5,5,1,8,5,5,5,5,6,5,6,
  4,4,4,5,4,4,6,4,4,4,4,4,3,3,4,4,1,5,4,4,4,5,4,4,7,4,4,4,4,4,4,4 };
static BYTE widthStd[256] ={
  1,1,1,1,1,1,1,1,1,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  2,2,6,8,6,8,9,3,4,4,8,8,3,4,3,4,6,3,6,6,7,6,6,5,6,6,3,3,6,7,6,6,
  10,6,6,6,6,5,5,6,6,2,6,6,6,8,7,6,6,7,6,6,6,6,6,10,6,6,6,4,4,4,10,8,
  3,5,5,5,5,5,5,5,5,2,4,5,2,6,5,5,5,5,4,5,5,5,6,8,6,5,5,4,2,4,7,9,
  7,7,1,6,1,1,6,6,4,10,6,1,9,7,10,6,10,3,3,6,6,1,1,1,5,11,5,1,8,6,7,6,
  1,2,5,7,9,8,1,6,4,8,5,8,1,1,8,1,4,6,1,1,1,6,1,1,1,1,5,8,1,1,1,6,
  5,5,5,6,5,5,9,5,4,4,4,4,3,3,4,4,7,6,5,5,5,5,5,1,8,5,5,5,5,6,5,7,
  5,5,5,5,5,5,8,4,5,5,5,5,3,3,4,4,1,5,5,5,5,5,5,6,7,5,5,5,5,5,4,5 };
static BYTE widthSmallFixed[256] = {
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 };
static BYTE widthStdFixed[256] = {
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5 };
static BYTE widthUser[256];

static USHORT smallFontBitmap[256][smallFontHeight] = {												/* ASCII CODE */
  { 0,0,0,0,0,0,0,0 },                     	/*  0  */
  { 0,0,0,0,0,0,0,0 },                     	/*  1  */
  { 0,0,0,0,0,0,0,0 },                     	/*  2  */
  { 0,0,0,0,0,0,0,0 },                     	/*  3  */
  { 0,0,0,0,0,0,0,0 },                     	/*  4  */
  { 0,0,0,0,0,0,0,0 },                     	/*  5  */
  { 0,0,0,0,0,0,0,0 },                     	/*  6  */
  { 0,0,0,0,0,0,0,0 },                     	/*  7  */
  { 0,0,0,0,0,0,0,0 },                     	/*  8  */
  { 0,0,0,0,0,0,0,0 },                     	/*  9  */
  { 0,0,0,0,0,0,0,0 },                     	/*  A  */
  { 0,0,0,0,0,0,0,0 },                     	/*  B  */
  { 0,0,0,0,0,0,0,0 },                     	/*  C  */
  { 0,0,0,0,0,0,0,0 },                     	/*  D  */
  { 0,0,0,0,0,0,0,0 },                     	/*  E  */
  { 0,0,0,0,0,0,0,0 },                     	/*  F  */
  { 0,0,0,0,0,0,0,0 },                     	/* 10  */
  { 0,0,0,0,0,0,0,0 },                     	/* 11  */
  { 0,0,0,0,0,0,0,0 },                     	/* 12  */
  { 0,0,0,0,0,0,0,0 },                     	/* 13  */
  { 0,0,0,0,0,0,0,0 },                     	/* 14  */
  { 0,0,0,0,0,0,0,0 },                     	/* 15  */
  { 0,0,0,0,0,0,0,0 },                     	/* 16  */
  { 0,0,0,0,0,0,0,0 },                     	/* 17  */
  { 0,0,0,0,0,0,0,0 },                     	/* 18  */
  { 0,0,0,0,0,0,0,0 },                     	/* 19  */
  { 0,0,0,0,0,0,0,0 },                     	/* 1A  */
  { 0,0,0,0,0,0,0,0 },                     	/* 1B  */
  { 0,0,0,0,0,0,0,0 },                     	/* 1C  */
  { 0,0,0,0,0,0,0,0 },                     	/* 1D  */
  { 0,0,0,0,0,0,0,0 },                     	/* 1E  */
  { 0,0,0,0,0,0,0,0 },						/* 1F  */
  { 0,0,0,0,0,0,0,0 },						/* 20  */
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x8000,0x0000 },	/* 21  */
  { 0xA000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 22  */
  { 0x1400,0x1400,0x7E00,0x2800,0xFC00,0x5000,0x5000,0x0000 },	/* 23  */
  { 0x2000,0x7000,0xA000,0x7000,0x2800,0x7000,0x2000,0x0000 },	/* 24  */
  { 0x4400,0xA400,0xA800,0x5400,0x2A00,0x4A00,0x4400,0x0000 },	/* 25  */
  { 0x3000,0x4800,0x5000,0x2000,0x5400,0x8800,0x7400,0x0000 },	/* 26  */
  { 0x8000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 27  */
  { 0x2000,0x4000,0x8000,0x8000,0x8000,0x4000,0x2000,0x0000 },	/* 28  */
  { 0x8000,0x4000,0x2000,0x2000,0x2000,0x4000,0x8000,0x0000 },	/* 29  */
  { 0x8800,0x5000,0x2000,0xD800,0x2000,0x5000,0x8800,0x0000 },	/* 2A  */
  { 0x0000,0x2000,0x2000,0xF800,0x2000,0x2000,0x0000,0x0000 },	/* 2B  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x8000 },	/* 2C  */
  { 0x0000,0x0000,0x0000,0xE000,0x0000,0x0000,0x0000,0x0000 },	/* 2D  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8000,0x0000 },	/* 2E  */
  { 0x0000,0x2000,0x2000,0x4000,0x4000,0x8000,0x8000,0x0000 },	/* 2F  */
  { 0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },	/* 30  */
  { 0xC000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },	/* 31  */
  { 0x6000,0x9000,0x1000,0x2000,0x4000,0x8000,0xF000,0x0000 },	/* 32  */
  { 0x6000,0x9000,0x1000,0x6000,0x1000,0x9000,0x6000,0x0000 },	/* 33  */
  { 0x1000,0x3000,0x5000,0x9000,0xF800,0x1000,0x1000,0x0000 },	/* 34  */
  { 0xF000,0x8000,0x8000,0xE000,0x1000,0x1000,0xE000,0x0000 },	/* 35  */
  { 0x6000,0x8000,0x8000,0xE000,0x9000,0x9000,0x6000,0x0000 },	/* 36  */
  { 0xE000,0x2000,0x2000,0x4000,0x4000,0x8000,0x8000,0x0000 },	/* 37  */
  { 0x6000,0x9000,0x9000,0x6000,0x9000,0x9000,0x6000,0x0000 },	/* 38  */
  { 0x6000,0x9000,0x9000,0x7000,0x1000,0x1000,0x6000,0x0000 },	/* 39  */
  { 0x0000,0x0000,0x0000,0x8000,0x0000,0x8000,0x0000,0x0000 },	/* 3A  */
  { 0x0000,0x0000,0x0000,0x4000,0x0000,0x4000,0x4000,0x8000 },	/* 3B  */
  { 0x1000,0x2000,0x4000,0x8000,0x4000,0x2000,0x1000,0x0000 },	/* 3C  */
  { 0x0000,0x0000,0xF800,0x0000,0xF800,0x0000,0x0000,0x0000 },	/* 3D  */
  { 0x8000,0x4000,0x2000,0x1000,0x2000,0x4000,0x8000,0x0000 },	/* 3E  */
  { 0x6000,0x9000,0x1000,0x2000,0x2000,0x0000,0x2000,0x0000 },	/* 3F  */
  { 0x3800,0x4400,0x9A00,0xAA00,0x9400,0x4000,0x3800,0x0000 },	/* 40  */
  { 0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },	/* 41A */
  { 0xE000,0x9000,0x9000,0xE000,0x9000,0x9000,0xE000,0x0000 },	/* 42B */
  { 0x6000,0x9000,0x8000,0x8000,0x8000,0x9000,0x6000,0x0000 },	/* 43C */
  { 0xE000,0x9000,0x9000,0x9000,0x9000,0x9000,0xE000,0x0000 },	/* 44D */
  { 0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0xE000,0x0000 },	/* 45E */
  { 0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0x8000,0x0000 },	/* 46F */
  { 0x6000,0x8000,0x8000,0xB000,0x9000,0x9000,0x6000,0x0000 },	/* 47G */
  { 0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x9000,0x0000 },	/* 48H */
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },	/* 49I */
  { 0xF000,0x2000,0x2000,0x2000,0xA000,0xA000,0x4000,0x0000 },	/* 4AJ */
  { 0x9000,0xA000,0xC000,0x8000,0xC000,0xA000,0x9000,0x0000 },	/* 4BK */
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xF000,0x0000 },	/* 4CL */
  { 0x8800,0xD800,0xA800,0xA800,0x8800,0x8800,0x8800,0x0000 },	/* 4DM */
  { 0x8800,0xC800,0xC800,0xA800,0x9800,0x9800,0x8800,0x0000 },	/* 4EN */
  { 0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },	/* 4FO */
  { 0xE000,0x9000,0x9000,0xE000,0x8000,0x8000,0x8000,0x0000 },	/* 50P */
  { 0x6000,0x9000,0x9000,0x9000,0xB000,0x9000,0x6800,0x0000 },	/* 51Q */
  { 0xE000,0x9000,0x9000,0xE000,0x9000,0x9000,0x9000,0x0000 },	/* 52R */
  { 0x7000,0x8000,0x8000,0x6000,0x1000,0x1000,0xE000,0x0000 },	/* 53S */
  { 0xE000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },	/* 54T */
  { 0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },	/* 55U */
  { 0x8800,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000 },	/* 56V */
  { 0x9200,0x9200,0x9200,0xAA00,0xAA00,0x4400,0x4400,0x0000 },	/* 57W */
  { 0x8800,0x8800,0x5000,0x2000,0x5000,0x8800,0x8800,0x0000 },	/* 58X */
  { 0x8800,0x8800,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000 },	/* 59Y */
  { 0xF000,0x1000,0x1000,0x2000,0x4000,0x8000,0xF000,0x0000 },	/* 5AZ */
  { 0xE000,0x8000,0x8000,0x8000,0x8000,0x8000,0xE000,0x0000 },	/* 5B  */
  { 0x0000,0x8000,0x8000,0x4000,0x4000,0x2000,0x2000,0x0000 },	/* 5C  */
  { 0xE000,0x2000,0x2000,0x2000,0x2000,0x2000,0xE000,0x0000 },	/* 5D  */
  { 0x1000,0x2800,0x4400,0x8200,0x0000,0x0000,0x0000,0x0000 },	/* 5E  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFE00,0x0000 },	/* 5F  */
  { 0x8000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 60  */
  { 0x0000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000,0x0000 },	/* 61a */
  { 0x8000,0x8000,0xC000,0xA000,0xA000,0xA000,0xC000,0x0000 },	/* 62b */
  { 0x0000,0x0000,0x6000,0x8000,0x8000,0x8000,0x6000,0x0000 },	/* 63c */
  { 0x2000,0x2000,0x6000,0xA000,0xA000,0xA000,0x6000,0x0000 },	/* 64d */
  { 0x0000,0x0000,0x4000,0xA000,0xE000,0x8000,0x6000,0x0000 },	/* 65e */
  { 0x2000,0x4000,0xE000,0x4000,0x4000,0x4000,0x4000,0x0000 },	/* 66f */
  { 0x0000,0x0000,0x4000,0xA000,0xA000,0x6000,0x2000,0xC000 },	/* 67g */
  { 0x8000,0x8000,0xC000,0xA000,0xA000,0xA000,0xA000,0x0000 },	/* 68h */
  { 0x8000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },    /* 69i */
  { 0x2000,0x0000,0x2000,0x2000,0x2000,0xA000,0x4000,0x0000 },    /* 6Aj */
  { 0x8000,0x8000,0xA000,0xA000,0xC000,0xA000,0xA000,0x0000 },	/* 6Bk */
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },	/* 6Cl */
  { 0x0000,0x0000,0xF000,0xA800,0xA800,0xA800,0xA800,0x0000 },	/* 6Dm */
  { 0x0000,0x0000,0xC000,0xA000,0xA000,0xA000,0xA000,0x0000 },	/* 6En */
  { 0x0000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000,0x0000 },	/* 6Fo */
  { 0x0000,0x0000,0xC000,0xA000,0xA000,0xC000,0x8000,0x8000 },	/* 70p */
  { 0x0000,0x0000,0x6000,0xA000,0xA000,0x6000,0x2000,0x2000 },	/* 71q */
  { 0x0000,0x0000,0xA000,0xC000,0x8000,0x8000,0x8000,0x0000 },	/* 72r */
  { 0x0000,0x0000,0x6000,0x8000,0x4000,0x2000,0xC000,0x0000 },	/* 73s */
  { 0x4000,0x4000,0xE000,0x4000,0x4000,0x4000,0x2000,0x0000 },	/* 74t */
  { 0x0000,0x0000,0x9000,0x9000,0x9000,0x9000,0x7000,0x0000 },    /* 75u */
  { 0x0000,0x0000,0xA000,0xA000,0xA000,0x4000,0x4000,0x0000 },	/* 76v */
  { 0x0000,0x0000,0xA800,0xA800,0xA800,0x5000,0x5000,0x0000 },	/* 77w */
  { 0x0000,0x0000,0xA000,0xA000,0x4000,0xA000,0xA000,0x0000 },	/* 78x */
  { 0x0000,0x0000,0xA000,0xA000,0xA000,0x6000,0x2000,0xC000 },	/* 79y */
  { 0x0000,0x0000,0xE000,0x2000,0x4000,0x8000,0xE000,0x0000 },	/* 7Az */
  { 0x2000,0x4000,0x4000,0x8000,0x4000,0x4000,0x2000,0x0000 },	/* 7B  */
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },	/* 7C  */
  { 0x8000,0x4000,0x4000,0x2000,0x4000,0x4000,0x8000,0x0000 },	/* 7D  */
  { 0x0000,0x0000,0x6400,0x9800,0x0000,0x0000,0x0000,0x0000 },	/* 7E  */
  { 0x0C00,0x0800,0x0800,0xD000,0x5000,0x2000,0x2000,0x0000 }, 	/* 7F  */
  { 0x3800,0x4000,0xF000,0x4000,0xF000,0x4000,0x3800,0x0000 }, 	/* 80  */
  { 0x7000,0x0800,0x0800,0x7800,0x8800,0x8800,0x7000,0x0000 }, 	/* 81  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 82  */
  { 0x1000,0x2000,0x7000,0x2000,0x4000,0x4000,0x8000,0x0000 }, 	/* 83  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 84  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 85  */
  { 0x4000,0xE000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 }, 	/* 86  */
  { 0x4000,0xE000,0x4000,0x4000,0xE000,0x4000,0x4000,0x0000 }, 	/* 87  */
  { 0x4000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 88  */
  { 0x0000,0x4400,0xA800,0x5000,0x2900,0x5680,0x8900,0x0000 }, 	/* 89  */
  { 0x5000,0x2000,0x7000,0x8000,0x7000,0x0800,0x0800,0x7000 },	/* 8A  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 8B  */
  { 0x7B00,0x9000,0x9000,0x9B00,0x9000,0x9000,0x7B00,0x0000 }, 	/* 8C  */
  { 0x6000,0x9000,0x9000,0xB000,0x8800,0x8800,0xB000,0x0000 }, 	/* 8D  */
  { 0x3800,0x4400,0x8200,0x8200,0x4400,0x2800,0xEE00,0x0000 }, 	/* 8E  */
  { 0xF000,0x8000,0x4000,0x2000,0x4000,0x8000,0xF000,0x0000 }, 	/* 8F  */
  { 0x0000,0x0000,0x7400,0x9A00,0xB200,0x5C00,0x0000,0x0000 }, 	/* 90  */
  { 0x8000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 91  */
  { 0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 92  */
  { 0x5000,0xA000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 93  */
  { 0x5000,0x5000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 94  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 95  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 96  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 97  */
  { 0x5000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 98  */
  { 0x0000,0xE880,0x4D80,0x4A80,0x4A80,0x4A80,0x0000,0x0000 },    /* 99  */
  { 0xA000,0x4000,0x6000,0x8000,0x4000,0x2000,0x9000,0x6000 },    /* 9A  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 9B  */
  { 0x0000,0x0000,0x5000,0xA800,0xB800,0xA000,0x5800,0x0000 }, 	/* 9C  */
  { 0xF800,0x5000,0x5000,0x5000,0x9000,0x9000,0x9000,0x0000 }, 	/* 9D  */
  { 0x0000,0x6400,0x9800,0x0000,0x6400,0x9800,0x0000,0x0000 }, 	/* 9E  */
  { 0x5000,0x0000,0x8800,0x5000,0x2000,0x2000,0x2000,0x0000 }, 	/* 9F  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* A0  */
  { 0x8000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 }, 	/* A1  */
  { 0x2000,0x7000,0xA000,0xA000,0xA000,0x7000,0x2000,0x0000 }, 	/* A2  */
  { 0x3800,0x4000,0x4000,0xF000,0x4000,0x4000,0xF800,0x0000 }, 	/* A3  */
  { 0x0000,0x8800,0x7000,0x5000,0x7000,0x8800,0x0000,0x0000 }, 	/* A4  */
  { 0x8800,0x5000,0xF800,0x2000,0xF800,0x2000,0x2000,0x0000 }, 	/* A5  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* A6  */
  { 0x7000,0x8000,0x7000,0x8800,0x7000,0x0800,0x7000,0x0000 }, 	/* A7  */
  { 0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* A8  */
  { 0x3800,0x4400,0x9A00,0xA200,0xA200,0x9A00,0x4400,0x3800 }, 	/* A9  */
  { 0xE000,0x2000,0xE000,0xA000,0xE000,0x0000,0xE000,0x0000 },	/* AA  */
  { 0x0000,0x2400,0x4800,0x9000,0x4800,0x2400,0x0000,0x0000 }, 	/* AB  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* AC  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* AD  */
  { 0x3800,0x4400,0xB200,0xAA00,0xB200,0xAA00,0x4400,0x3800 }, 	/* AE  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* AF  */
  { 0x4000,0xA000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B0  */
  { 0x0000,0x4000,0xE000,0x4000,0x0000,0xE000,0x0000,0x0000 }, 	/* B1  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B2  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B3  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B4  */
  { 0x9000,0x9000,0x9000,0xB000,0xD000,0x8000,0x8000,0x0000 }, 	/* B5  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B6  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B7  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B8  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B9  */
  { 0x4000,0xA000,0xA000,0xA000,0x4000,0x0000,0xE000,0x0000 }, 	/* BA  */
  { 0x0000,0x9000,0x4800,0x2400,0x4800,0x9000,0x0000,0x0000 }, 	/* BB  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* BC  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* BD  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* BE  */
  { 0x4000,0x0000,0x4000,0x4000,0x8000,0x9000,0x6000,0x0000 }, 	/* BF  */
  { 0x2000,0x1000,0x6000,0x9000,0x9000,0xF000,0x9000,0x0000 }, 	/* C0  */
  { 0x4000,0x8000,0x6000,0x9000,0x9000,0xF000,0x9000,0x0000 }, 	/* C1  */
  { 0x2000,0x5000,0x6000,0x9000,0x9000,0xF000,0x9000,0x0000 }, 	/* C2  */
  { 0x6800,0xB000,0x6000,0x9000,0x9000,0xF000,0x9000,0x0000 }, 	/* C3  */
  { 0x9000,0x0000,0x6000,0x9000,0x9000,0xF000,0x9000,0x0000 }, 	/* C4  */
  { 0x6000,0x9000,0x6000,0x6000,0x9000,0xF000,0x9000,0x0000 }, 	/* C5  */
  { 0x7C00,0x9000,0x9000,0xFC00,0x9000,0x9000,0x9C00,0x0000 }, 	/* C6  */
  { 0x6000,0x9000,0x8000,0x8000,0x9000,0x6000,0x4000,0x8000 }, 	/* C7  */
  { 0x4000,0x2000,0xE000,0x8000,0xE000,0x8000,0xE000,0x0000 }, 	/* C8  */
  { 0x4000,0x8000,0xE000,0x8000,0xE000,0x8000,0xE000,0x0000 }, 	/* C9  */
  { 0x4000,0xA000,0xE000,0x8000,0xE000,0x8000,0xE000,0x0000 }, 	/* CA  */
  { 0xA000,0x0000,0xE000,0x8000,0xE000,0x8000,0xE000,0x0000 }, 	/* CB  */
  { 0x8000,0x4000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },    /* CC  */
  { 0x4000,0x8000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 }, 	/* CD  */
  { 0x4000,0xA000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 }, 	/* CE  */
  { 0xA000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 }, 	/* CF  */
  { 0x7000,0x4800,0x4800,0xE800,0x4800,0x4800,0x7000,0x0000 }, 	/* D0  */
  { 0x5000,0xA000,0x0000,0x9000,0xD000,0xB000,0x9000,0x0000 }, 	/* D1  */
  { 0x2000,0x1000,0x6000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D2  */
  { 0x4000,0x8000,0x6000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D3  */
  { 0x2000,0x5000,0x6000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D4  */
  { 0x5000,0xA000,0x6000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D5  */
  { 0x9000,0x0000,0x6000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D6  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* D7  */
  { 0x3A00,0x4400,0x4C00,0x5400,0x6400,0x4400,0xB800,0x0000 }, 	/* D8  */
  { 0x4000,0x2000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D9  */
  { 0x2000,0x4000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* DA  */
  { 0x2000,0x5000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* DB  */
  { 0x9000,0x0000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* DC  */
  { 0x1000,0x2000,0x8800,0x5000,0x2000,0x2000,0x2000,0x0000 }, 	/* DD  */
  { 0x8000,0xE000,0x9000,0x9000,0xE000,0x8000,0x8000,0x0000 }, 	/* DE  */
  { 0x6000,0x9000,0x9000,0xB000,0x8800,0x8800,0xB000,0x0000 }, 	/* DF  */
  { 0x4000,0x2000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E0  */
  { 0x4000,0x8000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E1  */
  { 0x4000,0xA000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E2  */
  { 0x5000,0xA000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E3  */
  { 0xA000,0x0000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E4  */
  { 0x4000,0xA000,0x4000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E5  */
  { 0x0000,0x0000,0xD000,0x2800,0xF800,0xA000,0xF800,0x0000 }, 	/* E6  */
  { 0x6000,0x8000,0x8000,0x8000,0x8000,0x6000,0x4000,0x8000 },    /* E7  */
  { 0x4000,0x2000,0x0000,0x4000,0xA000,0xE000,0x8000,0x6000 }, 	/* E8  */
  { 0x4000,0x8000,0x0000,0x4000,0xA000,0xE000,0x8000,0x6000 }, 	/* E9  */
  { 0x4000,0xA000,0x0000,0x4000,0xA000,0xE000,0x8000,0x6000 }, 	/* EA  */
  { 0x0000,0xA000,0x0000,0x4000,0xA000,0xE000,0x8000,0x6000 }, 	/* EB  */
  { 0x0000,0x8000,0x4000,0x0000,0x8000,0x8000,0x8000,0x8000 },    /* EC  */
  { 0x0000,0x4000,0x8000,0x0000,0x4000,0x4000,0x4000,0x4000 }, 	/* ED  */
  { 0x0000,0x4000,0xA000,0x0000,0x4000,0x4000,0x4000,0x4000 }, 	/* EE  */
  { 0x0000,0xA000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000 }, 	/* EF  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* F0  */
  { 0x5000,0xA000,0x0000,0xC000,0xA000,0xA000,0xA000,0xA000 }, 	/* F1  */
  { 0x4000,0x2000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000 }, 	/* F2  */
  { 0x4000,0x8000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000 }, 	/* F3  */
  { 0x4000,0xA000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000 }, 	/* F4  */
  { 0x5000,0xA000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000 }, 	/* F5  */
  { 0xA000,0x0000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000 }, 	/* F6  */
  { 0x0000,0x0000,0x4000,0x0000,0xE000,0x0000,0x4000,0x0000 }, 	/* F7  */
  { 0x0000,0x3400,0x4800,0x5800,0x6800,0x4800,0xB000,0x0000 }, 	/* F8  */
  { 0x4000,0x2000,0x0000,0xA000,0xA000,0xA000,0xA000,0x4000 }, 	/* F9  */
  { 0x4000,0x8000,0x0000,0xA000,0xA000,0xA000,0xA000,0x4000 }, 	/* FA  */
  { 0x4000,0xA000,0x0000,0xA000,0xA000,0xA000,0xA000,0x4000 }, 	/* FB  */
  { 0xA000,0x0000,0x0000,0xA000,0xA000,0xA000,0xA000,0x4000 }, 	/* FC  */
  { 0x4000,0x8000,0x0000,0xA000,0xA000,0x6000,0x2000,0xC000 }, 	/* FD  */
  { 0x0000,0x8000,0xC000,0xA000,0xA000,0xC000,0x8000,0x8000 }, 	/* FE  */
  { 0x0000,0xA000,0x0000,0xA000,0xA000,0x6000,0x2000,0xC000 } 	/* FF  */
};


static USHORT stdFontBitmap[256][stdFontHeight] = {
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	 /*   0   */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   1   */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   2   */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   3   */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0xF000,0x8000,0x8000,0x8000,0xF000,0x0800,0x0800,0x0800,0xF000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   32   */
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x8000,0x0000 },  /*   33   */
  { 0x4800,0x9000,0xD800,0xD800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   34   */
  { 0x1400,0x1400,0x7E00,0x1400,0x2800,0x5000,0xFB00,0x5000,0x5000,0x0000 },  /*   35   */
  { 0x2000,0x7800,0xA000,0xA000,0x7000,0x2800,0x2800,0xF000,0x2000,0x0000 },  /*   36   */
  { 0x4200,0xA200,0xA400,0x4800,0x1000,0x2400,0x4B00,0x8B00,0x8400,0x0000 },  /*   37   */
  { 0x3000,0x4800,0x5000,0x2000,0x5000,0x8A00,0x8400,0x4A00,0x3100,0x0000 },  /*   38   */
  { 0xc000,0xc000,0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   39   */
  { 0x2000,0x4000,0x8000,0x8000,0x8000,0x8000,0x8000,0x4000,0x2000,0x0000 },  /*   40   */
  { 0x8000,0x4000,0x2000,0x2000,0x2000,0x2000,0x2000,0x4000,0x8000,0x0000 },  /*   41   */
  { 0x8200,0x4400,0x2800,0x1000,0xEE00,0x1000,0x2800,0x4400,0x8200,0x0000 },  /*   42   */
  { 0x0000,0x1000,0x1000,0x1000,0xFE00,0x1000,0x1000,0x1000,0x0000,0x0000 },  /*   43   */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0xc000,0x4000,0x8000 },  /*   44   */
  { 0x0000,0x0000,0x0000,0x0000,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   45   */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0xc000,0x0000 },  /*   46   */
  { 0x2000,0x2000,0x2000,0x4000,0x4000,0x4000,0x8000,0x8000,0x8000,0x0000 },  /*   47   */
  { 0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   48   */
  { 0xC000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   49   */
  { 0x7000,0x8800,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0xF800,0x0000 },  /*   50   */
  { 0x7000,0x8800,0x0800,0x0800,0x7000,0x0800,0x0800,0x8800,0x7000,0x0000 },  /*   51   */
  { 0x0800,0x1800,0x2800,0x4800,0x8800,0xFC00,0x0800,0x0800,0x0800,0x0000 },  /*   52   */
  { 0xF000,0x8000,0X8000,0x8000,0xF000,0x0800,0x0800,0x0800,0xF000,0x0000 },  /*   53   */
  { 0x7000,0x8000,0x8000,0x8000,0x7000,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   54   */
  { 0xF000,0x1000,0x1000,0x2000,0x2000,0x2000,0x4000,0x4000,0x4000,0x0000 },  /*   55   */
  { 0x7000,0x8800,0x8800,0x8800,0x7000,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   56   */
  { 0x7000,0x8800,0x8800,0x8800,0x7000,0x0800,0x0800,0x0800,0x7000,0x0000 },  /*   57   */
  { 0x0000,0xc000,0xc000,0x0000,0x0000,0xc000,0xc000,0x0000,0x0000,0x0000 },  /*   58   */
  { 0x0000,0x0000,0x0000,0xC000,0xC000,0x0000,0xC000,0xC000,0x4000,0x8000 },  /*   59   */
  { 0x0800,0x1000,0x2000,0x4000,0x8000,0x4000,0x2000,0x1000,0x0800,0x0000 },  /*   60   */
  { 0x0000,0x0000,0x0000,0xFC00,0x0000,0xFC00,0x0000,0x0000,0x0000,0x0000 },  /*   61   */
  { 0x8000,0x4000,0x2000,0x1000,0x0800,0x1000,0x2000,0x4000,0x8000,0x0000 },  /*   62   */
  { 0x7000,0x8800,0x0800,0x0800,0x1000,0x2000,0x2000,0x0000,0x2000,0x0000 },  /*   63   */
  { 0x1C00,0x2200,0x5D00,0xA480,0xA480,0xA480,0x5B00,0x2000,0x1C00,0x0000 },  /*   64   */
  { 0x7000,0x8800,0x8800,0x8800,0x8800,0xF800,0x8800,0x8800,0x8800,0x0000 },  /*   65   */
  { 0xF000,0x8800,0x8800,0x8800,0xF000,0x8800,0x8800,0x8800,0xF000,0x0000 },  /*   66   */
  { 0x7000,0x8800,0x8000,0x8000,0x8000,0x8000,0x8000,0x8800,0x7000,0x0000 },  /*   67   */
  { 0xF000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0xF000,0x0000 },  /*   68   */
  { 0xF000,0x8000,0x8000,0x8000,0xF000,0x8000,0x8000,0x8000,0xF000,0x0000 },  /*   69   */
  { 0xF000,0x8000,0x8000,0x8000,0xF000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   70   */
  { 0x7000,0x8000,0x8000,0x8000,0xB800,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   71   */
  { 0x8800,0x8800,0x8800,0x8800,0xF800,0x8800,0x8800,0x8800,0x8800,0x0000 },  /*   72   */
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   73   */
  { 0xF800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x9000,0x6000,0x0000 },  /*   74   */
  { 0x8800,0x8800,0x9000,0xA000,0xC000,0xA000,0x9000,0x8800,0x8800,0x0000 },  /*   75   */
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xF800,0x0000 },  /*   76   */
  { 0x8200,0xC600,0xAA00,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000 },  /*   77   */
  { 0x8400,0xC400,0xC400,0xA400,0xA400,0x9400,0x9400,0x8C00,0x8C00,0x0000 },  /*   78   */
  { 0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   79   */
  { 0xF000,0x8800,0x8800,0x8800,0xF000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   80   */
  { 0x7000,0x8800,0x8800,0x8800,0xC800,0xA800,0x9800,0x8800,0x7400,0x0000 },  /*   81   */
  { 0xF000,0x8800,0x8800,0x8800,0xF000,0x8800,0x8800,0x8800,0x8800,0x0000 },  /*   82   */
  { 0x7800,0x8000,0x8000,0x8000,0x7000,0x0800,0x0800,0x0800,0xF000,0x0000 },  /*   83   */
  { 0xF800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000 },  /*   84   */
  { 0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   85   */
  { 0x8800,0x8800,0x8800,0x5000,0x5000,0x5000,0x2000,0x2000,0x2000,0x0000 },  /*   86   */
  { 0x8880,0x8880,0x8880,0x8880,0x5500,0x5500,0x5500,0x2200,0x2200,0x0000 },  /*   87   */
  { 0x8800,0x8800,0x8800,0x5000,0x2000,0x5000,0x8800,0x8800,0x8800,0x0000 },  /*   88   */
  { 0x8800,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000 },  /*   89   */
  { 0xF800,0x0800,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0xF800,0x0000 },  /*   90   */
  { 0xE000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xE000,0x0000 },  /*   91   */
  { 0x8000,0x8000,0x8000,0x4000,0x4000,0x4000,0x2000,0x2000,0x2000,0x0000 },  /*   92  */
  { 0xE000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0xE000,0x0000 },  /*   93   */
  { 0x0000,0x0800,0x1400,0x2200,0x4100,0x8080,0x0000,0x0000,0x0000,0x0000 },  /*   94   */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFE00,0x0000 },  /*   95   */
  { 0x8000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   96   */
  { 0x0000,0x0000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   97   */
  { 0x8000,0x8000,0x8000,0xE000,0x9000,0x9000,0x9000,0x9000,0xE000,0x0000 },  /*   98   */
  { 0x0000,0x0000,0x0000,0x7000,0x8000,0x8000,0x8000,0x8000,0x7000,0x0000 },  /*   99   */
  { 0x1000,0x1000,0x1000,0x7000,0x9000,0x9000,0x9000,0x9000,0x7000,0x0000 },  /*   100  */
  { 0x0000,0x0000,0x0000,0x6000,0x9000,0x9000,0xF000,0x8000,0x7000,0x0000 },  /*   101  */
  { 0x2000,0x5000,0x4000,0x4000,0xF000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   102  */
  { 0x0000,0x0000,0x0000,0x6000,0x9000,0x9000,0x9000,0x7000,0x1000,0xE000 },  /*   103  */
  { 0x8000,0x8000,0x8000,0xE000,0x9000,0x9000,0x9000,0x9000,0x9000,0x0000 },  /*   104  */
  { 0x0000,0x8000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   105  */
  { 0x0000,0x2000,0x0000,0x2000,0x2000,0x2000,0x2000,0xA000,0x4000,0x0000 },  /*   106  */
  { 0x8000,0x8000,0x8000,0x9000,0x9000,0xA000,0xC000,0xA000,0x9000,0x0000 },  /*   107  */
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   108  */
  { 0x0000,0x0000,0x0000,0xF000,0xA800,0xA800,0xA800,0xA800,0xA800,0x0000 },  /*   109  */
  { 0x0000,0x0000,0x0000,0xE000,0x9000,0x9000,0x9000,0x9000,0x9000,0x0000 },  /*   110  */
  { 0x0000,0x0000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   111  */
  { 0x0000,0x0000,0x0000,0xE000,0x9000,0x9000,0x9000,0xE000,0x8000,0x8000 },  /*   112  */
  { 0x0000,0x0000,0x0000,0x7000,0x9000,0x9000,0x9000,0x7000,0x1000,0x1000 },  /*   113  */
  { 0x0000,0x0000,0x0000,0xA000,0xC000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   114  */
  { 0x0000,0x0000,0x0000,0x6000,0x9000,0x4000,0x2000,0x9000,0x6000,0x0000 },  /*   115  */
  { 0x0000,0x4000,0x4000,0xF000,0x4000,0x4000,0x4000,0x5000,0x2000,0x0000 },  /*   116  */
  { 0x0000,0x0000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x7000,0x0000 },  /*   117  */
  { 0x0000,0x0000,0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000 },  /*   118  */
  { 0x0000,0x0000,0x0000,0x8200,0x8200,0x5400,0x5400,0x2800,0x2800,0x0000 },  /*   119  */
  { 0x0000,0x0000,0x0000,0x8800,0x5000,0x2000,0x2000,0x5000,0x8800,0x0000 },  /*   120  */
  { 0x0000,0x0000,0x0000,0x9000,0x9000,0x9000,0x9000,0x7000,0x1000,0x6000 },  /*   121  */
  { 0x0000,0x0000,0x0000,0xF000,0x1000,0x2000,0x4000,0x8000,0xF000,0x0000 },  /*   122  */
  { 0x2000,0x4000,0x4000,0x4000,0x8000,0x4000,0x4000,0x4000,0x2000,0x0000 },  /*   123  */
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000 },  /*   124  */
  { 0x8000,0x4000,0x4000,0x4000,0x2000,0x4000,0x4000,0x4000,0x8000,0x0000 },  /*   125  */
  { 0x0000,0x0000,0x0000,0x0000,0x6400,0x9800,0x0000,0x0000,0x0000,0x0000 },  /*   126  */
  { 0x0000,0x0700,0x0400,0x0800,0x0800,0xD000,0x6000,0x2000,0x2000,0x0000 },  /*   127  */
  { 0x3800,0x4400,0x4000,0xF800,0x4000,0xF800,0x4000,0x4400,0x3800,0x0000 },  /*   128  */
  { 0x7800,0x0400,0x0400,0x7B00,0x8400,0x8400,0x8400,0x8400,0x7800,0x0000 },  /*   129  */
  { 0x0000,0x0000,0x0000,0x6400,0x9800,0x0000,0x6400,0x9800,0x0000,0x0000 },  /*   130  */
  { 0x1000,0x2800,0x2000,0x7000,0x2000,0x4000,0x4000,0x8000,0x8000,0x0000 },  /*   131  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   132  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   133  */
  { 0x2000,0x2000,0xF800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000 },  /*   134  */
  { 0x2000,0x2000,0xF800,0x2000,0x2000,0xF800,0x2000,0x2000,0x2000,0x0000 },  /*   135  */
  { 0x0000,0x4000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   136  */
  { 0x0000,0x4800,0xA800,0x5000,0x1000,0x2000,0x2900,0x5680,0x4900,0x0000 },  /*   137  */
  { 0x5000,0x2000,0x7800,0x8000,0x8000,0x7000,0x0800,0x0800,0xF000,0x0000 },  /*   138  */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   139  */
  { 0x7F00,0x8800,0x8800,0x8800,0x8F00,0x8800,0x8800,0x8800,0x7F00,0x0000 },  /*   140  */
  { 0x7000,0x8800,0x8800,0x8800,0x9800,0x8400,0x8400,0x8400,0xB800,0x0000 },  /*   141  */
  { 0x1e00,0x2200,0x4100,0x8080,0x8080,0x4100,0x2200,0x1400,0x7700,0x0000 },  /*   142  */
  { 0xF000,0x8000,0x4000,0x2000,0x1000,0x2000,0x4000,0x8000,0xF800,0x0000 },  /*   143  */
  { 0x0000,0x0000,0x7100,0x8A80,0x8c80,0x9880,0xA880,0x4780,0x0000,0x0000 },  /*   144  */
  { 0x0000,0x8000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   145 */
  { 0x0000,0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   146  */
  { 0x4800,0x9000,0xD800,0xD800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   147 */
  { 0xD800,0xD800,0x4800,0x9000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   148 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   149 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   150 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   151 */
  { 0x0000,0x5000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   152 */
  { 0x0000,0x0000,0xE840,0x4Cc0,0x4B40,0x4840,0x4840,0x4840,0x0000,0x0000 },  /*   153 */
  { 0x5000,0x2000,0x0000,0x6000,0x9000,0x4000,0x2000,0x9000,0x6000,0x0000 },  /*   154 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   155 */
  { 0x0000,0x0000,0x0000,0x6C00,0x9200,0x9200,0x9E00,0x9000,0x6E00,0x0000 },  /*   156 */
  { 0xF800,0x5000,0x5000,0x5000,0x9000,0x9000,0x9000,0x9000,0x9000,0x0000 },  /*   157 */
  { 0x0000,0x0000,0x0000,0x6400,0x9800,0x0000,0x6400,0x9800,0x0000,0x0000 },  /*   158 */
  { 0x5000,0x0000,0x8800,0x8800,0x8800,0x5000,0x2000,0x2000,0x2000,0x0000 },  /*   159 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   160 */
  { 0x8000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   161 */
  { 0x0000,0x2000,0x7000,0xA000,0xA000,0xA000,0xA000,0x7000,0x2000,0x0000 },  /*   162 */
  { 0x3C00,0x4000,0x4000,0xF800,0x4000,0x4000,0x4000,0x4000,0xFC00,0x0000 },  /*   163 */
  { 0x8100,0x4200,0x3C00,0x2400,0x2400,0x2400,0x3C00,0x4200,0x8100,0x0000 },  /*   164 */
  { 0x8200,0x4400,0x2800,0xFE00,0x1000,0xFE00,0x1000,0x1000,0x1000,0x0000 },  /*   165 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   166 */
  { 0x7000,0x8000,0x8000,0x7000,0x8800,0x7000,0x0800,0x0800,0x7000,0x0000 },  /*   167 */
  { 0x0000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   168 */
  { 0x0000,0x3800,0x4400,0x9A00,0xA200,0xA200,0x9A00,0x4400,0x3800,0x0000 },  /*   169 */
  { 0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000,0xF000,0x0000 },  /*   170 */
  { 0x0000,0x1200,0x2400,0x4800,0x9000,0x4800,0x2400,0x1200,0x0000,0x0000 },  /*   171 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   172 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   173 */
  { 0x0000,0x3800,0x4400,0xB200,0xAa00,0xB200,0xAC00,0x4400,0x3800,0x0000 },  /*   174 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   175 */
  { 0x0000,0x4000,0xA000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   176 */
  { 0x0000,0x0000,0x2000,0x2000,0xF800,0x2000,0x2000,0x0000,0xF800,0x0000 },  /*   177 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   178 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   179 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   180 */
  { 0x8800,0x8800,0x8800,0x8800,0x9800,0xA800,0xC000,0x8000,0x8000,0x0000 },  /*   181 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   182 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   183 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   184 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   185 */
  { 0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000,0xF000,0x0000 },  /*   186 */
  { 0x0000,0x9000,0x4800,0x2400,0x1200,0x2400,0x4800,0x9000,0x0000,0x0000 },  /*   187 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   188 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   189 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   190 */
  { 0x2000,0x0000,0x2000,0x2000,0x4000,0x8000,0x8000,0x8100,0x7000,0x0000 },  /*   191 */
  { 0x2000,0x1000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   192 */
  { 0x4000,0x8000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   193 */
  { 0x2000,0x5000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   194 */
  { 0x6800,0xB000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   195 */
  { 0x9000,0x0000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   196 */
  { 0x6000,0x9000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   197 */
  { 0x7F00,0x8800,0x8800,0x8800,0x8F00,0xF800,0x8800,0x8800,0x8F00,0x0000 },  /*   198 */
  { 0x6000,0x9000,0x8000,0x8000,0x8000,0x9000,0x6000,0x4000,0x8000,0x0000 },  /*   199 */
  { 0x4000,0x2000,0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0xE000,0x0000 },  /*   200 */
  { 0x4000,0x8000,0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0xE000,0x0000 },  /*   201 */
  { 0x4000,0xA000,0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0xE000,0x0000 },  /*   202 */
  { 0xA000,0x0000,0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0xE000,0x0000 },  /*   203 */
  { 0x8000,0x4000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   204 */
  { 0x4000,0x8000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   205 */
  { 0x4000,0xA000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   206 */
  { 0xA000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   207 */
  { 0x7800,0x4400,0x4400,0x4400,0xE400,0x4400,0x4400,0x4400,0x7800,0x0000 },  /*   208 */
  { 0x6800,0xB000,0x8800,0xC800,0xC800,0xA800,0xA800,0x9800,0x9800,0x0000 },  /*   209 */
  { 0x2000,0x1000,0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   210 */
  { 0x2000,0x4000,0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   211 */
  { 0x2000,0x5000,0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   212 */
  { 0x5000,0xA000,0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   213 */
  { 0x9000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   214 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   215 */
  { 0x3500,0x4400,0x4c00,0x5400,0x5400,0x5400,0x6400,0x4400,0xB800,0x0000 },  /*   216 */
  { 0x4000,0x2000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   217 */
  { 0x4000,0x8000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   218 */
  { 0x2000,0x5000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   219 */
  { 0x9000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   220 */
  { 0x1000,0x2000,0x8800,0x8800,0x8800,0x5000,0x2000,0x2000,0x2000,0x0000 },  /*   221 */
  { 0x8000,0xE000,0x9000,0x9000,0x9000,0xE000,0x8000,0x8000,0x8000,0x0000 },  /*   222 */
  { 0x7000,0x8800,0x8800,0x8800,0x9800,0x8400,0x8400,0x8400,0xB800,0x0000 },  /*   223 */
  { 0x4000,0x2000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   224 */
  { 0x2000,0x4000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   225 */
  { 0x2000,0x5000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   226 */
  { 0x5000,0xA000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   227 */
  { 0x0000,0x5000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   228 */
  { 0x2000,0x5000,0x2000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   229 */
  { 0x0000,0x0000,0x0000,0x6c00,0x1200,0x7200,0x9E00,0x9000,0x7E00,0x0000 },  /*   230 */
  { 0x0000,0x0000,0x6000,0x8000,0x8000,0x8000,0x6000,0x4000,0x8000,0x0000 },  /*   231 */
  { 0x4000,0x2000,0x0000,0x6000,0x9000,0x9000,0xF000,0x8000,0x7000,0x0000 },  /*   232 */
  { 0x2000,0x4000,0x0000,0x6000,0x9000,0x9000,0xF000,0x8000,0x7000,0x0000 },  /*   233 */
  { 0x4000,0xA000,0x0000,0x6000,0x9000,0x9000,0xF000,0x8000,0x7000,0x0000 },  /*   234 */
  { 0xA000,0x0000,0x0000,0x6000,0x9000,0x9000,0xF000,0x8000,0x7000,0x0000 },  /*   235 */
  { 0x8000,0x4000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   236 */
  { 0x4000,0x8000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   237 */
  { 0x4000,0xA000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   238 */
  { 0x0000,0xA000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   239 */
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   240 */
  { 0xA000,0x5000,0x0000,0xE000,0x9000,0x9000,0x9000,0x9000,0x9000,0x0000 },  /*   241 */
  { 0x4000,0x2000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   242 */
  { 0x2000,0x4000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   243 */
  { 0x2000,0x5000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   244 */
  { 0x5000,0xA000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   245 */
  { 0x0000,0x9000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   246 */
  { 0x0000,0x0000,0x2000,0x0000,0xF800,0x0000,0x2000,0x0000,0x0000,0x0000 },  /*   247 */
  { 0x0000,0x0000,0x0000,0x3400,0x4800,0x5800,0x6800,0x4800,0xB000,0x0000 },  /*   248 */
  { 0x4000,0x2000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   249 */
  { 0x2000,0x4000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   250 */
  { 0x2000,0x5000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   251 */
  { 0x0000,0x9000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   252 */
  { 0x2000,0x4000,0x0000,0x9000,0x9000,0x9000,0x9000,0x7000,0x1000,0x6000 },  /*   253 */
  { 0x0000,0x0000,0x0000,0x8000,0xc000,0xA000,0xA000,0xc000,0x8000,0x8000 },  /*   254 */
  { 0x0000,0x9000,0x0000,0x9000,0x9000,0x9000,0x9000,0x7000,0x1000,0x6000 },  /*   255 */
};

static USHORT smallFixedFontBitmap[256][smallFixedFontHeight] = {
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 0 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 1 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 2 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 3 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 4 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 5 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 6 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 7 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 8 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 9 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 10 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 11 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 12 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 13 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 14 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 15 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 16 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 17 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 18 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 19 
  { 0xe000,0xa400,0xe800,0x5a00,0xd000,0xc800,0x4400 },   // Glyph 20 
  { 0x2000,0x4000,0x8000,0xd000,0x8000,0x4000,0x2000 },   // Glyph 21 
  { 0x0200,0x0400,0x0800,0x1000,0x2000,0xc000,0xc000 },   // Glyph 22 
  { 0x1000,0x2800,0x2800,0x1000,0x2800,0xc400,0xc200 },   // Glyph 23 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa800 },   // Glyph 24 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 25 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 26 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 27 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 28 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 29 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 30 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 31 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 32 
  { 0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x4000 },   // Glyph 33 
  { 0xa000,0xa000,0xa000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 34 
  { 0xa000,0xa000,0xf000,0xa000,0xf000,0xa000,0xa000 },   // Glyph 35 
  { 0x4000,0xe000,0x8000,0xe000,0x2000,0xe000,0x4000 },   // Glyph 36 
  { 0xa000,0xa000,0x2000,0x4000,0xa000,0xa000,0x8000 },   // Glyph 37 
  { 0x4000,0xa000,0xa000,0x7000,0xa000,0xa000,0x6000 },   // Glyph 38 
  { 0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 39 
  { 0x4000,0x4000,0x8000,0x8000,0x8000,0x4000,0x4000 },   // Glyph 40 
  { 0x4000,0x4000,0x2000,0x2000,0x2000,0x4000,0x4000 },   // Glyph 41 
  { 0x0000,0xa000,0x4000,0xe000,0x4000,0xa000,0x0000 },   // Glyph 42 
  { 0x0000,0x4000,0x4000,0xe000,0x4000,0x4000,0x0000 },   // Glyph 43 
  { 0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x8000 },   // Glyph 44 
  { 0x0000,0x0000,0x0000,0xe000,0x0000,0x0000,0x0000 },   // Glyph 45 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000 },   // Glyph 46 
  { 0x2000,0x2000,0x4000,0x4000,0x4000,0x8000,0x8000 },   // Glyph 47 
  { 0xe000,0xa000,0xa000,0xa000,0xa000,0xa000,0xe000 },   // Glyph 48 
  { 0x4000,0xc000,0x4000,0x4000,0x4000,0x4000,0x4000 },   // Glyph 49 
  //{ 0x4000,0xa000,0x2000,0x4000,0x4000,0xa000,0xe000 },   // Glyph 50 
  { 0x4000,0xa000,0x2000,0x4000,0x4000,0x8000,0xe000 },   // Glyph 50 
  { 0x4000,0xa000,0x2000,0x4000,0x2000,0xa000,0x4000 },   // Glyph 51 
  { 0x2000,0x4000,0x4000,0xa000,0xe000,0x2000,0x2000 },   // Glyph 52 
  { 0xe000,0x8000,0x8000,0xc000,0x2000,0x2000,0xc000 },   // Glyph 53 
  { 0x2000,0x4000,0x8000,0xc000,0xa000,0xa000,0x4000 },   // Glyph 54 
  { 0xe000,0x2000,0x2000,0x4000,0x4000,0x4000,0x4000 },   // Glyph 55 
  { 0x4000,0xa000,0xa000,0x4000,0xa000,0xa000,0x4000 },   // Glyph 56 
  { 0x4000,0xa000,0xa000,0x6000,0x2000,0x4000,0x8000 },   // Glyph 57 
  { 0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000 },   // Glyph 58 
  { 0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x8000 },   // Glyph 59 
  { 0x0000,0x2000,0x4000,0x8000,0x4000,0x2000,0x0000 },   // Glyph 60 
  { 0x0000,0x0000,0xe000,0x0000,0xe000,0x0000,0x0000 },   // Glyph 61 
  { 0x0000,0x8000,0x4000,0x2000,0x4000,0x8000,0x0000 },   // Glyph 62 
  { 0x4000,0xa000,0x2000,0x4000,0x4000,0x0000,0x4000 },   // Glyph 63 
  { 0x4000,0xa000,0xe000,0xe000,0xe000,0x8000,0x6000 },   // Glyph 64 
  { 0x4000,0xa000,0xa000,0xe000,0xa000,0xa000,0xa000 },   // Glyph 65 
  { 0xc000,0xa000,0xa000,0xc000,0xa000,0xa000,0xc000 },   // Glyph 66 
  { 0x4000,0xa000,0x8000,0x8000,0x8000,0xa000,0x4000 },   // Glyph 67 
  { 0xc000,0xa000,0xa000,0xa000,0xa000,0xa000,0xc000 },   // Glyph 68 
  { 0xe000,0x8000,0x8000,0xe000,0x8000,0x8000,0xe000 },   // Glyph 69 
  { 0xe000,0x8000,0x8000,0xe000,0x8000,0x8000,0x8000 },   // Glyph 70 
  { 0x6000,0x8000,0x8000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 71 
  { 0xa000,0xa000,0xa000,0xe000,0xa000,0xa000,0xa000 },   // Glyph 72 
  { 0xe000,0x4000,0x4000,0x4000,0x4000,0x4000,0xe000 },   // Glyph 73 
  { 0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0xc000 },   // Glyph 74 
  { 0xa000,0xa000,0xc000,0xc000,0xa000,0xa000,0xa000 },   // Glyph 75 
  { 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xe000 },   // Glyph 76 
  { 0xa000,0xe000,0xa000,0xa000,0xa000,0xa000,0xa000 },   // Glyph 77 
  { 0xc000,0xa000,0xa000,0xa000,0xa000,0xa000,0xa000 },   // Glyph 78 
  { 0x4000,0xa000,0xa000,0xa000,0xa000,0xa000,0x4000 },   // Glyph 79 
  { 0xc000,0xa000,0xa000,0xc000,0x8000,0x8000,0x8000 },   // Glyph 80 
  { 0x4000,0xa000,0xa000,0xa000,0xa000,0x4000,0x2000 },   // Glyph 81 
  { 0xc000,0xa000,0xa000,0xc000,0xa000,0xa000,0xa000 },   // Glyph 82 
  { 0x6000,0x8000,0x8000,0x4000,0x2000,0x2000,0xc000 },   // Glyph 83 
  { 0xe000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000 },   // Glyph 84 
  { 0xa000,0xa000,0xa000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 85 
  { 0xa000,0xa000,0xa000,0xa000,0xe000,0x4000,0x4000 },   // Glyph 86 
  { 0xa000,0xa000,0xa000,0xa000,0xa000,0xe000,0xa000 },   // Glyph 87 
  { 0xa000,0xa000,0xa000,0x4000,0xa000,0xa000,0xa000 },   // Glyph 88 
  { 0xa000,0xa000,0xa000,0x4000,0x4000,0x4000,0x4000 },   // Glyph 89 
  { 0xe000,0x2000,0x4000,0x4000,0x4000,0x8000,0xe000 },   // Glyph 90 
  { 0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x6000 },   // Glyph 91 
  { 0x8000,0x8000,0x4000,0x4000,0x4000,0x2000,0x2000 },   // Glyph 92 
  { 0x6000,0x2000,0x2000,0x2000,0x2000,0x2000,0x6000 },   // Glyph 93 
  { 0x4000,0x4000,0xa000,0xa000,0xa000,0x0000,0x0000 },   // Glyph 94 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000 },   // Glyph 95 
  { 0x4000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 96 
  { 0x0000,0x0000,0x4000,0x2000,0x6000,0xa000,0x6000 },   // Glyph 97 
  { 0x8000,0x8000,0xc000,0xa000,0xa000,0xa000,0xc000 },   // Glyph 98 
  { 0x0000,0x0000,0x6000,0x8000,0x8000,0x8000,0x6000 },   // Glyph 99 
  { 0x2000,0x2000,0x6000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 100 
  { 0x0000,0x0000,0x4000,0xa000,0xe000,0x8000,0x6000 },   // Glyph 101 
  { 0x2000,0x4000,0xe000,0x4000,0x4000,0x4000,0xe000 },   // Glyph 102 
  //{ 0x6000,0xa000,0x4000,0x8000,0x6000,0xa000,0x4000 },   // Glyph 103 
  { 0x0000,0x0000,0x6000,0xa000,0x6000,0x2000,0xc000 },   // Glyph 103 
  { 0x8000,0x8000,0xc000,0xa000,0xa000,0xa000,0xa000 },   // Glyph 104 
  { 0x4000,0x0000,0xc000,0x4000,0x4000,0x4000,0xe000 },   // Glyph 105 
  { 0x2000,0x0000,0x6000,0x2000,0x2000,0x2000,0xc000 },   // Glyph 106 
  { 0x8000,0x8000,0xa000,0xc000,0xc000,0xa000,0xa000 },   // Glyph 107 
  { 0xc000,0x4000,0x4000,0x4000,0x4000,0x4000,0xe000 },   // Glyph 108 
  { 0x0000,0x0000,0xa000,0xe000,0xa000,0xa000,0xa000 },   // Glyph 109 
  { 0x0000,0x0000,0xc000,0xa000,0xa000,0xa000,0xa000 },   // Glyph 110 
  { 0x0000,0x0000,0x4000,0xa000,0xa000,0xa000,0x4000 },   // Glyph 111 
  { 0x0000,0x0000,0xc000,0xa000,0xa000,0xc000,0x8000 },   // Glyph 112 
  { 0x0000,0x0000,0x6000,0xa000,0xa000,0x6000,0x2000 },   // Glyph 113 
  { 0x0000,0x0000,0xa000,0xc000,0x8000,0x8000,0x8000 },   // Glyph 114 
  { 0x0000,0x0000,0x6000,0x8000,0x4000,0x2000,0xc000 },   // Glyph 115 
  { 0x0000,0x4000,0xe000,0x4000,0x4000,0x4000,0x2000 },   // Glyph 116 
  { 0x0000,0x0000,0xa000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 117 
  { 0x0000,0x0000,0xa000,0xa000,0xa000,0x4000,0x4000 },   // Glyph 118 
  { 0x0000,0x0000,0xa000,0xa000,0xa000,0xe000,0xa000 },   // Glyph 119 
  { 0x0000,0x0000,0xa000,0xa000,0x4000,0xa000,0xa000 },   // Glyph 120 
  //{ 0x0000,0x0000,0xa000,0xa000,0x4000,0x8000,0x8000 },   // Glyph 121 
  { 0x0000,0x0000,0xa000,0xa000,0x6000,0x2000,0xc000 },   // Glyph 121 
  { 0x0000,0x0000,0xe000,0x2000,0x4000,0x8000,0xe000 },   // Glyph 122 
  { 0x2000,0x4000,0x4000,0x8000,0x4000,0x4000,0x2000 },   // Glyph 123 
  { 0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000 },   // Glyph 124 
  { 0x8000,0x4000,0x4000,0x2000,0x4000,0x4000,0x8000 },   // Glyph 125 
  { 0x0000,0x0000,0x0000,0x5000,0xa000,0x0000,0x0000 },   // Glyph 126 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 127 
  { 0x6000,0x8000,0xc000,0x8000,0xc000,0x8000,0x6000 },   // Glyph 128 
  { 0x7000,0x5000,0x5000,0x5000,0x5000,0x5000,0x7000 },   // Glyph 129 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x8000 },   // Glyph 130 
  { 0x1000,0x2000,0xf000,0x4000,0x4000,0x4000,0x8000 },   // Glyph 131 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x5000,0xa000 },   // Glyph 132 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa000 },   // Glyph 133 
  { 0x4000,0x4000,0xe000,0x4000,0x4000,0x4000,0x4000 },   // Glyph 134 
  { 0x4000,0x4000,0xe000,0x4000,0x4000,0xe000,0x4000 },   // Glyph 135 
  { 0x4000,0xa000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 136 
  { 0xa000,0xa000,0x2000,0x4000,0xd000,0xd000,0x8000 },   // Glyph 137 
  { 0xa000,0x4000,0x0000,0x6000,0x8000,0x6000,0xc000 },   // Glyph 138 
  { 0x0000,0x0000,0x2000,0x4000,0x8000,0x4000,0x2000 },   // Glyph 139 
  { 0x7000,0xa000,0xa000,0xb000,0xa000,0xa000,0x7000 },   // Glyph 140 
  { 0x4000,0x4000,0xe000,0xe000,0xe000,0x4000,0x4000 },   // Glyph 141 
  { 0x4000,0xe000,0x4000,0xe000,0x4000,0x4000,0xe000 },   // Glyph 142 
  { 0xa000,0xe000,0xa000,0xa000,0xa000,0x4000,0x4000 },   // Glyph 143 
  { 0x4000,0xe000,0xe000,0xe000,0x4000,0x4000,0xe000 },   // Glyph 144 
  { 0x4000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 145 
  { 0x2000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 146 
  { 0xa000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 147 
  { 0x5000,0xa000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 148 
  { 0x0000,0x0000,0xe000,0xe000,0xe000,0x0000,0x0000 },   // Glyph 149 
  { 0x0000,0x0000,0x0000,0xe000,0x0000,0x0000,0x0000 },   // Glyph 150 
  { 0x0000,0x0000,0x0000,0xf000,0x0000,0x0000,0x0000 },   // Glyph 151 
  { 0x0000,0x5000,0xa000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 152 
  { 0x2000,0xe000,0x2000,0x0000,0xe000,0x6000,0xe000 },   // Glyph 153 
  { 0xa000,0x4000,0x0000,0x6000,0xc000,0x2000,0xc000 },   // Glyph 154 
  { 0x0000,0x0000,0x8000,0x4000,0x2000,0x4000,0x8000 },   // Glyph 155 
  { 0x0000,0x0000,0x7000,0xa000,0xb000,0xa000,0x7000 },   // Glyph 156 
  { 0xe000,0xa000,0xa000,0xa000,0xa000,0xa000,0xe000 },   // Glyph 157 
  { 0xe000,0xa000,0xa000,0xa000,0xa000,0xa000,0xe000 },   // Glyph 158 
  { 0xa000,0x0000,0xa000,0xa000,0xa000,0x4000,0x4000 },   // Glyph 159 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 160 
  { 0x4000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000 },   // Glyph 161 
  { 0x2000,0x7000,0xa000,0xa000,0xa000,0x7000,0x2000 },   // Glyph 162 
  { 0x2000,0x5000,0x4000,0xf000,0x4000,0xc000,0xb000 },   // Glyph 163 
  { 0x9000,0x9000,0x6000,0x9000,0x6000,0x9000,0x9000 },   // Glyph 164 
  { 0xa000,0x4000,0xe000,0x4000,0xe000,0x4000,0x4000 },   // Glyph 165 
  { 0x4000,0x4000,0x4000,0x0000,0x4000,0x4000,0x4000 },   // Glyph 166 
  { 0x4000,0xa000,0x4000,0xa000,0x6000,0xa000,0x4000 },   // Glyph 167 
  { 0x0000,0xa000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 168 
  { 0x4000,0xa000,0x6000,0xE000,0x0000,0xa000,0x4000 },   // Glyph 169 
  { 0x6000,0xa000,0x6000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 170 
  { 0x0000,0x0000,0x5000,0xa000,0xc000,0xa000,0x5000 },   // Glyph 171 
  { 0x0000,0x0000,0x0000,0xe000,0x2000,0x2000,0x0000 },   // Glyph 172 
  { 0x0000,0x0000,0x0000,0xe000,0x0000,0x0000,0x0000 },   // Glyph 173 
  { 0x4000,0xa000,0x0000,0xc000,0xa000,0x0000,0xE000 },   // Glyph 174 
  { 0xe000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 175 
  { 0x4000,0xa000,0xa000,0x4000,0x0000,0x0000,0x0000 },   // Glyph 176 
  { 0x4000,0x4000,0xe000,0x4000,0x4000,0xe000,0x0000 },   // Glyph 177 
  { 0xe000,0x2000,0x4000,0xe000,0x0000,0x0000,0x0000 },   // Glyph 178 
  { 0xe000,0x4000,0x2000,0xe000,0x0000,0x0000,0x0000 },   // Glyph 179 
  { 0x2000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 180 
  { 0xa000,0xa000,0xa000,0xa000,0xe000,0x8000,0x8000 },   // Glyph 181 
  { 0x6000,0xe000,0xe000,0x6000,0x6000,0x6000,0x6000 },   // Glyph 182 
  { 0x0000,0x0000,0x0000,0x4000,0x0000,0x0000,0x0000 },   // Glyph 183 
  { 0x0000,0x0000,0x0000,0x0000,0x4000,0x2000,0xc000 },   // Glyph 184 
  { 0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 185 
  { 0x4000,0xa000,0x4000,0x0000,0xe000,0x0000,0x0000 },   // Glyph 186 
  { 0x0000,0x0000,0xa000,0x5000,0x3000,0x5000,0xa000 },   // Glyph 187 
  { 0x8000,0x9000,0xa000,0x5000,0xb000,0x7000,0x1000 },   // Glyph 188 
  { 0x8000,0xa000,0x4000,0x8000,0x7000,0x2000,0x7000 },   // Glyph 189 
  { 0xe000,0x2000,0xe000,0x5000,0xb000,0x7000,0x1000 },   // Glyph 190 
  { 0x4000,0x0000,0x4000,0x4000,0x8000,0xa000,0x4000 },   // Glyph 191 
  { 0x8000,0x4000,0x0000,0x4000,0xa000,0xe000,0xa000 },   // Glyph 192 
  { 0x2000,0x4000,0x0000,0x4000,0xa000,0xe000,0xa000 },   // Glyph 193 
  { 0x4000,0xa000,0x0000,0x4000,0xa000,0xe000,0xa000 },   // Glyph 194 
  { 0x5000,0xa000,0x0000,0x4000,0xa000,0xe000,0xa000 },   // Glyph 195 
  { 0xa000,0x0000,0x4000,0xa000,0xe000,0xa000,0xa000 },   // Glyph 196 
  { 0x4000,0xa000,0x4000,0x4000,0xa000,0xe000,0xa000 },   // Glyph 197 
  { 0x7000,0xa000,0xa000,0xf000,0xa000,0xa000,0xb000 },   // Glyph 198 
  { 0x6000,0x8000,0x8000,0x8000,0x6000,0x4000,0x8000 },   // Glyph 199 
  { 0x8000,0x4000,0x0000,0xe000,0x8000,0xe000,0x8000 },   // Glyph 200 
  { 0x4000,0x8000,0x0000,0xe000,0x8000,0xe000,0x8000 },   // Glyph 201 
  { 0x4000,0xa000,0x0000,0xe000,0x8000,0xe000,0x8000 },   // Glyph 202 
  { 0xa000,0x0000,0xe000,0x8000,0xe000,0x8000,0xe000 },   // Glyph 203 
  { 0x8000,0x4000,0x0000,0xe000,0x4000,0x4000,0xe000 },   // Glyph 204 
  { 0x2000,0x4000,0x0000,0xe000,0x4000,0x4000,0xe000 },   // Glyph 205 
  { 0x4000,0xa000,0x0000,0xe000,0x4000,0x4000,0xe000 },   // Glyph 206 
  { 0xa000,0x0000,0x0000,0xe000,0x4000,0x4000,0xe000 },   // Glyph 207 
  { 0x6000,0x5000,0x5000,0xd000,0x5000,0x5000,0x6000 },   // Glyph 208 
  { 0x5000,0xa000,0x0000,0xc000,0xa000,0xa000,0xa000 },   // Glyph 209 
  { 0x8000,0x4000,0x0000,0x4000,0xa000,0xa000,0x4000 },   // Glyph 210 
  { 0x2000,0x4000,0x0000,0x4000,0xa000,0xa000,0x4000 },   // Glyph 211 
  { 0x4000,0xa000,0x0000,0x4000,0xa000,0xa000,0x4000 },   // Glyph 212 
  { 0x5000,0xa000,0x0000,0x4000,0xa000,0xa000,0x4000 },   // Glyph 213 
  { 0xa000,0x0000,0x4000,0xa000,0xa000,0xa000,0x4000 },   // Glyph 214 
  { 0x0000,0x0000,0xa000,0x4000,0x4000,0xa000,0x0000 },   // Glyph 215 
  { 0x6000,0xa000,0xa000,0xe000,0xa000,0xa000,0xc000 },   // Glyph 216 
  { 0x4000,0x2000,0x0000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 217 
  { 0x2000,0x4000,0x0000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 218 
  { 0x4000,0xa000,0x0000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 219 
  { 0xa000,0x0000,0xa000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 220 
  { 0x2000,0x4000,0x0000,0xa000,0xa000,0x4000,0x4000 },   // Glyph 221 
  { 0x8000,0xc000,0xa000,0xa000,0xa000,0xc000,0x8000 },   // Glyph 222 
  { 0x4000,0xa000,0xc000,0xa000,0xa000,0x2000,0x4000 },   // Glyph 223 
  { 0x4000,0x2000,0x0000,0x4000,0x6000,0xa000,0x6000 },   // Glyph 224 
  { 0x2000,0x4000,0x0000,0x4000,0x6000,0xa000,0x6000 },   // Glyph 225 
  { 0x4000,0xa000,0x0000,0x4000,0x6000,0xa000,0x6000 },   // Glyph 226 
  { 0x5000,0xa000,0x0000,0x4000,0x6000,0xa000,0x6000 },   // Glyph 227 
  { 0xa000,0x0000,0x4000,0x2000,0x6000,0xa000,0x6000 },   // Glyph 228 
  { 0x4000,0xa000,0x4000,0x0000,0x6000,0xe000,0x6000 },   // Glyph 229 
  { 0x0000,0x0000,0xb000,0x6000,0x7000,0xa000,0x7000 },   // Glyph 230 
  { 0x6000,0x8000,0x8000,0x8000,0x6000,0x4000,0x8000 },   // Glyph 231 
  { 0x8000,0x4000,0x0000,0x4000,0xe000,0x8000,0x6000 },   // Glyph 232 
  { 0x2000,0x4000,0x0000,0x4000,0xe000,0x8000,0x6000 },   // Glyph 233 
  { 0x4000,0xa000,0x0000,0x4000,0xe000,0x8000,0x6000 },   // Glyph 234 
  { 0xa000,0x0000,0x4000,0xa000,0xe000,0x8000,0x6000 },   // Glyph 235 
  { 0x8000,0x4000,0x0000,0xc000,0x4000,0x4000,0xe000 },   // Glyph 236 
  { 0x2000,0x4000,0x0000,0xc000,0x4000,0x4000,0xe000 },   // Glyph 237 
  { 0x4000,0xa000,0x0000,0xc000,0x4000,0x4000,0xe000 },   // Glyph 238 
  { 0xa000,0x0000,0xc000,0x4000,0x4000,0x4000,0xe000 },   // Glyph 239 
  { 0xc000,0xe000,0x2000,0x6000,0xa000,0xa000,0x4000 },   // Glyph 240 
  { 0x5000,0xa000,0x0000,0xc000,0xa000,0xa000,0xa000 },   // Glyph 241 
  { 0x8000,0x4000,0x0000,0x4000,0xa000,0xa000,0x4000 },   // Glyph 242 
  { 0x2000,0x4000,0x0000,0x4000,0xa000,0xa000,0x4000 },   // Glyph 243 
  { 0x4000,0xa000,0x0000,0x4000,0xa000,0xa000,0x4000 },   // Glyph 244 
  { 0x5000,0xa000,0x0000,0x4000,0xa000,0xa000,0x4000 },   // Glyph 245 
  { 0xa000,0x0000,0x4000,0xa000,0xa000,0xa000,0x4000 },   // Glyph 246 
  { 0x0000,0x0000,0x4000,0x0000,0xe000,0x0000,0x4000 },   // Glyph 247 
  { 0x0000,0x0000,0x6000,0xa000,0xe000,0xa000,0xc000 },   // Glyph 248 
  { 0x4000,0x2000,0x0000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 249 
  { 0x2000,0x4000,0x0000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 250 
  { 0x4000,0xa000,0x0000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 251 
  { 0xa000,0x0000,0xa000,0xa000,0xa000,0xa000,0x6000 },   // Glyph 252 
  { 0x6000,0x0000,0xa000,0xa000,0xa000,0x4000,0x8000 },   // Glyph 253 
  { 0x8000,0x8000,0xc000,0xa000,0xa000,0xc000,0x8000 },   // Glyph 254 
  { 0xa000,0x0000,0xa000,0xa000,0xa000,0x4000,0x8000 }    // Glyph 255 
};

static USHORT stdFixedFontBitmap[256][stdFixedFontHeight] = {
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 0 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 1 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 2 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 3 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 4 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 5 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 6 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 7 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 8 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 9 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 10 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 11 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 12 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 13 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 14 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 15 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 16 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 17 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 18 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 19 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 20 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 21 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 22 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 23 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 24 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 25 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 26 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 27 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 28 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 29 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 30 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 31 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 32 
  { 0x0000,0x0000,0x2000,0x2000,0x2000,0x2000,0x0000,0x2000,0x0000 },   // Glyph 33 
  { 0x0000,0x5000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 34 
  { 0x0000,0x0000,0x5000,0xf800,0x5000,0xf800,0x5000,0x0000,0x0000 },   // Glyph 35 
  { 0x0000,0x2000,0x7800,0xa000,0x7000,0x2800,0xa800,0x7000,0x2000 },   // Glyph 36 
  { 0x0000,0x0000,0x7800,0xa800,0xb000,0x6800,0xa800,0x9000,0x0000 },   // Glyph 37 
  { 0x0000,0x0000,0x4000,0xa000,0x4000,0x5000,0xa000,0x5000,0x0000 },   // Glyph 38 
  { 0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 39 
  { 0x0000,0x1000,0x2000,0x4000,0x4000,0x4000,0x4000,0x2000,0x1000 },   // Glyph 40 
  { 0x0000,0x8000,0x4000,0x2000,0x2000,0x2000,0x2000,0x4000,0x8000 },   // Glyph 41 
  { 0x0000,0x0000,0x4000,0x9000,0x6000,0x9000,0x2000,0x0000,0x0000 },   // Glyph 42 
  { 0x0000,0x0000,0x0000,0x0000,0x4000,0xe000,0x4000,0x0000,0x0000 },   // Glyph 43 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x8000 },   // Glyph 44 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0xe000,0x0000,0x0000,0x0000 },   // Glyph 45 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x0000 },   // Glyph 46 
  { 0x0000,0x1000,0x1000,0x2000,0x4000,0x4000,0x8000,0x8000,0x0000 },   // Glyph 47 
  { 0x0000,0x0000,0x6000,0x9000,0xb000,0xd000,0x9000,0x6000,0x0000 },   // Glyph 48 
  { 0x0000,0x0000,0x2000,0x6000,0x2000,0x2000,0x2000,0x7000,0x0000 },   // Glyph 49 
  { 0x0000,0x0000,0x6000,0x9000,0x1000,0x2000,0x4000,0xf000,0x0000 },   // Glyph 50 
  { 0x0000,0x0000,0x6000,0x9000,0x2000,0x1000,0x9000,0x6000,0x0000 },   // Glyph 51 
  { 0x0000,0x0000,0x2000,0x6000,0xa000,0xf000,0x2000,0x7000,0x0000 },   // Glyph 52 
  { 0x0000,0x0000,0xf000,0x8000,0xe000,0x1000,0x9000,0x6000,0x0000 },   // Glyph 53 
  { 0x0000,0x0000,0x6000,0x8000,0xe000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 54 
  { 0x0000,0x0000,0xf000,0x1000,0x2000,0x4000,0x4000,0x4000,0x0000 },   // Glyph 55 
  { 0x0000,0x0000,0x6000,0x9000,0x6000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 56 
  { 0x0000,0x0000,0x6000,0x9000,0x9000,0x7000,0x1000,0x6000,0x0000 },   // Glyph 57 
  { 0x0000,0x0000,0x0000,0x0000,0x2000,0x0000,0x0000,0x2000,0x0000 },   // Glyph 58 
  { 0x0000,0x0000,0x0000,0x0000,0x4000,0x0000,0x0000,0x4000,0x8000 },   // Glyph 59 
  { 0x0000,0x0000,0x0000,0x1000,0x2000,0x4000,0x2000,0x1000,0x0000 },   // Glyph 60 
  { 0x0000,0x0000,0x0000,0x0000,0xf000,0x0000,0xf000,0x0000,0x0000 },   // Glyph 61 
  { 0x0000,0x0000,0x0000,0x4000,0x2000,0x1000,0x2000,0x4000,0x0000 },   // Glyph 62 
  { 0x0000,0x0000,0x6000,0x9000,0x2000,0x4000,0x0000,0x4000,0x0000 },   // Glyph 63 
  { 0x0000,0x0000,0x6000,0x9000,0xb000,0xb000,0x8000,0x7000,0x0000 },   // Glyph 64 
  { 0x0000,0x0000,0x6000,0x9000,0x9000,0xf000,0x9000,0x9000,0x0000 },   // Glyph 65 
  { 0x0000,0x0000,0xe000,0x9000,0xe000,0x9000,0x9000,0xe000,0x0000 },   // Glyph 66 
  { 0x0000,0x0000,0x6000,0x9000,0x8000,0x8000,0x9000,0x6000,0x0000 },   // Glyph 67 
  { 0x0000,0x0000,0xe000,0x9000,0x9000,0x9000,0x9000,0xe000,0x0000 },   // Glyph 68 
  { 0x0000,0x0000,0xf000,0x8000,0xe000,0x8000,0x8000,0xf000,0x0000 },   // Glyph 69 
  { 0x0000,0x0000,0xf000,0x8000,0xe000,0x8000,0x8000,0x8000,0x0000 },   // Glyph 70 
  { 0x0000,0x0000,0x6000,0x9000,0x8000,0xb000,0x9000,0x6000,0x0000 },   // Glyph 71 
  { 0x0000,0x0000,0x9000,0x9000,0xf000,0x9000,0x9000,0x9000,0x0000 },   // Glyph 72 
  { 0x0000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000 },   // Glyph 73 
  { 0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x9000,0x6000,0x0000 },   // Glyph 74 
  { 0x0000,0x0000,0x9000,0xa000,0xc000,0xc000,0xa000,0x9000,0x0000 },   // Glyph 75 
  { 0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0xf000,0x0000 },   // Glyph 76 
  { 0x0000,0x0000,0x9000,0xf000,0xf000,0x9000,0x9000,0x9000,0x0000 },   // Glyph 77 
  { 0x0000,0x0000,0x9000,0xd000,0xb000,0x9000,0x9000,0x9000,0x0000 },   // Glyph 78 
  { 0x0000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 79 
  { 0x0000,0x0000,0xe000,0x9000,0x9000,0xe000,0x8000,0x8000,0x0000 },   // Glyph 80 
  { 0x0000,0x0000,0x6000,0x9000,0x9000,0x9000,0xb000,0x6000,0x1000 },   // Glyph 81 
  { 0x0000,0x0000,0xe000,0x9000,0x9000,0xe000,0x9000,0x9000,0x0000 },   // Glyph 82 
  { 0x0000,0x0000,0x7000,0x8000,0x6000,0x1000,0x1000,0xe000,0x0000 },   // Glyph 83 
  { 0x0000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000 },   // Glyph 84 
  { 0x0000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 85 
  { 0x0000,0x0000,0x9000,0x9000,0x9000,0x9000,0xa000,0x4000,0x0000 },   // Glyph 86 
  { 0x0000,0x0000,0x9000,0x9000,0x9000,0xf000,0xf000,0x9000,0x0000 },   // Glyph 87 
  { 0x0000,0x0000,0x9000,0x9000,0x6000,0x6000,0x9000,0x9000,0x0000 },   // Glyph 88 
  { 0x0000,0x0000,0x9000,0x9000,0xa000,0x4000,0x4000,0x4000,0x0000 },   // Glyph 89 
  { 0x0000,0x0000,0xf000,0x1000,0x2000,0x4000,0x8000,0xf000,0x0000 },   // Glyph 90 
  { 0x0000,0x3000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x3000 },   // Glyph 91 
  { 0x0000,0x8000,0x8000,0x4000,0x2000,0x2000,0x1000,0x1000,0x0000 },   // Glyph 92 
  { 0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x6000 },   // Glyph 93 
  { 0x0000,0x0000,0x2000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 94 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800 },   // Glyph 95 
  { 0x0000,0x4000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 96 
  { 0x0000,0x0000,0x0000,0x0000,0x7000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 97 
  { 0x0000,0x0000,0x8000,0x8000,0xe000,0x9000,0x9000,0xe000,0x0000 },   // Glyph 98 
  { 0x0000,0x0000,0x0000,0x0000,0x6000,0x9000,0x8000,0x7000,0x0000 },   // Glyph 99 
  { 0x0000,0x0000,0x1000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },   // Glyph 100 
  { 0x0000,0x0000,0x0000,0x0000,0x6000,0xf000,0x8000,0x7000,0x0000 },   // Glyph 101 
  { 0x0000,0x0000,0x1000,0x2000,0x7000,0x2000,0x2000,0x2000,0x0000 },   // Glyph 102 
  { 0x0000,0x0000,0x0000,0x0000,0x7000,0x9000,0x7000,0x1000,0x6000 },   // Glyph 103 
  { 0x0000,0x0000,0x8000,0x8000,0xe000,0x9000,0x9000,0x9000,0x0000 },   // Glyph 104 
  { 0x0000,0x0000,0x2000,0x0000,0x6000,0x2000,0x2000,0x7000,0x0000 },   // Glyph 105 
  { 0x0000,0x2000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x4000 },   // Glyph 106 
  { 0x0000,0x0000,0x8000,0x8000,0xa000,0xc000,0xa000,0x9000,0x0000 },   // Glyph 107 
  { 0x0000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000 },   // Glyph 108 
  { 0x0000,0x0000,0x0000,0x0000,0xf000,0xa800,0xa800,0xa800,0x0000 },   // Glyph 109 
  { 0x0000,0x0000,0x0000,0x0000,0xa000,0xd000,0x9000,0x9000,0x0000 },   // Glyph 110 
  { 0x0000,0x0000,0x0000,0x0000,0x6000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 111 
  { 0x0000,0x0000,0x0000,0x0000,0xe000,0x9000,0x9000,0xe000,0x8000 },   // Glyph 112 
  { 0x0000,0x0000,0x0000,0x0000,0x7000,0x9000,0x9000,0x7000,0x1000 },   // Glyph 113 
  { 0x0000,0x0000,0x0000,0x0000,0xa000,0xd000,0x8000,0x8000,0x0000 },   // Glyph 114 
  { 0x0000,0x0000,0x0000,0x0000,0x7000,0xe000,0x1000,0xe000,0x0000 },   // Glyph 115 
  { 0x0000,0x0000,0x2000,0x2000,0x7000,0x2000,0x2000,0x1000,0x0000 },   // Glyph 116 
  { 0x0000,0x0000,0x0000,0x0000,0x9000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 117 
  { 0x0000,0x0000,0x0000,0x0000,0x9000,0x9000,0xa000,0x4000,0x0000 },   // Glyph 118 
  { 0x0000,0x0000,0x0000,0x0000,0xa800,0xa800,0xa800,0x7000,0x0000 },   // Glyph 119 
  { 0x0000,0x0000,0x0000,0x0000,0x9000,0x6000,0x6000,0x9000,0x0000 },   // Glyph 120 
  { 0x0000,0x0000,0x0000,0x0000,0x9000,0x9000,0x7000,0x1000,0x6000 },   // Glyph 121 
  { 0x0000,0x0000,0x0000,0x0000,0xf000,0x2000,0x4000,0xf000,0x0000 },   // Glyph 122 
  { 0x1000,0x2000,0x2000,0x2000,0x4000,0x2000,0x2000,0x2000,0x1000 },   // Glyph 123 
  { 0x0000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000 },   // Glyph 124 
  { 0x4000,0x2000,0x2000,0x2000,0x1000,0x2000,0x2000,0x2000,0x4000 },   // Glyph 125 
  { 0x0000,0x0000,0x0000,0x0000,0x5000,0xa000,0x0000,0x0000,0x0000 },   // Glyph 126 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 127 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 128 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 129 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x8000 },   // Glyph 130 
  { 0x1000,0x2000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x4000 },   // Glyph 131 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x5000,0xa000 },   // Glyph 132 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa800,0x0000 },   // Glyph 133 
  { 0x0000,0x0000,0x2000,0x7000,0x2000,0x2000,0x2000,0x0000,0x0000 },   // Glyph 134 
  { 0x0000,0x0000,0x2000,0x7000,0x2000,0x7000,0x2000,0x0000,0x0000 },   // Glyph 135 
  { 0x2000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 136 
  { 0x0000,0x0000,0x7800,0xd000,0xe000,0x7000,0xf800,0x7000,0x0000 },   // Glyph 137 
  { 0x5000,0x2000,0x0000,0x7000,0x8000,0x6000,0x1000,0x1000,0xe000 },   // Glyph 138 
  { 0x0000,0x0000,0x0000,0x1000,0x2000,0x4000,0x2000,0x1000,0x0000 },   // Glyph 139 
  { 0x0000,0x0000,0x7000,0xa000,0xb000,0xa000,0xa000,0x7000,0x0000 },   // Glyph 140 
  { 0x0000,0x0000,0x0000,0x2000,0x5000,0x8800,0x5000,0x2000,0x0000 },   // Glyph 141 
  { 0x0000,0x2000,0x7000,0xf800,0xf800,0x7000,0x2000,0x7000,0x0000 },   // Glyph 142 
  { 0x0000,0x0000,0x0000,0x5000,0xa800,0x8800,0x5000,0x2000,0x0000 },   // Glyph 143 
  { 0x0000,0x2000,0x7000,0xf800,0xf800,0xf800,0x2000,0x7000,0x0000 },   // Glyph 144 
  { 0x0000,0x4000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 145 
  { 0x0000,0x2000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 146 
  { 0x0000,0xa000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 147 
  { 0x0000,0x5000,0xa000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 148 
  { 0x0000,0x0000,0x0000,0x7000,0x7000,0x7000,0x0000,0x0000,0x0000 },   // Glyph 149 
  { 0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000,0x0000,0x0000 },   // Glyph 150 
  { 0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000,0x0000,0x0000 },   // Glyph 151 
  { 0x0000,0x0000,0x5000,0xa000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 152 
  { 0x0000,0xf800,0x5800,0x5800,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 153 
  { 0x0000,0x5000,0x2000,0x0000,0x7000,0xe000,0x1000,0xe000,0x0000 },   // Glyph 154 
  { 0x0000,0x0000,0x0000,0x4000,0x2000,0x1000,0x2000,0x4000,0x0000 },   // Glyph 155 
  { 0x0000,0x0000,0x0000,0x0000,0x7000,0xb000,0xa000,0x7000,0x0000 },   // Glyph 156 
  { 0x0000,0x0000,0x0200,0x0400,0x0800,0x1000,0x2000,0xc000,0xc000 },   // Glyph 157 
  { 0x1000,0x2800,0x2800,0x2800,0x2800,0x1000,0x2800,0xc400,0xc200 },   // Glyph 158 
  { 0x5000,0x0000,0x9000,0x9000,0xa000,0x4000,0x4000,0x4000,0x0000 },   // Glyph 159 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 160 
  { 0x0000,0x0000,0x0000,0x2000,0x0000,0x2000,0x2000,0x2000,0x2000 },   // Glyph 161 
  { 0x0000,0x0000,0x0000,0x2000,0x6000,0xb000,0xc000,0x7000,0x4000 },   // Glyph 162 
  { 0x0000,0x0000,0x6000,0x8000,0xc000,0x8000,0x9000,0xe000,0x0000 },   // Glyph 163 
  { 0x0000,0x0000,0x0000,0xa800,0x7000,0xd800,0x7000,0xa800,0x0000 },   // Glyph 164 
  { 0x0000,0x0000,0x5000,0x2000,0x7000,0x2000,0x7000,0x2000,0x0000 },   // Glyph 165 
  { 0x2000,0x2000,0x2000,0x2000,0x0000,0x2000,0x2000,0x2000,0x2000 },   // Glyph 166 
  { 0x0000,0x6000,0x9000,0x4000,0xa000,0x5000,0x2000,0x9000,0x6000 },   // Glyph 167 
  { 0x0000,0x0000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 168 
  { 0x0000,0x0000,0x0000,0x7000,0x8800,0xa800,0x8800,0x7000,0x0000 },   // Glyph 169 
  { 0x0000,0x7000,0x9000,0xb000,0x5000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 170 
  { 0x0000,0x0000,0x0000,0x0000,0x4800,0x9000,0x4800,0x0000,0x0000 },   // Glyph 171 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0x1000,0x0000,0x0000 },   // Glyph 172 
  { 0x0000,0x0000,0x0000,0x0000,0x7000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 173 
  { 0x0000,0x0000,0x0000,0x7000,0x8800,0xa800,0x8800,0x7000,0x0000 },   // Glyph 174 
  { 0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 175 
  { 0x6000,0x9000,0x9000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 176 
  { 0x0000,0x0000,0x0000,0x4000,0xe000,0x4000,0xe000,0x0000,0x0000 },   // Glyph 177 
  { 0x0000,0x7000,0x1000,0x2000,0x7000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 178 
  { 0x0000,0x7000,0x2000,0x1000,0x7000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 179 
  { 0x0000,0x1000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 180 
  { 0x0000,0x0000,0x0000,0x0000,0xa000,0xa000,0xa000,0xd000,0x8000 },   // Glyph 181 
  { 0x0000,0x0000,0x7000,0xb000,0xb000,0x7000,0x3000,0x3000,0x0000 },   // Glyph 182 
  { 0x0000,0x0000,0x0000,0x0000,0x2000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 183 
  { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x2000,0x4000 },   // Glyph 184 
  { 0x0000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000 },   // Glyph 185 
  { 0x0000,0x6000,0x9000,0x6000,0x0000,0xf000,0x0000,0x0000,0x0000 },   // Glyph 186 
  { 0x0000,0x0000,0x0000,0x0000,0x9000,0x4800,0x9000,0x0000,0x0000 },   // Glyph 187 
  { 0x0000,0x8000,0x8800,0x9000,0x2000,0x5000,0xb800,0x1000,0x0000 },   // Glyph 188 
  { 0x0000,0x8000,0x8800,0x9000,0x2000,0x5000,0x8800,0x1800,0x0000 },   // Glyph 189 
  { 0x0000,0xc000,0xc800,0xd000,0x2000,0x5000,0xb800,0x1000,0x0000 },   // Glyph 190 
  { 0x0000,0x0000,0x0000,0x2000,0x0000,0x2000,0x4000,0x9000,0x6000 },   // Glyph 191 
  { 0x4000,0x2000,0x0000,0x6000,0x9000,0x9000,0xf000,0x9000,0x9000 },   // Glyph 192 
  { 0x2000,0x4000,0x0000,0x6000,0x9000,0x9000,0xf000,0x9000,0x9000 },   // Glyph 193 
  { 0x2000,0x5000,0x0000,0x6000,0x9000,0x9000,0xf000,0x9000,0x9000 },   // Glyph 194 
  { 0x5000,0xa000,0x0000,0x6000,0x9000,0x9000,0xf000,0x9000,0x9000 },   // Glyph 195 
  { 0x5000,0x0000,0x6000,0x9000,0x9000,0xf000,0x9000,0x9000,0x0000 },   // Glyph 196 
  { 0x6000,0x9000,0x6000,0x6000,0x9000,0x9000,0xf000,0x9000,0x9000 },   // Glyph 197 
  { 0x0000,0x0000,0x7000,0xa000,0xf000,0xa000,0xa000,0xb000,0x0000 },   // Glyph 198 
  { 0x0000,0x6000,0x9000,0x8000,0x8000,0x9000,0x6000,0x2000,0x4000 },   // Glyph 199 
  { 0x4000,0x2000,0x0000,0xf000,0x8000,0xe000,0x8000,0x8000,0xf000 },   // Glyph 200 
  { 0x2000,0x4000,0x0000,0xf000,0x8000,0xe000,0x8000,0x8000,0xf000 },   // Glyph 201 
  { 0x2000,0x5000,0x0000,0xf000,0x8000,0xe000,0x8000,0x8000,0xf000 },   // Glyph 202 
  { 0x5000,0x0000,0xf000,0x8000,0xe000,0x8000,0x8000,0xf000,0x0000 },   // Glyph 203 
  { 0x4000,0x2000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x7000 },   // Glyph 204 
  { 0x1000,0x2000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x7000 },   // Glyph 205 
  { 0x2000,0x5000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x7000 },   // Glyph 206 
  { 0x5000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000 },   // Glyph 207 
  { 0x0000,0x0000,0x7000,0x4800,0xe800,0x4800,0x4800,0x7000,0x0000 },   // Glyph 208 
  { 0x5000,0xa000,0x0000,0x9000,0xd000,0xb000,0x9000,0x9000,0x9000 },   // Glyph 209 
  { 0x4000,0x2000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000 },   // Glyph 210 
  { 0x2000,0x4000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000 },   // Glyph 211 
  { 0x2000,0x5000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000 },   // Glyph 212 
  { 0x5000,0xa000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000 },   // Glyph 213 
  { 0x5000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 214 
  { 0x0000,0x0000,0x0000,0x9000,0x6000,0x6000,0x9000,0x0000,0x0000 },   // Glyph 215 
  { 0x0000,0x0000,0x6000,0x9000,0xb000,0xd000,0x9000,0x6000,0x0000 },   // Glyph 216 
  { 0x4000,0x2000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000 },   // Glyph 217 
  { 0x2000,0x4000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000 },   // Glyph 218 
  { 0x2000,0x5000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000 },   // Glyph 219 
  { 0x5000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 220 
  { 0x2000,0x4000,0x0000,0x9000,0x9000,0xa000,0x4000,0x4000,0x4000 },   // Glyph 221 
  { 0x0000,0x8000,0xe000,0x9000,0x9000,0x9000,0xe000,0x8000,0x0000 },   // Glyph 222 
  { 0x0000,0x0000,0x6000,0x9000,0xa000,0xa000,0x9000,0xa000,0x8000 },   // Glyph 223 
  { 0x0000,0x4000,0x2000,0x0000,0x7000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 224 
  { 0x0000,0x2000,0x4000,0x0000,0x7000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 225 
  { 0x0000,0x2000,0x5000,0x0000,0x7000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 226 
  { 0x0000,0x5000,0xa000,0x0000,0x7000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 227 
  { 0x0000,0x0000,0x5000,0x0000,0x7000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 228 
  { 0x2000,0x5000,0x2000,0x0000,0x7000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 229 
  { 0x0000,0x0000,0x0000,0x0000,0x7000,0xb000,0xa000,0x5000,0x0000 },   // Glyph 230 
  { 0x0000,0x0000,0x0000,0x6000,0x9000,0x8000,0x7000,0x2000,0x4000 },   // Glyph 231 
  { 0x0000,0x4000,0x2000,0x0000,0x6000,0xf000,0x8000,0x7000,0x0000 },   // Glyph 232 
  { 0x0000,0x2000,0x4000,0x0000,0x6000,0xf000,0x8000,0x7000,0x0000 },   // Glyph 233 
  { 0x0000,0x2000,0x5000,0x0000,0x6000,0xf000,0x8000,0x7000,0x0000 },   // Glyph 234 
  { 0x0000,0x0000,0x5000,0x0000,0x6000,0xf000,0x8000,0x7000,0x0000 },   // Glyph 235 
  { 0x0000,0x4000,0x2000,0x0000,0x6000,0x2000,0x2000,0x7000,0x0000 },   // Glyph 236 
  { 0x0000,0x2000,0x4000,0x0000,0x6000,0x2000,0x2000,0x7000,0x0000 },   // Glyph 237 
  { 0x0000,0x2000,0x5000,0x0000,0x6000,0x2000,0x2000,0x7000,0x0000 },   // Glyph 238 
  { 0x0000,0x0000,0x5000,0x0000,0x6000,0x2000,0x2000,0x7000,0x0000 },   // Glyph 239 
  { 0x0000,0xc000,0xc000,0x2000,0x6000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 240 
  { 0x0000,0x5000,0xa000,0x0000,0xa000,0xd000,0x9000,0x9000,0x0000 },   // Glyph 241 
  { 0x0000,0x4000,0x2000,0x0000,0x6000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 242 
  { 0x0000,0x2000,0x4000,0x0000,0x6000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 243 
  { 0x0000,0x2000,0x5000,0x0000,0x6000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 244 
  { 0x0000,0x5000,0xa000,0x0000,0x6000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 245 
  { 0x0000,0x0000,0x5000,0x0000,0x6000,0x9000,0x9000,0x6000,0x0000 },   // Glyph 246 
  { 0x0000,0x0000,0x0000,0x4000,0x0000,0xe000,0x0000,0x4000,0x0000 },   // Glyph 247 
  { 0x0000,0x0000,0x0000,0x0000,0x6000,0xb000,0xd000,0x6000,0x0000 },   // Glyph 248 
  { 0x0000,0x4000,0x2000,0x0000,0x9000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 249 
  { 0x0000,0x2000,0x4000,0x0000,0x9000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 250 
  { 0x0000,0x2000,0x5000,0x0000,0x9000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 251 
  { 0x0000,0x0000,0x5000,0x0000,0x9000,0x9000,0xb000,0x5000,0x0000 },   // Glyph 252 
  { 0x2000,0x4000,0x0000,0x9000,0x9000,0x9000,0x7000,0x1000,0x6000 },   // Glyph 253 
  { 0x8000,0x8000,0xe000,0x9000,0x9000,0x9000,0xe000,0x8000,0x8000 },   // Glyph 254 
  { 0x0000,0x5000,0x0000,0x9000,0x9000,0x9000,0x7000,0x1000,0x6000 }    // Glyph 255 
};

static void *font_bitmap[numFonts] = { smallFontBitmap, stdFontBitmap, smallFixedFontBitmap, stdFixedFontBitmap, NULL};
static BYTE *font_width[numFonts]  = { widthSmall, widthStd, widthSmallFixed, widthStdFixed, widthUser };
static BYTE font_fixed[numFonts]   = { 0, 0, 1, 1, 0 };
static BYTE font_height[numFonts]  = { smallFontHeight, stdFontHeight, smallFixedFontHeight, stdFixedFontHeight, 0 };

#define MAX_FONT_PIXEL 	16			// 16 x 16 characters // brian
#define MAX_FONT_SIZE	MAX_FONT_PIXEL * MAX_FONT_PIXEL * BITS_OF_GREY / SIZE_OF_WORD // brian
static UBYTE font_template[sizeof(BitmapTemplate)]; // brian
static UWORD font_data[MAX_FONT_SIZE]; // brian

// What is our typeface?
static int currentFont = smallFont;
static int currentUnderline = FALSE;


int FntLineHeight(void)  // Height of character + linespace
{
  if (currentFont==userFont) return font_height[currentFont];
  return font_height[currentFont] + 1;
}

int FntCharHeight(void)  // Height of just character
{
  return font_height[currentFont];
}


void FntSetFont(int fontID) // Set font to ID
{
  if (fontID==userFont && font_bitmap[userFont]==NULL)
    fontID = smallFont;

  if (fontID>=smallFont && fontID<=userFont)
    currentFont = fontID;
}

int FntGetFont(void) // Current font
{
  return currentFont;
}

int FntIsFixedWidth(int fontID) // Is font fixed width?
{
  return font_fixed[currentFont];
}


int FntCharsWidth(const unsigned char *string, int len) // Width of string when displayed
{
  UWORD width;
  
  width = 0;
  while (len--)
    width += FntCharWidth(*(string++));
  return width;
}

static int fntstrlen(const unsigned char *str) {
  int i;
  i=0;
  while (*str) { i++; str++; }
  return i;
}

int FntStringWidth(const unsigned char *string) // Width of string when displayed
{
  return FntCharsWidth(string, fntstrlen(string));
}

int FntCharWidth(unsigned char chr) // Width of string when displayed
{
  const BYTE *text_width = font_width[currentFont];
  return text_width[chr];
}

void FntSetUnderlineMode(int underline) // 0=no underline, !0=underline
{
  if (underline) 
    currentUnderline = TRUE;
  else
    currentUnderline = FALSE;
}


static BitmapTemplate *char_to_bitmap(UBYTE character, int invert)
{
  USHORT 	byte;
  UWORD 	i, j, word1, word2; // brian
  const 	USHORT  *byte_ptr;
  UWORD 	*data_ptr = font_data;
  UWORD 	width;
  UWORD   *under;
  BitmapTemplate *bitmap_struct;
  BYTE font;
  BYTE color;
  BYTE bg_color;
	
  font = currentFont;
  if (invert) { bg_color = COLOR_BLACK; color = COLOR_WHITE; }
  else        { color = COLOR_BLACK; bg_color = COLOR_WHITE; }
	
  bitmap_struct = (BitmapTemplate *)font_template; // brian
	
  byte_ptr = (USHORT*)font_bitmap[currentFont];
  byte_ptr += font_height[currentFont] * character;
	
	
  width = FntCharWidth(character);
  bitmap_struct->width = width;
  bitmap_struct->height = (SHORT)(font_height[font] + SPACE_LINE);
  bitmap_struct->bitmap_data = (UWORD *)font_data;
  bitmap_struct->quantisation = Q_FOUR_BIT;
	
  i = font_height[currentFont];
  do {
    byte = *byte_ptr;
    byte_ptr++;
    word1 = 0;
    word2 = 0;
		
    j = SIZE_OF_WORD/BITS_OF_GREY;
    do {
      word1 <<= BITS_OF_GREY;
      if ((USHORT)(byte & 0x8000) == 0x8000)
	word1 += color;
      else
	word1 += bg_color;
      if (width > 8) {
	word2 <<= BITS_OF_GREY;
	if ((USHORT)(byte & 0x0080) == 0x0080)
	  word2 += color;
	else
	  word2 += bg_color;
      }
      byte <<= 1;
    } while (--j);
		
    *data_ptr++ = word1;
    if (width > 8) *data_ptr++ = word2;
  } while (--i);

  if (currentUnderline) {
    // calculate the underline color
    i = SIZE_OF_WORD/BITS_OF_GREY;
    j = 0;
    do {j <<= BITS_OF_GREY; j += color;} while (--i);
    if (width>8) under = data_ptr-2;
    else under = data_ptr-1;

    *under++ = j;
    if (width > 8) *under++ = j;
  }	

  // calculate the background color
  i = SIZE_OF_WORD/BITS_OF_GREY;
  j = 0;
  do {j <<= BITS_OF_GREY; j += bg_color;} while (--i);
	
  // fill the space line with background color
  i = SPACE_LINE;
  while(i) {
    *data_ptr++ = j;
    if (width > 8) *data_ptr++ = j;
    i--;
  }
	
  return bitmap_struct;
}


void FntDrawChar(unsigned char letter, int xstart, int ystart, int invert) // x,y from upper-left hand corner
{
  BitmapTemplate *bitmap_struct;
  bitmap_struct = char_to_bitmap(letter, invert);
  bitmap_struct->xcoord = xstart;
  bitmap_struct->ycoord = ystart;
  while (bitmap_struct->ycoord<0) {
    bitmap_struct->ycoord++;
    bitmap_struct->bitmap_data++;
    bitmap_struct->height--;
  }

  while (bitmap_struct->ycoord>159) {
    bitmap_struct->ycoord--;
    bitmap_struct->height--;
  }
  if (bitmap_struct->xcoord>160) return;
  while (bitmap_struct->xcoord+bitmap_struct->width>160) {
    bitmap_struct->width--;
  }
  if (bitmap_struct->height<=0) return;
  if (bitmap_struct->width<=0) return;
  LcdDrawBitmap(bitmap_struct, COLOR_NO_INVERT);
}

void FntDrawChars(const unsigned char *string, int len, int xstart, int ystart, int invert) // x,y from upper-left hand corner
{
  while (len) {
    FntDrawChar(*string, xstart, ystart, invert);
    xstart += FntCharWidth(*string);
    len--;
    string++;
  }
}

void FntDrawString(const unsigned char *string, int xstart, int ystart, int invert) // x,y from upper-left hand corner
{
  FntDrawChars(string, fntstrlen(string), xstart, ystart, invert);
}


void FntBeep()
{
  SndPlaySndEffect(SNDRES5_BEEP);
}

void FntClearScreen()
{
  ObjectBounds bnds;
  bnds.xcoord = bnds.ycoord = 0;
  bnds.width = bnds.height = 160;
  LcdEraseRegion(&bnds);
}


void FntInstallFont(const char *filename)
{
  FILE *fp;
  unsigned char *data;
  unsigned char *ptr, *bitmap, *bmloc, *offw;
  unsigned short tmp;
  unsigned short first;
  unsigned short last;
  unsigned short owloc;
  unsigned short roww;
  unsigned short height;
  unsigned short bmoff;
  unsigned short glyphbyte, glyphbit, *shortptr;
  unsigned long lng;
  int y, i;

  fp = fopen(filename,"rb");
  if (fp==NULL) return;
  data = qmalloc(fsize(fp));
  if (data==NULL) {
    fclose(fp);
    return;
  }
  fread(data, 1, fsize(fp), fp);
  fclose(fp);
  ptr = data+0x58; // Skip PDB header
  ptr += 2; // Skip Font Type;
  first = *(ptr++); first = (first<<8) + *(ptr++);
  last = *(ptr++); last = (last<<8) + *(ptr++);
  ptr += 2; // Skip maxwidth
  ptr += 2; // Skip kernmax
  ptr += 2; // Skip negdesc
  ptr += 2; // Skip rwid
  height = *(ptr++); height = (height<<8) + *(ptr++);
  owloc = *(ptr++); owloc = (owloc<<8) + *(ptr++);
  owloc *= 2; // Now in bytes
  owloc += 16; // Header skip
  ptr += 2; // Skip asc
  ptr += 2; // Skip des
  ptr += 2; // Skip lead
  roww = *(ptr++); roww = (roww<<8) + *(ptr++);
  bitmap = ptr;
  ptr += (roww*2)*height;
  bmloc = ptr;
  offw = data + 0x58 + owloc;

  font_height[userFont] = height;
  for(i=0;i<256;i++) {
    if (i<first || i>last) widthUser[i] = 1;
    else {
      offw++;
      widthUser[i] = *(offw++);
    }
  }
  if (widthUser['.']==widthUser['W']) font_fixed[userFont]=1;
  else font_fixed[userFont]==0;
  if (userFontBitmap) qfree(userFontBitmap);
  userFontBitmap = qmalloc(256*2*height);
  for (i=first; i<=last; i++) {
    shortptr = userFontBitmap+height*i;
    bmoff = *(bmloc++); bmoff = (bmoff<<8) + *(bmloc++);
    glyphbyte = bmoff/8;
    glyphbit = bmoff&7;
    for (y=0; y<height; y++) {
      lng = 255&*(bitmap+y*roww*2+glyphbyte); lng <<= 8;
      lng += 255&*(bitmap+y*roww*2+glyphbyte+1); lng <<= 8;
      lng += 255&*(bitmap+y*roww*2+glyphbyte+2); lng <<= 8;
      lng <<= glyphbit;
      *(shortptr++) = (lng>>16)&0xffff;
    }
  }
  font_bitmap[userFont] = userFontBitmap;
  qfree(data);
}

      
