#ifndef h_pnobridge_h
#define h_pnobridge_h

#define MYVERSION "001"

#define HW16BPP 1
#define F_DEBUGLOG 1

// register your own at http://www.palmos.com/dev/creatorid/
/*#define appName					"Little John for PalmOS"
#define appFileCreator			'LJPM'
#define appVersionNum			0x09
#define appPrefID				0x00
#define appPrefVersionNum		0x09
*/
#define CREATORID 'TTDM'
#define VFSPATH "/PALM/Programs/TTD/"
#define VFSROOT "/PALM/Programs/"

// 240*160 -> 480*320
#define _PEN_ADJUST_FACTORX_ (ljp_isLowRes ? 1 : 2)
#define _PEN_ADJUST_FACTORY_ (ljp_isLowRes ? 1 : 2)


//#define AUDIO_ARM      1 /* if audio-arm defined, then do arm callback */
//#define AUDIO_VOLUME 20 /* see audio_volume(); *64 */

// debug in pno?
//#define PNODEBUG 1

typedef struct {
  UInt32 vfs_max; // number of VFS volumes available
  UInt32 vfs_vol; // volume we actually want to use
  UInt32 vram;    // address of screen VRAM
  UInt32 eventf;  // function pointer to 68k func to do event handling
  UInt32 display_pitch;  // screenbuffer width
  UInt32 display_width;  // X width of display
  UInt32 display_height; // Y height of display
  UInt32 game_rom;       // pointer to chosen game rom filename
  UInt32 audio_buf;      // pointer to audio buffer
  UInt32 flags;          // flags for pnolet
  UInt32 stack;
} pnobridge_t;

// for requesting data from the 68k side, from the pnolet
#define BRIDGESHIFT 6
#define BRIDGEMASK  0x3F
enum {
  BRIDGE_MemGluePtrNew = 1,
  BRIDGE_debugu32, 
  BRIDGE_printfu32,
  BRIDGE_accum,
  BRIDGE_debugs,
  BRIDGE_printfs,
  BRIDGE_error,
  BRIDGE_progress,
  BRIDGE_midi_stop,
  BRIDGE_bigalloc,
  BRIDGE_midi_close,
  BRIDGE_bigfree,
  BRIDGE_zodiacblit,
  BRIDGE_midi_playing,
  BRIDGE_menu_button,
  BRIDGE_menu_bar,
  BRIDGE_menu_message,
  BRIDGE_menu_messageRaw,
  BRIDGE_filter_event,
  BRIDGE_handle_sysevent,
  BRIDGE_SndStreamCreate,
  BRIDGE_SndStreamDelete,
  BRIDGE_SndStreamStart,
  BRIDGE_SndStreamStop,
  BRIDGE_SndStreamGetVolume,
  BRIDGE_SndStreamSetVolume,
  BRIDGE_midi_volume,
  BRIDGE_midi_open,
  BRIDGE_SndStreamCreateExtended,
  BRIDGE_midi_play,
  BRIDGE_nothing
};

// bridge options going into the pno
#define BF_FULLSCREEN 1
#define BF_AUDIO      2
#define BF_ZODIAC	  4

#define BF_UNZIP	  1

#define BF_INIT_GFX	  1
#define BF_DEINIT_GFX 2

#define BF_HASPIN	  256

// for calling back from pno to host
typedef struct {
  UInt32 a;
  UInt32 b;
  UInt32 c;
  UInt32 d;
} hostcall_t;

typedef struct {
  UInt32 a;
  UInt32 b;
  UInt32 c;
  UInt32 d;
  UInt32 e;
  UInt32 f;
  UInt32 g;
  UInt32 h;
  UInt32 i;
} bighostcall_t;

// go to 68k side and ask it to do events, returning the goods
UInt32 host_events ( UInt32 foo );
void *GetObjectPtr ( UInt16 objectID );

extern pnobridge_t *g_pnobridge;

#endif
