#ifndef h_pcx_h
#define h_pcx_h

typedef struct {
  UInt8	Manufacturer;           // 1
  UInt8	Version;                // 2
  UInt8	Encoding;               // 3
  UInt8	BitsPerPixel;           // 4
  UInt16	XMin;           // 5,6
  UInt16	YMin;           // 7,8
  UInt16	XMax;           // 9,10
  UInt16	YMax;           // 11,12
  UInt16	HDpi;           // 13,14
  UInt16	VDpi;           // 15,16
  UInt8	ColorMap[16][3];        // 17->65
  UInt8	Reserved;               // 66
  UInt8	NPlanes;                // 67
  UInt16	BytesPerLine;   // 68-69
  UInt16	PaletteInfo;    // 70-71
  UInt16	HScreenSize;    // 72-73
  UInt16	VScreenSize;    // 74-75
  UInt8	Pad[54];
} PCX_HEADER;

int SavePCX ( char * Filename, UInt8 *Image,
	      UInt32 XSize, UInt32 YSize, UInt8 *Palette,
	      UInt8 bpp16 );

// returns XSize, YSize
UInt8 *LoadPCX ( char *FileName, UInt8 *Palette,
		 UInt32 *XSize, UInt32 *YSize );

// read from buffer
UInt8 *pcx_load_from_buffer ( UInt8 *buf, UInt32 len, UInt8 *Palette,
			      UInt32 *XSize, UInt32 *YSize );

// read from resource
UInt8 *pcx_load_from_resource ( UInt32 type, UInt32 num, UInt8 *Palette,
				UInt32 *XSize, UInt32 *YSize );

#endif
