
#include <PalmOS.h>
#include <VfsMgr.h>
#include <PalmOSGlue.h>
#include "pnobridge.h"
#include "host68k.h"
#include "endianutils.h"
#include "stdfile.h"
#include "StarterRsc.h"
#include "display68k.h"

UInt32 hw_flags = 0;

UInt8 hw_guess_screen_dimensions ( UInt16 *r_width, UInt16 *r_height,
				   UInt16 *r_pitch )
{
  /* WAIT; OS5 has WinScreenGetAttribute; life is good. */
  /* Process:
   * OS < 5
   *   ZOT requires OS5.
   *   Sony?
   *     If Sony, check Sony API .. its either low res, or we can ask API
   *   Non-Sony
   *     Is it a T|W? It should have DIA..
   *     If DIA, ask it.
   *     Otherwise, low res, bail.
   * OS >= 5
   *   DIA?
   *     If so, ask it.
   *   No DIA, so.. Sony?
   *     If Sony, ask it.
   *   No DIA, No Sony...
   *     Is it Treo? IF slo, low res
   *     If not Treo, must be high res (T|T1, T|T2)
   * Now, if new low res OS5 device comes out.. sucks.
   */
  UInt32 pitch = 0;
  UInt32 width = 0;
  UInt32 height = 0;

#if 0
  // is it ARM? 
  if ( ! hw_query_arm() ) {
    // not ARM, must be pre-OS5
    return ( 0 );
  }
#endif

  // Its OS5 at least

  // is it double density or single density? this is only available in
  // Window Manager v4; OS5 includes v4 always, however.
  WinScreenGetAttribute ( winScreenRowBytes, &pitch );
  //   T|T3 returned 640b for pitch; 16bit -> 320px
  //   zodiac returns 960b; 16bit -> 480px
  WinScreenGetAttribute ( winScreenWidth, &width );
  WinScreenGetAttribute ( winScreenHeight, &height );
  // zodiac lies returns 320 width always

  // deal with lies by using pitch..
  width = pitch / 2;
  pitch = pitch / 2;

  // Do we see a DIA present? (T|T3, Zodiac, UX50, Garmin, later devices..)
  {
    UInt32 version;
    Err err = FtrGet ( pinCreator, pinFtrAPIVersion, &version );
    if ( ! err && version ) {
      //PINS exists
      //DEBUGS("PIN present");
      hw_flags |= hf_pin_present;
    } // pin?
  } // DIA PIN?

  // done
  *r_width = width;
  *r_height = height;
  *r_pitch = pitch;

  return ( 1 );
}

void hw_show_grafitti ( UInt8 grafittip ) {

  if ( grafittip ) {

    if ( hw_flags & hf_pin_present ) {
      PINSetInputAreaState ( pinInputAreaOpen );
    }

  } else {

    if ( hw_flags & hf_pin_present ) {
      PINSetInputAreaState ( pinInputAreaClosed );
    }

  }

  return;
}

void hw_set_fullscreen ( UInt8 fullscreenp ) {

  if ( fullscreenp ) {

    if ( hw_flags & hf_pin_present ) {
      StatHide();
    }

  } else {

    if ( hw_flags & hf_pin_present ) {
      StatShow();
    }

  }

  return;
}
